/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ResidenceBlockListener
implements Listener {
    private List<String> MessageInformed = new ArrayList<String>();
    private List<String> ResCreated = new ArrayList<String>();
    private Residence plugin;
    public static final String SourceResidenceName = "SourceResidenceName";

    public ResidenceBlockListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlantGrow(BlockGrowEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.grow, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVineGrow(BlockSpreadEvent event) {
        if (event.getSource().getType() != Material.VINE) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.grow, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onleaveDecay(LeavesDecayEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.decay, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTreeGrowt(StructureGrowEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getLocation());
        if (!perms.has(Flags.grow, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getWorld())) {
            return;
        }
        ClaimedResidence startRes = this.plugin.getResidenceManager().getByLoc(event.getLocation());
        List blocks = event.getBlocks();
        int i = 0;
        for (BlockState one : blocks) {
            ClaimedResidence targetRes = this.plugin.getResidenceManager().getByLoc(one.getLocation());
            if (startRes == null && targetRes != null || targetRes != null && startRes != null && !startRes.getName().equals(targetRes.getName()) && !startRes.isOwner(targetRes.getOwner())) {
                BlockState matas = (BlockState)blocks.get(i);
                matas.setType(Material.AIR);
                blocks.set(i, matas);
            }
            ++i;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        Material mat = block.getType();
        String world = block.getWorld().getName();
        String group = this.plugin.getPermissionManager().getGroupNameByPlayer(player);
        if (this.plugin.getItemManager().isIgnored(mat, group, world)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (this.plugin.getConfigManager().enabledRentSystem() && res != null) {
            String resname = res.getName();
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getRentManager().isRented(resname)) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                event.setCancelled(true);
                return;
            }
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        String pname = player.getName();
        if (res != null && res.getItemIgnoreList().isListed(mat)) {
            return;
        }
        boolean hasdestroy = perms.playerHas(pname, player.getWorld().getName(), Flags.destroy, perms.playerHas(pname, player.getWorld().getName(), Flags.build, true));
        boolean hasContainer = perms.playerHas(pname, player.getWorld().getName(), Flags.container, true);
        if (!hasdestroy && !player.hasPermission("residence.bypass.destroy")) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
            event.setCancelled(true);
        } else if (!hasContainer && mat == Material.CHEST) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        FlagPermissions perms;
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!(event instanceof EntityBlockFormEvent)) {
            return;
        }
        if (((EntityBlockFormEvent)event).getEntity() instanceof Snowman && !(perms = this.plugin.getPermsByLoc(event.getBlock().getLocation())).has(Flags.snowtrail, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onIceForm(BlockFormEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Material ice = Material.getMaterial((String)"FROSTED_ICE");
        if (event.getNewState().getType() != Material.SNOW && event.getNewState().getType() != Material.ICE && ice != null && ice != event.getNewState().getType()) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.iceform, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onIceMelt(BlockFadeEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (event.getNewState().getType() != Material.STATIONARY_WATER && event.getBlock().getState().getType() != Material.SNOW && event.getBlock().getState().getType() != Material.SNOW_BLOCK) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.icemelt, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Entity ent = event.getEntity();
        if (!ent.hasMetadata(SourceResidenceName)) {
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
            String resName = res == null ? "NULL" : res.getName();
            ent.setMetadata(SourceResidenceName, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)resName));
        } else {
            String resName;
            String saved = ((MetadataValue)ent.getMetadata(SourceResidenceName).get(0)).asString();
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
            if (res != null && res.getPermissions().has(Flags.fallinprotection, FlagPermissions.FlagCombo.OnlyFalse)) {
                return;
            }
            String string = resName = res == null ? "NULL" : res.getName();
            if (!saved.equalsIgnoreCase(resName)) {
                event.setCancelled(true);
                ent.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFall(EntityChangeBlockEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isBlockFall()) {
            return;
        }
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (event.getTo().hasGravity()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!this.plugin.getConfigManager().getBlockFallWorlds().contains(block.getLocation().getWorld().getName())) {
            return;
        }
        if (block.getY() <= this.plugin.getConfigManager().getBlockFallLevel()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        Location loc = new Location(block.getLocation().getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
        int i = loc.getBlockY() - 1;
        while (i >= this.plugin.getConfigManager().getBlockFallLevel() - 1) {
            block11: {
                block12: {
                    ClaimedResidence targetRes;
                    loc.setY((double)i);
                    if (loc.getBlock().getType() == Material.AIR || (targetRes = this.plugin.getResidenceManager().getByLoc(loc)) == null) break block11;
                    if (res == null || res.getName().equals(targetRes.getName())) break block12;
                    if (targetRes.getPermissions().has(Flags.fallinprotection, FlagPermissions.FlagCombo.OnlyFalse)) break block11;
                    event.setCancelled(true);
                    block.setType(Material.AIR);
                }
                return;
            }
            --i;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestPlace(BlockPlaceEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().ShowNoobMessage()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        ArrayList<String> list2 = this.plugin.getPlayerManager().getResidenceList(player.getName());
        if (list2.size() != 0) {
            return;
        }
        if (this.MessageInformed.contains(player.getName())) {
            return;
        }
        this.plugin.msg((CommandSender)player, lm.General_NewPlayerInfo, new Object[0]);
        this.MessageInformed.add(player.getName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestPlaceCreateRes(BlockPlaceEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isNewPlayerUse()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        ArrayList<String> list2 = this.plugin.getPlayerManager().getResidenceList(player.getName());
        if (list2.size() != 0) {
            return;
        }
        if (this.ResCreated.contains(player.getName())) {
            return;
        }
        Location loc = block.getLocation();
        this.plugin.getSelectionManager().placeLoc1(player, new Location(loc.getWorld(), (double)(loc.getBlockX() - this.plugin.getConfigManager().getNewPlayerRangeX()), (double)(loc.getBlockY() - this.plugin.getConfigManager().getNewPlayerRangeY()), (double)(loc.getBlockZ() - this.plugin.getConfigManager().getNewPlayerRangeZ())), true);
        this.plugin.getSelectionManager().placeLoc2(player, new Location(loc.getWorld(), (double)(loc.getBlockX() + this.plugin.getConfigManager().getNewPlayerRangeX()), (double)(loc.getBlockY() + this.plugin.getConfigManager().getNewPlayerRangeY()), (double)(loc.getBlockZ() + this.plugin.getConfigManager().getNewPlayerRangeZ())), true);
        boolean created = this.plugin.getResidenceManager().addResidence(player, player.getName(), this.plugin.getSelectionManager().getPlayerLoc1(player.getName()), this.plugin.getSelectionManager().getPlayerLoc2(player.getName()), this.plugin.getConfigManager().isNewPlayerFree());
        if (created) {
            this.ResCreated.add(player.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        Material mat = block.getType();
        String world = block.getWorld().getName();
        String group = this.plugin.getPermissionManager().getGroupNameByPlayer(player);
        if (this.plugin.getItemManager().isIgnored(mat, group, world)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (this.plugin.getConfigManager().enabledRentSystem() && res != null) {
            String resname = res.getName();
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getRentManager().isRented(resname)) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                event.setCancelled(true);
                return;
            }
        }
        String pname = player.getName();
        if (res != null && !res.getItemBlacklist().isAllowed(mat)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            event.setCancelled(true);
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean hasplace = perms.playerHas(pname, world, Flags.place, perms.playerHas(pname, world, Flags.build, true));
        if (!hasplace && !player.hasPermission("residence.bypass.build")) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.place.getName());
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        FlagPermissions perms = this.plugin.getPermsByLoc(loc);
        if (!perms.has(Flags.spread, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.piston, true)) {
            event.setCancelled(true);
            return;
        }
        List<Block> blocks = this.plugin.getNms().getPistonRetractBlocks(event);
        if (!event.isSticky()) {
            return;
        }
        ClaimedResidence pistonRes = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation());
        for (Block block : blocks) {
            Location locFrom = block.getLocation();
            ClaimedResidence blockFrom = this.plugin.getResidenceManager().getByLoc(locFrom);
            if (blockFrom == null || blockFrom == pistonRes || pistonRes != null && blockFrom.isOwner(pistonRes.getOwner()) || !blockFrom.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.piston, true)) {
            event.setCancelled(true);
            return;
        }
        ClaimedResidence pistonRes = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation());
        BlockFace dir = event.getDirection();
        for (Block block : event.getBlocks()) {
            Location locFrom = block.getLocation();
            Location locTo = new Location(block.getWorld(), (double)(block.getX() + dir.getModX()), (double)(block.getY() + dir.getModY()), (double)(block.getZ() + dir.getModZ()));
            ClaimedResidence blockFrom = this.plugin.getResidenceManager().getByLoc(locFrom);
            ClaimedResidence blockTo = this.plugin.getResidenceManager().getByLoc(locTo);
            if (pistonRes == null && blockTo != null && blockTo.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) {
                event.setCancelled(true);
                return;
            }
            if (blockTo != null && blockFrom == null && blockTo.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) {
                event.setCancelled(true);
                return;
            }
            if (blockTo == null || blockFrom == null || (pistonRes == null || blockTo.isOwner(pistonRes.getOwner())) && blockTo.isOwner(blockFrom.getOwner()) || !blockTo.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        ClaimedResidence fromRes = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation());
        ClaimedResidence toRes = this.plugin.getResidenceManager().getByLoc(event.getToBlock().getLocation());
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getToBlock().getLocation());
        boolean hasflow = perms.has(Flags.flow, FlagPermissions.FlagCombo.TrueOrNone);
        Material mat = event.getBlock().getType();
        if (perms.has(Flags.flowinprotection, FlagPermissions.FlagCombo.TrueOrNone) && (fromRes == null && toRes != null || fromRes != null && toRes != null && !fromRes.equals(toRes) && !fromRes.isOwner(toRes.getOwner()))) {
            event.setCancelled(true);
            return;
        }
        if (perms.has(Flags.flow, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
        if (mat == Material.LAVA || mat == Material.STATIONARY_LAVA) {
            if (!perms.has(Flags.lavaflow, hasflow)) {
                event.setCancelled(true);
            }
            return;
        }
        if (mat == Material.WATER || mat == Material.STATIONARY_WATER) {
            if (!perms.has(Flags.waterflow, hasflow)) {
                event.setCancelled(true);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLandDryFade(BlockFadeEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Material mat = event.getBlock().getType();
        if (mat != Material.SOIL) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getNewState().getLocation());
        if (!perms.has(Flags.dryup, true)) {
            event.getBlock().setData((byte)7);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLandDryPhysics(BlockPhysicsEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Material mat = event.getBlock().getType();
        if (mat != Material.SOIL) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.dryup, true)) {
            event.getBlock().setData((byte)7);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDispense(BlockDispenseEvent event) {
        ClaimedResidence sourceres;
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Location location = new Location(event.getBlock().getWorld(), (double)event.getVelocity().getBlockX(), (double)event.getVelocity().getBlockY(), (double)event.getVelocity().getBlockZ());
        ClaimedResidence targetres = this.plugin.getResidenceManager().getByLoc(location);
        if (targetres == null && location.getBlockY() >= this.plugin.getConfigManager().getPlaceLevel() && this.plugin.getConfigManager().getNoPlaceWorlds().contains(location.getWorld().getName())) {
            ItemStack mat = event.getItem();
            if (this.plugin.getConfigManager().isNoLavaPlace() && mat.getType() == Material.LAVA_BUCKET) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getConfigManager().isNoWaterPlace() && mat.getType() == Material.WATER_BUCKET) {
                event.setCancelled(true);
                return;
            }
        }
        if (((sourceres = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation())) == null && targetres != null || sourceres != null && targetres == null || sourceres != null && targetres != null && !sourceres.getName().equals(targetres.getName())) && (event.getItem().getType() == Material.LAVA_BUCKET || event.getItem().getType() == Material.WATER_BUCKET)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLavaWaterFlow(BlockFromToEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Material mat = event.getBlock().getType();
        Location location = event.getToBlock().getLocation();
        if (!this.plugin.getConfigManager().getNoFlowWorlds().contains(location.getWorld().getName())) {
            return;
        }
        if (location.getBlockY() < this.plugin.getConfigManager().getFlowLevel()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(location);
        if (res != null) {
            return;
        }
        if (this.plugin.getConfigManager().isNoLava() && (mat == Material.LAVA || mat == Material.STATIONARY_LAVA)) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getConfigManager().isNoWater() && (mat == Material.WATER || mat == Material.STATIONARY_WATER)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.firespread, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        if (cause == BlockIgniteEvent.IgniteCause.SPREAD) {
            FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
            if (!perms.has(Flags.firespread, true)) {
                event.setCancelled(true);
            }
        } else if (cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            Player player = event.getPlayer();
            FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getBlock().getLocation(), player);
            if (player != null && !perms.playerHas(player.getName(), player.getWorld().getName(), Flags.ignite, true) && !this.plugin.isResAdminOn(player)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.ignite.getName());
            }
        } else {
            FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
            if (!perms.has(Flags.ignite, true)) {
                event.setCancelled(true);
            }
        }
    }
}

