/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CleanupUnusedClaimTask;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

class CleanupUnusedClaimPreTask
implements Runnable {
    private Claim claim = null;

    CleanupUnusedClaimPreTask(Claim claim) {
        this.claim = claim;
    }

    @Override
    public void run() {
        PlayerData ownerData = GriefPrevention.instance.dataStore.getPlayerDataFromStorage(this.claim.ownerID);
        OfflinePlayer ownerInfo = Bukkit.getServer().getOfflinePlayer(this.claim.ownerID);
        if (ownerInfo.isOnline()) {
            return;
        }
        GriefPrevention.AddLogEntry("Looking for expired claims.  Checking data for " + this.claim.ownerID.toString(), CustomLogEntryTypes.Debug, true);
        int bonusBlocks = ownerData.getBonusClaimBlocks();
        if (bonusBlocks >= GriefPrevention.instance.config_claims_expirationExemptionBonusBlocks || bonusBlocks + ownerData.getAccruedClaimBlocks() >= GriefPrevention.instance.config_claims_expirationExemptionTotalBlocks) {
            GriefPrevention.AddLogEntry("Player exempt from claim expiration based on claim block counts vs. config file settings.", CustomLogEntryTypes.Debug, true);
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)new CleanupUnusedClaimTask(this.claim, ownerData, ownerInfo), 1L);
    }
}

