/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.ResidenceCommandListener;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.RandomLoc;
import com.bekvon.bukkit.residence.economy.ResidenceBank;
import com.bekvon.bukkit.residence.economy.TransactionManager;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceAreaAddEvent;
import com.bekvon.bukkit.residence.event.ResidenceAreaDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceSizeChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceSubzoneCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceTPEvent;
import com.bekvon.bukkit.residence.itemlist.ItemList;
import com.bekvon.bukkit.residence.itemlist.ResidenceItemList;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.text.help.InformationPager;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ClaimedResidence {
    private String resName;
    protected ClaimedResidence parent;
    protected Map<String, CuboidArea> areas;
    protected Map<String, ClaimedResidence> subzones;
    protected ResidencePermissions perms;
    protected ResidenceBank bank;
    protected Double BlockSellPrice = 0.0;
    protected Location tpLoc;
    protected String enterMessage;
    protected String leaveMessage;
    protected String ShopDesc = null;
    protected String ChatPrefix = "";
    protected ChatColor ChannelColor = ChatColor.WHITE;
    protected ResidenceItemList ignorelist;
    protected ResidenceItemList blacklist;
    protected boolean mainRes = false;
    protected long createTime = 0L;
    protected List<String> cmdWhiteList = new ArrayList<String>();
    protected List<String> cmdBlackList = new ArrayList<String>();
    protected RentableLand rentableland = null;
    protected RentedLand rentedland = null;
    protected Integer sellPrice = -1;
    private Residence plugin;

    public String getResidenceName() {
        return this.resName;
    }

    public void setName(String name) {
        this.resName = name.contains(".") ? name.split("\\.")[name.split("\\.").length - 1] : name;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Integer getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(Integer amount) {
        this.sellPrice = amount;
    }

    public boolean isForSell() {
        return Residence.getTransactionManager().isForSale(this.getName());
    }

    public boolean isForRent() {
        return Residence.getRentManager().isForRent(this);
    }

    public boolean isRented() {
        return Residence.getRentManager().isRented(this);
    }

    public void setRentable(RentableLand rl) {
        this.rentableland = rl;
    }

    public RentableLand getRentable() {
        return this.rentableland;
    }

    public void setRented(RentedLand rl) {
        this.rentedland = rl;
    }

    public RentedLand getRentedLand() {
        return this.rentedland;
    }

    public ClaimedResidence(String creationWorld, Residence plugin) {
        this(Residence.getServerLandname(), creationWorld, plugin);
    }

    public ClaimedResidence(String creator, String creationWorld, Residence plugin) {
        this(plugin);
        this.perms = new ResidencePermissions(this, creator, creationWorld);
    }

    public ClaimedResidence(String creator, String creationWorld, ClaimedResidence parentResidence, Residence plugin) {
        this(creator, creationWorld, plugin);
        this.parent = parentResidence;
    }

    public ClaimedResidence(Residence plugin) {
        this.subzones = new HashMap<String, ClaimedResidence>();
        this.areas = new HashMap<String, CuboidArea>();
        this.bank = new ResidenceBank(this);
        this.blacklist = new ResidenceItemList(this, ItemList.ListType.BLACKLIST);
        this.ignorelist = new ResidenceItemList(this, ItemList.ListType.IGNORELIST);
        this.plugin = plugin;
    }

    public boolean isMainResidence() {
        return this.mainRes;
    }

    public void setMainResidence(boolean state) {
        this.mainRes = state;
    }

    public boolean isSubzone() {
        return this.parent != null;
    }

    public int getSubzoneDeep() {
        return this.getSubzoneDeep(0);
    }

    public int getSubzoneDeep(int deep) {
        ++deep;
        if (this.parent != null) {
            return this.parent.getSubzoneDeep(deep);
        }
        return deep;
    }

    public static boolean CheckAreaSize(Player player, CuboidArea area2, boolean resadmin2) {
        if (!resadmin2 && area2.getSize() < (long)Residence.getConfigManager().getMinimalResSize()) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.ToSmallTotal", Residence.getConfigManager().getMinimalResSize()));
            }
            return false;
        }
        if (!resadmin2 && area2.getXSize() < Residence.getConfigManager().getMinimalResX()) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.ToSmallX", area2.getXSize(), Residence.getConfigManager().getMinimalResX()));
            }
            return false;
        }
        if (!resadmin2 && area2.getYSize() < Residence.getConfigManager().getMinimalResY()) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.ToSmallY", area2.getYSize(), Residence.getConfigManager().getMinimalResY()));
            }
            return false;
        }
        if (!resadmin2 && area2.getZSize() < Residence.getConfigManager().getMinimalResZ()) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.ToSmallZ", area2.getZSize(), Residence.getConfigManager().getMinimalResZ()));
            }
            return false;
        }
        return true;
    }

    public boolean addArea(CuboidArea area2, String name) {
        return this.addArea(null, area2, name, true);
    }

    public boolean addArea(Player player, CuboidArea area2, String name, boolean resadmin2) {
        return this.addArea(player, area2, name, resadmin2, true);
    }

    public boolean addArea(Player player, CuboidArea area2, String name, boolean resadmin2, boolean chargeMoney) {
        if (!Residence.validName(name)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.NameCharacters"));
            }
            return false;
        }
        String NName = name;
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            name = name.toLowerCase();
        }
        if (this.areas.containsKey(NName)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.Exists"));
            }
            return false;
        }
        if (!ClaimedResidence.CheckAreaSize(player, area2, resadmin2)) {
            return false;
        }
        if (!resadmin2 && Residence.getConfigManager().getEnforceAreaInsideArea() && this.getParent() == null) {
            boolean inside = false;
            for (CuboidArea are : this.areas.values()) {
                if (!are.isAreaWithinArea(area2)) continue;
                inside = true;
            }
            if (!inside) {
                return false;
            }
        }
        if (!area2.getWorld().getName().equalsIgnoreCase(this.perms.getWorld())) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.DiffWorld"));
            }
            return false;
        }
        if (this.parent == null) {
            String collideResidence = Residence.getResidenceManager().checkAreaCollision(area2, this);
            if (collideResidence != null) {
                if (player != null) {
                    player.sendMessage(Residence.getLM().getMessage("Area.Collision", collideResidence));
                    CuboidArea oldArea = Residence.getResidenceManager().getByName(collideResidence).getAreaArray()[0];
                    if (oldArea != null) {
                        Residence.getSelectionManager().NewMakeBorders(player, oldArea.lowPoints, oldArea.highPoints, true);
                        Residence.getSelectionManager().NewMakeBorders(player, area2.lowPoints, area2.highPoints, false);
                    }
                }
                return false;
            }
        } else {
            String[] szs;
            String[] stringArray = szs = this.parent.listSubzones();
            int n = szs.length;
            int n2 = 0;
            while (n2 < n) {
                String sz = stringArray[n2];
                ClaimedResidence res = this.parent.getSubzone(sz);
                if (res != null && res != this && res.checkCollision(area2)) {
                    if (player != null) {
                        player.sendMessage(Residence.getLM().getMessage("Area.SubzoneCollision", sz));
                    }
                    return false;
                }
                ++n2;
            }
        }
        if (!resadmin2 && player != null) {
            int chargeamount;
            if (!this.perms.hasResidencePermission((CommandSender)player, true)) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return false;
            }
            if (this.parent != null) {
                if (!this.parent.containsLoc(area2.getHighLoc()) || !this.parent.containsLoc(area2.getLowLoc())) {
                    player.sendMessage(Residence.getLM().getMessage("Area.NotWithinParent"));
                    return false;
                }
                if (!this.parent.getPermissions().hasResidencePermission((CommandSender)player, true) && !this.parent.getPermissions().playerHas(player.getName(), "subzone", true)) {
                    player.sendMessage(Residence.getLM().getMessage("Residence.ParentNoPermission"));
                    return false;
                }
            }
            PermissionGroup group = Residence.getPermissionManager().getGroup(player);
            if (!this.isSubzone() && !group.canCreateResidences() && !player.hasPermission("residence.create") || this.isSubzone() && !group.canCreateResidences() && !player.hasPermission("residence.create.subzone")) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return false;
            }
            if (this.areas.size() >= group.getMaxPhysicalPerResidence()) {
                player.sendMessage(Residence.getLM().getMessage("Area.MaxPhysical"));
                return false;
            }
            if (!group.inLimits(area2)) {
                player.sendMessage(Residence.getLM().getMessage("Area.SizeLimit"));
                return false;
            }
            if (group.getMinHeight() > area2.getLowLoc().getBlockY()) {
                player.sendMessage(Residence.getLM().getMessage("Area.LowLimit", String.format("%d", group.getMinHeight())));
                return false;
            }
            if (group.getMaxHeight() < area2.getHighLoc().getBlockY()) {
                player.sendMessage(Residence.getLM().getMessage("Area.HighLimit", String.format("%d", group.getMaxHeight())));
                return false;
            }
            if (chargeMoney && this.parent == null && Residence.getConfigManager().enableEconomy() && !resadmin2 && !TransactionManager.chargeEconomyMoney(player, chargeamount = (int)Math.ceil((double)area2.getSize() * group.getCostPerBlock()))) {
                return false;
            }
        }
        ResidenceAreaAddEvent resevent = new ResidenceAreaAddEvent(player, NName, this, area2);
        Residence.getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return false;
        }
        Residence.getResidenceManager().removeChunkList(this.getName());
        this.areas.put(name, area2);
        Residence.getResidenceManager().calculateChunks(this.getName());
        return true;
    }

    public boolean replaceArea(CuboidArea neware, String name) {
        return this.replaceArea(null, neware, name, true);
    }

    public boolean replaceArea(Player player, CuboidArea newarea, String name, boolean resadmin2) {
        ClaimedResidence res;
        String sz;
        int n;
        int n2;
        String[] stringArray;
        String[] szs;
        if (!this.areas.containsKey(name)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.NonExist"));
            }
            return false;
        }
        CuboidArea oldarea = this.areas.get(name);
        if (!newarea.getWorld().getName().equalsIgnoreCase(this.perms.getWorld())) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.DiffWorld"));
            }
            return false;
        }
        if (this.parent == null) {
            String collideResidence = Residence.getResidenceManager().checkAreaCollision(newarea, this);
            if (collideResidence != null && player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.Collision", collideResidence));
                CuboidArea area2 = Residence.getResidenceManager().getByName(collideResidence).getAreaArray()[0];
                Residence.getSelectionManager().NewMakeBorders(player, area2.getLowLoc(), area2.highPoints, true);
                return false;
            }
        } else {
            stringArray = szs = this.parent.listSubzones();
            n2 = szs.length;
            n = 0;
            while (n < n2) {
                sz = stringArray[n];
                res = this.parent.getSubzone(sz);
                if (res != null && res != this && res.checkCollision(newarea)) {
                    if (player != null) {
                        player.sendMessage(Residence.getLM().getMessage("Area.SubzoneCollision", sz));
                        Residence.getSelectionManager().NewMakeBorders(player, res.getAreaArray()[0].lowPoints, res.getAreaArray()[0].highPoints, true);
                    }
                    return false;
                }
                ++n;
            }
        }
        stringArray = szs = this.listSubzones();
        n2 = szs.length;
        n = 0;
        while (n < n2) {
            sz = stringArray[n];
            res = this.getSubzone(sz);
            if (res != null && res != this) {
                String[] szareas;
                String[] stringArray2 = szareas = res.getAreaList();
                int n3 = szareas.length;
                int n4 = 0;
                while (n4 < n3) {
                    String area3 = stringArray2[n4];
                    if (!newarea.isAreaWithinArea(res.getArea(area3))) {
                        boolean good = false;
                        CuboidArea[] cuboidAreaArray = this.getAreaArray();
                        int n5 = cuboidAreaArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            CuboidArea arae = cuboidAreaArray[n6];
                            if (arae != oldarea && arae.isAreaWithinArea(res.getArea(area3))) {
                                good = true;
                            }
                            ++n6;
                        }
                        if (!good) {
                            res.removeArea(area3);
                        }
                    }
                    ++n4;
                }
                if (res.getAreaArray().length == 0) {
                    this.removeSubzone(sz);
                }
            }
            ++n;
        }
        if (!resadmin2 && player != null) {
            int chargeamount;
            PermissionGroup group;
            if (!this.perms.hasResidencePermission((CommandSender)player, true)) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return false;
            }
            if (this.parent != null) {
                if (!this.parent.containsLoc(newarea.getHighLoc()) || !this.parent.containsLoc(newarea.getLowLoc())) {
                    player.sendMessage(Residence.getLM().getMessage("Area.NotWithinParent"));
                    return false;
                }
                if (!this.parent.getPermissions().hasResidencePermission((CommandSender)player, true) && !this.parent.getPermissions().playerHas(player.getName(), "subzone", true)) {
                    player.sendMessage(Residence.getLM().getMessage("Residence.ParentNoPermission"));
                    return false;
                }
            }
            if (!(group = Residence.getPermissionManager().getGroup(player)).canCreateResidences() && !player.hasPermission("residence.resize")) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return false;
            }
            if (!group.inLimits(newarea)) {
                player.sendMessage(Residence.getLM().getMessage("Area.SizeLimit"));
                return false;
            }
            if (group.getMinHeight() > newarea.getLowLoc().getBlockY()) {
                player.sendMessage(Residence.getLM().getMessage("Area.LowLimit", String.format("%d", group.getMinHeight())));
                return false;
            }
            if (group.getMaxHeight() < newarea.getHighLoc().getBlockY()) {
                player.sendMessage(Residence.getLM().getMessage("Area.HighLimit", String.format("%d", group.getMaxHeight())));
                return false;
            }
            if (this.parent == null && Residence.getConfigManager().enableEconomy() && !resadmin2 && (chargeamount = (int)Math.ceil((double)(newarea.getSize() - oldarea.getSize()) * group.getCostPerBlock())) > 0 && !TransactionManager.chargeEconomyMoney(player, chargeamount)) {
                return false;
            }
        }
        ResidenceSizeChangeEvent resevent = new ResidenceSizeChangeEvent(player, this, oldarea, newarea);
        Residence.getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return false;
        }
        Residence.getResidenceManager().removeChunkList(this.getName());
        this.areas.remove(name);
        this.areas.put(name, newarea);
        Residence.getResidenceManager().calculateChunks(this.getName());
        if (player != null) {
            player.sendMessage(Residence.getLM().getMessage("Area.Update"));
        }
        return true;
    }

    public boolean addSubzone(String name, Location loc1, Location loc2) {
        return this.addSubzone(null, loc1, loc2, name, true);
    }

    public boolean addSubzone(Player player, Location loc1, Location loc2, String name, boolean resadmin2) {
        if (player == null) {
            return this.addSubzone(null, Residence.getServerLandname(), loc1, loc2, name, resadmin2);
        }
        return this.addSubzone(player, player.getName(), loc1, loc2, name, resadmin2);
    }

    public boolean addSubzone(Player player, String owner, Location loc1, Location loc2, String name, boolean resadmin2) {
        ClaimedResidence newres;
        if (!Residence.validName(name)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.NameCharacters"));
            }
            return false;
        }
        if (!this.containsLoc(loc1) || !this.containsLoc(loc2)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Subzone.SelectInside"));
            }
            return false;
        }
        String NName = name;
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            name = name.toLowerCase();
        }
        if (this.subzones.containsKey(name)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Subzone.Exists", NName));
            }
            return false;
        }
        if (!resadmin2 && player != null) {
            if (!this.perms.hasResidencePermission((CommandSender)player, true) && !this.perms.playerHas(player.getName(), "subzone", this.perms.playerHas(player.getName(), "admin", false))) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return false;
            }
            PermissionGroup group = Residence.getPermissionManager().getGroup(player);
            if (this.getZoneDepth() >= group.getMaxSubzoneDepth(owner)) {
                player.sendMessage(Residence.getLM().getMessage("Subzone.MaxDepth"));
                return false;
            }
        }
        CuboidArea newArea = new CuboidArea(loc1, loc2);
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        for (Map.Entry<String, ClaimedResidence> resEntry : set2) {
            ClaimedResidence res = resEntry.getValue();
            if (!res.checkCollision(newArea)) continue;
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Subzone.Collide", resEntry.getKey()));
                if (res.getAreaArray().length > 0) {
                    CuboidArea oldArea = res.getAreaArray()[0];
                    Residence.getSelectionManager().NewMakeBorders(player, oldArea.lowPoints, oldArea.highPoints, true);
                    Residence.getSelectionManager().NewMakeBorders(player, newArea.lowPoints, newArea.highPoints, false);
                }
            }
            return false;
        }
        if (player != null) {
            newres = new ClaimedResidence(owner, this.perms.getWorld(), this, this.plugin);
            newres.addArea(player, newArea, NName, resadmin2);
        } else {
            newres = new ClaimedResidence(owner, this.perms.getWorld(), this, this.plugin);
            newres.addArea(newArea, NName);
        }
        if (newres.getAreaCount() != 0) {
            newres.getPermissions().applyDefaultFlags();
            if (player != null) {
                PermissionGroup group = Residence.getPermissionManager().getGroup(player);
                newres.setEnterMessage(group.getDefaultEnterMessage());
                newres.setLeaveMessage(group.getDefaultLeaveMessage());
            }
            if (Residence.getConfigManager().flagsInherit()) {
                newres.getPermissions().setParent(this.perms);
            }
            newres.resName = name;
            newres.setCreateTime();
            ResidenceSubzoneCreationEvent resevent = new ResidenceSubzoneCreationEvent(player, name, newres, newArea);
            Residence.getServ().getPluginManager().callEvent((Event)resevent);
            if (resevent.isCancelled()) {
                return false;
            }
            this.subzones.put(name, newres);
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.Create", name));
                player.sendMessage(Residence.getLM().getMessage("Subzone.Create", name));
            }
            return true;
        }
        if (player != null) {
            player.sendMessage(Residence.getLM().getMessage("Subzone.CreateFail", name));
        }
        return false;
    }

    public String getSubzoneNameByLoc(Location loc) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        ClaimedResidence res = null;
        String key = null;
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            if (!entry.getValue().containsLoc(loc)) continue;
            key = entry.getKey();
            res = entry.getValue();
            break;
        }
        if (key == null || res == null) {
            return null;
        }
        String subname = res.getSubzoneNameByLoc(loc);
        if (subname != null) {
            return String.valueOf(key) + "." + subname;
        }
        return key;
    }

    public ClaimedResidence getSubzoneByLoc(Location loc) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        ClaimedResidence res = null;
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            if (!entry.getValue().containsLoc(loc)) continue;
            res = entry.getValue();
            break;
        }
        if (res == null) {
            return null;
        }
        ClaimedResidence subrez = res.getSubzoneByLoc(loc);
        if (subrez == null) {
            return res;
        }
        return subrez;
    }

    public ClaimedResidence getSubzone(String subzonename) {
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            subzonename = subzonename.toLowerCase();
        }
        if (!subzonename.contains(".")) {
            return this.subzones.get(subzonename);
        }
        String[] split = subzonename.split("\\.");
        ClaimedResidence get = this.subzones.get(split[0]);
        int i = 1;
        while (i < split.length) {
            if (get == null) {
                return null;
            }
            get = get.getSubzone(split[i]);
            ++i;
        }
        return get;
    }

    public String getSubzoneNameByRes(ClaimedResidence res) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            if (entry.getValue() == res) {
                return entry.getValue().getResidenceName();
            }
            String n = entry.getValue().getSubzoneNameByRes(res);
            if (n == null) continue;
            return String.valueOf(entry.getValue().getResidenceName()) + "." + n;
        }
        return null;
    }

    public String[] getSubzoneList() {
        ArrayList<String> zones = new ArrayList<String>();
        Set<String> set2 = this.subzones.keySet();
        for (String key : set2) {
            if (key == null) continue;
            zones.add(key);
        }
        return zones.toArray(new String[zones.size()]);
    }

    public boolean checkCollision(CuboidArea area2) {
        Set<String> set2 = this.areas.keySet();
        for (String key : set2) {
            CuboidArea checkarea = this.areas.get(key);
            if (checkarea == null || !checkarea.checkCollision(area2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLoc(Location loc) {
        Collection<CuboidArea> keys = this.areas.values();
        for (CuboidArea key : keys) {
            if (!key.containsLoc(loc)) continue;
            if (this.parent != null) {
                return this.parent.containsLoc(loc);
            }
            return true;
        }
        return false;
    }

    public ClaimedResidence getParent() {
        return this.parent;
    }

    public String getTopParentName() {
        return this.getTopParent().getName();
    }

    public ClaimedResidence getTopParent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTopParent();
    }

    public boolean removeSubzone(String name) {
        return this.removeSubzone(null, name, true);
    }

    public boolean removeSubzone(Player player, String name, boolean resadmin2) {
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            name = name.toLowerCase();
        }
        ClaimedResidence res = this.subzones.get(name);
        if (player != null && !res.perms.hasResidencePermission((CommandSender)player, true) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return false;
        }
        this.subzones.remove(name);
        if (player != null) {
            player.sendMessage(Residence.getLM().getMessage("Subzone.Remove", name));
        }
        return true;
    }

    public long getTotalSize() {
        Collection<CuboidArea> set2 = this.areas.values();
        long size = 0L;
        if (!Residence.getConfigManager().isNoCostForYBlocks()) {
            for (CuboidArea entry : set2) {
                size += entry.getSize();
            }
        } else {
            for (CuboidArea entry : set2) {
                size += (long)(entry.getXSize() * entry.getZSize());
            }
        }
        return size;
    }

    public CuboidArea[] getAreaArray() {
        CuboidArea[] temp = new CuboidArea[this.areas.size()];
        int i = 0;
        Iterator<CuboidArea> iterator = this.areas.values().iterator();
        while (iterator.hasNext()) {
            CuboidArea area2;
            temp[i] = area2 = iterator.next();
            ++i;
        }
        return temp;
    }

    public Map<String, CuboidArea> getAreaMap() {
        return this.areas;
    }

    public ResidencePermissions getPermissions() {
        return this.perms;
    }

    public String getEnterMessage() {
        return this.enterMessage;
    }

    public String getLeaveMessage() {
        return this.leaveMessage;
    }

    public String getShopDesc() {
        return this.ShopDesc;
    }

    public void setEnterMessage(String message2) {
        this.enterMessage = message2;
    }

    public void setLeaveMessage(String message2) {
        this.leaveMessage = message2;
    }

    public void setShopDesc(String message2) {
        this.ShopDesc = message2;
    }

    public void setEnterLeaveMessage(Player player, String message2, boolean enter, boolean resadmin2) {
        PermissionGroup group;
        if (message2 != null && message2.equals("")) {
            message2 = null;
        }
        if (!(group = Residence.getPermissionManager().getGroup(this.perms.getOwner(), this.perms.getWorld())).canSetEnterLeaveMessages() && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.OwnerNoPermission"));
            return;
        }
        if (!this.perms.hasResidencePermission((CommandSender)player, false) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        if (enter) {
            this.setEnterMessage(message2);
        } else {
            this.setLeaveMessage(message2);
        }
        player.sendMessage(Residence.getLM().getMessage("Residence.MessageChange"));
    }

    public Location getMiddleFreeLoc(Location insideLoc, Player player) {
        CuboidArea area2 = this.getAreaByLoc(insideLoc);
        if (area2 == null) {
            return insideLoc;
        }
        int y = area2.getHighLoc().getBlockY();
        int x = area2.getLowLoc().getBlockX() + area2.getXSize() / 2;
        int z = area2.getLowLoc().getBlockZ() + area2.getZSize() / 2;
        Location newLoc = new Location(area2.getWorld(), (double)x + 0.5, (double)y, (double)z + 0.5);
        boolean found = false;
        int maxIt = area2.getWorld().getMaxHeight() - 63;
        for (int it = 0; it < maxIt; ++it) {
            newLoc.setY(newLoc.getY() - 1.0);
            if (newLoc.getBlockY() < 63) break;
            Block block = newLoc.getBlock();
            Block block2 = newLoc.clone().add(0.0, 1.0, 0.0).getBlock();
            Block block3 = newLoc.clone().add(0.0, -1.0, 0.0).getBlock();
            if (!Residence.getNms().isEmptyBlock(block) || !Residence.getNms().isEmptyBlock(block2) || Residence.getNms().isEmptyBlock(block3)) continue;
            found = true;
            break;
        }
        if (found) {
            return newLoc;
        }
        return this.getOutsideFreeLoc(insideLoc, player);
    }

    public Location getOutsideFreeLoc(Location insideLoc, Player player) {
        CuboidArea area2 = this.getAreaByLoc(insideLoc);
        if (area2 == null) {
            return insideLoc;
        }
        ArrayList<RandomLoc> randomLocList = new ArrayList<RandomLoc>();
        int z = -1;
        while (z < area2.getZSize() + 1) {
            randomLocList.add(new RandomLoc(area2.getLowLoc().getX(), 0.0, area2.getLowLoc().getZ() + (double)z));
            randomLocList.add(new RandomLoc(area2.getLowLoc().getX() + (double)area2.getXSize(), 0.0, area2.getLowLoc().getZ() + (double)z));
            ++z;
        }
        int x = -1;
        while (x < area2.getXSize() + 1) {
            randomLocList.add(new RandomLoc(area2.getLowLoc().getX() + (double)x, 0.0, area2.getLowLoc().getZ()));
            randomLocList.add(new RandomLoc(area2.getLowLoc().getX() + (double)x, 0.0, area2.getLowLoc().getZ() + (double)area2.getZSize()));
            ++x;
        }
        Location loc = insideLoc.clone();
        boolean found = false;
        int it = 0;
        int maxIt = 30;
        while (!found && it < maxIt) {
            ClaimedResidence res;
            ++it;
            Random ran = new Random(System.currentTimeMillis());
            if (randomLocList.isEmpty()) break;
            int check2 = ran.nextInt(randomLocList.size());
            RandomLoc place = (RandomLoc)randomLocList.get(check2);
            randomLocList.remove(check2);
            double x2 = place.getX();
            double z2 = place.getZ();
            loc.setX(x2);
            loc.setZ(z2);
            loc.setY((double)area2.getHighLoc().getBlockY());
            int max = area2.getHighLoc().getBlockY();
            int i = max = loc.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : max;
            while ((double)i > area2.getLowLoc().getY()) {
                loc.setY((double)i);
                Block block = loc.getBlock();
                Block block2 = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = loc.clone().add(0.0, -1.0, 0.0).getBlock();
                if (!Residence.getNms().isEmptyBlock(block3) && Residence.getNms().isEmptyBlock(block) && Residence.getNms().isEmptyBlock(block2)) break;
                --i;
            }
            if (!Residence.getNms().isEmptyBlock(loc.getBlock()) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.LAVA || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.STATIONARY_LAVA || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.WATER || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.STATIONARY_WATER || (res = Residence.getResidenceManager().getByLoc(loc)) != null && player != null && !res.getPermissions().playerHas(player.getName(), "tp", true) && !player.hasPermission("residence.admin.tp")) continue;
            found = true;
            loc.setY(loc.getY() + 2.0);
            loc.add(0.5, 0.0, 0.5);
            break;
        }
        if (!found && Residence.getConfigManager().getKickLocation() != null) {
            return Residence.getConfigManager().getKickLocation();
        }
        return loc;
    }

    protected CuboidArea getAreaByLoc(Location loc) {
        for (CuboidArea thisarea : this.areas.values()) {
            if (!thisarea.containsLoc(loc)) continue;
            return thisarea;
        }
        return null;
    }

    public String[] listSubzones() {
        String[] list2 = new String[this.subzones.size()];
        int i = 0;
        Iterator<String> iterator = this.subzones.keySet().iterator();
        while (iterator.hasNext()) {
            String res;
            list2[i] = res = iterator.next();
            ++i;
        }
        return list2;
    }

    public List<ClaimedResidence> getSubzones() {
        ArrayList<ClaimedResidence> list2 = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.subzones.entrySet()) {
            list2.add(res.getValue());
        }
        return list2;
    }

    public void printSubzoneList(Player player, int page) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Map.Entry<String, ClaimedResidence> sz : this.subzones.entrySet()) {
            temp.add(ChatColor.GREEN + sz.getKey() + ChatColor.YELLOW + " - " + Residence.getLM().getMessage("General.Owner", sz.getValue().getOwner()));
        }
        InformationPager.printInfo((CommandSender)player, Residence.getLM().getMessage("General.Subzones"), temp, page);
    }

    public void printAreaList(Player player, int page) {
        ArrayList<String> temp = new ArrayList<String>();
        for (String area2 : this.areas.keySet()) {
            temp.add(area2);
        }
        InformationPager.printInfo((CommandSender)player, Residence.getLM().getMessage("General.PhysicalAreas"), temp, page);
    }

    public void printAdvancedAreaList(Player player, int page) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            CuboidArea a = entry.getValue();
            Location h = a.getHighLoc();
            Location l = a.getLowLoc();
            temp.add(ChatColor.GREEN + "{" + ChatColor.YELLOW + "ID:" + ChatColor.RED + entry.getKey() + " " + ChatColor.YELLOW + "P1:" + ChatColor.RED + "(" + h.getBlockX() + "," + h.getBlockY() + "," + h.getBlockZ() + ") " + ChatColor.YELLOW + "P2:" + ChatColor.RED + "(" + l.getBlockX() + "," + l.getBlockY() + "," + l.getBlockZ() + ") " + ChatColor.YELLOW + "(Size:" + ChatColor.RED + a.getSize() + ChatColor.YELLOW + ")" + ChatColor.GREEN + "} ");
        }
        InformationPager.printInfo((CommandSender)player, Residence.getLM().getMessage("General.PhysicalAreas"), temp, page);
    }

    public String[] getAreaList() {
        String[] arealist = new String[this.areas.size()];
        int i = 0;
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            arealist[i] = entry.getKey();
            ++i;
        }
        return arealist;
    }

    public int getZoneDepth() {
        int count = 0;
        ClaimedResidence res = this.parent;
        while (res != null) {
            ++count;
            res = res.getParent();
        }
        return count;
    }

    public void setTpLoc(Player player, boolean resadmin2) {
        if (!this.perms.hasResidencePermission((CommandSender)player, false) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        if (!this.containsLoc(player.getLocation())) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotIn"));
            return;
        }
        this.tpLoc = player.getLocation();
        player.sendMessage(Residence.getLM().getMessage("Residence.SetTeleportLocation"));
    }

    public int isSafeTp(Player player) {
        if (player.getAllowFlight()) {
            return 0;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return 0;
        }
        if (Residence.getNms().isSpectator(player.getGameMode())) {
            return 0;
        }
        if (this.tpLoc == null) {
            return 0;
        }
        Location tempLoc = new Location(this.tpLoc.getWorld(), this.tpLoc.getX(), this.tpLoc.getY(), this.tpLoc.getZ());
        int from = (int)tempLoc.getY();
        int fallDistance = 0;
        int i = 0;
        while (i < 255) {
            tempLoc.setY((double)(from - i));
            Block block = tempLoc.getBlock();
            if (!Residence.getNms().isEmptyBlock(block)) break;
            ++fallDistance;
            ++i;
        }
        return fallDistance;
    }

    public void tpToResidence(Player reqPlayer, Player targetPlayer, boolean resadmin2) {
        int distance;
        boolean isAdmin = Residence.isResAdminOn(reqPlayer);
        if (!(resadmin2 || isAdmin || reqPlayer.hasPermission("residence.tpbypass") || this.isOwner(targetPlayer))) {
            PermissionGroup group = Residence.getPermissionManager().getGroup(reqPlayer);
            if (!group.hasTpAccess()) {
                reqPlayer.sendMessage(Residence.getLM().getMessage("General.TeleportDeny"));
                return;
            }
            if (!reqPlayer.equals(targetPlayer)) {
                reqPlayer.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return;
            }
            if (!this.perms.playerHas(reqPlayer.getName(), "tp", true)) {
                reqPlayer.sendMessage(Residence.getLM().getMessage("Residence.TeleportNoFlag"));
                return;
            }
            if (!this.perms.playerHas(reqPlayer.getName(), "move", true)) {
                reqPlayer.sendMessage(Residence.getLM().getMessage("Residence.MoveDeny", this.getName()));
                return;
            }
        }
        if (!ResidenceCommandListener.getTeleportMap().containsKey(targetPlayer.getName()) && !isAdmin && (distance = this.isSafeTp(reqPlayer)) > 6) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("General.TeleportConfirm", distance));
            ResidenceCommandListener.getTeleportMap().put(reqPlayer.getName(), this);
            return;
        }
        if (Residence.getConfigManager().getTeleportDelay() > 0 && !isAdmin && !resadmin2) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("General.TeleportStarted", this.getName(), Residence.getConfigManager().getTeleportDelay()));
            ResidenceCommandListener.getTeleportDelayMap().add(reqPlayer.getName());
        }
        if (this.tpLoc != null) {
            if (Residence.getConfigManager().getTeleportDelay() > 0 && !isAdmin) {
                this.performDelaydTp(this.tpLoc, targetPlayer, reqPlayer, true);
            } else {
                this.performInstantTp(this.tpLoc, targetPlayer, reqPlayer, true);
            }
        } else {
            CuboidArea area2 = this.areas.values().iterator().next();
            if (area2 == null) {
                reqPlayer.sendMessage(ChatColor.RED + "Could not find area to teleport to...");
                ResidenceCommandListener.getTeleportDelayMap().remove(targetPlayer.getName());
                return;
            }
            Location targloc = this.getMiddleFreeLoc(area2.getHighLoc(), targetPlayer);
            if (Residence.getConfigManager().getTeleportDelay() > 0 && !isAdmin) {
                this.performDelaydTp(targloc, targetPlayer, reqPlayer, true);
            } else {
                this.performInstantTp(targloc, targetPlayer, reqPlayer, true);
            }
        }
    }

    public void performDelaydTp(final Location targloc, final Player targetPlayer, Player reqPlayer, final boolean near) {
        ResidenceTPEvent tpevent = new ResidenceTPEvent(this, targloc, targetPlayer, reqPlayer);
        Residence.getServ().getPluginManager().callEvent((Event)tpevent);
        if (!tpevent.isCancelled()) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (!ResidenceCommandListener.getTeleportDelayMap().contains(targetPlayer.getName()) && Residence.getConfigManager().getTeleportDelay() > 0) {
                        return;
                    }
                    if (ResidenceCommandListener.getTeleportDelayMap().contains(targetPlayer.getName())) {
                        ResidenceCommandListener.getTeleportDelayMap().remove(targetPlayer.getName());
                    }
                    targetPlayer.teleport(targloc);
                    if (near) {
                        targetPlayer.sendMessage(Residence.getLM().getMessage("Residence.TeleportNear"));
                    } else {
                        targetPlayer.sendMessage(Residence.getLM().getMessage("General.TeleportSuccess"));
                    }
                }
            }, (long)Residence.getConfigManager().getTeleportDelay() * 20L);
        }
    }

    private void performInstantTp(Location targloc, Player targetPlayer, Player reqPlayer, boolean near) {
        ResidenceTPEvent tpevent = new ResidenceTPEvent(this, targloc, targetPlayer, reqPlayer);
        Residence.getServ().getPluginManager().callEvent((Event)tpevent);
        if (!tpevent.isCancelled()) {
            targetPlayer.teleport(targloc);
            if (near) {
                targetPlayer.sendMessage(Residence.getLM().getMessage("Residence.TeleportNear"));
            } else {
                targetPlayer.sendMessage(Residence.getLM().getMessage("General.TeleportSuccess"));
            }
        }
    }

    public String getAreaIDbyLoc(Location loc) {
        for (Map.Entry<String, CuboidArea> area2 : this.areas.entrySet()) {
            if (!area2.getValue().containsLoc(loc)) continue;
            return area2.getKey();
        }
        return null;
    }

    public CuboidArea getCuboidAreabyName(String name) {
        for (Map.Entry<String, CuboidArea> area2 : this.areas.entrySet()) {
            if (!area2.getKey().equals(name)) continue;
            return area2.getValue();
        }
        return null;
    }

    public void removeArea(String id) {
        Residence.getResidenceManager().removeChunkList(this.getName());
        this.areas.remove(id);
        Residence.getResidenceManager().calculateChunks(this.getName());
    }

    public void removeArea(Player player, String id, boolean resadmin2) {
        if (this.getPermissions().hasResidencePermission((CommandSender)player, true) || resadmin2) {
            if (!this.areas.containsKey(id)) {
                player.sendMessage(Residence.getLM().getMessage("Area.NonExist"));
                return;
            }
            if (this.areas.size() == 1 && !Residence.getConfigManager().allowEmptyResidences()) {
                player.sendMessage(Residence.getLM().getMessage("Area.RemoveLast"));
                return;
            }
            ResidenceAreaDeleteEvent resevent = new ResidenceAreaDeleteEvent(player, this, player == null ? ResidenceDeleteEvent.DeleteCause.OTHER : ResidenceDeleteEvent.DeleteCause.PLAYER_DELETE);
            Residence.getServ().getPluginManager().callEvent((Event)resevent);
            if (resevent.isCancelled()) {
                return;
            }
            this.removeArea(id);
            player.sendMessage(Residence.getLM().getMessage("Area.Remove"));
        } else {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
        }
    }

    public Map<String, Object> save() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> areamap = new HashMap<String, Map<String, Object>>();
        root.put("CapitalizedName", this.resName);
        if (this.mainRes) {
            root.put("MainResidence", this.mainRes);
        }
        if (this.createTime != 0L) {
            root.put("CreatedOn", this.createTime);
        }
        root.put("EnterMessage", this.enterMessage);
        root.put("LeaveMessage", this.leaveMessage);
        root.put("ShopDescription", this.ShopDesc);
        root.put("StoredMoney", this.bank.getStoredMoney());
        root.put("BlockSellPrice", this.BlockSellPrice);
        root.put("ChatPrefix", this.ChatPrefix);
        root.put("ChannelColor", this.ChannelColor.name());
        root.put("BlackList", this.blacklist.save());
        root.put("IgnoreList", this.ignorelist.save());
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            areamap.put(entry.getKey(), entry.getValue().save());
        }
        root.put("Areas", areamap);
        HashMap<String, Map<String, Object>> subzonemap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, ClaimedResidence> sz : this.subzones.entrySet()) {
            subzonemap.put(sz.getKey(), sz.getValue().save());
        }
        root.put("Subzones", subzonemap);
        root.put("Permissions", this.perms.save());
        if (!this.cmdBlackList.isEmpty()) {
            root.put("cmdBlackList", this.cmdBlackList);
        }
        if (!this.cmdWhiteList.isEmpty()) {
            root.put("cmdWhiteList", this.cmdWhiteList);
        }
        if (this.tpLoc != null) {
            HashMap<String, Double> tpmap = new HashMap<String, Double>();
            tpmap.put("X", this.convertDouble(this.tpLoc.getX()));
            tpmap.put("Y", this.convertDouble(this.tpLoc.getY()));
            tpmap.put("Z", this.convertDouble(this.tpLoc.getZ()));
            tpmap.put("Pitch", this.convertDouble(this.tpLoc.getPitch()));
            tpmap.put("Yaw", this.convertDouble(this.tpLoc.getYaw()));
            root.put("TPLoc", tpmap);
        }
        return root;
    }

    private double convertDouble(double d) {
        return ClaimedResidence.convertDouble(String.valueOf(d));
    }

    private static double convertDouble(String dString) {
        DecimalFormat formatter = new DecimalFormat("#0.00");
        formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.getDefault()));
        dString = dString.replace(",", ".");
        Double d = 0.0;
        try {
            d = Double.valueOf(dString);
            d = Double.valueOf(formatter.format(d));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static ClaimedResidence load(Map<String, Object> root, ClaimedResidence parent, Residence plugin) throws Exception {
        ClaimedResidence res = new ClaimedResidence(plugin);
        if (root == null) {
            throw new Exception("Null residence!");
        }
        if (root.containsKey("CapitalizedName")) {
            res.resName = (String)root.get("CapitalizedName");
        }
        res.createTime = root.containsKey("CreatedOn") ? (Long)root.get("CreatedOn") : System.currentTimeMillis();
        res.enterMessage = (String)root.get("EnterMessage");
        res.leaveMessage = (String)root.get("LeaveMessage");
        if (root.containsKey("ShopDescription")) {
            res.setShopDesc((String)root.get("ShopDescription"));
        }
        if (root.containsKey("StoredMoney")) {
            res.bank.setStoredMoney((Integer)root.get("StoredMoney"));
        }
        if (root.containsKey("BlackList")) {
            res.blacklist = ResidenceItemList.load(res, (Map)root.get("BlackList"));
        }
        if (root.containsKey("IgnoreList")) {
            res.ignorelist = ResidenceItemList.load(res, (Map)root.get("IgnoreList"));
        }
        Map areamap = (Map)root.get("Areas");
        res.perms = ResidencePermissions.load(res, (Map)root.get("Permissions"));
        if (res.getPermissions().ownerLastKnownName == null) {
            return null;
        }
        if (root.containsKey("MainResidence")) {
            res.mainRes = (Boolean)root.get("MainResidence");
        }
        if (root.containsKey("BlockSellPrice")) {
            res.BlockSellPrice = (Double)root.get("BlockSellPrice");
        } else {
            PermissionGroup group = Residence.getPermissionManager().getGroup(res.getOwner(), res.getWorld());
            res.BlockSellPrice = group.getSellPerBlock();
        }
        World world = Residence.getServ().getWorld(res.perms.getWorld());
        if (world == null) {
            throw new Exception("Cant Find World: " + res.perms.getWorld());
        }
        for (Map.Entry map : areamap.entrySet()) {
            res.areas.put((String)map.getKey(), CuboidArea.load((Map)map.getValue(), world));
        }
        Map subzonemap = (Map)root.get("Subzones");
        for (Map.Entry map : subzonemap.entrySet()) {
            ClaimedResidence subres = ClaimedResidence.load((Map)map.getValue(), res, plugin);
            if (subres == null) continue;
            if (subres.getResidenceName() == null) {
                subres.setName((String)map.getKey());
            }
            if (Residence.getConfigManager().flagsInherit()) {
                subres.getPermissions().setParent(res.getPermissions());
            }
            if (Residence.getConfigManager().isResCreateCaseSensitive()) {
                res.subzones.put((String)map.getKey(), subres);
                continue;
            }
            res.subzones.put(((String)map.getKey()).toLowerCase(), subres);
        }
        res.parent = parent;
        Map tploc = (Map)root.get("TPLoc");
        if (tploc != null) {
            double pitch = 0.0;
            double yaw = 0.0;
            if (tploc.containsKey("Yaw")) {
                yaw = ClaimedResidence.convertDouble(tploc.get("Yaw").toString());
            }
            if (tploc.containsKey("Pitch")) {
                pitch = ClaimedResidence.convertDouble(tploc.get("Pitch").toString());
            }
            res.tpLoc = new Location(world, ClaimedResidence.convertDouble(tploc.get("X").toString()), ClaimedResidence.convertDouble(tploc.get("Y").toString()), ClaimedResidence.convertDouble(tploc.get("Z").toString()));
            res.tpLoc.setPitch((float)pitch);
            res.tpLoc.setYaw((float)yaw);
        }
        if (root.containsKey("cmdBlackList")) {
            res.cmdBlackList = (List)root.get("cmdBlackList");
        }
        if (root.containsKey("cmdWhiteList")) {
            res.cmdWhiteList = (List)root.get("cmdWhiteList");
        }
        if (root.containsKey("ChatPrefix")) {
            res.ChatPrefix = (String)root.get("ChatPrefix");
        }
        res.ChannelColor = root.containsKey("ChannelColor") ? ChatColor.valueOf((String)((String)root.get("ChannelColor"))) : Residence.getConfigManager().getChatColor();
        return res;
    }

    public int getAreaCount() {
        return this.areas.size();
    }

    public boolean renameSubzone(String oldName, String newName) {
        return this.renameSubzone(null, oldName, newName, true);
    }

    public boolean renameSubzone(Player player, String oldName, String newName, boolean resadmin2) {
        ClaimedResidence res;
        if (!Residence.validName(newName)) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.NameCharacters"));
            return false;
        }
        String newN = newName;
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            oldName = oldName.toLowerCase();
            newName = newName.toLowerCase();
        }
        if ((res = this.subzones.get(oldName)) == null) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.Subzone"));
            }
            return false;
        }
        if (player != null && !res.getPermissions().hasResidencePermission((CommandSender)player, true) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return false;
        }
        if (this.subzones.containsKey(newName)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Subzone.Exists", newName));
            }
            return false;
        }
        res.setName(newN);
        this.subzones.put(newName, res);
        this.subzones.remove(oldName);
        if (player != null) {
            player.sendMessage(Residence.getLM().getMessage("Subzone.Rename", oldName, newName));
        }
        return true;
    }

    public boolean renameArea(String oldName, String newName) {
        return this.renameArea(null, oldName, newName, true);
    }

    public boolean renameArea(Player player, String oldName, String newName, boolean resadmin2) {
        if (!Residence.validName(newName)) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.NameCharacters"));
            return false;
        }
        if (player == null || this.perms.hasResidencePermission((CommandSender)player, true) || resadmin2) {
            if (this.areas.containsKey(newName)) {
                if (player != null) {
                    player.sendMessage(Residence.getLM().getMessage("Area.Exists"));
                }
                return false;
            }
            CuboidArea area2 = this.areas.get(oldName);
            if (area2 == null) {
                if (player != null) {
                    player.sendMessage(Residence.getLM().getMessage("Area.InvalidName"));
                }
                return false;
            }
            this.areas.put(newName, area2);
            this.areas.remove(oldName);
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Area.Rename", oldName, newName));
            }
            return true;
        }
        player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
        return false;
    }

    public CuboidArea getArea(String name) {
        return this.areas.get(name);
    }

    public String getName() {
        return Residence.getResidenceManager().getNameByRes(this);
    }

    public String getShortName() {
        String name = Residence.getResidenceManager().getNameByRes(this);
        if (name.contains(".")) {
            String[] split = name.split("\\.");
            name = split[split.length - 1];
        }
        return name;
    }

    public void remove() {
        String name = this.getName();
        if (name != null) {
            Residence.getResidenceManager().removeResidence(name);
            Residence.getResidenceManager().removeChunkList(name);
        }
    }

    public ResidenceBank getBank() {
        return this.bank;
    }

    public String getWorld() {
        return this.perms.getWorld();
    }

    public String getOwner() {
        return this.perms.getOwner();
    }

    public boolean isOwner(String name) {
        return this.perms.getOwner().equals(name);
    }

    public boolean isOwner(Player p) {
        if (Residence.getConfigManager().isOfflineMode()) {
            return this.isOwner(p.getName());
        }
        return this.perms.getOwnerUUID().equals(p.getUniqueId());
    }

    public boolean isOwner(CommandSender sender) {
        if (Residence.getConfigManager().isOfflineMode()) {
            return this.isOwner(sender.getName());
        }
        if (sender instanceof Player) {
            return this.perms.getOwnerUUID().equals(((Player)sender).getUniqueId());
        }
        return true;
    }

    public void setChatPrefix(String ChatPrefix) {
        this.ChatPrefix = ChatPrefix;
    }

    public String getChatPrefix() {
        return this.ChatPrefix == null ? "" : this.ChatPrefix;
    }

    public void setChannelColor(ChatColor ChannelColor) {
        this.ChannelColor = ChannelColor;
    }

    public ChatChannel getChatChannel() {
        return Residence.getChatManager().getChannel(this.getName());
    }

    public ChatColor getChannelColor() {
        return this.ChannelColor;
    }

    public UUID getOwnerUUID() {
        return this.perms.getOwnerUUID();
    }

    public ResidenceItemList getItemBlacklist() {
        return this.blacklist;
    }

    public ResidenceItemList getItemIgnoreList() {
        return this.ignorelist;
    }

    public List<String> getCmdBlackList() {
        return this.cmdBlackList;
    }

    public List<String> getCmdWhiteList() {
        return this.cmdWhiteList;
    }

    public boolean addCmdBlackList(String cmd2) {
        if (cmd2.contains("/")) {
            cmd2 = cmd2.replace("/", "");
        }
        if (!this.cmdBlackList.contains(cmd2.toLowerCase())) {
            this.cmdBlackList.add(cmd2.toLowerCase());
            return true;
        }
        this.cmdBlackList.remove(cmd2.toLowerCase());
        return false;
    }

    public boolean addCmdWhiteList(String cmd2) {
        if (cmd2.contains("/")) {
            cmd2 = cmd2.replace("/", "");
        }
        if (!this.cmdWhiteList.contains(cmd2.toLowerCase())) {
            this.cmdWhiteList.add(cmd2.toLowerCase());
            return true;
        }
        this.cmdWhiteList.remove(cmd2.toLowerCase());
        return false;
    }

    public Double getBlockSellPrice() {
        return this.BlockSellPrice;
    }

    public ArrayList<Player> getPlayersInResidence() {
        ArrayList<Player> within = new ArrayList<Player>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.containsLoc(player.getLocation())) continue;
            within.add(player);
        }
        return within;
    }
}

