/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy.rent;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.MarketRentInterface;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceRentEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class RentManager
implements MarketRentInterface {
    private Set<ClaimedResidence> rentedLand = new HashSet<ClaimedResidence>();
    private Set<ClaimedResidence> rentableLand = new HashSet<ClaimedResidence>();

    @Override
    public RentedLand getRentedLand(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getRentedLand(res);
    }

    public RentedLand getRentedLand(ClaimedResidence res) {
        if (res == null) {
            return null;
        }
        return res.isRented() ? res.getRentedLand() : null;
    }

    @Override
    public List<String> getRentedLands(String playername) {
        return this.getRentedLands(playername, false);
    }

    public List<String> getRentedLands(String playername, boolean onlyHidden) {
        ArrayList<String> rentedLands = new ArrayList<String>();
        for (ClaimedResidence res : this.rentedLand) {
            if (res == null || !res.isRented() || !res.getRentedLand().player.equals(playername)) continue;
            String world = " ";
            ClaimedResidence topres = res.getTopParent();
            world = topres.getWorld();
            boolean hidden = topres.getPermissions().has("hidden", false);
            if (onlyHidden && !hidden) continue;
            rentedLands.add(String.valueOf(Residence.getLM().getMessage("Residence.List", "", res.getName(), world)) + Residence.getLM().getMessage("Rent.Rented"));
        }
        return rentedLands;
    }

    public List<ClaimedResidence> getRents(String playername) {
        return this.getRents(playername, false);
    }

    public List<ClaimedResidence> getRents(String playername, boolean onlyHidden) {
        ArrayList<ClaimedResidence> rentedLands = new ArrayList<ClaimedResidence>();
        for (ClaimedResidence res : this.rentedLand) {
            if (res == null || !res.isRented() || !res.getRentedLand().player.equalsIgnoreCase(playername)) continue;
            ClaimedResidence topres = res.getTopParent();
            boolean hidden = topres.getPermissions().has("hidden", false);
            if (onlyHidden && !hidden) continue;
            rentedLands.add(res);
        }
        return rentedLands;
    }

    public List<String> getRentedLandsList(Player player) {
        return this.getRentedLandsList(player.getName());
    }

    public List<String> getRentedLandsList(String playername) {
        ArrayList<String> rentedLands = new ArrayList<String>();
        for (ClaimedResidence res : this.rentedLand) {
            if (res == null || !res.isRented() || !res.getRentedLand().player.equalsIgnoreCase(playername)) continue;
            rentedLands.add(res.getName());
        }
        return rentedLands;
    }

    @Override
    public void setForRent(Player player, String landName, int amount, int days, boolean AllowRenewing, boolean resadmin2) {
        this.setForRent(player, landName, amount, days, AllowRenewing, Residence.getConfigManager().isRentStayInMarket(), resadmin2);
    }

    @Override
    public void setForRent(Player player, String landName, int amount, int days, boolean AllowRenewing, boolean StayInMarket, boolean resadmin2) {
        this.setForRent(player, landName, amount, days, AllowRenewing, StayInMarket, Residence.getConfigManager().isRentAllowAutoPay(), resadmin2);
    }

    @Override
    public void setForRent(Player player, String landName, int amount, int days, boolean AllowRenewing, boolean StayInMarket, boolean AllowAutoPay, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.setForRent(player, res, amount, days, AllowRenewing, StayInMarket, AllowAutoPay, resadmin2);
    }

    public void setForRent(Player player, ClaimedResidence res, int amount, int days, boolean AllowRenewing, boolean StayInMarket, boolean AllowAutoPay, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (!Residence.getConfigManager().enabledRentSystem()) {
            player.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
            return;
        }
        if (res.isForSell()) {
            player.sendMessage(Residence.getLM().getMessage("Economy.SellRentFail"));
            return;
        }
        if (!resadmin2) {
            if (!res.getPermissions().hasResidencePermission((CommandSender)player, true)) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return;
            }
            PermissionGroup group = Residence.getPermissionManager().getGroup(player);
            if (this.getRentableCount(player.getName()) >= group.getMaxRentables()) {
                player.sendMessage(Residence.getLM().getMessage("Residence.MaxRent"));
                return;
            }
        }
        if (!this.rentableLand.contains(res)) {
            ResidenceRentEvent revent = new ResidenceRentEvent(res, player, ResidenceRentEvent.RentEventType.RENTABLE);
            Residence.getServ().getPluginManager().callEvent((Event)revent);
            if (revent.isCancelled()) {
                return;
            }
            RentableLand newrent = new RentableLand();
            newrent.days = days;
            newrent.cost = amount;
            newrent.AllowRenewing = AllowRenewing;
            newrent.StayInMarket = StayInMarket;
            newrent.AllowAutoPay = AllowAutoPay;
            res.setRentable(newrent);
            this.rentableLand.add(res);
            player.sendMessage(Residence.getLM().getMessage("Residence.ForRentSuccess", res.getShortName(), amount, days));
        } else {
            player.sendMessage(Residence.getLM().getMessage("Residence.AlreadyRent"));
        }
    }

    @Override
    public void rent(Player player, String landName, boolean AutoPay, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.rent(player, res, AutoPay, resadmin2);
    }

    public void rent(Player player, ClaimedResidence res, boolean AutoPay, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (!Residence.getConfigManager().enabledRentSystem()) {
            player.sendMessage(Residence.getLM().getMessage("Rent.Disabled"));
            return;
        }
        if (res.isOwner(player)) {
            player.sendMessage(Residence.getLM().getMessage("Economy.OwnerRentFail"));
            return;
        }
        PermissionGroup group = Residence.getPermissionManager().getGroup(player);
        if (!resadmin2 && this.getRentCount(player.getName()) >= group.getMaxRents(player.getName())) {
            player.sendMessage(Residence.getLM().getMessage("Residence.MaxRent"));
            return;
        }
        if (!res.isForRent()) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotForRent"));
            return;
        }
        if (res.isRented()) {
            this.printRentInfo(player, res.getName());
            return;
        }
        RentableLand land = res.getRentable();
        if (!land.AllowAutoPay && AutoPay) {
            player.sendMessage(Residence.getLM().getMessage("Residence.CantAutoPay"));
            AutoPay = false;
        }
        if (Residence.getEconomyManager().canAfford(player.getName(), land.cost)) {
            ResidenceRentEvent revent = new ResidenceRentEvent(res, player, ResidenceRentEvent.RentEventType.RENT);
            Residence.getServ().getPluginManager().callEvent((Event)revent);
            if (revent.isCancelled()) {
                return;
            }
            if (Residence.getEconomyManager().transfer(player.getName(), res.getPermissions().getOwner(), land.cost)) {
                RentedLand newrent = new RentedLand();
                newrent.player = player.getName();
                newrent.startTime = System.currentTimeMillis();
                newrent.endTime = System.currentTimeMillis() + this.daysToMs(land.days);
                newrent.AutoPay = AutoPay;
                res.setRented(newrent);
                this.rentedLand.add(res);
                Residence.getSignUtil().CheckSign(res);
                CuboidArea area2 = res.getAreaArray()[0];
                Residence.getSelectionManager().NewMakeBorders(player, area2.getHighLoc(), area2.getLowLoc(), false);
                res.getPermissions().copyUserPermissions(res.getPermissions().getOwner(), player.getName());
                res.getPermissions().clearPlayersFlags(res.getPermissions().getOwner());
                res.getPermissions().setPlayerFlag(player.getName(), "admin", FlagPermissions.FlagState.TRUE);
                player.sendMessage(Residence.getLM().getMessage("Residence.RentSuccess", res.getName(), land.days));
                if (Residence.getSchematicManager() != null && Residence.getConfigManager().RestoreAfterRentEnds && !Residence.getConfigManager().SchematicsSaveOnFlagChange && res.getPermissions().has("backup", true)) {
                    Residence.getSchematicManager().save(res);
                }
            } else {
                player.sendMessage(ChatColor.RED + "Error, unable to transfer money...");
            }
        } else {
            player.sendMessage(Residence.getLM().getMessage("Economy.NotEnoughMoney"));
        }
    }

    public void payRent(Player player, String landName, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.payRent(player, res, resadmin2);
    }

    public void payRent(Player player, ClaimedResidence res, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (!Residence.getConfigManager().enabledRentSystem()) {
            player.sendMessage(Residence.getLM().getMessage("Rent.Disabled"));
            return;
        }
        if (!res.isForRent()) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotForRent"));
            return;
        }
        if (res.isRented() && !this.getRentingPlayer(res).equals(player.getName()) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Rent.NotByYou"));
            return;
        }
        RentableLand land = res.getRentable();
        RentedLand rentedLand = res.getRentedLand();
        if (rentedLand == null) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotRented"));
            return;
        }
        if (!land.AllowRenewing) {
            player.sendMessage(Residence.getLM().getMessage("Rent.OneTime"));
            return;
        }
        PermissionGroup group = Residence.getPermissionManager().getGroup(player);
        if (!resadmin2 && group.getMaxRentDays() != -1 && this.msToDays(rentedLand.endTime - System.currentTimeMillis() + this.daysToMs(land.days)) >= group.getMaxRentDays()) {
            player.sendMessage(Residence.getLM().getMessage("Rent.MaxRentDays", group.getMaxRentDays()));
            return;
        }
        if (Residence.getEconomyManager().canAfford(player.getName(), land.cost)) {
            ResidenceRentEvent revent = new ResidenceRentEvent(res, player, ResidenceRentEvent.RentEventType.RENT);
            Residence.getServ().getPluginManager().callEvent((Event)revent);
            if (revent.isCancelled()) {
                return;
            }
            if (Residence.getEconomyManager().transfer(player.getName(), res.getPermissions().getOwner(), land.cost)) {
                rentedLand.endTime += this.daysToMs(land.days);
                Residence.getSignUtil().CheckSign(res);
                CuboidArea area2 = res.getAreaArray()[0];
                Residence.getSelectionManager().NewMakeBorders(player, area2.getHighLoc(), area2.getLowLoc(), false);
                player.sendMessage(Residence.getLM().getMessage("Rent.Extended", land.days, res.getName()));
                player.sendMessage(Residence.getLM().getMessage("Rent.Expire", GetTime.getTime(rentedLand.endTime)));
            } else {
                player.sendMessage(ChatColor.RED + "Error, unable to transfer money...");
            }
        } else {
            player.sendMessage(Residence.getLM().getMessage("Economy.NotEnoughMoney"));
        }
    }

    @Override
    public void unrent(Player player, String landName, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.unrent(player, res, resadmin2);
    }

    public void unrent(Player player, ClaimedResidence res, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        RentedLand rent = res.getRentedLand();
        if (rent == null) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotRented"));
            return;
        }
        if (resadmin2 || rent.player.equals(player.getName())) {
            ResidenceRentEvent revent = new ResidenceRentEvent(res, player, ResidenceRentEvent.RentEventType.UNRENTABLE);
            Residence.getServ().getPluginManager().callEvent((Event)revent);
            if (revent.isCancelled()) {
                return;
            }
            this.rentedLand.remove(res);
            res.setRented(null);
            if (!res.getRentable().AllowRenewing && !res.getRentable().StayInMarket) {
                this.rentableLand.remove(res);
                res.setRentable(null);
            }
            boolean backup = res.getPermissions().has("backup", false);
            res.getPermissions().applyDefaultFlags();
            if (Residence.getSchematicManager() != null && Residence.getConfigManager().RestoreAfterRentEnds && backup) {
                Residence.getSchematicManager().load(res);
                res.getPermissions().setFlag("backup", FlagPermissions.FlagState.TRUE);
            }
            Residence.getSignUtil().CheckSign(res);
            player.sendMessage(Residence.getLM().getMessage("Residence.Unrent", res.getName()));
        } else {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
        }
    }

    private long daysToMs(int days) {
        return (long)days * 24L * 60L * 60L * 1000L;
    }

    private int msToDays(long ms) {
        return (int)Math.ceil((double)ms / 1000.0 / 60.0 / 60.0 / 24.0);
    }

    @Override
    public void removeFromForRent(Player player, String landName, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.removeFromForRent(player, res, resadmin2);
    }

    public void removeFromForRent(Player player, ClaimedResidence res, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (!res.getPermissions().hasResidencePermission((CommandSender)player, true) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        if (this.rentableLand.contains(res)) {
            ResidenceRentEvent revent = new ResidenceRentEvent(res, player, ResidenceRentEvent.RentEventType.UNRENT);
            Residence.getServ().getPluginManager().callEvent((Event)revent);
            if (revent.isCancelled()) {
                return;
            }
            this.rentableLand.remove(res);
            res.setRentable(null);
            res.getPermissions().applyDefaultFlags();
            Residence.getSignUtil().CheckSign(res);
            player.sendMessage(Residence.getLM().getMessage("Residence.RemoveRentable", res.getShortName()));
        } else {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotForRent"));
        }
    }

    @Override
    public void removeFromRent(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.removeFromRent(res);
    }

    public void removeFromRent(ClaimedResidence res) {
        this.rentedLand.remove(res);
    }

    @Override
    public void removeRentable(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.removeRentable(res);
    }

    public void removeRentable(ClaimedResidence res) {
        if (res == null) {
            return;
        }
        this.removeFromRent(res);
        this.rentableLand.remove(res);
        Residence.getSignUtil().removeSign(res.getName());
    }

    @Override
    public boolean isForRent(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.isForRent(res);
    }

    public boolean isForRent(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return this.rentableLand.contains(res);
    }

    public RentableLand getRentableLand(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getRentableLand(res);
    }

    public RentableLand getRentableLand(ClaimedResidence res) {
        if (res == null) {
            return null;
        }
        if (res.isForRent()) {
            return res.getRentable();
        }
        return null;
    }

    @Override
    public boolean isRented(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.isRented(res);
    }

    public boolean isRented(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return this.rentedLand.contains(res);
    }

    @Override
    public String getRentingPlayer(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getRentingPlayer(res);
    }

    public String getRentingPlayer(ClaimedResidence res) {
        if (res == null) {
            return null;
        }
        return res.isRented() ? res.getRentedLand().player : null;
    }

    @Override
    public int getCostOfRent(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getCostOfRent(res);
    }

    public int getCostOfRent(ClaimedResidence res) {
        if (res == null) {
            return 0;
        }
        return res.isForRent() ? res.getRentable().cost : 0;
    }

    @Override
    public boolean getRentableRepeatable(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getRentableRepeatable(res);
    }

    public boolean getRentableRepeatable(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return res.isForRent() ? res.getRentable().AllowRenewing : false;
    }

    @Override
    public boolean getRentedAutoRepeats(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getRentedAutoRepeats(res);
    }

    public boolean getRentedAutoRepeats(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return this.getRentableRepeatable(res) ? (this.rentedLand.contains(res) ? res.getRentedLand().AutoPay : false) : false;
    }

    @Override
    public int getRentDays(String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        return this.getRentDays(res);
    }

    public int getRentDays(ClaimedResidence res) {
        if (res == null) {
            return 0;
        }
        return res.isForRent() ? res.getRentable().days : 0;
    }

    @Override
    public void checkCurrentRents() {
        for (ClaimedResidence res : this.rentedLand) {
            RentedLand land;
            if (res == null || (land = res.getRentedLand()) == null || land.endTime > System.currentTimeMillis()) continue;
            if (Residence.getConfigManager().debugEnabled()) {
                System.out.println("Rent Check: " + res.getName());
            }
            ResidenceRentEvent revent = new ResidenceRentEvent(res, null, ResidenceRentEvent.RentEventType.RENT_EXPIRE);
            Residence.getServ().getPluginManager().callEvent((Event)revent);
            if (revent.isCancelled()) continue;
            RentableLand rentable = res.getRentable();
            if (!rentable.AllowRenewing) {
                if (!rentable.StayInMarket) {
                    this.rentableLand.remove(res);
                    res.setRentable(null);
                }
                this.rentedLand.remove(res);
                res.setRented(null);
                res.getPermissions().applyDefaultFlags();
                Residence.getSignUtil().CheckSign(res);
                continue;
            }
            if (land.AutoPay && rentable.AllowAutoPay) {
                if (!Residence.getEconomyManager().canAfford(land.player, rentable.cost)) {
                    if (!rentable.StayInMarket) {
                        this.rentableLand.remove(res);
                        res.setRentable(null);
                    }
                    this.rentedLand.remove(res);
                    res.setRented(null);
                    res.getPermissions().applyDefaultFlags();
                } else if (!Residence.getEconomyManager().transfer(land.player, res.getPermissions().getOwner(), rentable.cost)) {
                    if (!rentable.StayInMarket) {
                        this.rentableLand.remove(res);
                        res.setRentable(null);
                    }
                    this.rentedLand.remove(res);
                    res.setRented(null);
                    res.getPermissions().applyDefaultFlags();
                } else {
                    land.endTime = System.currentTimeMillis() + this.daysToMs(rentable.days);
                }
                Residence.getSignUtil().CheckSign(res);
                continue;
            }
            if (!rentable.StayInMarket) {
                this.rentableLand.remove(res);
                res.setRentable(null);
            }
            this.rentedLand.remove(res);
            res.setRented(null);
            boolean backup = res.getPermissions().has("backup", false);
            res.getPermissions().applyDefaultFlags();
            if (Residence.getSchematicManager() != null && Residence.getConfigManager().RestoreAfterRentEnds && backup) {
                Residence.getSchematicManager().load(res);
                Residence.getSignUtil().CheckSign(res);
                res.getPermissions().setFlag("backup", FlagPermissions.FlagState.TRUE);
                break;
            }
            Residence.getSignUtil().CheckSign(res);
        }
    }

    @Override
    public void setRentRepeatable(Player player, String landName, boolean value, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.setRentRepeatable(player, res, value, resadmin2);
    }

    public void setRentRepeatable(Player player, ClaimedResidence res, boolean value, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        RentableLand land = res.getRentable();
        if (!res.isOwner(player) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotOwner"));
            return;
        }
        if (land == null || res == null || !res.isOwner(player) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotOwner"));
            return;
        }
        land.AllowRenewing = value;
        if (!value && this.isRented(res)) {
            res.getRentedLand().AutoPay = false;
        }
        if (value) {
            player.sendMessage(Residence.getLM().getMessage("Rentable.EnableRenew", res.getShortName()));
        } else {
            player.sendMessage(Residence.getLM().getMessage("Rentable.DisableRenew", res.getShortName()));
        }
    }

    @Override
    public void setRentedRepeatable(Player player, String landName, boolean value, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.setRentedRepeatable(player, res, value, resadmin2);
    }

    public void setRentedRepeatable(Player player, ClaimedResidence res, boolean value, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        RentedLand land = res.getRentedLand();
        if (land == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (!res.getRentable().AllowAutoPay && value) {
            player.sendMessage(Residence.getLM().getMessage("Residence.CantAutoPay"));
            return;
        }
        if (!land.player.equals(player.getName()) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotOwner"));
            return;
        }
        if (!land.player.equals(player.getName()) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotOwner"));
            return;
        }
        land.AutoPay = value;
        if (value) {
            player.sendMessage(Residence.getLM().getMessage("Rent.EnableRenew", res.getShortName()));
        } else {
            player.sendMessage(Residence.getLM().getMessage("Rent.DisableRenew", res.getShortName()));
        }
        if (res != null) {
            Residence.getSignUtil().CheckSign(res);
        }
    }

    public void printRentInfo(Player player, String landName) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(landName);
        this.printRentInfo(player, res);
    }

    public void printRentInfo(Player player, ClaimedResidence res) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        RentableLand rentable = res.getRentable();
        RentedLand rented = res.getRentedLand();
        if (rentable != null) {
            player.sendMessage(Residence.getLM().getMessage("General.Separator"));
            player.sendMessage(Residence.getLM().getMessage("General.Land", res.getName()));
            player.sendMessage(Residence.getLM().getMessage("General.Cost", rentable.cost, rentable.days));
            player.sendMessage(Residence.getLM().getMessage("Rentable.AllowRenewing", rentable.AllowRenewing));
            player.sendMessage(Residence.getLM().getMessage("Rentable.StayInMarket", rentable.StayInMarket));
            player.sendMessage(Residence.getLM().getMessage("Rentable.AllowAutoPay", rentable.AllowAutoPay));
            if (rented != null) {
                player.sendMessage(Residence.getLM().getMessage("Residence.RentedBy", rented.player));
                if (rented.player.equals(player.getName()) || res != null && res.isOwner(player) || Residence.isResAdminOn(player)) {
                    player.sendMessage(String.valueOf(rented.AutoPay ? Residence.getLM().getMessage("Rent.AutoPayTurnedOn") : Residence.getLM().getMessage("Rent.AutoPayTurnedOff")) + "\n");
                }
                player.sendMessage(Residence.getLM().getMessage("Rent.Expire", GetTime.getTime(rented.endTime)));
            } else {
                player.sendMessage(Residence.getLM().getMessage("General.Status", Residence.getLM().getMessage("General.Available")));
            }
            player.sendMessage(Residence.getLM().getMessage("General.Separator"));
        } else {
            player.sendMessage(Residence.getLM().getMessage("General.Separator"));
            player.sendMessage(Residence.getLM().getMessage("Residence.NotForRent"));
            player.sendMessage(Residence.getLM().getMessage("General.Separator"));
        }
    }

    public void printRentableResidences(Player player, int page) {
        player.sendMessage(Residence.getLM().getMessage("Rentable.Land"));
        StringBuilder sbuild = new StringBuilder();
        sbuild.append(ChatColor.GREEN);
        int perpage = 10;
        int pagecount = (int)Math.ceil((double)this.rentableLand.size() / (double)perpage);
        if (page < 1) {
            page = 1;
        }
        int z = 0;
        for (ClaimedResidence res : this.rentableLand) {
            if (res == null || ++z <= (page - 1) * perpage) continue;
            if (z > (page - 1) * perpage + perpage) break;
            boolean rented = res.isRented();
            if (!res.getRentable().AllowRenewing && rented) continue;
            String rentedBy = "";
            String hover = "";
            if (rented) {
                RentedLand rent = res.getRentedLand();
                rentedBy = Residence.getLM().getMessage("Residence.RentedBy", rent.player);
                hover = GetTime.getTime(rent.endTime);
            }
            String msg = Residence.getLM().getMessage("Rent.RentList", z, res.getName(), res.getRentable().cost, res.getRentable().days, res.getRentable().AllowRenewing, res.getOwner(), rentedBy);
            if (!hover.equalsIgnoreCase("")) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " {\"text\":\"\",\"extra\":[{\"text\":\"" + msg + "\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\u00a72" + hover + "\"}}]}"));
                continue;
            }
            player.sendMessage(msg);
        }
        String separator = "" + ChatColor.GOLD;
        String simbol = "\u25ac";
        int i = 0;
        while (i < 10) {
            separator = String.valueOf(separator) + simbol;
            ++i;
        }
        if (pagecount == 1) {
            return;
        }
        int NextPage = page + 1;
        NextPage = page < pagecount ? NextPage : page;
        int Prevpage = page - 1;
        Prevpage = page > 1 ? Prevpage : page;
        String prevCmd = "/res market list rent " + Prevpage;
        String prev = "[\"\",{\"text\":\"" + separator + " " + Residence.getLM().getMessage("General.PrevInfoPage") + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + prevCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + "<<<" + "\"}]}}}";
        String nextCmd = "/res market list rent " + NextPage;
        String next = " {\"text\":\"" + Residence.getLM().getMessage("General.NextInfoPage") + " " + separator + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + nextCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ">>>" + "\"}]}}}]";
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " " + prev + "," + next));
    }

    @Override
    public int getRentCount(String player) {
        int count = 0;
        for (ClaimedResidence res : this.rentedLand) {
            if (!res.getRentedLand().player.equalsIgnoreCase(player)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getRentableCount(String player) {
        int count = 0;
        for (ClaimedResidence res : this.rentableLand) {
            if (res == null || !res.isOwner(player)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Set<ClaimedResidence> getRentableResidences() {
        return this.rentableLand;
    }

    @Override
    public Set<ClaimedResidence> getCurrentlyRentedResidences() {
        return this.rentedLand;
    }

    public void load(Map<String, Object> root) {
        if (root == null) {
            return;
        }
        this.rentableLand.clear();
        Map rentables = (Map)root.get("Rentables");
        for (Map.Entry rent : rentables.entrySet()) {
            RentableLand one = this.loadRentable((Map)rent.getValue());
            ClaimedResidence res = Residence.getResidenceManager().getByName((String)rent.getKey());
            if (res == null) continue;
            res.setRentable(one);
            this.rentableLand.add(res);
        }
        Map rented = (Map)root.get("Rented");
        for (Map.Entry rent : rented.entrySet()) {
            RentedLand one = this.loadRented((Map)rent.getValue());
            ClaimedResidence res = Residence.getResidenceManager().getByName((String)rent.getKey());
            if (res == null) continue;
            res.setRented(one);
            this.rentedLand.add(res);
        }
    }

    public Map<String, Object> save() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> rentables = new HashMap<String, Map<String, Object>>();
        for (ClaimedResidence res : this.rentableLand) {
            if (res == null || res.getRentable() == null) continue;
            rentables.put(res.getName(), res.getRentable().save());
        }
        HashMap<String, Map<String, Object>> rented = new HashMap<String, Map<String, Object>>();
        for (ClaimedResidence res : this.rentedLand) {
            if (res == null || res.getRentedLand() == null) continue;
            rented.put(res.getName(), res.getRentedLand().save());
        }
        root.put("Rentables", rentables);
        root.put("Rented", rented);
        return root;
    }

    private RentableLand loadRentable(Map<String, Object> map) {
        RentableLand newland = new RentableLand();
        newland.cost = (Integer)map.get("Cost");
        newland.days = (Integer)map.get("Days");
        newland.AllowRenewing = (Boolean)map.get("Repeatable");
        if (map.containsKey("StayInMarket")) {
            newland.StayInMarket = (Boolean)map.get("StayInMarket");
        }
        if (map.containsKey("AllowAutoPay")) {
            newland.AllowAutoPay = (Boolean)map.get("AllowAutoPay");
        }
        return newland;
    }

    private RentedLand loadRented(Map<String, Object> map) {
        RentedLand newland = new RentedLand();
        newland.player = (String)map.get("Player");
        newland.startTime = (Long)map.get("StartTime");
        newland.endTime = (Long)map.get("EndTime");
        newland.AutoPay = (Boolean)map.get("AutoRefresh");
        return newland;
    }
}

