/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ResidencePlayer {
    private String userName = null;
    private Player player = null;
    private OfflinePlayer ofPlayer = null;
    private Map<String, ClaimedResidence> ResidenceList = new HashMap<String, ClaimedResidence>();
    private ClaimedResidence mainResidence = null;
    private int currentRes = -1;
    private PermissionGroup group = null;
    private int maxRes = -1;
    private int maxRents = -1;
    private int maxSubzones = -1;

    public ResidencePlayer(Player player) {
        this.player = player;
        this.userName = player.getName();
        this.RecalculatePermissions();
    }

    public ResidencePlayer(OfflinePlayer player) {
        this.ofPlayer = player;
        this.userName = player.getName();
        this.RecalculatePermissions();
    }

    public ResidencePlayer(String userName) {
        this.userName = userName;
        this.RecalculatePermissions();
    }

    public void setMainResidence(ClaimedResidence res) {
        if (this.mainResidence != null) {
            this.mainResidence.setMainResidence(false);
        }
        this.mainResidence = res;
    }

    public ClaimedResidence getMainResidence() {
        if (this.mainResidence == null) {
            for (Map.Entry<String, ClaimedResidence> entry : this.ResidenceList.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().isMainResidence()) continue;
                this.mainResidence = entry.getValue();
                return this.mainResidence;
            }
            for (String string : Residence.getRentManager().getRentedLands(this.player.getName())) {
                ClaimedResidence res = Residence.getResidenceManager().getByName(string);
                if (res == null) continue;
                this.mainResidence = res;
                return this.mainResidence;
            }
            for (Map.Entry entry : this.ResidenceList.entrySet()) {
                if (entry.getValue() == null) continue;
                this.mainResidence = (ClaimedResidence)entry.getValue();
                return this.mainResidence;
            }
        }
        return this.mainResidence;
    }

    public void RecalculatePermissions() {
        this.player = Bukkit.getPlayerExact((String)this.userName);
        if (this.player == null) {
            this.ofPlayer = Residence.getOfflinePlayer(this.userName);
        }
        this.recountMaxRes();
        this.recountMaxRents();
        this.recountMaxSubzones();
    }

    public void recountMaxRes() {
        int i = 1;
        while (i <= Residence.getConfigManager().getMaxResCount()) {
            if (this.player != null) {
                if (this.player.isPermissionSet("residence.max.res." + i)) {
                    this.maxRes = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.res." + i, Residence.getConfigManager().getDefaultWorld())) {
                this.maxRes = i;
            }
            ++i;
        }
    }

    public void recountMaxRents() {
        int i = 1;
        while (i <= Residence.getConfigManager().getMaxRentCount()) {
            if (this.player != null) {
                if (this.player.isPermissionSet("residence.max.rents." + i)) {
                    this.maxRents = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.rents." + i, Residence.getConfigManager().getDefaultWorld())) {
                this.maxRents = i;
            }
            ++i;
        }
    }

    public void recountMaxSubzones() {
        int i = 1;
        while (i <= Residence.getConfigManager().getMaxSubzonesCount()) {
            if (this.player != null) {
                if (this.player.isPermissionSet("residence.max.subzones." + i)) {
                    this.maxSubzones = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.subzones." + i, Residence.getConfigManager().getDefaultWorld())) {
                this.maxSubzones = i;
            }
            ++i;
        }
    }

    public int getMaxRes() {
        this.recountMaxRes();
        return this.maxRes;
    }

    public int getMaxRents() {
        this.recountMaxRents();
        return this.maxRents;
    }

    public int getMaxSubzones() {
        this.recountMaxSubzones();
        return this.maxSubzones;
    }

    public PermissionGroup getGroup() {
        Player player = Bukkit.getPlayer((String)this.userName);
        if (player != null) {
            String gp = Residence.getPermissionManager().getGroupNameByPlayer(player.getName(), player.getWorld().getName());
            this.group = Residence.getPermissionManager().getGroupByName(gp);
        } else {
            String gp = Residence.getPermissionManager().getGroupNameByPlayer(this.userName, Residence.getConfigManager().getDefaultWorld());
            this.group = Residence.getPermissionManager().getGroupByName(gp);
        }
        return this.group;
    }

    public void recountRes() {
        if (this.userName != null) {
            ResidenceManager m = Residence.getResidenceManager();
            this.ResidenceList = m.getResidenceMapList(this.userName, true);
        }
        this.recountResAmount();
    }

    public void recountResAmount() {
        this.currentRes = this.ResidenceList.size();
    }

    public void addResidence(ClaimedResidence residence) {
        String name = residence.getName();
        if (Residence.getConfigManager().isResCreateCaseSensitive()) {
            name = name.toLowerCase();
        }
        this.ResidenceList.put(name, residence);
    }

    public void removeResidence(String residence) {
        if (Residence.getConfigManager().isResCreateCaseSensitive()) {
            residence = residence.toLowerCase();
        }
        this.ResidenceList.remove(residence);
    }

    public void renameResidence(String oldResidence, String newResidence) {
        ClaimedResidence res;
        if (Residence.getConfigManager().isResCreateCaseSensitive()) {
            oldResidence = oldResidence.toLowerCase();
            newResidence = newResidence.toLowerCase();
        }
        if ((res = this.ResidenceList.get(oldResidence)) != null) {
            this.removeResidence(oldResidence);
            this.ResidenceList.put(newResidence, res);
        }
    }

    public int getResAmount() {
        if (this.currentRes == -1) {
            this.recountResAmount();
        }
        return this.currentRes;
    }

    public List<ClaimedResidence> getResList() {
        ArrayList<ClaimedResidence> temp = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> one : this.ResidenceList.entrySet()) {
            temp.add(one.getValue());
        }
        return temp;
    }
}

