/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.ResidenceCommandListener;
import com.bekvon.bukkit.residence.containers.HelpLines;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class HelpEntry {
    protected String name;
    protected String desc;
    protected String[] lines;
    protected List<HelpEntry> subentrys;
    protected static int linesPerPage = 8;

    public HelpEntry(String entryname) {
        this.name = entryname;
        this.subentrys = new ArrayList<HelpEntry>();
        this.lines = new String[0];
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String inname) {
        this.name = inname;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public String getDescription() {
        if (this.desc == null) {
            return "";
        }
        return this.desc;
    }

    public void printHelp(CommandSender sender, int page, boolean resadmin2, String path) {
        List<HelpLines> helplines = this.getHelpData(sender, resadmin2);
        path = "/" + path.replace(".", " ") + " ";
        int pagecount = (int)Math.ceil((double)helplines.size() / (double)linesPerPage);
        if (page > pagecount || page < 1) {
            sender.sendMessage(Residence.getLM().getMessage("Invalid.Help"));
            return;
        }
        String separator = "" + ChatColor.GOLD;
        String simbol = "-";
        if (sender instanceof Player) {
            simbol = "\u25ac";
        }
        int i = 0;
        while (i < 10) {
            separator = String.valueOf(separator) + simbol;
            ++i;
        }
        sender.sendMessage(ChatColor.GOLD + separator + " " + Residence.getLM().getMessage("General.HelpPageHeader", path, page, pagecount) + " " + separator);
        int start = linesPerPage * (page - 1);
        int end = start + linesPerPage;
        int i2 = start;
        while (i2 < end) {
            if (helplines.size() > i2) {
                if (helplines.get(i2).getCommand() != null) {
                    HelpEntry sub = this.getSubEntry(helplines.get(i2).getCommand());
                    String desc = "";
                    int y = 0;
                    String[] stringArray = sub.lines;
                    int n = sub.lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String one = stringArray[n2];
                        desc = String.valueOf(desc) + ChatColor.YELLOW + one;
                        if (++y < sub.lines.length) {
                            desc = String.valueOf(desc) + "\n";
                        }
                        ++n2;
                    }
                    if (resadmin2) {
                        path = path.replace("/res ", "/resadmin ");
                    }
                    String msg = "[\"\",{\"text\":\"" + ChatColor.GOLD + " " + helplines.get(i2).getDesc() + "\",\"color\":\"gold\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + path + helplines.get(i2).getCommand() + " \"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + desc + "\"}]}}}]";
                    if (sender instanceof Player) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + msg));
                    } else {
                        sender.sendMessage(helplines.get(i2).getDesc());
                    }
                } else {
                    sender.sendMessage(ChatColor.GREEN + " " + helplines.get(i2).getDesc());
                }
            }
            ++i2;
        }
        if (pagecount == 1) {
            return;
        }
        int NextPage = page + 1;
        NextPage = page < pagecount ? NextPage : page;
        int Prevpage = page - 1;
        Prevpage = page > 1 ? Prevpage : page;
        String baseCmd = resadmin2 ? "resadmin" : "res";
        String prevCmd = !this.name.equalsIgnoreCase("res") ? "/" + baseCmd + " " + this.name + " ? " + Prevpage : "/" + baseCmd + " ? " + Prevpage;
        String prev = "[\"\",{\"text\":\"" + separator + " " + Residence.getLM().getMessage("General.PrevInfoPage") + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + prevCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + "<<<" + "\"}]}}}";
        String nextCmd = !this.name.equalsIgnoreCase("res") ? "/" + baseCmd + " " + this.name + " ? " + NextPage : "/" + baseCmd + " ? " + NextPage;
        String next = " {\"text\":\"" + Residence.getLM().getMessage("General.NextInfoPage") + " " + separator + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + nextCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ">>>" + "\"}]}}}]";
        if (sender instanceof Player) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + prev + "," + next));
        }
    }

    public void printHelp(CommandSender sender, int page, String path, boolean resadmin2) {
        HelpEntry subEntry = this.getSubEntry(path);
        if (subEntry != null) {
            subEntry.printHelp(sender, page, resadmin2, path);
        } else {
            sender.sendMessage(Residence.getLM().getMessage("Invalid.Help"));
        }
    }

    private List<HelpLines> getHelpData(CommandSender sender, boolean resadmin2) {
        ArrayList<HelpLines> helplines = new ArrayList<HelpLines>();
        String[] stringArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            String one = stringArray[n2];
            helplines.add(new HelpLines(null, one));
            ++n2;
        }
        FlagPermissions GlobalFlags = Residence.getPermissionManager().getAllFlags();
        Map<String, String> unsortMap = new HashMap<String, String>();
        for (HelpEntry helpEntry : this.subentrys) {
            if (!this.name.equalsIgnoreCase("flags")) {
                if (ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && !resadmin2 || !ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && resadmin2) {
                    continue;
                }
            } else if (GlobalFlags.getFlags().containsKey(helpEntry.getName().toLowerCase())) {
                Boolean state = GlobalFlags.getFlags().get(helpEntry.getName().toLowerCase());
                if (!state.booleanValue() && !resadmin2 && !sender.hasPermission("residence.flag." + helpEntry.getName().toLowerCase())) continue;
                unsortMap.put(helpEntry.getName(), ChatColor.GREEN + helpEntry.getName() + ChatColor.GOLD + " - " + helpEntry.getDescription());
                continue;
            }
            helplines.add(new HelpLines(helpEntry.getName(), ChatColor.GREEN + helpEntry.getName() + ChatColor.GOLD + " - " + helpEntry.getDescription()));
        }
        if (!unsortMap.isEmpty()) {
            unsortMap = Residence.getSortingManager().sortStringByKeyASC(unsortMap);
            for (Map.Entry entry : unsortMap.entrySet()) {
                helplines.add(new HelpLines((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return helplines;
    }

    public boolean containesEntry(String name) {
        return this.getSubEntry(name) != null;
    }

    public HelpEntry getSubEntry(String name) {
        String[] split = name.split("\\.");
        HelpEntry entry = this;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String entryname = stringArray[n2];
            if ((entry = entry.findSubEntry(entryname)) == null) {
                return null;
            }
            ++n2;
        }
        return entry;
    }

    private HelpEntry findSubEntry(String name) {
        for (HelpEntry entry : this.subentrys) {
            if (!entry.getName().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return null;
    }

    public void addSubEntry(HelpEntry entry) {
        if (!this.subentrys.contains(entry)) {
            this.subentrys.add(entry);
        }
    }

    public void removeSubEntry(HelpEntry entry) {
        if (this.subentrys.contains(entry)) {
            this.subentrys.remove(entry);
        }
    }

    public int getSubEntryCount() {
        return this.subentrys.size();
    }

    public static HelpEntry parseHelp(FileConfiguration node, String key) {
        String[] split = key.split("\\.");
        String thisname = split[split.length - 1];
        HelpEntry entry = new HelpEntry(thisname);
        ConfigurationSection keysnode = node.getConfigurationSection(key);
        Set keys = null;
        if (keysnode != null) {
            keys = keysnode.getKeys(false);
        }
        if (keys != null) {
            List stringList;
            if (keys.contains("Info") && (stringList = node.getStringList(String.valueOf(key) + ".Info")) != null) {
                entry.lines = new String[stringList.size()];
                int i = 0;
                while (i < stringList.size()) {
                    entry.lines[i] = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)stringList.get(i)));
                    ++i;
                }
            }
            if (keys.contains("Description")) {
                entry.desc = node.getString(String.valueOf(key) + ".Description");
            }
            if (keys.contains("SubCommands")) {
                Set subcommandkeys = node.getConfigurationSection(String.valueOf(key) + ".SubCommands").getKeys(false);
                for (String subkey : subcommandkeys) {
                    entry.subentrys.add(HelpEntry.parseHelp(node, String.valueOf(key) + ".SubCommands." + subkey));
                }
            }
        }
        return entry;
    }

    public Set<String> getSubCommands(CommandSender sender, String[] args) {
        block63: {
            boolean subCommand;
            ConfigurationSection tempmeinPath;
            HashSet<String> subCommands;
            block64: {
                File langFile = new File(new File(Residence.getDataLocation(), "Language"), "English.yml");
                subCommands = new HashSet<String>();
                if (!langFile.isFile()) break block63;
                YamlConfiguration node = new YamlConfiguration();
                try {
                    node.load(langFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
                ConfigurationSection meinPath = node.getConfigurationSection("CommandHelp.SubCommands.res.SubCommands");
                tempmeinPath = node.getConfigurationSection("CommandHelp.SubCommands.res.SubCommands");
                if (args.length == 1) {
                    return meinPath.getKeys(false);
                }
                boolean ok = true;
                int i = 0;
                while (ok) {
                    if (args[i].equalsIgnoreCase("")) {
                        return tempmeinPath.getKeys(false);
                    }
                    if (!tempmeinPath.isConfigurationSection(String.valueOf(args[i]) + ".SubCommands")) break;
                    tempmeinPath = tempmeinPath.getConfigurationSection(String.valueOf(args[i]) + ".SubCommands");
                    ++i;
                }
                int neededArgPlace = args.length - 2 - i;
                subCommand = true;
                if (tempmeinPath.isConfigurationSection(args[i])) {
                    subCommand = false;
                    tempmeinPath = tempmeinPath.getConfigurationSection(args[i]);
                }
                String Args = tempmeinPath.isString("Args") ? tempmeinPath.getString("Args") : null;
                ArrayList<String> ArgsList = new ArrayList<String>();
                if (Args != null) {
                    if (Args.contains(" ")) {
                        ArgsList.addAll(Arrays.asList(Args.split(" ")));
                    } else {
                        ArgsList.add(Args);
                    }
                }
                String NeededArg = null;
                if (neededArgPlace < ArgsList.size() && neededArgPlace >= 0) {
                    NeededArg = (String)ArgsList.get(neededArgPlace);
                }
                if (NeededArg == null) break block64;
                switch (NeededArg) {
                    case "[playername]": {
                        for (Player one : Bukkit.getOnlinePlayers()) {
                            subCommands.add(one.getName());
                        }
                        break;
                    }
                    case "[residence]": {
                        ClaimedResidence res;
                        if (sender instanceof Player) {
                            ArrayList<String> resList;
                            String resName;
                            res = Residence.getResidenceManager().getByLoc(((Player)sender).getLocation());
                            if (res != null && (resName = res.getName()) != null) {
                                subCommands.add(resName);
                            }
                            if ((resList = Residence.getResidenceManager().getResidenceList(((Player)sender).getName(), true, false, false)).size() <= 0) break;
                            subCommands.addAll(resList);
                            break;
                        }
                        ArrayList<String> resList = Residence.getResidenceManager().getResidenceList("Server_land", true, false, false);
                        if (resList.size() <= 0) break;
                        subCommands.addAll(resList);
                        break;
                    }
                    case "[cresidence]": {
                        String resName;
                        ClaimedResidence res;
                        if (!(sender instanceof Player) || (res = Residence.getResidenceManager().getByLoc(((Player)sender).getLocation())) == null || (resName = res.getName()) == null) break;
                        subCommands.add(resName);
                        break;
                    }
                    case "[residenceshop]": {
                        subCommands.addAll(Residence.getResidenceManager().getShops());
                        break;
                    }
                    case "[flag]": {
                        FlagPermissions GlobalFlags = Residence.getPermissionManager().getAllFlags();
                        for (Map.Entry<String, Boolean> one : GlobalFlags.getFlags().entrySet()) {
                            subCommands.add(one.getKey());
                        }
                        break;
                    }
                    case "[deposit/withdraw]": {
                        subCommands.add("deposit");
                        subCommands.add("withdraw");
                        break;
                    }
                    case "[enter/leave]": {
                        subCommands.add("enter");
                        subCommands.add("leave");
                        break;
                    }
                    case "[renew/cost]": {
                        subCommands.add("renew");
                        subCommands.add("cost");
                        break;
                    }
                    case "[true/false]": {
                        subCommands.add("true");
                        subCommands.add("false");
                        break;
                    }
                    case "[true/false/remove]": {
                        subCommands.add("true");
                        subCommands.add("false");
                        subCommands.add("remove");
                        break;
                    }
                    case "[blacklist/ignorelist]": {
                        subCommands.add("blacklist");
                        subCommands.add("ignorelist");
                        break;
                    }
                    case "[material]": {
                        Material[] materialArray = Material.values();
                        int n = materialArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Material one = materialArray[n2];
                            subCommands.add(one.name().toLowerCase());
                            ++n2;
                        }
                        break;
                    }
                    case "[worldname]": {
                        for (World one : Bukkit.getWorlds()) {
                            subCommands.add(one.getName());
                        }
                        break;
                    }
                }
            }
            String command2 = tempmeinPath.getCurrentPath().replace("CommandHelp.SubCommands.", "").replace(".SubCommands.", " ");
            if (subCommands.size() > 0) {
                return subCommands;
            }
            if (subCommand) {
                return tempmeinPath.getKeys(false);
            }
            Bukkit.dispatchCommand((CommandSender)sender, (String)(String.valueOf(command2) + " ?"));
        }
        return new HashSet<String>(Arrays.asList("?"));
    }
}

