/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WorldFlagManager {
    protected Map<String, Map<String, FlagPermissions>> groupperms;
    protected Map<String, FlagPermissions> worldperms;
    protected FlagPermissions globaldefaults = new FlagPermissions();

    public WorldFlagManager() {
        this.worldperms = new HashMap<String, FlagPermissions>();
        this.groupperms = new HashMap<String, Map<String, FlagPermissions>>();
    }

    public WorldFlagManager(FileConfiguration config, FileConfiguration groups) {
        this();
        this.parsePerms(config, groups);
    }

    public FlagPermissions getPerms(Player player) {
        return this.getPerms(player.getWorld().getName(), Residence.getPermissionManager().getGroupNameByPlayer(player));
    }

    public FlagPermissions getPerms(String world, String group) {
        world = world.toLowerCase();
        Map<String, FlagPermissions> groupworldperms = this.groupperms.get(group = group.toLowerCase());
        if (groupworldperms == null) {
            return this.getPerms(world);
        }
        FlagPermissions list2 = groupworldperms.get(world);
        if (list2 == null) {
            list2 = groupworldperms.get("global." + world);
            if (list2 == null) {
                list2 = groupworldperms.get("global");
            }
            if (list2 == null) {
                return this.getPerms(world);
            }
        }
        return list2;
    }

    public FlagPermissions getPerms(String world) {
        FlagPermissions list2 = this.worldperms.get(world = world.toLowerCase());
        if (list2 == null) {
            if (this.globaldefaults == null) {
                return new FlagPermissions();
            }
            return this.globaldefaults;
        }
        return list2;
    }

    public final void parsePerms(FileConfiguration config, FileConfiguration groups) {
        block13: {
            try {
                Set keys = config.getConfigurationSection("Global.Flags").getKeys(false);
                if (keys != null) {
                    for (String string : keys) {
                        if (string.equalsIgnoreCase("Global")) {
                            this.globaldefaults = FlagPermissions.parseFromConfigNode(string, config.getConfigurationSection("Global.Flags"));
                            continue;
                        }
                        this.worldperms.put(string.toLowerCase(), FlagPermissions.parseFromConfigNode(string, config.getConfigurationSection("Global.Flags")));
                    }
                }
                for (Map.Entry entry : this.worldperms.entrySet()) {
                    ((FlagPermissions)entry.getValue()).setParent(this.globaldefaults);
                }
                if (!groups.isConfigurationSection("Groups")) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Your groups.yml file is incorrect!");
                    return;
                }
                keys = groups.getConfigurationSection("Groups").getKeys(false);
                if (keys == null) break block13;
                for (String string : keys) {
                    Set worldkeys;
                    if (!groups.contains("Groups." + string + ".Flags") || !groups.contains("Groups." + string + ".Flags.World") || string == null || (worldkeys = groups.getConfigurationSection("Groups." + string + ".Flags.World").getKeys(false)) == null) continue;
                    HashMap<String, FlagPermissions> perms = new HashMap<String, FlagPermissions>();
                    for (String string2 : worldkeys) {
                        FlagPermissions list2 = FlagPermissions.parseFromConfigNode(string2, groups.getConfigurationSection("Groups." + string + ".Flags.World"));
                        if (string2.equalsIgnoreCase("global")) {
                            list2.setParent(this.globaldefaults);
                            perms.put(string2.toLowerCase(), list2);
                            for (Map.Entry<String, FlagPermissions> worldperm : this.worldperms.entrySet()) {
                                list2 = FlagPermissions.parseFromConfigNode(string2, groups.getConfigurationSection("Groups." + string + ".Flags.World"));
                                list2.setParent(worldperm.getValue());
                                perms.put("global." + worldperm.getKey().toLowerCase(), list2);
                            }
                            continue;
                        }
                        perms.put(string2.toLowerCase(), list2);
                    }
                    for (Map.Entry entry : perms.entrySet()) {
                        String wkey = (String)entry.getKey();
                        FlagPermissions list3 = (FlagPermissions)entry.getValue();
                        if (wkey.startsWith("global.")) continue;
                        list3.setParent((FlagPermissions)perms.get("global." + wkey));
                        if (list3.getParent() == null) {
                            list3.setParent(this.worldperms.get(wkey));
                        }
                        if (list3.getParent() != null) continue;
                        list3.setParent(this.globaldefaults);
                    }
                    this.groupperms.put(string.toLowerCase(), perms);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(WorldFlagManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

