/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.SelectionSides;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class SelectionManager {
    protected Map<String, Location> playerLoc1;
    protected Map<String, Location> playerLoc2;
    protected Server server;
    private Residence plugin;
    public static HashMap<String, Long> normalPrintMap = new HashMap();
    public static HashMap<String, Long> errorPrintMap = new HashMap();
    public static HashMap<String, Integer> normalIDMap = new HashMap();
    public static HashMap<String, Integer> errorIDMap = new HashMap();
    public static final int MIN_HEIGHT = 0;
    Permission p = new Permission("residence.bypass.ignorey", PermissionDefault.FALSE);

    public SelectionManager(Server server2, Residence plugin) {
        this.plugin = plugin;
        this.server = server2;
        this.playerLoc1 = Collections.synchronizedMap(new HashMap());
        this.playerLoc2 = Collections.synchronizedMap(new HashMap());
    }

    public void updateLocations(Player player, Location loc1, Location loc2) {
        if (loc1 != null && loc2 != null) {
            this.playerLoc1.put(player.getName(), loc1);
            this.playerLoc2.put(player.getName(), loc2);
            this.updateForY(player);
            this.afterSelectionUpdate(player);
        }
    }

    public void placeLoc1(Player player, Location loc, boolean show) {
        if (loc != null) {
            this.playerLoc1.put(player.getName(), loc);
            this.updateForY(player);
            if (show) {
                this.afterSelectionUpdate(player);
            }
        }
    }

    public void placeLoc2(Player player, Location loc, boolean show) {
        if (loc != null) {
            this.playerLoc2.put(player.getName(), loc);
            this.updateForY(player);
            if (show) {
                this.afterSelectionUpdate(player);
            }
        }
    }

    private void updateForY(Player player) {
        if (Residence.getConfigManager().isSelectionIgnoreY() && this.hasPlacedBoth(player.getName()) && !player.hasPermission(this.p)) {
            this.qsky(player);
            this.qbedrock(player);
        }
    }

    public void afterSelectionUpdate(Player player) {
        if (this.hasPlacedBoth(player.getName())) {
            this.NewMakeBorders(player, this.getPlayerLoc1(player.getName()), this.getPlayerLoc2(player.getName()), false);
        }
    }

    public Location getPlayerLoc1(String player) {
        return this.playerLoc1.get(player);
    }

    public Location getPlayerLoc2(String player) {
        return this.playerLoc2.get(player);
    }

    public CuboidArea getSelectionCuboid(Player player) {
        return this.getSelectionCuboid(player.getName());
    }

    public CuboidArea getSelectionCuboid(String player) {
        return new CuboidArea(this.getPlayerLoc1(player), this.getPlayerLoc2(player));
    }

    public boolean hasPlacedBoth(String player) {
        return this.playerLoc1.containsKey(player) && this.playerLoc2.containsKey(player);
    }

    public void showSelectionInfoInActionBar(Player player) {
        if (!Residence.getConfigManager().useActionBarOnSelection()) {
            return;
        }
        String pname = player.getName();
        CuboidArea cuboidArea = new CuboidArea(this.getPlayerLoc1(pname), this.getPlayerLoc2(pname));
        String Message = Residence.getLM().getMessage("Select.TotalSize", cuboidArea.getSize());
        PermissionGroup group = Residence.getPermissionManager().getGroup(player);
        if (Residence.getConfigManager().enableEconomy()) {
            Message = String.valueOf(Message) + " " + Residence.getLM().getMessage("General.LandCost", (int)Math.ceil((double)cuboidArea.getSize() * group.getCostPerBlock()));
        }
        Residence.getAB().send(player, Message);
    }

    public void showSelectionInfo(Player player) {
        String pname = player.getName();
        if (this.hasPlacedBoth(pname)) {
            player.sendMessage(Residence.getLM().getMessage("General.Separator"));
            CuboidArea cuboidArea = new CuboidArea(this.getPlayerLoc1(pname), this.getPlayerLoc2(pname));
            player.sendMessage(Residence.getLM().getMessage("Select.TotalSize", cuboidArea.getSize()));
            PermissionGroup group = Residence.getPermissionManager().getGroup(player);
            if (Residence.getConfigManager().enableEconomy()) {
                player.sendMessage(Residence.getLM().getMessage("General.LandCost", (int)Math.ceil((double)cuboidArea.getSize() * group.getCostPerBlock())));
            }
            player.sendMessage(ChatColor.YELLOW + "X" + Residence.getLM().getMessage("General.Size", cuboidArea.getXSize()));
            player.sendMessage(ChatColor.YELLOW + "Y" + Residence.getLM().getMessage("General.Size", cuboidArea.getYSize()));
            player.sendMessage(ChatColor.YELLOW + "Z" + Residence.getLM().getMessage("General.Size", cuboidArea.getZSize()));
            player.sendMessage(Residence.getLM().getMessage("General.Separator"));
            this.NewMakeBorders(player, this.getPlayerLoc1(pname), this.getPlayerLoc2(pname), false);
        } else {
            player.sendMessage(Residence.getLM().getMessage("Select.Points"));
        }
    }

    public static boolean showParticle(Player player, Location Current, boolean error) {
        if (!player.getLocation().getWorld().getName().equalsIgnoreCase(Current.getWorld().getName())) {
            return false;
        }
        if (!error) {
            Residence.getConfigManager().getSelectedFrame().display(0.0f, 0.0f, 0.0f, 0.0f, 1, Current, player);
        } else {
            Residence.getConfigManager().getOverlapFrame().display(0.0f, 0.0f, 0.0f, 0.0f, 1, Current, player);
        }
        return false;
    }

    public static boolean showParticleWalls(Player player, Location Current, boolean error) {
        if (!player.getLocation().getWorld().getName().equalsIgnoreCase(Current.getWorld().getName())) {
            return false;
        }
        if (!error) {
            Residence.getConfigManager().getSelectedSides().display(0.0f, 0.0f, 0.0f, 0.0f, 1, Current, player);
        } else {
            Residence.getConfigManager().getOverlapSides().display(0.0f, 0.0f, 0.0f, 0.0f, 1, Current, player);
        }
        return false;
    }

    public void NewMakeBorders(final Player player, final Location OriginalLow, final Location OriginalHigh, final boolean error) {
        if (!Residence.getConfigManager().useVisualizer()) {
            return;
        }
        if (!error) {
            normalPrintMap.put(player.getName(), System.currentTimeMillis());
        } else {
            errorPrintMap.put(player.getName(), System.currentTimeMillis());
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                SelectionManager.this.MakeBorders(player, OriginalLow, OriginalHigh, error);
            }
        });
    }

    public List<Location> getLocations(Location lowLoc, Location loc, Double TX, Double TY, Double TZ, Double Range, boolean StartFromZero) {
        double eachCollumn = Residence.getConfigManager().getVisualizerRowSpacing();
        double eachRow = Residence.getConfigManager().getVisualizerCollumnSpacing();
        if (TX == 0.0) {
            TX = eachCollumn + eachCollumn * 0.1;
        }
        if (TY == 0.0) {
            TY = eachRow + eachRow * 0.1;
        }
        if (TZ == 0.0) {
            TZ = eachCollumn + eachCollumn * 0.1;
        }
        double CollumnStart = eachCollumn;
        double RowStart = eachRow;
        if (StartFromZero) {
            CollumnStart = 0.0;
            RowStart = 0.0;
        }
        ArrayList<Location> locList = new ArrayList<Location>();
        if (lowLoc.getWorld() != loc.getWorld()) {
            return locList;
        }
        double x = CollumnStart;
        while (x < TX) {
            Location CurrentX = lowLoc.clone();
            if (TX > eachCollumn + eachCollumn * 0.1) {
                CurrentX.add(x, 0.0, 0.0);
            }
            double y = RowStart;
            while (y < TY) {
                Location CurrentY = CurrentX.clone();
                if (TY > eachRow + eachRow * 0.1) {
                    CurrentY.add(0.0, y, 0.0);
                }
                double z = CollumnStart;
                while (z < TZ) {
                    double dist;
                    Location CurrentZ = CurrentY.clone();
                    if (TZ > eachCollumn + eachCollumn * 0.1) {
                        CurrentZ.add(0.0, 0.0, z);
                    }
                    if ((dist = loc.distance(CurrentZ)) < Range) {
                        locList.add(CurrentZ.clone());
                    }
                    z += eachCollumn;
                }
                y += eachRow;
            }
            x += eachCollumn;
        }
        return locList;
    }

    public List<Location> GetLocationsWallsByData(Player player, Location loc, Double TX, Double TY, Double TZ, Location lowLoc, SelectionSides Sides, double Range) {
        ArrayList<Location> locList = new ArrayList<Location>();
        if (Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), TX, TY, 0.0, Range, false));
        }
        if (Sides.ShowSouthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, TZ.doubleValue()), loc.clone(), TX, TY, 0.0, Range, false));
        }
        if (Sides.ShowWestSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), 0.0, TY, TZ, Range, false));
        }
        if (Sides.ShowEastSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, 0.0), loc.clone(), 0.0, TY, TZ, Range, false));
        }
        if (Sides.ShowTopSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), 0.0), loc.clone(), TX, 0.0, TZ, Range, false));
        }
        if (Sides.ShowBottomSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), TX, 0.0, TZ, Range, false));
        }
        return locList;
    }

    public List<Location> GetLocationsCornersByData(Player player, Location loc, Double TX, Double TY, Double TZ, Location lowLoc, SelectionSides Sides, double Range) {
        ArrayList<Location> locList = new ArrayList<Location>();
        if (Sides.ShowBottomSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowTopSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), 0.0), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowBottomSide() && Sides.ShowSouthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, TZ.doubleValue()), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowTopSide() && Sides.ShowSouthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), TZ.doubleValue()), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowWestSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, 0.0), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowEastSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, 0.0), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowSouthSide() && Sides.ShowWestSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, TZ.doubleValue()), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowSouthSide() && Sides.ShowEastSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, TZ.doubleValue()), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowWestSide() && Sides.ShowBottomSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        if (Sides.ShowEastSide() && Sides.ShowBottomSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        if (Sides.ShowWestSide() && Sides.ShowTopSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        if (Sides.ShowEastSide() && Sides.ShowTopSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), TY.doubleValue(), 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        return locList;
    }

    public boolean MakeBorders(final Player player, final Location OriginalLow, final Location OriginalHigh, final boolean error) {
        CuboidArea cuboidArea = new CuboidArea(OriginalLow, OriginalHigh);
        cuboidArea.getHighLoc().add(1.0, 1.0, 1.0);
        SelectionSides Sides = new SelectionSides();
        int Range = Residence.getConfigManager().getVisualizerRange();
        Location loc = player.getLocation();
        double PLLX = loc.getBlockX() - Range;
        double PLLZ = loc.getBlockZ() - Range;
        double PLLY = loc.getBlockY() - Range;
        double PLHX = loc.getBlockX() + Range;
        double PLHZ = loc.getBlockZ() + Range;
        double PLHY = loc.getBlockY() + Range;
        if ((double)cuboidArea.getLowLoc().getBlockX() < PLLX) {
            cuboidArea.getLowLoc().setX(PLLX);
            Sides.setWestSide(false);
        }
        if ((double)cuboidArea.getHighLoc().getBlockX() > PLHX) {
            cuboidArea.getHighLoc().setX(PLHX);
            Sides.setEastSide(false);
        }
        if ((double)cuboidArea.getLowLoc().getBlockZ() < PLLZ) {
            cuboidArea.getLowLoc().setZ(PLLZ);
            Sides.setNorthSide(false);
        }
        if ((double)cuboidArea.getHighLoc().getBlockZ() > PLHZ) {
            cuboidArea.getHighLoc().setZ(PLHZ);
            Sides.setSouthSide(false);
        }
        if ((double)cuboidArea.getLowLoc().getBlockY() < PLLY) {
            cuboidArea.getLowLoc().setY(PLLY);
            Sides.setBottomSide(false);
        }
        if ((double)cuboidArea.getHighLoc().getBlockY() > PLHY) {
            cuboidArea.getHighLoc().setY(PLHY);
            Sides.setTopSide(false);
        }
        double TX = cuboidArea.getXSize() - 1;
        double TY = cuboidArea.getYSize() - 1;
        double TZ = cuboidArea.getZSize() - 1;
        if (!error && normalIDMap.containsKey(player.getName())) {
            Bukkit.getScheduler().cancelTask(normalIDMap.get(player.getName()).intValue());
        } else if (error && errorIDMap.containsKey(player.getName())) {
            Bukkit.getScheduler().cancelTask(errorIDMap.get(player.getName()).intValue());
        }
        final List<Location> locList = this.GetLocationsWallsByData(player, loc, TX, TY, TZ, cuboidArea.getLowLoc().clone(), Sides, Range);
        final List<Location> locList2 = this.GetLocationsCornersByData(player, loc, TX, TY, TZ, cuboidArea.getLowLoc().clone(), Sides, Range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!error) {
                    for (Location one : locList) {
                        Residence.getConfigManager().getSelectedSides().display(0.0f, 0.0f, 0.0f, 0.0f, 1, one, player);
                    }
                } else {
                    for (Location one : locList) {
                        Residence.getConfigManager().getOverlapSides().display(0.0f, 0.0f, 0.0f, 0.0f, 1, one, player);
                    }
                }
                if (!error) {
                    for (Location one : locList2) {
                        Residence.getConfigManager().getSelectedFrame().display(0.0f, 0.0f, 0.0f, 0.0f, 1, one, player);
                    }
                } else {
                    for (Location one : locList2) {
                        Residence.getConfigManager().getOverlapFrame().display(0.0f, 0.0f, 0.0f, 0.0f, 1, one, player);
                    }
                }
            }
        });
        String planerName = player.getName();
        if (!error && !normalPrintMap.containsKey(planerName)) {
            return false;
        }
        if (error && !errorPrintMap.containsKey(planerName)) {
            return false;
        }
        if (!error && normalPrintMap.get(planerName) + (long)Residence.getConfigManager().getVisualizerShowFor() < System.currentTimeMillis()) {
            return false;
        }
        if (error && errorPrintMap.get(planerName) + (long)Residence.getConfigManager().getVisualizerShowFor() < System.currentTimeMillis()) {
            return false;
        }
        int scid = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (player.isOnline()) {
                    SelectionManager.this.MakeBorders(player, OriginalLow, OriginalHigh, error);
                }
            }
        }, (long)Residence.getConfigManager().getVisualizerUpdateInterval() * 1L);
        if (!error) {
            normalIDMap.put(planerName, scid);
        } else {
            errorIDMap.put(planerName, scid);
        }
        return true;
    }

    public void vert(Player player, boolean resadmin2) {
        if (this.hasPlacedBoth(player.getName())) {
            this.sky(player, resadmin2);
            this.bedrock(player, resadmin2);
        } else {
            player.sendMessage(Residence.getLM().getMessage("Select.Points"));
        }
    }

    public void qsky(Player player) {
        int y1 = this.playerLoc1.get(player.getName()).getBlockY();
        int y2 = this.playerLoc2.get(player.getName()).getBlockY();
        int newy = player.getLocation().getWorld().getMaxHeight() - 1;
        if (y1 > y2) {
            this.playerLoc1.get(player.getName()).setY((double)newy);
        } else {
            this.playerLoc2.get(player.getName()).setY((double)newy);
        }
    }

    public void qbedrock(Player player) {
        int y2;
        int y1 = this.playerLoc1.get(player.getName()).getBlockY();
        if (y1 < (y2 = this.playerLoc2.get(player.getName()).getBlockY())) {
            boolean newy = false;
            this.playerLoc1.get(player.getName()).setY((double)newy);
        } else {
            boolean newy = false;
            this.playerLoc2.get(player.getName()).setY((double)newy);
        }
    }

    public void sky(Player player, boolean resadmin2) {
        if (this.hasPlacedBoth(player.getName())) {
            PermissionGroup group = Residence.getPermissionManager().getGroup(player);
            int y1 = this.playerLoc1.get(player.getName()).getBlockY();
            int y2 = this.playerLoc2.get(player.getName()).getBlockY();
            int newy = player.getLocation().getWorld().getMaxHeight() - 1;
            if (y1 > y2) {
                if (!resadmin2) {
                    if (group.getMaxHeight() < newy) {
                        newy = group.getMaxHeight();
                    }
                    if (newy - y2 > group.getMaxY() - 1) {
                        newy = y2 + (group.getMaxY() - 1);
                    }
                }
                this.playerLoc1.get(player.getName()).setY((double)newy);
            } else {
                if (!resadmin2) {
                    if (group.getMaxHeight() < newy) {
                        newy = group.getMaxHeight();
                    }
                    if (newy - y1 > group.getMaxY() - 1) {
                        newy = y1 + (group.getMaxY() - 1);
                    }
                }
                this.playerLoc2.get(player.getName()).setY((double)newy);
            }
            player.sendMessage(Residence.getLM().getMessage("Select.Sky"));
        } else {
            player.sendMessage(Residence.getLM().getMessage("Select.Points"));
        }
    }

    public void bedrock(Player player, boolean resadmin2) {
        if (this.hasPlacedBoth(player.getName())) {
            int y2;
            PermissionGroup group = Residence.getPermissionManager().getGroup(player);
            int y1 = this.playerLoc1.get(player.getName()).getBlockY();
            if (y1 < (y2 = this.playerLoc2.get(player.getName()).getBlockY())) {
                int newy = 0;
                if (!resadmin2) {
                    if (newy < group.getMinHeight()) {
                        newy = group.getMinHeight();
                    }
                    if (y2 - newy > group.getMaxY() - 1) {
                        newy = y2 - (group.getMaxY() - 1);
                    }
                }
                this.playerLoc1.get(player.getName()).setY((double)newy);
            } else {
                int newy = 0;
                if (!resadmin2) {
                    if (newy < group.getMinHeight()) {
                        newy = group.getMinHeight();
                    }
                    if (y1 - newy > group.getMaxY() - 1) {
                        newy = y1 - (group.getMaxY() - 1);
                    }
                }
                this.playerLoc2.get(player.getName()).setY((double)newy);
            }
            player.sendMessage(Residence.getLM().getMessage("Select.Bedrock"));
        } else {
            player.sendMessage(Residence.getLM().getMessage("Select.Points"));
        }
    }

    public void clearSelection(Player player) {
        this.playerLoc1.remove(player.getName());
        this.playerLoc2.remove(player.getName());
    }

    public void selectChunk(Player player) {
        Chunk chunk = player.getWorld().getChunkAt(player.getLocation());
        int xcoord = chunk.getX() * 16;
        int zcoord = chunk.getZ() * 16;
        boolean ycoord = false;
        int xmax = xcoord + 15;
        int zmax = zcoord + 15;
        int ymax = player.getLocation().getWorld().getMaxHeight() - 1;
        this.playerLoc1.put(player.getName(), new Location(player.getWorld(), (double)xcoord, (double)ycoord, (double)zcoord));
        this.playerLoc2.put(player.getName(), new Location(player.getWorld(), (double)xmax, (double)ymax, (double)zmax));
        player.sendMessage(Residence.getLM().getMessage("Select.Success"));
    }

    public boolean worldEdit(Player player) {
        player.sendMessage(Residence.getLM().getMessage("General.WorldEditNotFound"));
        return false;
    }

    public boolean worldEditUpdate(Player player) {
        player.sendMessage(Residence.getLM().getMessage("General.WorldEditNotFound"));
        return false;
    }

    public void selectBySize(Player player, int xsize, int ysize, int zsize) {
        Location myloc = player.getLocation();
        Location loc1 = new Location(myloc.getWorld(), (double)(myloc.getBlockX() + xsize), (double)(myloc.getBlockY() + ysize), (double)(myloc.getBlockZ() + zsize));
        Location loc2 = new Location(myloc.getWorld(), (double)(myloc.getBlockX() - xsize), (double)(myloc.getBlockY() - ysize), (double)(myloc.getBlockZ() - zsize));
        this.placeLoc1(player, loc1, false);
        this.placeLoc2(player, loc2, true);
        player.sendMessage(Residence.getLM().getMessage("Select.Success"));
        this.showSelectionInfo(player);
    }

    public void modify(Player player, boolean shift, double amount) {
        if (!this.hasPlacedBoth(player.getName())) {
            player.sendMessage(Residence.getLM().getMessage("Select.Points"));
            return;
        }
        Direction d = this.getDirection(player);
        if (d == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Direction"));
        }
        CuboidArea area2 = new CuboidArea(this.playerLoc1.get(player.getName()), this.playerLoc2.get(player.getName()));
        switch (d) {
            case DOWN: {
                double oldy = area2.getLowLoc().getBlockY();
                oldy -= amount;
                if (oldy < 0.0) {
                    player.sendMessage(Residence.getLM().getMessage("Select.TooLow"));
                    oldy = 0.0;
                }
                area2.getLowLoc().setY(oldy);
                if (shift) {
                    double oldy2 = area2.getHighLoc().getBlockY();
                    area2.getHighLoc().setY(oldy2 -= amount);
                    player.sendMessage(Residence.getLM().getMessage("Shifting.Down", amount));
                    break;
                }
                player.sendMessage(Residence.getLM().getMessage("Expanding.Down", amount));
                break;
            }
            case MINUSX: {
                double oldx = area2.getLowLoc().getBlockX();
                area2.getLowLoc().setX(oldx -= amount);
                if (shift) {
                    double oldx2 = area2.getHighLoc().getBlockX();
                    area2.getHighLoc().setX(oldx2 -= amount);
                    player.sendMessage(Residence.getLM().getMessage("Shifting.West", amount));
                    break;
                }
                player.sendMessage(Residence.getLM().getMessage("Expanding.West", amount));
                break;
            }
            case MINUSZ: {
                double oldz = area2.getLowLoc().getBlockZ();
                area2.getLowLoc().setZ(oldz -= amount);
                if (shift) {
                    double oldz2 = area2.getHighLoc().getBlockZ();
                    area2.getHighLoc().setZ(oldz2 -= amount);
                    player.sendMessage(Residence.getLM().getMessage("Shifting.North", amount));
                    break;
                }
                player.sendMessage(Residence.getLM().getMessage("Expanding.North", amount));
                break;
            }
            case PLUSX: {
                double oldx = area2.getHighLoc().getBlockX();
                area2.getHighLoc().setX(oldx += amount);
                if (shift) {
                    double oldx2 = area2.getLowLoc().getBlockX();
                    area2.getLowLoc().setX(oldx2 += amount);
                    player.sendMessage(Residence.getLM().getMessage("Shifting.East", amount));
                    break;
                }
                player.sendMessage(Residence.getLM().getMessage("Expanding.East", amount));
                break;
            }
            case PLUSZ: {
                double oldz = area2.getHighLoc().getBlockZ();
                area2.getHighLoc().setZ(oldz += amount);
                if (shift) {
                    double oldz2 = area2.getLowLoc().getBlockZ();
                    area2.getLowLoc().setZ(oldz2 += amount);
                    player.sendMessage(Residence.getLM().getMessage("Shifting.South", amount));
                    break;
                }
                player.sendMessage(Residence.getLM().getMessage("Expanding.South", amount));
                break;
            }
            case UP: {
                double oldy = area2.getHighLoc().getBlockY();
                oldy += amount;
                if (oldy > (double)(player.getLocation().getWorld().getMaxHeight() - 1)) {
                    player.sendMessage(Residence.getLM().getMessage("Select.TooHigh"));
                    oldy = player.getLocation().getWorld().getMaxHeight() - 1;
                }
                area2.getHighLoc().setY(oldy);
                if (shift) {
                    double oldy2 = area2.getLowLoc().getBlockY();
                    area2.getLowLoc().setY(oldy2 += amount);
                    player.sendMessage(Residence.getLM().getMessage("Shifting.Up", amount));
                    break;
                }
                player.sendMessage(Residence.getLM().getMessage("Expanding.Up", amount));
                break;
            }
        }
        this.updateLocations(player, area2.getHighLoc(), area2.getLowLoc());
    }

    public boolean contract(Player player, double amount, boolean resadmin2) {
        if (!this.hasPlacedBoth(player.getName())) {
            player.sendMessage(Residence.getLM().getMessage("Select.Points"));
            return false;
        }
        Direction d = this.getDirection(player);
        if (d == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Direction"));
        }
        CuboidArea area2 = new CuboidArea(this.playerLoc1.get(player.getName()), this.playerLoc2.get(player.getName()));
        switch (d) {
            case DOWN: {
                double oldy = area2.getHighLoc().getBlockY();
                oldy -= amount;
                if (oldy > (double)(player.getLocation().getWorld().getMaxHeight() - 1)) {
                    player.sendMessage(Residence.getLM().getMessage("Select.TooHigh"));
                    oldy = player.getLocation().getWorld().getMaxHeight() - 1;
                }
                area2.getHighLoc().setY(oldy);
                player.sendMessage(Residence.getLM().getMessage("Contracting.Down", amount));
                break;
            }
            case MINUSX: {
                double oldx = area2.getHighLoc().getBlockX();
                area2.getHighLoc().setX(oldx -= amount);
                player.sendMessage(Residence.getLM().getMessage("Contracting.West", amount));
                break;
            }
            case MINUSZ: {
                double oldz = area2.getHighLoc().getBlockZ();
                area2.getHighLoc().setZ(oldz -= amount);
                player.sendMessage(Residence.getLM().getMessage("Contracting.North", amount));
                break;
            }
            case PLUSX: {
                double oldx = area2.getLowLoc().getBlockX();
                area2.getLowLoc().setX(oldx += amount);
                player.sendMessage(Residence.getLM().getMessage("Contracting.East", amount));
                break;
            }
            case PLUSZ: {
                double oldz = area2.getLowLoc().getBlockZ();
                area2.getLowLoc().setZ(oldz += amount);
                player.sendMessage(Residence.getLM().getMessage("Contracting.South", amount));
                break;
            }
            case UP: {
                double oldy = area2.getLowLoc().getBlockY();
                oldy += amount;
                if (oldy < 0.0) {
                    player.sendMessage(Residence.getLM().getMessage("Select.TooLow"));
                    oldy = 0.0;
                }
                area2.getLowLoc().setY(oldy);
                player.sendMessage(Residence.getLM().getMessage("Contracting.Up", amount));
                break;
            }
        }
        if (!ClaimedResidence.CheckAreaSize(player, area2, resadmin2)) {
            return false;
        }
        this.updateLocations(player, area2.getHighLoc(), area2.getLowLoc());
        return true;
    }

    private Direction getDirection(Player player) {
        int yaw = (int)player.getLocation().getYaw();
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 45;
        int facing = (yaw %= 360) / 90;
        float pitch = player.getLocation().getPitch();
        if (pitch < -50.0f) {
            return Direction.UP;
        }
        if (pitch > 50.0f) {
            return Direction.DOWN;
        }
        if (facing == 1) {
            return Direction.MINUSX;
        }
        if (facing == 3) {
            return Direction.PLUSX;
        }
        if (facing == 2) {
            return Direction.MINUSZ;
        }
        if (facing == 0) {
            return Direction.PLUSZ;
        }
        return null;
    }

    public static enum Direction {
        UP,
        DOWN,
        PLUSX,
        PLUSZ,
        MINUSX,
        MINUSZ;

    }
}

