/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.shampaggon.crackshot.events.WeaponDamageEntityEvent;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class CrackShot
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(WeaponDamageEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        Player cause = null;
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (Residence.isResAdminOn(cause)) {
            return;
        }
        if (!(event.getVictim() instanceof LivingEntity)) {
            return;
        }
        Entity entity = event.getVictim();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(entity.getLocation());
        if (Residence.getNms().isAnimal(entity) && res != null && !res.getPermissions().playerHas(cause.getName(), "animalkilling", true)) {
            cause.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "animalkilling", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(WeaponDamageEntityEvent event) {
        Player player;
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getVictim().getType() != EntityType.ITEM_FRAME && !Residence.getNms().isArmorStandEntity(event.getVictim().getType())) {
            return;
        }
        Entity dmgr = event.getDamager();
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
        } else if (dmgr instanceof Projectile && ((Projectile)dmgr).getShooter() instanceof Player) {
            player = (Player)((Projectile)dmgr).getShooter();
        } else {
            return;
        }
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Location loc = event.getVictim().getLocation();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(loc);
        if (res != null && !res.getPermissions().playerHas(player.getName(), "container", false)) {
            event.setCancelled(true);
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "container", res.getName()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(WeaponDamageEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!(event.getVictim() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getVictim();
        if (victim.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence area2 = Residence.getResidenceManager().getByLoc(victim.getLocation());
        Player damager = event.getPlayer();
        ClaimedResidence srcarea = null;
        if (damager == null) {
            return;
        }
        srcarea = Residence.getResidenceManager().getByLoc(damager.getLocation());
        boolean srcpvp = true;
        if (srcarea != null) {
            srcpvp = srcarea.getPermissions().has("pvp", true);
        }
        if (!srcpvp) {
            damager.sendMessage(Residence.getLM().getMessage("General.NoPVPZone"));
            event.setCancelled(true);
            return;
        }
        if (area2 == null) {
            if (!Residence.getWorldFlags().getPerms(damager.getWorld().getName()).has("pvp", true)) {
                damager.sendMessage(Residence.getLM().getMessage("General.WorldPVPDisabled"));
                event.setCancelled(true);
            }
        } else if (!area2.getPermissions().has("pvp", true)) {
            damager.sendMessage(Residence.getLM().getMessage("General.NoPVPZone"));
            event.setCancelled(true);
        }
    }
}

