/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.cmd;
import com.bekvon.bukkit.residence.event.ResidenceCommandEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceCommandListener
extends Residence {
    public static List<String> AdminCommands = Arrays.asList("removeworld", "setowner", "removeall", "signupdate", "listhidden", "listallhidden", "server", "clearflags", "resreload", "resload", "signconvert", "reload");

    public static List<String> getAdminCommands() {
        return AdminCommands;
    }

    public boolean onCommand(CommandSender sender, Command command2, String label, String[] args) {
        block40: {
            boolean respond;
            String cmd2;
            ResidenceCommandEvent cevent = new ResidenceCommandEvent(command2.getName(), args, sender);
            Residence.getServ().getPluginManager().callEvent((Event)cevent);
            if (cevent.isCancelled()) {
                return true;
            }
            if (sender instanceof Player && !Residence.getPermissionManager().isResidenceAdmin((CommandSender)((Player)sender)) && Residence.isDisabledWorldCommand(((Player)sender).getWorld())) {
                sender.sendMessage(Residence.getLM().getMessage("General.DisabledWorld"));
                return true;
            }
            if (command2.getName().equals("resreload") && args.length == 0) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (Residence.getPermissionManager().isResidenceAdmin((CommandSender)player) && player.hasPermission("residence.topadmin")) {
                        this.reloadPlugin();
                        sender.sendMessage(ChatColor.GREEN + "[Residence] Reloaded config.");
                        System.out.println("[Residence] Reloaded by " + player.getName() + ".");
                    } else {
                        player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                    }
                } else {
                    this.reloadPlugin();
                    System.out.println("[Residence] Reloaded by console.");
                }
                return true;
            }
            if (command2.getName().equals("resload")) {
                if (!(sender instanceof Player) || sender instanceof Player && Residence.gmanager.isResidenceAdmin((CommandSender)((Player)sender)) && ((Player)sender).hasPermission("residence.topadmin")) {
                    try {
                        this.loadYml();
                        sender.sendMessage(ChatColor.GREEN + "[Residence] Reloaded save file...");
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "[Residence] Unable to reload the save file, exception occured!");
                        sender.sendMessage(ChatColor.RED + ex.getMessage());
                        Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    sender.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                }
                return true;
            }
            if (command2.getName().equals("rc")) {
                cmd cmdClass = this.getCmdClass(sender, "rc", new String[]{"rc"});
                if (cmdClass == null) {
                    this.sendUsage(sender, command2.getName());
                    return true;
                }
                boolean respond2 = cmdClass.perform(args, false, command2, sender);
                if (!respond2) {
                    this.sendUsage(sender, command2.getName());
                }
                return true;
            }
            if (!command2.getName().equals("res") && !command2.getName().equals("residence") && !command2.getName().equals("resadmin")) break block40;
            boolean resadmin2 = false;
            if (sender instanceof Player) {
                if (command2.getName().equals("resadmin") && Residence.gmanager.isResidenceAdmin((CommandSender)((Player)sender))) {
                    resadmin2 = true;
                }
                if (command2.getName().equals("resadmin") && !Residence.gmanager.isResidenceAdmin((CommandSender)((Player)sender))) {
                    ((Player)sender).sendMessage(Residence.getLM().getMessage("Residence.NonAdmin"));
                    return true;
                }
                if (command2.getName().equals("res") && Residence.gmanager.isResidenceAdmin((CommandSender)((Player)sender)) && Residence.getConfigManager().getAdminFullAccess()) {
                    resadmin2 = true;
                }
            } else {
                resadmin2 = true;
            }
            if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("?") || args.length > 1 && args[args.length - 2].equals("?")) {
                return this.commandHelp(args, resadmin2, sender, command2);
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            } else {
                resadmin2 = true;
            }
            if (Residence.cmanager.allowAdminsOnly() && !resadmin2) {
                player.sendMessage(Residence.getLM().getMessage("General.AdminOnly"));
                return true;
            }
            if (args.length == 0) {
                args = new String[]{"?"};
            }
            switch (cmd2 = args[0].toLowerCase()) {
                case "delete": {
                    cmd2 = "remove";
                    break;
                }
                case "sz": {
                    cmd2 = "subzone";
                }
            }
            cmd cmdClass = this.getCmdClass(sender, command2.getName(), args);
            if (cmdClass == null) {
                return this.commandHelp(new String[]{"?"}, resadmin2, sender, command2);
            }
            if (!sender.hasPermission("residence.command." + args[0].toLowerCase())) {
                sender.sendMessage(Residence.getLM().getMessage("General.NoCmdPermission"));
                return true;
            }
            if (!resadmin2 && Residence.resadminToggle.contains(player.getName()) && !Residence.gmanager.isResidenceAdmin((CommandSender)player)) {
                Residence.resadminToggle.remove(player.getName());
            }
            if (!(respond = cmdClass.perform(args, resadmin2, command2, sender))) {
                String[] tempArray = new String[args.length + 1];
                int i = 0;
                while (i < args.length) {
                    tempArray[i] = args[i];
                    ++i;
                }
                tempArray[args.length] = "?";
                args = tempArray;
                return this.commandHelp(args, resadmin2, sender, command2);
            }
            return true;
        }
        return this.onCommand(sender, command2, label, args);
    }

    private cmd getCmdClass(CommandSender sender, String command2, String[] args) {
        cmd cmdClass = null;
        try {
            Class<?> nmsClass = Class.forName("com.bekvon.bukkit.residence.commands." + args[0].toLowerCase());
            if (cmd.class.isAssignableFrom(nmsClass)) {
                cmdClass = (cmd)nmsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return cmdClass;
    }

    public void sendUsage(CommandSender sender, String command2) {
        sender.sendMessage(Residence.getLM().getMessage("General.DefaultUsage", command2));
    }

    private boolean commandHelp(String[] args, boolean resadmin2, CommandSender sender, Command command2) {
        if (Residence.helppages == null) {
            return false;
        }
        String helppath = this.getHelpPath(args);
        int page = 1;
        if (!args[args.length - 1].equalsIgnoreCase("?")) {
            try {
                page = Integer.parseInt(args[args.length - 1]);
            }
            catch (Exception ex) {
                sender.sendMessage(Residence.getLM().getMessage("General.InvalidHelp"));
            }
        }
        if (command2.getName().equalsIgnoreCase("res")) {
            resadmin2 = false;
        }
        if (Residence.helppages.containesEntry(helppath)) {
            Residence.helppages.printHelp(sender, page, helppath, resadmin2);
        }
        return true;
    }

    private String getHelpPath(String[] args) {
        String helppath = "res";
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("?")) break;
            helppath = String.valueOf(helppath) + "." + args[i];
            ++i;
        }
        if (!Residence.helppages.containesEntry(helppath) && args.length > 0) {
            return this.getHelpPath(Arrays.copyOf(args, args.length - 1));
        }
        return helppath;
    }
}

