/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.shopStuff;

import com.bekvon.bukkit.residence.CommentedYamlConfiguration;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.shopStuff.Board;
import com.bekvon.bukkit.residence.shopStuff.ShopVote;
import com.bekvon.bukkit.residence.shopStuff.Vote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ShopSignUtil {
    ConcurrentHashMap<String, List<ShopVote>> VoteList = new ConcurrentHashMap();
    List<Board> AllBoards = new ArrayList<Board>();
    private Residence plugin;

    public ShopSignUtil(Residence plugin) {
        this.plugin = plugin;
    }

    public void setVoteList(ConcurrentHashMap<String, List<ShopVote>> VoteList) {
        this.VoteList = VoteList;
    }

    public ConcurrentHashMap<String, List<ShopVote>> GetAllVoteList() {
        return this.VoteList;
    }

    public void removeVoteList(String resName) {
        this.VoteList.remove(resName);
    }

    public void addVote(String ResName, List<ShopVote> ShopVote2) {
        this.VoteList.put(ResName, ShopVote2);
    }

    public void setAllSigns(List<Board> AllBoards) {
        this.AllBoards = AllBoards;
    }

    public List<Board> GetAllBoards() {
        return this.AllBoards;
    }

    public void removeBoard(Board Board2) {
        this.AllBoards.remove(Board2);
    }

    public void addBoard(Board Board2) {
        this.AllBoards.add(Board2);
    }

    public void LoadShopVotes() {
        this.GetAllVoteList().clear();
        File file = new File(this.plugin.getDataFolder(), "ShopVotes.yml");
        YamlConfiguration f = YamlConfiguration.loadConfiguration((File)file);
        if (!f.isConfigurationSection("ShopVotes")) {
            return;
        }
        ConfigurationSection ConfCategory = f.getConfigurationSection("ShopVotes");
        ArrayList categoriesList = new ArrayList(ConfCategory.getKeys(false));
        if (categoriesList.size() == 0) {
            return;
        }
        for (String category : categoriesList) {
            List List2 = ConfCategory.getStringList(category);
            ArrayList<ShopVote> VoteList = new ArrayList<ShopVote>();
            for (String oneEntry : List2) {
                if (!oneEntry.contains("%")) continue;
                String name = oneEntry.split("%")[0];
                int vote = -1;
                try {
                    String voteString = oneEntry.split("%")[1];
                    if (voteString.contains("!")) {
                        voteString = oneEntry.split("%")[1].split("!")[0];
                    }
                    vote = Integer.parseInt(voteString);
                }
                catch (Exception ex) {
                    continue;
                }
                if (vote < 0) {
                    vote = 0;
                } else if (vote > 10) {
                    vote = 10;
                }
                long time = 0L;
                if (oneEntry.contains("!")) {
                    try {
                        time = Long.parseLong(oneEntry.split("!")[1]);
                    }
                    catch (Exception ex) {
                        time = System.currentTimeMillis();
                    }
                }
                VoteList.add(new ShopVote(name, vote, time));
            }
            this.addVote(category, VoteList);
        }
    }

    public void saveShopVotes() {
        File f = new File(this.plugin.getDataFolder(), "ShopVotes.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        CommentedYamlConfiguration writer = new CommentedYamlConfiguration();
        conf.options().copyDefaults(true);
        writer.addComment("ShopVotes", "DO NOT EDIT THIS FILE BY HAND!");
        if (!conf.isConfigurationSection("ShopVotes")) {
            conf.createSection("ShopVotes");
        }
        for (Map.Entry<String, List<ShopVote>> one : this.GetAllVoteList().entrySet()) {
            if (one.getKey() == null || one.getKey().equalsIgnoreCase("")) continue;
            String path = "ShopVotes." + one.getKey();
            ArrayList<String> list2 = new ArrayList<String>();
            for (ShopVote oneVote : one.getValue()) {
                list2.add(String.valueOf(oneVote.getName()) + "%" + oneVote.getVote() + "!" + oneVote.getTime());
            }
            writer.set(path, list2);
        }
        try {
            writer.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Vote getAverageVote(String resName) {
        ConcurrentHashMap<String, List<ShopVote>> allvotes = this.GetAllVoteList();
        if (!allvotes.containsKey(resName)) {
            return new Vote(Residence.getConfigManager().getVoteRangeTo() / 2, 0);
        }
        List<ShopVote> votes = allvotes.get(resName);
        double total = 0.0;
        for (ShopVote oneVote : votes) {
            total += (double)oneVote.getVote();
        }
        double vote = (double)((int)(total / (double)votes.size() * 100.0)) / 100.0;
        return new Vote(vote, votes.size());
    }

    public int getLikes(String resName) {
        ConcurrentHashMap<String, List<ShopVote>> allvotes = this.GetAllVoteList();
        if (!allvotes.containsKey(resName)) {
            return 0;
        }
        List<ShopVote> votes = allvotes.get(resName);
        int likes = 0;
        for (ShopVote oneVote : votes) {
            if (oneVote.getVote() < Residence.getConfigManager().getVoteRangeTo() / 2) continue;
            ++likes;
        }
        return likes;
    }

    public Map<String, Double> getSortedShopList() {
        Map<String, Double> allvotes = new HashMap<String, Double>();
        List<String> shops = Residence.getResidenceManager().getShops();
        for (String one : shops) {
            if (Residence.getConfigManager().isOnlyLike()) {
                allvotes.put(one, Double.valueOf(this.getLikes(one)));
                continue;
            }
            allvotes.put(one, this.getAverageVote(one).getVote());
        }
        allvotes = this.sortByComparator(allvotes);
        return allvotes;
    }

    private Map<String, Double> sortByComparator(Map<String, Double> allvotes) {
        LinkedList<Map.Entry<String, Double>> list2 = new LinkedList<Map.Entry<String, Double>>(allvotes.entrySet());
        Collections.sort(list2, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Double> sortedMap = new LinkedHashMap<String, Double>();
        for (Map.Entry entry : list2) {
            sortedMap.put((String)entry.getKey(), (Double)entry.getValue());
        }
        return sortedMap;
    }

    public void LoadSigns() {
        this.GetAllBoards().clear();
        File file = new File(this.plugin.getDataFolder(), "ShopSigns.yml");
        YamlConfiguration f = YamlConfiguration.loadConfiguration((File)file);
        if (!f.isConfigurationSection("ShopSigns")) {
            return;
        }
        ConfigurationSection ConfCategory = f.getConfigurationSection("ShopSigns");
        ArrayList categoriesList = new ArrayList(ConfCategory.getKeys(false));
        if (categoriesList.size() == 0) {
            return;
        }
        for (String category : categoriesList) {
            ConfigurationSection NameSection = ConfCategory.getConfigurationSection(category);
            Board newTemp = new Board();
            newTemp.setStartPlace(NameSection.getInt("StartPlace"));
            newTemp.setWorld(NameSection.getString("World"));
            newTemp.setTX(NameSection.getInt("TX"));
            newTemp.setTY(NameSection.getInt("TY"));
            newTemp.setTZ(NameSection.getInt("TZ"));
            newTemp.setBX(NameSection.getInt("BX"));
            newTemp.setBY(NameSection.getInt("BY"));
            newTemp.setBZ(NameSection.getInt("BZ"));
            newTemp.GetTopLocation();
            newTemp.GetBottomLocation();
            newTemp.GetLocations();
            this.addBoard(newTemp);
        }
    }

    public void saveSigns() {
        File f = new File(this.plugin.getDataFolder(), "ShopSigns.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        CommentedYamlConfiguration writer = new CommentedYamlConfiguration();
        conf.options().copyDefaults(true);
        writer.addComment("ShopSigns", "DO NOT EDIT THIS FILE BY HAND!");
        if (!conf.isConfigurationSection("ShopSigns")) {
            conf.createSection("ShopSigns");
        }
        int cat = 0;
        for (Board one : this.GetAllBoards()) {
            String path = "ShopSigns." + ++cat;
            writer.set(String.valueOf(path) + ".StartPlace", one.GetStartPlace());
            writer.set(String.valueOf(path) + ".World", one.GetWorld());
            writer.set(String.valueOf(path) + ".TX", one.GetTopLocation().getBlockX());
            writer.set(String.valueOf(path) + ".TY", one.GetTopLocation().getBlockY());
            writer.set(String.valueOf(path) + ".TZ", one.GetTopLocation().getBlockZ());
            writer.set(String.valueOf(path) + ".BX", one.GetBottomLocation().getBlockX());
            writer.set(String.valueOf(path) + ".BY", one.GetBottomLocation().getBlockY());
            writer.set(String.valueOf(path) + ".BZ", one.GetBottomLocation().getBlockZ());
        }
        try {
            writer.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean BoardUpdateDelayed() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ShopSignUtil.this.BoardUpdate();
            }
        }, 20L);
        return true;
    }

    public boolean BoardUpdate() {
        for (Board board : this.GetAllBoards()) {
            board.clearSignLoc();
            List<Location> SignsLocation = board.GetLocations();
            ArrayList<String> ShopNames = new ArrayList<String>(this.getSortedShopList().keySet());
            int Start = board.GetStartPlace();
            for (Location OneSignLoc : SignsLocation) {
                Block block = OneSignLoc.getBlock();
                if (!(block.getState() instanceof Sign)) continue;
                String Shop = "";
                if (ShopNames.size() > Start) {
                    Shop = ShopNames.get(Start);
                }
                ClaimedResidence res = Residence.getResidenceManager().getByName(Shop);
                Sign sign = (Sign)block.getState();
                if (Shop.equalsIgnoreCase("")) {
                    sign.setLine(0, "");
                    sign.setLine(1, "");
                    sign.setLine(2, "");
                    sign.setLine(3, "");
                    sign.update();
                    continue;
                }
                Vote vote = null;
                String votestat = "";
                if (Residence.getResidenceManager().getShops().size() >= Start) {
                    vote = this.getAverageVote(ShopNames.get(Start));
                    votestat = Residence.getConfigManager().isOnlyLike() ? (vote.getAmount() == 0 ? "" : Residence.getLM().getMessage("Shop.ListLiked", this.getLikes(ShopNames.get(Start)))) : (vote.getAmount() == 0 ? "" : Residence.getLM().getMessage("Shop.SignLines.4", String.valueOf(vote.getVote()) + "%" + vote.getAmount()));
                }
                sign.setLine(0, Residence.getLM().getMessage("Shop.SignLines.1", Start + 1));
                sign.setLine(1, Residence.getLM().getMessage("Shop.SignLines.2", res.getName()));
                sign.setLine(2, Residence.getLM().getMessage("Shop.SignLines.3", res.getOwner()));
                sign.setLine(3, votestat);
                sign.update();
                board.addSignLoc(res.getName(), sign.getLocation());
                ++Start;
            }
        }
        return true;
    }
}

