/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.potion.PotionEffect;

public class ResidenceEntityListener
implements Listener {
    Residence plugin;

    public ResidenceEntityListener(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEndermanChangeBlock(EntityChangeBlockEvent event) {
        if (Residence.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (event.getEntityType() != EntityType.ENDERMAN) {
            return;
        }
        FlagPermissions perms = Residence.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has("destroy", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(block.getWorld())) {
            return;
        }
        Material mat = block.getType();
        Entity entity = event.getEntity();
        FlagPermissions perms = Residence.getPermsByLoc(block.getLocation());
        boolean hastrample = perms.has("trample", perms.has("hasbuild", true));
        if (!(hastrample || entity.getType() == EntityType.FALLING_BLOCK || mat != Material.SOIL && mat != Material.SOUL_SAND)) {
            event.setCancelled(true);
        }
    }

    public static boolean isMonster(Entity ent) {
        return ent instanceof Monster || ent instanceof Slime || ent instanceof Ghast;
    }

    private boolean isTamed(Entity ent) {
        return ent instanceof Tameable ? ((Tameable)ent).isTamed() : false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!Residence.getNms().isAnimal(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (Residence.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(cause.getName(), "animalkilling", true)) {
            cause.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "AnimalKilling", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKillingByFlame(EntityCombustByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!Residence.getNms().isAnimal(entity)) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        Entity damager = event.getCombuster();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (Residence.isResAdminOn(cause)) {
            return;
        }
        if (!res.getPermissions().playerHas(cause.getName(), "animalkilling", true)) {
            cause.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "AnimalKilling", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalDamageByMobs(EntityDamageByEntityEvent event) {
        FlagPermissions world;
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!Residence.getNms().isAnimal(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player || damager instanceof Player) {
            return;
        }
        FlagPermissions perms = Residence.getPermsByLoc(entity.getLocation());
        if (!perms.has("animalkilling", (world = Residence.getWorldFlags().getPerms(entity.getWorld().getName())).has("animalkilling", true))) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void OnEntityDeath(EntityDeathEvent event) {
        LivingEntity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (ent instanceof Player) {
            return;
        }
        Location loc = ent.getLocation();
        FlagPermissions perms = Residence.getPermsByLoc(loc);
        if (!perms.has("mobitemdrop", true)) {
            event.getDrops().clear();
        }
        if (!perms.has("mobexpdrop", true)) {
            event.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void VehicleDestroy(VehicleDestroyEvent event) {
        FlagPermissions perms;
        Entity damager = event.getAttacker();
        if (damager == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(damager.getWorld())) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle == null) {
            return;
        }
        if ((damager instanceof Projectile && !(((Projectile)damager).getShooter() instanceof Player) || !(damager instanceof Player)) && !(perms = Residence.getPermsByLoc(vehicle.getLocation())).has("vehicledestroy", true)) {
            event.setCancelled(true);
            return;
        }
        Player cause = null;
        if (damager instanceof Player) {
            cause = (Player)damager;
        } else if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) {
            cause = (Player)((Projectile)damager).getShooter();
        }
        if (cause == null) {
            return;
        }
        if (Residence.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(vehicle.getLocation());
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(cause.getName(), "vehicledestroy", true)) {
            cause.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "vehicledestroy", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void MonsterKilling(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!ResidenceEntityListener.isMonster(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (Residence.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(cause.getName(), "mobkilling", true)) {
            cause.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "MobKilling", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalLeash(PlayerLeashEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        if (!Residence.getNms().isAnimal(entity) && !(player instanceof Player)) {
            return;
        }
        if (Residence.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(player.getName(), "leash", true)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Leash", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        block20: {
            FlagPermissions perms;
            LivingEntity ent;
            block19: {
                ent = event.getEntity();
                if (ent == null) {
                    return;
                }
                if (Residence.isDisabledWorldListener(ent.getWorld())) {
                    return;
                }
                perms = Residence.getPermsByLoc(event.getLocation());
                if (!Residence.getNms().isAnimal((Entity)ent)) break block19;
                if (!perms.has("animals", true)) {
                    event.setCancelled(true);
                    return;
                }
                switch (event.getSpawnReason()) {
                    case BUILD_WITHER: {
                        break;
                    }
                    case BUILD_SNOWMAN: 
                    case BUILD_IRONGOLEM: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (!perms.has("canimals", true)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case EGG: 
                    case VILLAGE_DEFENSE: 
                    case VILLAGE_INVASION: 
                    case BREEDING: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case CURED: 
                    case OCELOT_BABY: 
                    case MOUNT: {
                        if (!perms.has("nanimals", true)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (!perms.has("sanimals", true)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (ResidenceEntityListener.isMonster((Entity)ent)) {
                if (!perms.has("monsters", true)) {
                    event.setCancelled(true);
                    return;
                }
                switch (event.getSpawnReason()) {
                    case BUILD_WITHER: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (perms.has("cmonsters", true)) break;
                        event.setCancelled(true);
                        return;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case LIGHTNING: 
                    case SLIME_SPLIT: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case INFECTION: 
                    case CURED: 
                    case SILVERFISH_BLOCK: 
                    case MOUNT: {
                        if (perms.has("nmonsters", true)) break;
                        event.setCancelled(true);
                        return;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (perms.has("smonsters", true)) break;
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        String world;
        String pname;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(player.getWorld())) {
            return;
        }
        if (Residence.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = Residence.getPermsByLocForPlayer(event.getEntity().getLocation(), player);
        if (!perms.playerHas(pname = player.getName(), world = player.getWorld().getName(), "place", perms.playerHas(pname, world, "build", true))) {
            event.setCancelled(true);
            player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "place"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        String world;
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getRemover();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        if (Residence.getResidenceManager().isOwnerOfLocation(player, ent.getLocation())) {
            return;
        }
        String pname = player.getName();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(ent.getLocation(), player);
        if (!perms.playerHas(pname, world = ent.getWorld().getName(), "destroy", perms.playerHas(pname, world, "build", true))) {
            event.setCancelled(true);
            player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "destroy"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (event.getRemover() instanceof Player) {
            return;
        }
        FlagPermissions perms = Residence.getPermsByLoc(ent.getLocation());
        if (!perms.has("destroy", perms.has("build", true))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        FlagPermissions perms = Residence.getPermsByLoc(ent.getLocation());
        if (!perms.has("burn", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        EntityType entity = event.getEntityType();
        FlagPermissions perms = Residence.getPermsByLoc(ent.getLocation());
        switch (entity) {
            case CREEPER: {
                if (perms.has("creeper", perms.has("explode", true))) break;
                if (Residence.getConfigManager().isCreeperExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= Residence.getConfigManager().getCreeperExplodeBelowLevel()) {
                        event.setCancelled(true);
                        ent.remove();
                        break;
                    }
                    ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    event.setCancelled(true);
                    ent.remove();
                    break;
                }
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case PRIMED_TNT: 
            case MINECART_TNT: {
                if (perms.has("tnt", perms.has("explode", true))) break;
                if (Residence.getConfigManager().isTNTExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= Residence.getConfigManager().getTNTExplodeBelowLevel()) {
                        event.setCancelled(true);
                        ent.remove();
                        break;
                    }
                    ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    event.setCancelled(true);
                    ent.remove();
                    break;
                }
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                if (perms.has("fireball", perms.has("explode", true))) break;
                event.setCancelled(true);
                ent.remove();
                break;
            }
            default: {
                if (perms.has("destroy", true)) break;
                event.setCancelled(true);
                ent.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (Residence.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Boolean cancel = false;
        EntityType entity = event.getEntityType();
        FlagPermissions perms = Residence.getPermsByLoc(ent.getLocation());
        FlagPermissions world = Residence.getWorldFlags().getPerms(ent.getWorld().getName());
        switch (entity) {
            case CREEPER: {
                ClaimedResidence res;
                if (perms.has("creeper", perms.has("explode", true))) break;
                if (Residence.getConfigManager().isCreeperExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= Residence.getConfigManager().getCreeperExplodeBelowLevel()) {
                        cancel = true;
                        break;
                    }
                    res = Residence.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    cancel = true;
                    break;
                }
                cancel = true;
                break;
            }
            case PRIMED_TNT: 
            case MINECART_TNT: {
                ClaimedResidence res;
                if (perms.has("tnt", perms.has("explode", true))) break;
                if (Residence.getConfigManager().isTNTExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= Residence.getConfigManager().getTNTExplodeBelowLevel()) {
                        cancel = true;
                        break;
                    }
                    res = Residence.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    cancel = true;
                    break;
                }
                cancel = true;
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                if (perms.has("fireball", perms.has("explode", true))) break;
                cancel = true;
                break;
            }
            default: {
                if (perms.has("destroy", world.has("destroy", true))) break;
                cancel = true;
            }
        }
        if (cancel.booleanValue()) {
            event.setCancelled(true);
            ent.remove();
            return;
        }
        ArrayList<Block> preserve = new ArrayList<Block>();
        block12: for (Block block : event.blockList()) {
            FlagPermissions blockperms = Residence.getPermsByLoc(block.getLocation());
            switch (entity) {
                case CREEPER: {
                    ClaimedResidence res;
                    if (blockperms.has("creeper", blockperms.has("explode", true))) continue block12;
                    if (Residence.getConfigManager().isCreeperExplodeBelow()) {
                        if (block.getY() >= Residence.getConfigManager().getCreeperExplodeBelowLevel()) {
                            preserve.add(block);
                            break;
                        }
                        res = Residence.getResidenceManager().getByLoc(block.getLocation());
                        if (res == null) continue block12;
                        preserve.add(block);
                        break;
                    }
                    preserve.add(block);
                    break;
                }
                case PRIMED_TNT: 
                case MINECART_TNT: {
                    ClaimedResidence res;
                    if (blockperms.has("tnt", blockperms.has("explode", true))) continue block12;
                    if (Residence.getConfigManager().isTNTExplodeBelow()) {
                        if (block.getY() >= Residence.getConfigManager().getTNTExplodeBelowLevel()) {
                            preserve.add(block);
                            break;
                        }
                        res = Residence.getResidenceManager().getByLoc(block.getLocation());
                        if (res == null) continue block12;
                        preserve.add(block);
                        break;
                    }
                    preserve.add(block);
                    break;
                }
                case ENDER_DRAGON: {
                    if (blockperms.has("dragongrief", false)) continue block12;
                    preserve.add(block);
                    break;
                }
                case ENDER_CRYSTAL: {
                    if (blockperms.has("explode", false)) continue block12;
                    preserve.add(block);
                    break;
                }
                case FIREBALL: 
                case SMALL_FIREBALL: {
                    if (blockperms.has("fireball", blockperms.has("explode", true))) continue block12;
                    preserve.add(block);
                    break;
                }
                default: {
                    if (blockperms.has("destroy", world.has("destroy", true))) continue block12;
                    preserve.add(block);
                }
            }
        }
        for (Block block : preserve) {
            event.blockList().remove(block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(PotionSplashEvent event) {
        if (Residence.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        boolean harmfull = false;
        block0: for (PotionEffect one : event.getPotion().getEffects()) {
            for (String oneHarm : Residence.getConfigManager().getNegativePotionEffects()) {
                if (!oneHarm.equalsIgnoreCase(one.getType().getName())) continue;
                harmfull = true;
                break block0;
            }
        }
        if (!harmfull) {
            return;
        }
        ThrownPotion ent = event.getEntity();
        boolean srcpvp = Residence.getPermsByLoc(ent.getLocation()).has("pvp", true);
        for (LivingEntity target : event.getAffectedEntities()) {
            if (target.getType() != EntityType.PLAYER) continue;
            Boolean tgtpvp = Residence.getPermsByLoc(target.getLocation()).has("pvp", true);
            if (srcpvp && tgtpvp.booleanValue()) continue;
            event.setIntensity(target, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntityType() != EntityType.ITEM_FRAME && !Residence.getNms().isArmorStandEntity(event.getEntityType())) {
            return;
        }
        Entity dmgr = event.getDamager();
        Player player = null;
        if (dmgr instanceof Player) {
            player = (Player)event.getDamager();
        } else if (dmgr instanceof Projectile && ((Projectile)dmgr).getShooter() instanceof Player) {
            player = (Player)((Projectile)dmgr).getShooter();
        } else {
            FlagPermissions perms;
            boolean destroy;
            if (dmgr instanceof Projectile && !(((Projectile)dmgr).getShooter() instanceof Player)) {
                Location loc = event.getEntity().getLocation();
                FlagPermissions perm = Residence.getPermsByLoc(loc);
                if (!perm.has("destroy", true)) {
                    event.setCancelled(true);
                }
                return;
            }
            if (!(dmgr.getType() != EntityType.PRIMED_TNT && dmgr.getType() != EntityType.MINECART_TNT && dmgr.getType() != EntityType.WITHER_SKULL && dmgr.getType() != EntityType.WITHER || (destroy = (perms = Residence.getPermsByLoc(event.getEntity().getLocation())).has("explode", false)))) {
                event.setCancelled(true);
                return;
            }
        }
        Location loc = event.getEntity().getLocation();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (ResidenceEntityListener.isMonster(dmgr) && !res.getPermissions().has("destroy", false)) {
            event.setCancelled(true);
            return;
        }
        if (player == null) {
            return;
        }
        if (Residence.isResAdminOn(player)) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "destroy", false)) {
            event.setCancelled(true);
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "destroy", res.getName()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (Residence.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent.hasMetadata("NPC")) {
            return;
        }
        boolean tamedAnimal = this.isTamed(ent);
        ClaimedResidence area2 = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent attackevent = (EntityDamageByEntityEvent)event;
            Entity damager = attackevent.getDamager();
            if (area2 != null && ent instanceof Player && damager instanceof Player && (area2.getPermissions().has("overridepvp", false) || Residence.getConfigManager().isOverridePvp() && area2.getPermissions().has("pvp", false))) {
                Player player;
                Player damage = player = (Player)event.getEntity();
                damage.damage(event.getDamage());
                damage.setVelocity(damager.getLocation().getDirection());
                event.setCancelled(true);
                return;
            }
            ClaimedResidence srcarea = null;
            if (damager != null) {
                srcarea = Residence.getResidenceManager().getByLoc(damager.getLocation());
            }
            boolean srcpvp = true;
            boolean allowSnowBall = false;
            boolean isSnowBall = false;
            if (srcarea != null) {
                srcpvp = srcarea.getPermissions().has("pvp", true);
            }
            if (((ent = attackevent.getEntity()) instanceof Player || tamedAnimal) && (damager instanceof Player || damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) && event.getCause() != EntityDamageEvent.DamageCause.FALL) {
                Player attacker = null;
                if (damager instanceof Player) {
                    attacker = (Player)damager;
                } else if (damager instanceof Projectile) {
                    Projectile project = (Projectile)damager;
                    if (project.getType() == EntityType.SNOWBALL && srcarea != null) {
                        isSnowBall = true;
                        allowSnowBall = srcarea.getPermissions().has("snowball", false);
                    }
                    attacker = (Player)((Projectile)damager).getShooter();
                }
                if (!srcpvp && !isSnowBall || !allowSnowBall && isSnowBall) {
                    attacker.sendMessage(Residence.getLM().getMessage("General.NoPVPZone"));
                    event.setCancelled(true);
                    return;
                }
                if (area2 == null) {
                    if (!Residence.getWorldFlags().getPerms(damager.getWorld().getName()).has("pvp", true)) {
                        attacker.sendMessage(Residence.getLM().getMessage("General.WorldPVPDisabled"));
                        event.setCancelled(true);
                    }
                } else if (!isSnowBall && !area2.getPermissions().has("pvp", true) || isSnowBall && !allowSnowBall) {
                    attacker.sendMessage(Residence.getLM().getMessage("General.NoPVPZone"));
                    event.setCancelled(true);
                }
                return;
            }
            if ((ent instanceof Player || tamedAnimal) && damager instanceof Creeper) {
                if (area2 == null && !Residence.getWorldFlags().getPerms(damager.getWorld().getName()).has("creeper", true)) {
                    event.setCancelled(true);
                } else if (area2 != null && !area2.getPermissions().has("creeper", true)) {
                    event.setCancelled(true);
                }
            }
        }
        if (area2 == null) {
            if (!Residence.getWorldFlags().getPerms(ent.getWorld().getName()).has("damage", true) && (ent instanceof Player || tamedAnimal)) {
                event.setCancelled(true);
            }
        } else if (!area2.getPermissions().has("damage", true) && (ent instanceof Player || tamedAnimal)) {
            event.setCancelled(true);
        }
        if (event.isCancelled() && (ent instanceof Player || tamedAnimal) && (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
            ent.setFireTicks(0);
        }
    }
}

