/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidenceBank {
    int storedMoney = 0;
    ClaimedResidence res;

    public ResidenceBank(ClaimedResidence parent) {
        this.res = parent;
    }

    public int getStoredMoney() {
        return this.storedMoney;
    }

    public void setStoredMoney(int amount) {
        this.storedMoney = amount;
    }

    public void add(int amount) {
        this.storedMoney += amount;
    }

    public boolean hasEnough(int amount) {
        return this.storedMoney >= amount;
    }

    public void subtract(int amount) {
        this.storedMoney -= amount;
        if (this.storedMoney < 0) {
            this.storedMoney = 0;
        }
    }

    public void withdraw(CommandSender sender, int amount, boolean resadmin2) {
        if (!Residence.getConfigManager().enableEconomy()) {
            sender.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
        }
        if (!resadmin2 && !this.res.getPermissions().playerHas(sender.getName(), "bank", false)) {
            sender.sendMessage(Residence.getLM().getMessage("Bank.NoAccess"));
            return;
        }
        if (!this.hasEnough(amount)) {
            sender.sendMessage(Residence.getLM().getMessage("Bank.NoMoney"));
            return;
        }
        if (sender instanceof Player && Residence.getEconomyManager().add(sender.getName(), amount) || !(sender instanceof Player)) {
            this.subtract(amount);
            sender.sendMessage(Residence.getLM().getMessage("Bank.Withdraw", String.format("%d", amount)));
        }
    }

    public void deposit(CommandSender sender, int amount, boolean resadmin2) {
        if (!Residence.getConfigManager().enableEconomy()) {
            sender.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
        }
        if (!resadmin2 && !this.res.getPermissions().playerHas(sender.getName(), "bank", false)) {
            sender.sendMessage(Residence.getLM().getMessage("Bank.NoAccess"));
            return;
        }
        if (sender instanceof Player && !Residence.getEconomyManager().canAfford(sender.getName(), amount)) {
            sender.sendMessage(Residence.getLM().getMessage("Economy.NotEnoughMoney"));
            return;
        }
        if (sender instanceof Player && Residence.getEconomyManager().subtract(sender.getName(), amount) || !(sender instanceof Player)) {
            this.add(amount);
            sender.sendMessage(Residence.getLM().getMessage("Bank.Deposit", String.format("%d", amount)));
        }
    }
}

