/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public interface Region
extends Iterable<BlockVector>,
Cloneable {
    public Vector getMinimumPoint();

    public Vector getMaximumPoint();

    public Vector getCenter();

    public int getArea();

    public int getWidth();

    public int getHeight();

    public int getLength();

    public void expand(Vector ... var1) throws RegionOperationException;

    public void contract(Vector ... var1) throws RegionOperationException;

    public void shift(Vector var1) throws RegionOperationException;

    public boolean contains(Vector var1);

    default public boolean contains(int x, int y, int z) {
        return this.contains(MutableBlockVector.get(x, y, z));
    }

    default public boolean contains(int x, int z) {
        return this.contains(MutableBlockVector.get(x, 0, z));
    }

    default public boolean isGlobal() {
        Vector pos1 = this.getMinimumPoint();
        Vector pos2 = this.getMaximumPoint();
        return pos1.getBlockX() == Integer.MIN_VALUE && pos1.getBlockZ() == Integer.MIN_VALUE && pos2.getBlockX() == Integer.MAX_VALUE && pos2.getBlockZ() == Integer.MAX_VALUE && pos1.getBlockY() <= 0 && pos2.getBlockY() >= 255;
    }

    public Set<Vector2D> getChunks();

    public Set<Vector> getChunkCubes();

    @Nullable
    public World getWorld();

    public void setWorld(@Nullable World var1);

    public Region clone();

    public List<BlockVector2D> polygonize(int var1);
}

