/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.visitor.Fast2DIterator;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.regions.FlatRegion;
import java.util.List;

public class FlatRegionVisitor
implements Operation {
    private final FlatRegionFunction function;
    private MappedFaweQueue queue;
    private int affected = 0;
    private final Iterable<Vector2D> iterator;

    public FlatRegionVisitor(FlatRegion flatRegion, FlatRegionFunction function) {
        Preconditions.checkNotNull((Object)flatRegion);
        Preconditions.checkNotNull((Object)function);
        this.function = function;
        this.iterator = flatRegion.asFlatRegion();
    }

    public FlatRegionVisitor(FlatRegion flatRegion, FlatRegionFunction function, HasFaweQueue hasFaweQueue) {
        Preconditions.checkNotNull((Object)flatRegion);
        Preconditions.checkNotNull((Object)function);
        this.function = function;
        this.iterator = flatRegion.asFlatRegion();
        FaweQueue queue = hasFaweQueue.getQueue();
        this.queue = (MappedFaweQueue)(queue instanceof MappedFaweQueue ? queue : null);
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        if (this.queue != null) {
            for (Vector2D pt : new Fast2DIterator(this.iterator, this.queue)) {
                if (!this.function.apply(pt)) continue;
                ++this.affected;
            }
        } else {
            for (Vector2D pt : this.iterator) {
                if (!this.function.apply(pt)) continue;
                ++this.affected;
            }
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
        messages.add(BBC.VISITOR_FLAT.format(this.getAffected()));
    }
}

