/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory;

import com.boydti.fawe.command.FaweParser;
import com.boydti.fawe.command.SuggestInputParseException;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.util.StringMan;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.MaskCommands;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockMaskBuilder;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.MaskUnion;
import com.sk89q.worldedit.internal.command.ActorAuthorizer;
import com.sk89q.worldedit.internal.command.WorldEditBinding;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.SimpleDispatcher;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultMaskParser
extends FaweParser<Mask> {
    private final Dispatcher dispatcher;
    private final Pattern INTERSECTION_PATTERN = Pattern.compile("[&|;]+(?![^\\[]*\\])");

    public DefaultMaskParser(WorldEdit worldEdit) {
        super(worldEdit);
        this.dispatcher = new SimpleDispatcher();
        this.register(new MaskCommands(worldEdit));
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void register(Object clazz) {
        ParametricBuilder builder = new ParametricBuilder();
        builder.setAuthorizer(new ActorAuthorizer());
        builder.addBinding(new WorldEditBinding(this.worldEdit), new Type[0]);
        builder.registerMethodsAsCommands(this.dispatcher, clazz);
    }

    @Override
    public Mask parseFromInput(String input, ParserContext context) throws InputParseException {
        Actor actor;
        if (input.isEmpty()) {
            throw new SuggestInputParseException("No input provided", "", () -> Stream.concat(Stream.of("#", ",", "&"), BlockTypes.getNameSpaces().stream().map(n -> n + ":")).collect(Collectors.toList()));
        }
        Extent extent = Request.request().getExtent();
        if (extent == null) {
            extent = context.getExtent();
        }
        ArrayList masks = new ArrayList();
        masks.add(new ArrayList());
        CommandLocals locals = new CommandLocals();
        Actor actor2 = actor = context != null ? context.getActor() : null;
        if (actor != null) {
            locals.put(Actor.class, actor);
        }
        try {
            List<Map.Entry<FaweParser.ParseEntry, List<String>>> parsed = DefaultMaskParser.parse(input);
            for (Map.Entry<FaweParser.ParseEntry, List<String>> entry : parsed) {
                FaweParser.ParseEntry pe = entry.getKey();
                String command = pe.input;
                String full = pe.full;
                Mask mask = null;
                if (command.isEmpty()) {
                    mask = this.parseFromInput(StringMan.join((Collection)entry.getValue(), ','), context);
                } else if (this.dispatcher.get(command) == null) {
                    boolean charMask;
                    char char0 = command.charAt(0);
                    boolean bl = charMask = input.length() > 1 && input.charAt(1) != '[';
                    if (charMask && input.charAt(0) == '=') {
                        return this.parseFromInput(char0 + "[" + input.substring(1) + "]", context);
                    }
                    if (char0 == '#' || char0 == '?') {
                        throw new SuggestInputParseException(new NoMatchException("Unknown mask: " + full + ", See: //masks"), full, () -> {
                            if (full.length() == 1) {
                                return new ArrayList<String>(this.dispatcher.getPrimaryAliases());
                            }
                            return this.dispatcher.getAliases().stream().filter(s -> s.startsWith(command.toLowerCase())).collect(Collectors.toList());
                        });
                    }
                    if (charMask) {
                        switch (char0) {
                            case '$': 
                            case '%': 
                            case '/': 
                            case '\\': 
                            case '{': {
                                String value = command.substring(1) + (entry.getValue().isEmpty() ? "" : "[" + StringMan.join((Collection)entry.getValue(), "][") + "]");
                                if (value.contains(":")) {
                                    if (value.charAt(0) == ':') {
                                        value.replaceFirst(":", "");
                                    }
                                    value = value.replaceAll(":", "][");
                                }
                                mask = this.parseFromInput("#" + char0 + "[" + value + "]", context);
                                break;
                            }
                            case '!': 
                            case '<': 
                            case '>': 
                            case '|': 
                            case '~': {
                                input = input.substring(input.indexOf(char0) + 1);
                                mask = this.parseFromInput(char0 + "[" + input + "]", context);
                                if (actor != null) {
                                    BBC.COMMAND_CLARIFYING_BRACKET.send(actor, char0 + "[" + input + "]");
                                }
                                return mask;
                            }
                        }
                    }
                    if (mask == null) {
                        if (command.startsWith("[")) {
                            int end = command.lastIndexOf(93);
                            mask = this.parseFromInput(command.substring(1, end == -1 ? command.length() : end), context);
                        } else {
                            List<String> entries = entry.getValue();
                            BlockMaskBuilder builder = new BlockMaskBuilder();
                            try {
                                builder.addRegex(full);
                            }
                            catch (SuggestInputParseException rethrow) {
                                throw rethrow;
                            }
                            catch (InputParseException rethrow) {
                                // empty catch block
                            }
                            if (mask == null) {
                                context.setPreferringWildcard(true);
                                context.setRestricted(false);
                                BlockStateHolder block = (BlockStateHolder)this.worldEdit.getBlockFactory().parseFromInput(full, context);
                                builder.add(block);
                                mask = builder.build(extent);
                            }
                        }
                    }
                } else {
                    List<String> args = entry.getValue();
                    String cmdArgs = args.isEmpty() ? "" : " " + StringMan.join(args, " ");
                    try {
                        mask = (Mask)this.dispatcher.call(command + cmdArgs, locals, new String[0]);
                    }
                    catch (SuggestInputParseException rethrow) {
                        throw rethrow;
                    }
                    catch (Throwable e) {
                        throw SuggestInputParseException.of(e, full, () -> {
                            try {
                                List<String> suggestions = this.dispatcher.get(command).getCallable().getSuggestions(cmdArgs, locals);
                                if (suggestions.size() <= 2) {
                                    for (int i = 0; i < suggestions.size(); ++i) {
                                        String suggestion = suggestions.get(i);
                                        if (suggestion.indexOf(32) == 0) continue;
                                        Object[] split = suggestion.split(" ");
                                        suggestion = BBC.color("[" + StringMan.join(split, "][") + "]");
                                        suggestions.set(i, suggestion);
                                    }
                                }
                                return suggestions;
                            }
                            catch (CommandException e1) {
                                throw new InputParseException(e1.getMessage());
                            }
                            catch (Throwable e2) {
                                e2.printStackTrace();
                                throw new InputParseException(e2.getMessage());
                            }
                        });
                    }
                }
                if (pe.and) {
                    masks.add(new ArrayList());
                }
                ((List)masks.get(masks.size() - 1)).add(mask);
            }
        }
        catch (InputParseException rethrow) {
            throw rethrow;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InputParseException(e.getMessage(), e);
        }
        ArrayList<Mask> maskUnions = new ArrayList<Mask>();
        for (List list : masks) {
            if (list.size() == 1) {
                maskUnions.add((Mask)list.get(0));
                continue;
            }
            if (list.size() == 0) continue;
            maskUnions.add(new MaskUnion(list));
        }
        if (maskUnions.size() == 1) {
            return (Mask)maskUnions.get(0);
        }
        if (maskUnions.size() != 0) {
            return new MaskIntersection(maskUnions);
        }
        return null;
    }
}

