/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.wrappers;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TargetBlock;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import java.io.File;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class PlayerWrapper
extends AbstractPlayerActor {
    private final Player parent;

    public PlayerWrapper(Player parent) {
        this.parent = parent;
    }

    public static PlayerWrapper wrap(Player parent) {
        if (parent instanceof PlayerWrapper) {
            return (PlayerWrapper)parent;
        }
        return new PlayerWrapper(parent);
    }

    public Player getParent() {
        return this.parent;
    }

    @Override
    public BlockState getBlockInHand(HandSide handSide) throws WorldEditException {
        return this.parent.getBlockInHand(handSide);
    }

    @Override
    public UUID getUniqueId() {
        return this.parent.getUniqueId();
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        return this.parent.getItemInHand(handSide);
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
        this.parent.giveItem(itemStack);
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return this.parent.getInventoryBlockBag();
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Can't withPropertyId() on a player");
    }

    @Override
    public Location getLocation() {
        return this.parent.getLocation();
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        this.parent.setPosition(pos, pitch, yaw);
    }

    @Override
    public World getWorld() {
        return WorldWrapper.wrap(this.parent.getWorld());
    }

    @Override
    public void printRaw(String msg) {
        this.parent.printRaw(msg);
    }

    @Override
    public void printDebug(String msg) {
        this.parent.printDebug(msg);
    }

    @Override
    public void print(String msg) {
        this.parent.print(msg);
    }

    @Override
    public void printError(String msg) {
        this.parent.printError(msg);
    }

    @Override
    public String[] getGroups() {
        return this.parent.getGroups();
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.parent.hasPermission(perm);
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        this.parent.dispatchCUIEvent(event);
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return this.parent.getFacet(cls);
    }

    @Override
    public SessionKey getSessionKey() {
        return this.parent.getSessionKey();
    }

    @Override
    public GameMode getGameMode() {
        return this.parent.getGameMode();
    }

    @Override
    public void setGameMode(GameMode gameMode) {
        this.parent.setGameMode(gameMode);
    }

    @Override
    public void findFreePosition(final Location searchPos) {
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                PlayerWrapper.super.findFreePosition(searchPos);
            }
        });
    }

    @Override
    public void setOnGround(final Location searchPos) {
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                PlayerWrapper.super.setOnGround(searchPos);
            }
        });
    }

    @Override
    public void findFreePosition() {
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                PlayerWrapper.this.parent.findFreePosition();
            }
        });
    }

    @Override
    public boolean ascendLevel() {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = PlayerWrapper.this.parent.ascendLevel();
            }
        });
    }

    @Override
    public boolean descendLevel() {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = PlayerWrapper.this.parent.descendLevel();
            }
        });
    }

    @Override
    public boolean ascendToCeiling(int clearance) {
        return this.ascendToCeiling(clearance, true);
    }

    @Override
    public boolean ascendToCeiling(int clearance, boolean alwaysGlass) {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int y = Math.max(0, pos.getBlockY() + 2);
        int z = pos.getBlockZ();
        Extent world = this.getLocation().getExtent();
        if (!world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isAir()) {
            return false;
        }
        while ((double)y <= world.getMaximumPoint().getY()) {
            if (world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isMovementBlocker()) {
                int platformY = Math.max(initialY, y - 3 - clearance);
                this.floatAt(x, platformY + 1, z, alwaysGlass);
                return true;
            }
            ++y;
        }
        return false;
    }

    @Override
    public boolean ascendUpwards(int distance) {
        return this.ascendUpwards(distance, true);
    }

    @Override
    public boolean ascendUpwards(int distance, boolean alwaysGlass) {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        int maxY = Math.min(this.getWorld().getMaxY() + 1, initialY + distance);
        Extent world = this.getLocation().getExtent();
        for (int y = Math.max(0, pos.getBlockY() + 1); (double)y <= world.getMaximumPoint().getY() + 2.0 && !world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isMovementBlocker() && y <= maxY + 1; ++y) {
            if (y != maxY + 1) continue;
            this.floatAt(x, y - 1, z, alwaysGlass);
            return true;
        }
        return false;
    }

    @Override
    public void floatAt(final int x, final int y, final int z, boolean alwaysGlass) {
        RuntimeException caught = null;
        try {
            EditSession edit = new EditSessionBuilder(this.parent.getWorld()).player(FawePlayer.wrap(this)).build();
            edit.setBlock(new Vector(x, y - 1, z), BlockTypes.GLASS);
            edit.flushQueue();
            LocalSession session = Fawe.get().getWorldEdit().getSessionManager().get(this);
            if (session != null) {
                session.remember(edit, true, FawePlayer.wrap((Object)this).getLimit().MAX_HISTORY);
            }
        }
        catch (RuntimeException e) {
            caught = e;
        }
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                PlayerWrapper.this.setPosition(new Vector((double)x + 0.5, (double)y, (double)z + 0.5));
            }
        });
        if (caught != null) {
            throw caught;
        }
    }

    @Override
    public Location getBlockTrace(final int range, final boolean useLastBlock) {
        return TaskManager.IMP.sync(new RunnableVal<Location>(){

            @Override
            public void run(Location value) {
                TargetBlock tb = new TargetBlock(PlayerWrapper.this, range, 0.2);
                this.value = useLastBlock ? tb.getAnyTargetBlock() : tb.getTargetBlock();
            }
        });
    }

    @Override
    public Location getBlockTraceFace(final int range, final boolean useLastBlock) {
        return TaskManager.IMP.sync(new RunnableVal<Location>(){

            @Override
            public void run(Location value) {
                TargetBlock tb = new TargetBlock(PlayerWrapper.this, range, 0.2);
                this.value = useLastBlock ? tb.getAnyTargetBlockFace() : tb.getTargetBlockFace();
            }
        });
    }

    @Override
    public Location getSolidBlockTrace(final int range) {
        return TaskManager.IMP.sync(new RunnableVal<Location>(){

            @Override
            public void run(Location value) {
                TargetBlock tb = new TargetBlock(PlayerWrapper.this, range, 0.2);
                this.value = tb.getSolidTargetBlock();
            }
        });
    }

    @Override
    public PlayerDirection getCardinalDirection() {
        return this.parent.getCardinalDirection();
    }

    @Override
    public boolean passThroughForwardWall(final int range) {
        return TaskManager.IMP.sync(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                Location block;
                int searchDist = 0;
                TargetBlock hitBlox = new TargetBlock(PlayerWrapper.this, range, 0.2);
                Extent world = PlayerWrapper.this.getLocation().getExtent();
                boolean firstBlock = true;
                int freeToFind = 2;
                boolean inFree = false;
                while ((block = hitBlox.getNextBlock()) != null) {
                    boolean free;
                    boolean bl = free = !world.getBlock(block.toVector()).getBlockType().getMaterial().isMovementBlocker();
                    if (firstBlock) {
                        firstBlock = false;
                        if (!free) {
                            --freeToFind;
                            continue;
                        }
                    }
                    if (++searchDist > 20) {
                        return false;
                    }
                    if (inFree != free && free) {
                        --freeToFind;
                    }
                    if (freeToFind == 0) {
                        PlayerWrapper.this.setOnGround(block);
                        return true;
                    }
                    inFree = free;
                }
                return false;
            }
        });
    }

    @Override
    public boolean remove() {
        return this.parent.remove();
    }

    @Override
    public boolean canDestroyBedrock() {
        return this.parent.canDestroyBedrock();
    }

    @Override
    public boolean isPlayer() {
        return this.parent.isPlayer();
    }

    @Override
    public File openFileOpenDialog(String[] extensions) {
        return this.parent.openFileOpenDialog(extensions);
    }

    @Override
    public File openFileSaveDialog(String[] extensions) {
        return this.parent.openFileSaveDialog(extensions);
    }
}

