/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.util.TextureHolder;
import com.boydti.fawe.util.TextureUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DesaturatePattern
extends AbstractPattern {
    private transient TextureHolder holder;
    private final Extent extent;
    private final double value;

    public DesaturatePattern(Extent extent, double value, TextureHolder util) {
        this.extent = extent;
        this.holder = util;
        this.value = Math.max(0.0, Math.min(1.0, value));
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        BlockType block = this.extent.getBlockType(position);
        TextureUtil util = this.holder.getTextureUtil();
        int color = util.getColor(block);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        double l = 0.3f * (float)r + 0.6f * (float)g + 0.1f * (float)b;
        int red = (int)((double)r + this.value * (l - (double)r));
        int green = (int)((double)g + this.value * (l - (double)g));
        int blue = (int)((double)b + this.value * (l - (double)b));
        int newColor = (alpha << 24) + (red << 16) + (green << 8) + (blue << 0);
        return util.getNearestBlock(newColor).getDefaultState();
    }

    @Override
    public boolean apply(Extent extent, Vector setPosition, Vector getPosition) throws WorldEditException {
        int blue;
        int green;
        int b;
        int g;
        double l;
        int r;
        int red;
        BlockType block = extent.getBlockType(getPosition);
        TextureUtil util = this.holder.getTextureUtil();
        int color = util.getColor(block);
        int alpha = color >> 24 & 0xFF;
        int newColor = (alpha << 24) + ((red = (int)((double)(r = color >> 16 & 0xFF) + this.value * ((l = (double)(0.3f * (float)r + 0.6f * (float)(g = color >> 8 & 0xFF) + 0.1f * (float)(b = color >> 0 & 0xFF))) - (double)r))) << 16) + ((green = (int)((double)g + this.value * (l - (double)g))) << 8) + ((blue = (int)((double)b + this.value * (l - (double)b))) << 0);
        if (newColor == color) {
            return false;
        }
        BlockType newBlock = util.getNextNearestBlock(newColor);
        if (block.equals(newBlock)) {
            return false;
        }
        return extent.setBlock(setPosition, newBlock.getDefaultState());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.holder = Fawe.get().getCachedTextureUtil(true, 0, 100);
    }
}

