/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.CachedMask;
import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;

public class AdjacentAnyMask
extends AbstractMask
implements ResettableMask {
    private final CachedMask mask;
    private transient MutableBlockVector mutable = new MutableBlockVector();

    public AdjacentAnyMask(Mask mask) {
        this.mask = CachedMask.cache(mask);
        this.mutable = new MutableBlockVector();
    }

    @Override
    public void reset() {
        this.mutable = new MutableBlockVector();
    }

    public CachedMask getParentMask() {
        return this.mask;
    }

    @Override
    public boolean test(Vector v) {
        int z;
        int y;
        int x = v.getBlockX();
        if (this.mask.test(x + 1, y = v.getBlockY(), z = v.getBlockZ())) {
            return true;
        }
        if (this.mask.test(x - 1, y, z)) {
            return true;
        }
        if (this.mask.test(x, y, z + 1)) {
            return true;
        }
        if (this.mask.test(x, y, z - 1)) {
            return true;
        }
        if (y < 256 && this.mask.test(x, y + 1, z)) {
            return true;
        }
        return y > 0 && this.mask.test(x, y - 1, z);
    }

    public Vector direction(Vector v) {
        int z;
        int y;
        int x = v.getBlockX();
        if (this.mask.test(x + 1, y = v.getBlockY(), z = v.getBlockZ())) {
            return this.mutable.setComponents(1, 0, 0);
        }
        if (this.mask.test(x - 1, y, z)) {
            return this.mutable.setComponents(-1, 0, 0);
        }
        if (this.mask.test(x, y, z + 1)) {
            return this.mutable.setComponents(0, 0, 1);
        }
        if (this.mask.test(x, y, z - 1)) {
            return this.mutable.setComponents(0, 0, -1);
        }
        if (y < 256 && this.mask.test(x, y + 1, z)) {
            return this.mutable.setComponents(0, 1, 0);
        }
        if (y > 0 && this.mask.test(x, y - 1, z)) {
            return this.mutable.setComponents(0, -1, 0);
        }
        return null;
    }
}

