/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe;

import com.boydti.fawe.FaweVersion;
import com.boydti.fawe.IFawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Commands;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.brush.visualization.VisualQueue;
import com.boydti.fawe.regions.general.plot.PlotSquaredFeature;
import com.boydti.fawe.util.CachedTextureUtil;
import com.boydti.fawe.util.CleanTextureUtil;
import com.boydti.fawe.util.FaweTimer;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.RandomTextureUtil;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.TextureUtil;
import com.boydti.fawe.util.Updater;
import com.boydti.fawe.util.WEManager;
import com.boydti.fawe.util.chat.ChatManager;
import com.boydti.fawe.util.chat.PlainChatManager;
import com.boydti.fawe.util.cui.CUI;
import com.boydti.fawe.util.metrics.BStats;
import com.github.luben.zstd.util.Native;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.factory.DefaultTransformParser;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.session.request.Request;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class Fawe {
    private static Fawe INSTANCE;
    private final FaweTimer timer;
    private FaweVersion version;
    private VisualQueue visualQueue;
    private Updater updater;
    private TextureUtil textures;
    private DefaultTransformParser transformParser;
    private ChatManager chatManager = new PlainChatManager();
    private BStats stats;
    private final IFawe IMP;
    private Thread thread = Thread.currentThread();
    private ConcurrentHashMap<String, FawePlayer> players = new ConcurrentHashMap(8, 0.9f, 1);
    private ConcurrentHashMap<UUID, FawePlayer> playersUUID = new ConcurrentHashMap(8, 0.9f, 1);

    public static <T extends IFawe> T imp() {
        return (T)(INSTANCE != null ? Fawe.INSTANCE.IMP : null);
    }

    public static Fawe get() {
        return INSTANCE;
    }

    public static void set(IFawe implementation) throws InstanceAlreadyExistsException, IllegalArgumentException {
        if (INSTANCE != null) {
            throw new InstanceAlreadyExistsException("FAWE has already been initialized with: " + Fawe.INSTANCE.IMP);
        }
        if (implementation == null) {
            throw new IllegalArgumentException("Implementation may not be null.");
        }
        INSTANCE = new Fawe(implementation);
    }

    public static void debugPlain(String s) {
        if (INSTANCE != null) {
            Fawe.INSTANCE.IMP.debug(s);
        } else {
            System.out.println(BBC.stripColor(BBC.color(s)));
        }
    }

    public static void debug(Object s) {
        Actor actor = Request.request().getActor();
        if (actor != null && actor.isPlayer()) {
            actor.print(BBC.color(BBC.PREFIX.original() + " " + s));
            return;
        }
        Fawe.debugPlain(BBC.PREFIX.original() + " " + s);
    }

    private Fawe(IFawe implementation) {
        INSTANCE = this;
        this.IMP = implementation;
        this.thread = Thread.currentThread();
        this.setupConfigs();
        TaskManager.IMP = this.IMP.getTaskManager();
        TaskManager.IMP.async(new Runnable(){

            @Override
            public void run() {
                MainUtil.deleteOlder(MainUtil.getFile(Fawe.this.IMP.getDirectory(), Settings.IMP.PATHS.HISTORY), TimeUnit.DAYS.toMillis(Settings.IMP.HISTORY.DELETE_AFTER_DAYS), false);
                MainUtil.deleteOlder(MainUtil.getFile(Fawe.this.IMP.getDirectory(), Settings.IMP.PATHS.CLIPBOARD), TimeUnit.DAYS.toMillis(Settings.IMP.CLIPBOARD.DELETE_AFTER_DAYS), false);
            }
        });
        if (Settings.IMP.METRICS) {
            try {
                this.stats = new BStats();
                this.IMP.startMetrics();
                TaskManager.IMP.later(new Runnable(){

                    @Override
                    public void run() {
                        Fawe.this.stats.start();
                    }
                }, 1);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        this.setupMemoryListener();
        this.timer = new FaweTimer();
        this.IMP.setupVault();
        File jar = MainUtil.getJarFile();
        TaskManager.IMP.later(() -> {
            try {
                this.transformParser = new DefaultTransformParser(this.getWorldEdit());
                this.visualQueue = new VisualQueue(3);
                WEManager.IMP.managers.addAll(this.IMP.getMaskManagers());
                WEManager.IMP.managers.add(new PlotSquaredFeature());
                Fawe.debug("Plugin 'PlotSquared' found. Using it now.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 0);
        TaskManager.IMP.repeat(this.timer, 1);
        if (!Settings.IMP.UPDATE.equalsIgnoreCase("false")) {
            this.updater = new Updater();
            TaskManager.IMP.async(() -> this.update());
            TaskManager.IMP.repeatAsync(() -> this.update(), 36000);
        }
    }

    public void onDisable() {
        if (this.stats != null) {
            this.stats.close();
        }
    }

    private boolean update() {
        if (this.updater != null) {
            this.updater.getUpdate(this.IMP.getPlatform(), this.getVersion());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUI getCUI(Actor actor) {
        FawePlayer fp = FawePlayer.wrap(actor);
        CUI cui = (CUI)fp.getMeta("CUI");
        if (cui == null && (cui = Fawe.imp().getCUI(fp)) != null) {
            FawePlayer fawePlayer = fp;
            synchronized (fawePlayer) {
                CUI tmp = (CUI)fp.getMeta("CUI");
                if (tmp == null) {
                    fp.setMeta("CUI", cui);
                } else {
                    cui = tmp;
                }
            }
        }
        return cui;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public void setChatManager(ChatManager chatManager) {
        Preconditions.checkNotNull((Object)chatManager);
        this.chatManager = chatManager;
    }

    public DefaultTransformParser getTransformParser() {
        return this.transformParser;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public TextureUtil getCachedTextureUtil(boolean randomize, int min, int max) {
        TextureUtil tu = this.getTextureUtil();
        try {
            tu = min == 0 && max == 100 ? tu : new CleanTextureUtil(tu, min, max);
            tu = randomize ? new RandomTextureUtil(tu) : new CachedTextureUtil(tu);
        }
        catch (FileNotFoundException neverHappens) {
            neverHappens.printStackTrace();
        }
        return tu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureUtil getTextureUtil() {
        TextureUtil tmp = this.textures;
        if (tmp == null) {
            Fawe fawe = this;
            synchronized (fawe) {
                tmp = this.textures;
                if (tmp == null) {
                    try {
                        this.textures = tmp = new TextureUtil();
                        tmp.loadModTextures();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return tmp;
    }

    public FaweTimer getTimer() {
        return this.timer;
    }

    public VisualQueue getVisualQueue() {
        return this.visualQueue;
    }

    @Nullable
    public FaweVersion getVersion() {
        return this.version;
    }

    public double getTPS() {
        return this.timer.getTPS();
    }

    public void setupConfigs() {
        MainUtil.copyFile(MainUtil.getJarFile(), "de/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "ru/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "ru/commands.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "tr/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "es/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "es/commands.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "nl/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "fr/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "cn/message.yml", null);
        MainUtil.copyFile(MainUtil.getJarFile(), "it/message.yml", null);
        File file = new File(this.IMP.getDirectory(), "config.yml");
        Settings.IMP.PLATFORM = this.IMP.getPlatform().replace("\"", "");
        try {
            InputStream stream = this.getClass().getResourceAsStream("/fawe.properties");
            Scanner scanner = new Scanner(stream).useDelimiter("\\A");
            String versionString = scanner.next().trim();
            scanner.close();
            this.version = new FaweVersion(versionString);
            Settings.IMP.DATE = new Date(100 + this.version.year, this.version.month, this.version.day).toGMTString();
            Settings.IMP.BUILD = "https://ci.athion.net/job/FastAsyncWorldEdit/" + this.version.build;
            Settings.IMP.COMMIT = "https://github.com/boy0001/FastAsyncWorldedit/commit/" + Integer.toHexString(this.version.hash);
        }
        catch (Throwable stream) {
            // empty catch block
        }
        try {
            Settings.IMP.reload(file);
            String lang = Objects.toString(Settings.IMP.LANGUAGE);
            BBC.load(new File(this.IMP.getDirectory(), (lang.isEmpty() ? "" : lang + File.separator) + "message.yml"));
            Commands.load(new File(Fawe.INSTANCE.IMP.getDirectory(), "commands.yml"));
        }
        catch (Throwable e) {
            Fawe.debug("====== Failed to load config ======");
            Fawe.debug("Please validate your yaml files:");
            Fawe.debug("====================================");
            e.printStackTrace();
            Fawe.debug("====================================");
        }
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static void setupInjector() {
        if (!Settings.IMP.EXPERIMENTAL.DISABLE_NATIVES) {
            block8: {
                try {
                    Native.load();
                }
                catch (Throwable e) {
                    if (Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL <= 6 && Settings.IMP.HISTORY.COMPRESSION_LEVEL <= 6) break block8;
                    Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL = Math.min(6, Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL);
                    Settings.IMP.HISTORY.COMPRESSION_LEVEL = Math.min(6, Settings.IMP.HISTORY.COMPRESSION_LEVEL);
                    Fawe.debug("====== ZSTD COMPRESSION BINDING NOT FOUND ======");
                    Fawe.debug(e);
                    Fawe.debug("===============================================");
                    Fawe.debug("FAWE will work but won't compress data as much");
                    Fawe.debug("===============================================");
                }
            }
            try {
                net.jpountz.util.Native.load();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Fawe.debug("====== LZ4 COMPRESSION BINDING NOT FOUND ======");
                Fawe.debug(e);
                Fawe.debug("===============================================");
                Fawe.debug("FAWE will work but compression will be slower");
                Fawe.debug(" - Try updating your JVM / OS");
                Fawe.debug(" - Report this issue if you cannot resolve it");
                Fawe.debug("===============================================");
            }
        }
        try {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            boolean x86OS = !arch.endsWith("64") && (wow64Arch == null || !wow64Arch.endsWith("64"));
            boolean x86JVM = System.getProperty("sun.arch.data.model").equals("32");
            if (x86OS != x86JVM) {
                Fawe.debug("====== UPGRADE TO 64-BIT JAVA ======");
                Fawe.debug("You are running 32-bit Java on a 64-bit machine");
                Fawe.debug(" - This is only a recommendation");
                Fawe.debug("====================================");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setupMemoryListener() {
        if (Settings.IMP.MAX_MEMORY_PERCENT < 1 || Settings.IMP.MAX_MEMORY_PERCENT > 99) {
            return;
        }
        try {
            MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter ne = (NotificationEmitter)((Object)memBean);
            ne.addNotificationListener(new NotificationListener(){

                @Override
                public void handleNotification(Notification notification, Object handback) {
                    long heapMaxSize;
                    long heapSize = Runtime.getRuntime().totalMemory();
                    if (heapSize < (heapMaxSize = Runtime.getRuntime().maxMemory())) {
                        return;
                    }
                    MemUtil.memoryLimitedTask();
                }
            }, null, null);
            List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean mp : memPools) {
                MemoryUsage mu;
                long max;
                if (!mp.isUsageThresholdSupported() || (max = (mu = mp.getUsage()).getMax()) < 0L) continue;
                long alert = max * (long)Settings.IMP.MAX_MEMORY_PERCENT / 100L;
                mp.setUsageThreshold(alert);
            }
        }
        catch (Throwable e) {
            Fawe.debug("====== MEMORY LISTENER ERROR ======");
            MainUtil.handleError(e, false);
            Fawe.debug("===================================");
            Fawe.debug("FAWE needs access to the JVM memory system:");
            Fawe.debug(" - Change your Java security settings");
            Fawe.debug(" - Disable this with `max-memory-percent: -1`");
            Fawe.debug("===================================");
        }
    }

    public Thread getMainThread() {
        return this.thread;
    }

    public static boolean isMainThread() {
        return INSTANCE != null ? Fawe.INSTANCE.thread == Thread.currentThread() : true;
    }

    public Thread setMainThread() {
        this.thread = Thread.currentThread();
        return this.thread;
    }

    public <T> void register(FawePlayer<T> player) {
        this.players.put(player.getName(), player);
        this.playersUUID.put(player.getUUID(), player);
    }

    public <T> void unregister(String name) {
        FawePlayer player = this.players.remove(name);
        if (player != null) {
            this.playersUUID.remove(player.getUUID());
        }
    }

    public FawePlayer getCachedPlayer(String name) {
        return this.players.get(name);
    }

    public FawePlayer getCachedPlayer(UUID uuid) {
        return this.playersUUID.get(uuid);
    }

    public Collection<FawePlayer> getCachedPlayers() {
        return this.players.values();
    }
}

