/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.command.parametric;

import com.sk89q.worldedit.util.command.SimpleParameter;
import com.sk89q.worldedit.util.command.parametric.Binding;
import com.sk89q.worldedit.util.command.parametric.BindingBehavior;
import com.sk89q.worldedit.util.command.parametric.ParametricException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;

public class ParameterData
extends SimpleParameter {
    private Binding binding;
    private Annotation classifier;
    private Annotation[] modifiers;
    private Type type;

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Annotation getClassifier() {
        return this.classifier;
    }

    public void setClassifier(Annotation classifier) {
        this.classifier = classifier;
    }

    public Annotation[] getModifiers() {
        return this.modifiers;
    }

    public <T extends Annotation> T getModifier(Class<T> annotatedType) {
        for (Annotation annotation : this.getModifiers()) {
            if (annotation.getClass() != annotatedType) continue;
            return (T)annotation;
        }
        return null;
    }

    public void setModifiers(Annotation[] modifiers) {
        this.modifiers = modifiers;
    }

    public int getConsumedCount() {
        return this.getBinding().getConsumedCount(this);
    }

    public boolean isUserInput() {
        return this.getBinding().getBehavior(this) != BindingBehavior.PROVIDES;
    }

    public boolean isNonFlagConsumer() {
        return this.getBinding().getBehavior(this) != BindingBehavior.PROVIDES && !this.isValueFlag();
    }

    public void validate(Method method, int parameterIndex) throws ParametricException {
        this.validate(() -> method.toGenericString(), parameterIndex);
    }

    public void validate(Supplier<String> method, int parameterIndex) throws ParametricException {
        boolean indeterminate;
        BindingBehavior behavior = this.getBinding().getBehavior(this);
        boolean bl = indeterminate = behavior == BindingBehavior.INDETERMINATE;
        if (!this.isValueFlag() && indeterminate) {
            throw new ParametricException("@Switch missing for indeterminate consumer\n\nNotably:\nFor the type " + this.type + ", the binding " + this.getBinding().getClass().getCanonicalName() + "\nmay or may not consume parameters (isIndeterminateConsumer(" + this.type + ") = true)" + "\nand therefore @Switch(flag) is required for parameter #" + parameterIndex + " of \n" + method.get());
        }
        if (behavior != BindingBehavior.CONSUMES && this.binding.getConsumedCount(this) != -1) {
            throw new ParametricException("getConsumedCount() does not return -1 for binding " + this.getBinding().getClass().getCanonicalName() + "\neven though its behavior type is " + behavior.name() + "\nfor parameter #" + parameterIndex + " of \n" + method.get());
        }
        if (behavior != BindingBehavior.PROVIDES && this.binding.getConsumedCount(this) == 0) {
            throw new ParametricException("getConsumedCount() must not return 0 for binding " + this.getBinding().getClass().getCanonicalName() + "\nwhen its behavior type is " + behavior.name() + " and not PROVIDES " + "\nfor parameter #" + parameterIndex + " of \n" + method.get());
        }
    }
}

