/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.boydti.fawe.object.HasFaweQueue;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.visitor.BreadthFirstSearch;

public class RecursiveVisitor
extends BreadthFirstSearch {
    private final Mask mask;

    public RecursiveVisitor(Mask mask, RegionFunction function) {
        this(mask, function, Integer.MAX_VALUE);
    }

    public RecursiveVisitor(Mask mask, RegionFunction function, int maxDepth) {
        this(mask, function, maxDepth, null);
    }

    public RecursiveVisitor(Mask mask, RegionFunction function, int maxDepth, HasFaweQueue faweQueue) {
        super(function, maxDepth, faweQueue);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    @Override
    public boolean isVisitable(Vector from, Vector to) {
        return this.mask.test(to);
    }
}

