/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashSet;
import java.util.Set;

public class FloodFillTool
implements BlockTool {
    private int range;
    private Pattern pattern;

    public FloodFillTool(int range, Pattern pattern) {
        this.range = range;
        this.pattern = pattern;
    }

    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.flood-fill");
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        World world = (World)clicked.getExtent();
        BlockType initialType = world.getBlockType(clicked.toVector());
        if (initialType.getMaterial().isAir()) {
            return true;
        }
        if (initialType == BlockTypes.BEDROCK && !player.canDestroyBedrock()) {
            return true;
        }
        EditSession editSession = session.createEditSession(player);
        try {
            this.recurse(editSession, clicked.toVector().toBlockVector(), clicked.toVector(), this.range, initialType, new HashSet<BlockVector>());
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
        editSession.flushQueue();
        session.remember(editSession);
        return true;
    }

    private void recurse(EditSession editSession, BlockVector pos, Vector origin, int size, BlockType initialType, Set<BlockVector> visited) throws WorldEditException {
        if (origin.distance(pos) > (double)size || visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        if (editSession.getBlock(pos).getBlockType() != initialType) {
            return;
        }
        editSession.setBlock((Vector)pos, this.pattern.apply(pos));
        this.recurse(editSession, pos.add(1, 0, 0).toBlockVector(), origin, size, initialType, visited);
        this.recurse(editSession, pos.add(-1, 0, 0).toBlockVector(), origin, size, initialType, visited);
        this.recurse(editSession, pos.add(0, 0, 1).toBlockVector(), origin, size, initialType, visited);
        this.recurse(editSession, pos.add(0, 0, -1).toBlockVector(), origin, size, initialType, visited);
        this.recurse(editSession, pos.add(0, 1, 0).toBlockVector(), origin, size, initialType, visited);
        this.recurse(editSession, pos.add(0, -1, 0).toBlockVector(), origin, size, initialType, visited);
    }
}

