/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.brush.InspectBrush;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.command.tool.BlockDataCyler;
import com.sk89q.worldedit.command.tool.BlockReplacer;
import com.sk89q.worldedit.command.tool.DistanceWand;
import com.sk89q.worldedit.command.tool.FloatingTreeRemover;
import com.sk89q.worldedit.command.tool.FloodFillTool;
import com.sk89q.worldedit.command.tool.LongRangeBuildTool;
import com.sk89q.worldedit.command.tool.QueryTool;
import com.sk89q.worldedit.command.tool.TreePlanter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.command.parametric.Optional;

@Command(aliases={"brush", "br", "tool"}, desc="Bind functions to held items: [More Info](https://goo.gl/xPnPxj)")
public class ToolCommands {
    private final WorldEdit we;

    public ToolCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"info", "/info"}, usage="", desc="Block information tool", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.info"})
    public void info(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        session.setTool(new QueryTool(), player);
        BaseItemStack itemStack = player.getItemInHand(HandSide.MAIN_HAND);
        BBC.TOOL_INFO.send(player, itemStack.getType().getName());
    }

    @Command(aliases={"inspect"}, usage="", desc="Inspect edits within a radius", help="Chooses the inspect brush", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.inspect"})
    public void inspectBrush(Player player, LocalSession session, @Optional(value={"1"}) double radius) throws WorldEditException {
        session.setTool(new InspectBrush(), player);
        BBC.TOOL_INSPECT.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"tree"}, usage="[type]", desc="Tree generator tool", min=0, max=1)
    @CommandPermissions(value={"worldedit.tool.tree"})
    public void tree(Player player, LocalSession session, @Optional(value={"tree"}) TreeGenerator.TreeType type, CommandContext args) throws WorldEditException {
        session.setTool(new TreePlanter(type), player);
        BBC.TOOL_TREE.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"repl"}, usage="<block>", desc="Block replacer tool", min=1, max=1)
    @CommandPermissions(value={"worldedit.tool.replacer"})
    public void repl(Player player, LocalSession session, Pattern pattern) throws WorldEditException {
        session.setTool(new BlockReplacer(pattern), player);
        BBC.TOOL_REPL.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"cycler"}, usage="", desc="Block data cycler tool", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.data-cycler"})
    public void cycler(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        session.setTool(new BlockDataCyler(), player);
        BBC.TOOL_CYCLER.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"floodfill", "flood"}, usage="<pattern> <range>", desc="Flood fill tool", min=2, max=2)
    @CommandPermissions(value={"worldedit.tool.flood-fill"})
    public void floodFill(Player player, EditSession editSession, LocalSession session, Pattern pattern, int range) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (range > config.maxSuperPickaxeSize) {
            BBC.TOOL_RANGE_ERROR.send(player, config.maxSuperPickaxeSize);
            return;
        }
        session.setTool(new FloodFillTool(range, pattern), player);
        BBC.TOOL_FLOOD_FILL.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"deltree"}, usage="", desc="Floating tree remover tool", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.deltree"})
    public void deltree(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        session.setTool(new FloatingTreeRemover(), player);
        BBC.TOOL_DELTREE.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"farwand"}, usage="", desc="Wand at a distance tool", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.farwand"})
    public void farwand(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        session.setTool(new DistanceWand(), player);
        BBC.TOOL_FARWAND.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
    }

    @Command(aliases={"lrbuild", "/lrbuild"}, usage="<leftclick block> <rightclick block>", desc="Long-range building tool", min=2, max=2)
    @CommandPermissions(value={"worldedit.tool.lrbuild"})
    public void longrangebuildtool(Player player, LocalSession session, Pattern secondary, Pattern primary) throws WorldEditException {
        session.setTool(new LongRangeBuildTool(primary, secondary), player);
        BBC.TOOL_LRBUILD_BOUND.send(player, player.getItemInHand(HandSide.MAIN_HAND).getType().getName());
        BBC.TOOL_LRBUILD_INFO.send(player, secondary, primary);
    }
}

