/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.boydti.fawe.object.schematic.Schematic;
import com.boydti.fawe.util.MainUtil;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.command.FlattenedClipboardTransform;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Deprecated
public class CuboidClipboard {
    private BlockArrayClipboard clipboard;
    private AffineTransform transform;
    public Vector size;

    public CuboidClipboard(Vector size) {
        Preconditions.checkNotNull((Object)size);
        MainUtil.warnDeprecated(BlockArrayClipboard.class, ClipboardFormat.class);
        this.size = size;
        this.clipboard = this.init(Vector.ZERO, Vector.ZERO);
    }

    public CuboidClipboard(BlockArrayClipboard clipboard) {
        this.clipboard = clipboard;
        this.size = clipboard.getDimensions();
    }

    public CuboidClipboard(Vector size, Vector origin) {
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkNotNull((Object)origin);
        MainUtil.warnDeprecated(BlockArrayClipboard.class, ClipboardFormat.class);
        this.size = size;
        this.clipboard = this.init(Vector.ZERO, origin);
    }

    public CuboidClipboard(Vector size, Vector origin, Vector offset) {
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)offset);
        MainUtil.warnDeprecated(BlockArrayClipboard.class, ClipboardFormat.class);
        this.size = size;
        this.clipboard = this.init(offset, origin);
    }

    private BlockArrayClipboard init(Vector offset, Vector min) {
        Vector origin = min.subtract(offset);
        CuboidRegion region = new CuboidRegion(min, min.add(this.size).subtract(Vector.ONE));
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(origin);
        return clipboard;
    }

    private BaseBlock adapt(BlockState state) {
        if (state instanceof BaseBlock) {
            return (BaseBlock)state;
        }
        return new BaseBlock(state);
    }

    public BaseBlock getBlock(Vector position) {
        return this.getBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public BaseBlock getBlock(int x, int y, int z) {
        return this.adapt(this.clipboard.IMP.getBlock(x, y, z));
    }

    public BaseBlock getLazyBlock(Vector position) {
        return this.getBlock(position);
    }

    public void setBlock(Vector location, BaseBlock block) {
        this.setBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ(), block);
    }

    public boolean setBlock(int x, int y, int z, BaseBlock block) {
        return this.setBlock(x, y, z, (BlockState)block);
    }

    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.clipboard.IMP.setBlock(x, y, z, block);
    }

    public int getWidth() {
        return this.size.getBlockX();
    }

    public int getLength() {
        return this.size.getBlockZ();
    }

    public int getHeight() {
        return this.size.getBlockY();
    }

    public void rotate2D(int angle) {
        AffineTransform newTransform = new AffineTransform().rotateY(-angle);
        this.transform = this.transform == null ? newTransform : newTransform.combine(this.transform);
    }

    public void flip(FlipDirection dir) {
        this.flip(dir, false);
    }

    public void flip(FlipDirection dir, boolean aroundPlayer) {
        Preconditions.checkNotNull((Object)((Object)dir));
        Direction direction = dir.direction;
        AffineTransform newTransform = new AffineTransform().scale(direction.toVector().positive().multiply(-2).add(1, 1, 1));
        this.transform = this.transform == null ? newTransform : newTransform.combine(this.transform);
    }

    public void copy(EditSession editSession) {
        for (int x = 0; x < this.size.getBlockX(); ++x) {
            for (int y = 0; y < this.size.getBlockY(); ++y) {
                for (int z = 0; z < this.size.getBlockZ(); ++z) {
                    this.setBlock(x, y, z, editSession.getBlock(new Vector(x, y, z).add(this.getOrigin())));
                }
            }
        }
    }

    public void copy(EditSession editSession, Region region) {
        for (int x = 0; x < this.size.getBlockX(); ++x) {
            for (int y = 0; y < this.size.getBlockY(); ++y) {
                for (int z = 0; z < this.size.getBlockZ(); ++z) {
                    Vector pt = new Vector(x, y, z).add(this.getOrigin());
                    if (region.contains(pt)) {
                        this.setBlock(x, y, z, editSession.getBlock(pt));
                        continue;
                    }
                    this.setBlock(x, y, z, null);
                }
            }
        }
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir) throws MaxChangedBlocksException {
        this.paste(editSession, newOrigin, noAir, false);
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir, boolean entities) throws MaxChangedBlocksException {
        new Schematic(this.clipboard).paste(editSession, newOrigin, false, !noAir, entities, this.transform);
        editSession.flushQueue();
    }

    public void place(EditSession editSession, Vector newOrigin, boolean noAir) throws MaxChangedBlocksException {
        this.paste(editSession, newOrigin, noAir, false);
    }

    @Deprecated
    public BaseBlock getPoint(Vector position) throws ArrayIndexOutOfBoundsException {
        BaseBlock block = this.getBlock(position);
        if (block == null) {
            return new BaseBlock(BlockTypes.AIR);
        }
        return block;
    }

    public Vector getOrigin() {
        return this.clipboard.getMinimumPoint();
    }

    public void setOrigin(Vector origin) {
        Preconditions.checkNotNull((Object)origin);
        this.setOriginAndOffset(this.getOffset(), origin);
    }

    public void setOriginAndOffset(Vector offset, Vector min) {
        Vector origin = min.subtract(offset);
        CuboidRegion region = new CuboidRegion(min, min.add(this.size).subtract(Vector.ONE));
        this.clipboard.setRegion(region);
        this.clipboard.setOrigin(origin);
    }

    public Vector getOffset() {
        Vector min = this.clipboard.getMinimumPoint();
        Vector origin = this.clipboard.getOrigin();
        Vector offset = min.subtract(origin);
        return offset;
    }

    public void setOffset(Vector offset) {
        Preconditions.checkNotNull((Object)offset);
        this.setOriginAndOffset(offset, this.getOrigin());
    }

    public Vector getSize() {
        return this.size;
    }

    @Deprecated
    public void saveSchematic(File path) throws IOException, DataException {
        Preconditions.checkNotNull((Object)path);
        if (this.transform != null && !this.transform.isIdentity()) {
            FlattenedClipboardTransform result = FlattenedClipboardTransform.transform(this.clipboard, this.transform);
            BlockArrayClipboard target = new BlockArrayClipboard(result.getTransformedRegion(), UUID.randomUUID());
            target.setOrigin(this.clipboard.getOrigin());
            Operations.completeLegacy(result.copyTo(target));
            this.clipboard = target;
        }
        new Schematic(this.clipboard).save(path, ClipboardFormat.SPONGE_SCHEMATIC);
    }

    @Deprecated
    public static CuboidClipboard loadSchematic(File path) throws DataException, IOException {
        Preconditions.checkNotNull((Object)path);
        return new CuboidClipboard((Vector)((Object)ClipboardFormat.SCHEMATIC.load(path).getClipboard()));
    }

    public List<Countable<Integer>> getBlockDistribution() {
        ArrayList<Countable<Integer>> distribution = new ArrayList<Countable<Integer>>();
        List<Countable<BlockStateHolder>> distr = this.clipboard.getBlockDistributionWithData(this.clipboard.getRegion());
        for (Countable<BlockStateHolder> item : distr) {
            BlockStateHolder state = item.getID();
            int[] legacyId = LegacyMapper.getInstance().getLegacyFromBlock(state.toImmutableState());
            if (legacyId[0] == 0) continue;
            distribution.add(new Countable<Integer>(legacyId[0], item.getAmount()));
        }
        return distribution;
    }

    public List<Countable<BaseBlock>> getBlockDistributionWithData() {
        ArrayList<Countable<BaseBlock>> distribution = new ArrayList<Countable<BaseBlock>>();
        List<Countable<BlockStateHolder>> distr = this.clipboard.getBlockDistributionWithData(this.clipboard.getRegion());
        for (Countable<BlockStateHolder> item : distr) {
            distribution.add(new Countable<BaseBlock>(new BaseBlock(item.getID()), item.getAmount()));
        }
        return distribution;
    }

    public static enum FlipDirection {
        NORTH_SOUTH(Direction.NORTH),
        WEST_EAST(Direction.WEST),
        UP_DOWN(Direction.UP);

        private final Direction direction;

        private FlipDirection(Direction direction) {
            this.direction = direction;
        }
    }
}

