/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class ShapeInterpolator {
    private Shape savedV0;
    private Shape savedV1;
    private Geometry geom0;
    private Geometry geom1;

    public static Shape apply(Shape v0, Shape v1, float fraction) {
        return ShapeInterpolator.apply(v0, v1, fraction, false);
    }

    public static Shape apply(Shape v0, Shape v1, float fraction, boolean unionBounds) {
        ShapeInterpolator instance = new ShapeInterpolator();
        return instance.evaluate(v0, v1, fraction, unionBounds);
    }

    public Shape evaluate(Shape v0, Shape v1, float fraction) {
        return this.evaluate(v0, v1, fraction, false);
    }

    public Shape evaluate(Shape v0, Shape v1, float fraction, boolean unionBounds) {
        if (this.savedV0 != v0 || this.savedV1 != v1) {
            if (this.savedV0 == v1 && this.savedV1 == v0) {
                Geometry tmp = this.geom0;
                this.geom0 = this.geom1;
                this.geom1 = tmp;
            } else {
                this.recalculate(v0, v1);
            }
            this.savedV0 = v0;
            this.savedV1 = v1;
        }
        return this.getShape(fraction, unionBounds);
    }

    private void recalculate(Shape v0, Shape v1) {
        this.geom0 = new Geometry(v0);
        this.geom1 = new Geometry(v1);
        float[] tVals0 = this.geom0.getTVals();
        float[] tVals1 = this.geom1.getTVals();
        float[] masterTVals = ShapeInterpolator.mergeTVals(tVals0, tVals1);
        this.geom0.setTVals(masterTVals);
        this.geom1.setTVals(masterTVals);
    }

    private Shape getShape(float fraction, boolean unionBounds) {
        return new MorphedShape(this.geom0, this.geom1, fraction, unionBounds);
    }

    private static float[] mergeTVals(float[] tVals0, float[] tVals1) {
        int count = ShapeInterpolator.sortTVals(tVals0, tVals1, null);
        float[] newTVals = new float[count];
        ShapeInterpolator.sortTVals(tVals0, tVals1, newTVals);
        return newTVals;
    }

    private static int sortTVals(float[] tVals0, float[] tVals1, float[] newTVals) {
        int i0 = 0;
        int i1 = 0;
        int numTVals = 0;
        while (i0 < tVals0.length && i1 < tVals1.length) {
            float t0 = tVals0[i0];
            float t1 = tVals1[i1];
            if (t0 <= t1) {
                if (newTVals != null) {
                    newTVals[numTVals] = t0;
                }
                ++i0;
            }
            if (t1 <= t0) {
                if (newTVals != null) {
                    newTVals[numTVals] = t1;
                }
                ++i1;
            }
            ++numTVals;
        }
        return numTVals;
    }

    private static float interp(float v0, float v1, float t) {
        return v0 + (v1 - v0) * t;
    }

    private static class Iterator
    implements PathIterator {
        AffineTransform at;
        Geometry g0;
        Geometry g1;
        float t;
        int cIndex;

        public Iterator(AffineTransform at, Geometry g0, Geometry g1, float t) {
            this.at = at;
            this.g0 = g0;
            this.g1 = g1;
            this.t = t;
        }

        @Override
        public int getWindingRule() {
            return (double)this.t < 0.5 ? this.g0.getWindingRule() : this.g1.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.cIndex > this.g0.getNumCoordinates();
        }

        @Override
        public void next() {
            this.cIndex = this.cIndex == 0 ? 2 : (this.cIndex += 6);
        }

        @Override
        public int currentSegment(float[] coordinates) {
            int n;
            int type;
            if (this.cIndex == 0) {
                type = 0;
                n = 2;
            } else if (this.cIndex >= this.g0.getNumCoordinates()) {
                type = 4;
                n = 0;
            } else {
                type = 3;
                n = 6;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    coordinates[i] = ShapeInterpolator.interp(this.g0.getCoordinate(this.cIndex + i), this.g1.getCoordinate(this.cIndex + i), this.t);
                }
                if (this.at != null) {
                    this.at.transform(coordinates, 0, coordinates, 0, n / 2);
                }
            }
            return type;
        }

        @Override
        public int currentSegment(double[] coordinates) {
            float[] temp = new float[6];
            int res = this.currentSegment(temp);
            for (int i = 0; i < 6; ++i) {
                coordinates[i] = temp[i];
            }
            return res;
        }
    }

    private static class MorphedShape
    implements Shape {
        final Geometry geom0;
        final Geometry geom1;
        final float t;
        final boolean unionBounds;

        MorphedShape(Geometry geom0, Geometry geom1, float t, boolean unionBounds) {
            this.geom0 = geom0;
            this.geom1 = geom1;
            this.t = t;
            this.unionBounds = unionBounds;
        }

        @Override
        public Rectangle getBounds() {
            return this.getBounds2D().getBounds();
        }

        @Override
        public Rectangle2D getBounds2D() {
            float yMin;
            float yMax;
            float xMin;
            float xMax;
            int n = this.geom0.getNumCoordinates();
            if (this.unionBounds) {
                xMin = xMax = this.geom0.getCoordinate(0);
                yMin = yMax = this.geom0.getCoordinate(1);
                for (int i = 2; i < n; i += 2) {
                    float x = this.geom0.getCoordinate(i);
                    float y = this.geom0.getCoordinate(i + 1);
                    if (xMin > x) {
                        xMin = x;
                    }
                    if (yMin > y) {
                        yMin = y;
                    }
                    if (xMax < x) {
                        xMax = x;
                    }
                    if (!(yMax < y)) continue;
                    yMax = y;
                }
                int m = this.geom1.getNumCoordinates();
                for (int i = 0; i < m; i += 2) {
                    float x = this.geom1.getCoordinate(i);
                    float y = this.geom1.getCoordinate(i + 1);
                    if (xMin > x) {
                        xMin = x;
                    }
                    if (yMin > y) {
                        yMin = y;
                    }
                    if (xMax < x) {
                        xMax = x;
                    }
                    if (!(yMax < y)) continue;
                    yMax = y;
                }
            } else {
                xMin = xMax = ShapeInterpolator.interp(this.geom0.getCoordinate(0), this.geom1.getCoordinate(0), this.t);
                yMin = yMax = ShapeInterpolator.interp(this.geom0.getCoordinate(1), this.geom1.getCoordinate(1), this.t);
                for (int i = 2; i < n; i += 2) {
                    float x = ShapeInterpolator.interp(this.geom0.getCoordinate(i), this.geom1.getCoordinate(i), this.t);
                    float y = ShapeInterpolator.interp(this.geom0.getCoordinate(i + 1), this.geom1.getCoordinate(i + 1), this.t);
                    if (xMin > x) {
                        xMin = x;
                    }
                    if (yMin > y) {
                        yMin = y;
                    }
                    if (xMax < x) {
                        xMax = x;
                    }
                    if (!(yMax < y)) continue;
                    yMax = y;
                }
            }
            return new Rectangle2D.Float(xMin, yMin, xMax - xMin, yMax - yMin);
        }

        @Override
        public boolean contains(double x, double y) {
            return Path2D.contains(this.getPathIterator(null), x, y);
        }

        @Override
        public boolean contains(Point2D p) {
            return Path2D.contains(this.getPathIterator(null), p);
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return Path2D.intersects(this.getPathIterator(null), x, y, w, h);
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            return Path2D.intersects(this.getPathIterator(null), r);
        }

        @Override
        public boolean contains(double x, double y, double width, double height) {
            return Path2D.contains(this.getPathIterator(null), x, y, width, height);
        }

        @Override
        public boolean contains(Rectangle2D r) {
            return Path2D.contains(this.getPathIterator(null), r);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return new Iterator(at, this.geom0, this.geom1, this.t);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            return new FlatteningPathIterator(this.getPathIterator(at), flatness);
        }
    }

    private static class Geometry {
        static final float THIRD = 0.33333334f;
        static final float MIN_LEN = 0.001f;
        final int windingRule;
        float[] bezierCoordinates = new float[20];
        int numCoordinates;
        float[] myTVals;

        public Geometry(Shape s) {
            int i;
            float newY;
            float newX;
            float movY;
            float movX;
            PathIterator pi = s.getPathIterator(null);
            this.windingRule = pi.getWindingRule();
            if (pi.isDone()) {
                this.numCoordinates = 8;
            }
            float[] coordinates = new float[6];
            int type = pi.currentSegment(coordinates);
            pi.next();
            if (type != 0) {
                throw new IllegalPathStateException("missing initial move-to");
            }
            float curX = movX = coordinates[0];
            this.bezierCoordinates[0] = movX;
            float curY = movY = coordinates[1];
            this.bezierCoordinates[1] = movY;
            Vector<Point2D.Float> savedPathEndPoints = new Vector<Point2D.Float>();
            this.numCoordinates = 2;
            while (!pi.isDone()) {
                switch (pi.currentSegment(coordinates)) {
                    case 0: {
                        if (curX != movX || curY != movY) {
                            this.appendLineTo(curX, curY, movX, movY);
                            curX = movX;
                            curY = movY;
                        }
                        newX = coordinates[0];
                        newY = coordinates[1];
                        if (curX == newX && curY == newY) break;
                        savedPathEndPoints.add(new Point2D.Float(movX, movY));
                        this.appendLineTo(curX, curY, newX, newY);
                        curX = movX = newX;
                        curY = movY = newY;
                        break;
                    }
                    case 4: {
                        if (curX == movX && curY == movY) break;
                        this.appendLineTo(curX, curY, movX, movY);
                        curX = movX;
                        curY = movY;
                        break;
                    }
                    case 1: {
                        newX = coordinates[0];
                        newY = coordinates[1];
                        this.appendLineTo(curX, curY, newX, newY);
                        curX = newX;
                        curY = newY;
                        break;
                    }
                    case 2: {
                        float ctrlX = coordinates[0];
                        float ctrlY = coordinates[1];
                        newX = coordinates[2];
                        newY = coordinates[3];
                        this.appendQuadTo(curX, curY, ctrlX, ctrlY, newX, newY);
                        curX = newX;
                        curY = newY;
                        break;
                    }
                    case 3: {
                        newX = coordinates[4];
                        newY = coordinates[5];
                        this.appendCubicTo(coordinates[0], coordinates[1], coordinates[2], coordinates[3], newX, newY);
                        curX = newX;
                        curY = newY;
                    }
                }
                pi.next();
            }
            if (this.numCoordinates < 8 || curX != movX || curY != movY) {
                this.appendLineTo(curX, curY, movX, movY);
                curX = movX;
                curY = movY;
            }
            for (int i2 = savedPathEndPoints.size() - 1; i2 >= 0; --i2) {
                Point2D.Float p = (Point2D.Float)savedPathEndPoints.get(i2);
                newX = p.x;
                newY = p.y;
                if (curX == newX && curY == newY) continue;
                this.appendLineTo(curX, curY, newX, newY);
                curX = newX;
                curY = newY;
            }
            int minPt = 0;
            float minX = this.bezierCoordinates[0];
            float minY = this.bezierCoordinates[1];
            for (int ci = 6; ci < this.numCoordinates; ci += 6) {
                float x = this.bezierCoordinates[ci];
                float y = this.bezierCoordinates[ci + 1];
                if (!(y < minY) && (y != minY || !(x < minX))) continue;
                minPt = ci;
                minX = x;
                minY = y;
            }
            if (minPt > 0) {
                float[] newCoordinates = new float[this.numCoordinates];
                System.arraycopy(this.bezierCoordinates, minPt, newCoordinates, 0, this.numCoordinates - minPt);
                System.arraycopy(this.bezierCoordinates, 2, newCoordinates, this.numCoordinates - minPt, minPt);
                this.bezierCoordinates = newCoordinates;
            }
            float area = 0.0f;
            curX = this.bezierCoordinates[0];
            curY = this.bezierCoordinates[1];
            for (i = 2; i < this.numCoordinates; i += 2) {
                newX = this.bezierCoordinates[i];
                newY = this.bezierCoordinates[i + 1];
                area += curX * newY - newX * curY;
                curX = newX;
                curY = newY;
            }
            if (area < 0.0f) {
                i = 2;
                for (int j = this.numCoordinates - 4; i < j; i += 2, j -= 2) {
                    curX = this.bezierCoordinates[i];
                    curY = this.bezierCoordinates[i + 1];
                    this.bezierCoordinates[i] = this.bezierCoordinates[j];
                    this.bezierCoordinates[i + 1] = this.bezierCoordinates[j + 1];
                    this.bezierCoordinates[j] = curX;
                    this.bezierCoordinates[j + 1] = curY;
                }
            }
        }

        private void appendLineTo(float x0, float y0, float x1, float y1) {
            this.appendCubicTo(ShapeInterpolator.interp(x0, x1, 0.33333334f), ShapeInterpolator.interp(y0, y1, 0.33333334f), ShapeInterpolator.interp(x1, x0, 0.33333334f), ShapeInterpolator.interp(y1, y0, 0.33333334f), x1, y1);
        }

        private void appendQuadTo(float x0, float y0, float ctrlX, float ctrlY, float x1, float y1) {
            this.appendCubicTo(ShapeInterpolator.interp(ctrlX, x0, 0.33333334f), ShapeInterpolator.interp(ctrlY, y0, 0.33333334f), ShapeInterpolator.interp(ctrlX, x1, 0.33333334f), ShapeInterpolator.interp(ctrlY, y1, 0.33333334f), x1, y1);
        }

        private void appendCubicTo(float ctrlX1, float ctrlY1, float ctrlX2, float ctrlY2, float x1, float y1) {
            if (this.numCoordinates + 6 > this.bezierCoordinates.length) {
                int newsize = (this.numCoordinates - 2) * 2 + 2;
                float[] newCoordinates = new float[newsize];
                System.arraycopy(this.bezierCoordinates, 0, newCoordinates, 0, this.numCoordinates);
                this.bezierCoordinates = newCoordinates;
            }
            this.bezierCoordinates[this.numCoordinates++] = ctrlX1;
            this.bezierCoordinates[this.numCoordinates++] = ctrlY1;
            this.bezierCoordinates[this.numCoordinates++] = ctrlX2;
            this.bezierCoordinates[this.numCoordinates++] = ctrlY2;
            this.bezierCoordinates[this.numCoordinates++] = x1;
            this.bezierCoordinates[this.numCoordinates++] = y1;
        }

        public int getWindingRule() {
            return this.windingRule;
        }

        public int getNumCoordinates() {
            return this.numCoordinates;
        }

        public float getCoordinate(int i) {
            return this.bezierCoordinates[i];
        }

        public float[] getTVals() {
            if (this.myTVals != null) {
                return this.myTVals;
            }
            float[] tVals = new float[(this.numCoordinates - 2) / 6 + 1];
            float segX = this.bezierCoordinates[0];
            float segY = this.bezierCoordinates[1];
            float tLen = 0.0f;
            int ci = 2;
            int ti = 0;
            while (ci < this.numCoordinates) {
                float prevX = segX;
                float prevY = segY;
                float newX = this.bezierCoordinates[ci++];
                float newY = this.bezierCoordinates[ci++];
                float len = (float)Math.sqrt((prevX -= newX) * prevX + (prevY -= newY) * prevY);
                prevX = newX;
                prevY = newY;
                newX = this.bezierCoordinates[ci++];
                newY = this.bezierCoordinates[ci++];
                len += (float)Math.sqrt((prevX -= newX) * prevX + (prevY -= newY) * prevY);
                prevX = newX;
                prevY = newY;
                newX = this.bezierCoordinates[ci++];
                newY = this.bezierCoordinates[ci++];
                len += (float)Math.sqrt((prevX -= newX) * prevX + (prevY -= newY) * prevY);
                len += (float)Math.sqrt((segX -= newX) * segX + (segY -= newY) * segY);
                if ((len /= 2.0f) < 0.001f) {
                    len = 0.001f;
                }
                tVals[ti++] = tLen += len;
                segX = newX;
                segY = newY;
            }
            float prevT = tVals[0];
            tVals[0] = 0.0f;
            for (ti = 1; ti < tVals.length - 1; ++ti) {
                float nextT = tVals[ti];
                tVals[ti] = prevT / tLen;
                prevT = nextT;
            }
            tVals[ti] = 1.0f;
            this.myTVals = tVals;
            return tVals;
        }

        public void setTVals(float[] newTVals) {
            float y1;
            float x1;
            float[] oldCoordinates = this.bezierCoordinates;
            float[] newCoordinates = new float[2 + (newTVals.length - 1) * 6];
            float[] oldTVals = this.getTVals();
            int oldCi = 0;
            float xc1 = x1 = oldCoordinates[oldCi++];
            float xc0 = x1;
            float x0 = x1;
            float yc1 = y1 = oldCoordinates[oldCi++];
            float yc0 = y1;
            float y0 = y1;
            int newCi = 0;
            newCoordinates[newCi++] = x0;
            newCoordinates[newCi++] = y0;
            float t0 = 0.0f;
            float t1 = 0.0f;
            int oldTi = 1;
            int newTi = 1;
            while (newTi < newTVals.length) {
                if (t0 >= t1) {
                    x0 = x1;
                    y0 = y1;
                    xc0 = oldCoordinates[oldCi++];
                    yc0 = oldCoordinates[oldCi++];
                    xc1 = oldCoordinates[oldCi++];
                    yc1 = oldCoordinates[oldCi++];
                    x1 = oldCoordinates[oldCi++];
                    y1 = oldCoordinates[oldCi++];
                    t1 = oldTVals[oldTi++];
                }
                int n = newTi++;
                float nt = newTVals[n];
                if (nt < t1) {
                    float relT = (nt - t0) / (t1 - t0);
                    newCoordinates[newCi++] = x0 = ShapeInterpolator.interp(x0, xc0, relT);
                    newCoordinates[newCi++] = y0 = ShapeInterpolator.interp(y0, yc0, relT);
                    xc0 = ShapeInterpolator.interp(xc0, xc1, relT);
                    yc0 = ShapeInterpolator.interp(yc0, yc1, relT);
                    xc1 = ShapeInterpolator.interp(xc1, x1, relT);
                    yc1 = ShapeInterpolator.interp(yc1, y1, relT);
                    newCoordinates[newCi++] = x0 = ShapeInterpolator.interp(x0, xc0, relT);
                    newCoordinates[newCi++] = y0 = ShapeInterpolator.interp(y0, yc0, relT);
                    xc0 = ShapeInterpolator.interp(xc0, xc1, relT);
                    yc0 = ShapeInterpolator.interp(yc0, yc1, relT);
                    newCoordinates[newCi++] = x0 = ShapeInterpolator.interp(x0, xc0, relT);
                    newCoordinates[newCi++] = y0 = ShapeInterpolator.interp(y0, yc0, relT);
                } else {
                    newCoordinates[newCi++] = xc0;
                    newCoordinates[newCi++] = yc0;
                    newCoordinates[newCi++] = xc1;
                    newCoordinates[newCi++] = yc1;
                    newCoordinates[newCi++] = x1;
                    newCoordinates[newCi++] = y1;
                }
                t0 = nt;
            }
            this.bezierCoordinates = newCoordinates;
            this.numCoordinates = newCoordinates.length;
            this.myTVals = newTVals;
        }
    }
}

