/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.example;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.IFaweQueueMap;
import com.boydti.fawe.example.IntFaweChunk;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.example.NMSRelighter;
import com.boydti.fawe.example.NullRelighter;
import com.boydti.fawe.example.Relighter;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class NMSMappedFaweQueue<WORLD, CHUNK, CHUNKSECTION, SECTION>
extends MappedFaweQueue<WORLD, CHUNK, CHUNKSECTION, SECTION> {
    private final int maxY;
    private final Relighter relighter;

    public NMSMappedFaweQueue(World world) {
        super(world);
        this.getSettings();
        this.relighter = Settings.IMP.LIGHTING.MODE > 0 ? new NMSRelighter(this) : NullRelighter.INSTANCE;
        this.maxY = world.getMaxY();
    }

    public NMSMappedFaweQueue(String world) {
        super(world);
        this.getSettings();
        this.relighter = Settings.IMP.LIGHTING.MODE > 0 ? new NMSRelighter(this) : NullRelighter.INSTANCE;
        this.maxY = 256;
    }

    public NMSMappedFaweQueue(String world, IFaweQueueMap map) {
        super(world, map);
        this.getSettings();
        this.relighter = Settings.IMP.LIGHTING.MODE > 0 ? new NMSRelighter(this) : NullRelighter.INSTANCE;
        this.maxY = 256;
    }

    public NMSMappedFaweQueue(World world, IFaweQueueMap map) {
        super(world, map);
        this.getSettings();
        this.relighter = Settings.IMP.LIGHTING.MODE > 0 ? new NMSRelighter(this) : NullRelighter.INSTANCE;
        this.maxY = world.getMaxY();
    }

    @Override
    public void runTasks() {
        super.runTasks();
        if (!this.getRelighter().isEmpty()) {
            TaskManager.IMP.async(new Runnable(){

                @Override
                public void run() {
                    NMSMappedFaweQueue.this.getSettings();
                    if (Settings.IMP.LIGHTING.REMOVE_FIRST) {
                        NMSMappedFaweQueue.this.getRelighter().removeAndRelight(NMSMappedFaweQueue.this.hasSky());
                    } else {
                        NMSMappedFaweQueue.this.getRelighter().fixLightingSafe(NMSMappedFaweQueue.this.hasSky());
                    }
                }
            });
        }
    }

    @Override
    public Relighter getRelighter() {
        return this.relighter;
    }

    @Override
    public void end(FaweChunk chunk) {
        super.end(chunk);
        this.getSettings();
        if (Settings.IMP.LIGHTING.MODE == 0) {
            this.sendChunk(chunk);
            return;
        }
        this.getSettings();
        if (!Settings.IMP.LIGHTING.DELAY_PACKET_SENDING) {
            this.sendChunk(chunk);
        }
        this.getSettings();
        if (Settings.IMP.LIGHTING.MODE == 2) {
            this.getRelighter().addChunk(chunk.getX(), chunk.getZ(), null, chunk.getBitMask());
            return;
        }
        IntFaweChunk cfc = (IntFaweChunk)chunk;
        boolean relight = false;
        byte[] fix = new byte[this.maxY + 1 >> 4];
        boolean sky = this.hasSky();
        if (sky) {
            for (int i = cfc.ids.length - 1; i >= 0; --i) {
                int air = cfc.getAir(i);
                int solid = cfc.getCount(i);
                if (air == 4096) {
                    fix[i] = 1;
                    continue;
                }
                if (air == 0 && solid == 4096) {
                    fix[i] = 2;
                    continue;
                }
                if (solid == 0 && !relight) {
                    fix[i] = 1;
                    continue;
                }
                fix[i] = 0;
                relight = true;
            }
        }
        if (relight) {
            this.getRelighter().addChunk(chunk.getX(), chunk.getZ(), fix, chunk.getBitMask());
        } else {
            this.getSettings();
            if (Settings.IMP.LIGHTING.DELAY_PACKET_SENDING) {
                this.sendChunk(chunk);
            }
        }
    }

    @Override
    public void sendChunk(FaweChunk fc) {
        try {
            this.refreshChunk(fc);
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
        }
    }

    public abstract void setHeightMap(FaweChunk var1, byte[] var2);

    public abstract void setFullbright(CHUNKSECTION var1);

    public boolean removeLighting(CHUNKSECTION sections, FaweQueue.RelightMode mode, boolean hasSky) {
        boolean result = false;
        for (int i = 0; i < 16; ++i) {
            Object section = this.getCachedSection(sections, i);
            if (section == null) continue;
            result |= this.removeSectionLighting(section, i, hasSky);
        }
        return result;
    }

    public abstract boolean removeSectionLighting(SECTION var1, int var2, boolean var3);

    public boolean isSurrounded(char[][] sections, int x, int y, int z) {
        return this.isSolid(this.getId(sections, x, y + 1, z)) && this.isSolid(this.getId(sections, x + 1, y - 1, z)) && this.isSolid(this.getId(sections, x - 1, y, z)) && this.isSolid(this.getId(sections, x, y, z + 1)) && this.isSolid(this.getId(sections, x, y, z - 1));
    }

    public boolean isSolid(int id) {
        return !BlockTypes.get(id).getMaterial().isTranslucent();
    }

    public int getId(char[][] sections, int x, int y, int z) {
        if (x < 0 || x > 15 || z < 0 || z > 15) {
            return BlockTypes.AIR.getInternalId();
        }
        if (y < 0 || y > this.maxY) {
            return BlockTypes.AIR.getInternalId();
        }
        short i = FaweCache.CACHE_I[y][z][x];
        char[] section = sections[i];
        if (section == null) {
            return 0;
        }
        short j = FaweCache.CACHE_J[y][z][x];
        return section[j] >> 4;
    }

    public void saveChunk(CHUNK chunk) {
    }

    public abstract void relight(int var1, int var2, int var3);

    public abstract void relightBlock(int var1, int var2, int var3);

    public abstract void relightSky(int var1, int var2, int var3);

    /*
     * Enabled aggressive block sorting
     */
    public void setSkyLight(int x, int y, int z, int value) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return;
        }
        this.setSkyLight(this.lastSection, x, y, z, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBlockLight(int x, int y, int z, int value) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return;
        }
        this.setBlockLight(this.lastSection, x, y, z, value);
    }

    public abstract void setSkyLight(SECTION var1, int var2, int var3, int var4, int var5);

    public abstract void setBlockLight(SECTION var1, int var2, int var3, int var4, int var5);

    public abstract void refreshChunk(FaweChunk var1);

    public abstract IntFaweChunk getPrevious(IntFaweChunk var1, CHUNKSECTION var2, Map<?, ?> var3, Collection<?>[] var4, Set<UUID> var5, boolean var6) throws Exception;
}

