/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.bukkit.v0.BukkitQueue_0;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.queue.DelegateFaweQueue;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public class AsyncWorld
extends DelegateFaweQueue
implements World,
HasFaweQueue {
    private World parent;
    private FaweQueue queue;
    private BukkitImplAdapter adapter;

    public <T> void spawnParticle(Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6, T t) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5, v6, t);
    }

    public Entity getEntity(UUID uuid) {
        return TaskManager.IMP.sync(() -> this.parent.getEntity(uuid));
    }

    public boolean createExplosion(Entity source, Location loc, float power, boolean setFire, boolean breakBlocks) {
        return TaskManager.IMP.sync(() -> this.parent.createExplosion(source, loc, power, setFire, breakBlocks));
    }

    public <T> void spawnParticle(Particle particle, List<Player> receivers, Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.parent.spawnParticle(particle, receivers, source, x, y, z, count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, List<Player> list, Player player, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6, T t, boolean b) {
        this.parent.spawnParticle(particle, list, player, v, v1, v2, i, v3, v4, v5, v6, t, b);
    }

    @Deprecated
    public AsyncWorld(World parent, boolean autoQueue) {
        this(parent, FaweAPI.createQueue(parent.getName(), autoQueue));
    }

    public AsyncWorld(String world, boolean autoQueue) {
        this(Bukkit.getWorld((String)world), autoQueue);
    }

    @Deprecated
    public AsyncWorld(World parent, FaweQueue queue) {
        super(queue);
        this.parent = parent;
        this.queue = queue;
        if (queue instanceof BukkitQueue_0) {
            BukkitQueue_0 cfr_ignored_0 = (BukkitQueue_0)queue;
            this.adapter = BukkitQueue_0.getAdapter();
        } else {
            try {
                this.adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static AsyncWorld wrap(World world) {
        if (world instanceof AsyncWorld) {
            return (AsyncWorld)world;
        }
        return new AsyncWorld(world, false);
    }

    public void changeWorld(World world, FaweQueue queue) {
        this.parent = world;
        if (queue != this.queue) {
            if (this.queue != null) {
                final FaweQueue oldQueue = this.queue;
                TaskManager.IMP.async(new Runnable(){

                    @Override
                    public void run() {
                        oldQueue.flush();
                    }
                });
            }
            this.queue = queue;
        }
        this.setParent(queue);
    }

    public String toString() {
        return super.toString() + ":" + this.queue.toString();
    }

    public World getBukkitWorld() {
        return this.parent;
    }

    @Override
    public FaweQueue getQueue() {
        return this.queue;
    }

    public static synchronized AsyncWorld create(WorldCreator creator) {
        BukkitQueue_0 queue = (BukkitQueue_0)SetQueue.IMP.getNewQueue(creator.name(), true, false);
        World world = queue.createWorld(creator);
        return AsyncWorld.wrap(world);
    }

    @Override
    public Operation commit() {
        this.flush();
        return null;
    }

    @Override
    public void flush() {
        if (this.queue != null) {
            this.queue.flush();
        }
    }

    public WorldBorder getWorldBorder() {
        return TaskManager.IMP.sync(new RunnableVal<WorldBorder>(){

            @Override
            public void run(WorldBorder value) {
                this.value = AsyncWorld.this.parent.getWorldBorder();
            }
        });
    }

    public void spawnParticle(Particle particle, Location location, int i) {
        this.parent.spawnParticle(particle, location, i);
    }

    public void spawnParticle(Particle particle, double v, double v1, double v2, int i) {
        this.parent.spawnParticle(particle, v, v1, v2, i);
    }

    public <T> void spawnParticle(Particle particle, Location location, int i, T t) {
        this.parent.spawnParticle(particle, location, i, t);
    }

    public <T> void spawnParticle(Particle particle, double v, double v1, double v2, int i, T t) {
        this.parent.spawnParticle(particle, v, v1, v2, i, t);
    }

    public void spawnParticle(Particle particle, Location location, int i, double v, double v1, double v2) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2);
    }

    public void spawnParticle(Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5);
    }

    public <T> void spawnParticle(Particle particle, Location location, int i, double v, double v1, double v2, T t) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2, t);
    }

    public <T> void spawnParticle(Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, T t) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5, t);
    }

    public void spawnParticle(Particle particle, Location location, int i, double v, double v1, double v2, double v3) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2, v3);
    }

    public void spawnParticle(Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5, v6);
    }

    public <T> void spawnParticle(Particle particle, Location location, int i, double v, double v1, double v2, double v3, T t) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2, v3, t);
    }

    public boolean setSpawnLocation(Location location) {
        return this.parent.setSpawnLocation(location);
    }

    public AsyncBlock getBlockAt(int x, int y, int z) {
        return new AsyncBlock(this, this.queue, x, y, z);
    }

    public AsyncBlock getBlockAt(Location loc) {
        return this.getBlockAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public int getHighestBlockYAt(int x, int z) {
        for (int y = this.getMaxHeight() - 1; y >= 0; --y) {
            int stateId = this.queue.getCachedCombinedId4Data(x, y, z, BlockTypes.AIR.getInternalId());
            BlockTypes type = BlockTypes.getFromStateId(stateId);
            if (type.getMaterial().isAir()) continue;
            return y;
        }
        return 0;
    }

    public int getHighestBlockYAt(Location loc) {
        return this.getHighestBlockYAt(loc.getBlockX(), loc.getBlockZ());
    }

    public AsyncBlock getHighestBlockAt(int x, int z) {
        int y = this.getHighestBlockYAt(x, z);
        return this.getBlockAt(x, y, z);
    }

    public AsyncBlock getHighestBlockAt(Location loc) {
        return this.getHighestBlockAt(loc.getBlockX(), loc.getBlockZ());
    }

    public AsyncChunk getChunkAt(int x, int z) {
        return new AsyncChunk(this, this.queue, x, z);
    }

    public AsyncChunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX(), location.getBlockZ());
    }

    public AsyncChunk getChunkAt(Block block) {
        return this.getChunkAt(block.getX(), block.getZ());
    }

    public boolean isChunkGenerated(int x, int z) {
        return this.parent.isChunkGenerated(x, z);
    }

    public void getChunkAtAsync(int x, int z, World.ChunkLoadCallback cb) {
        this.parent.getChunkAtAsync(x, z, cb);
    }

    public void getChunkAtAsync(Location location, World.ChunkLoadCallback cb) {
        this.parent.getChunkAtAsync(location, cb);
    }

    public void getChunkAtAsync(Block block, World.ChunkLoadCallback cb) {
        this.parent.getChunkAtAsync(block, cb);
    }

    public boolean isChunkLoaded(Chunk chunk) {
        return chunk.isLoaded();
    }

    public Chunk[] getLoadedChunks() {
        return this.parent.getLoadedChunks();
    }

    public void loadChunk(final Chunk chunk) {
        if (!chunk.isLoaded()) {
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    AsyncWorld.this.parent.loadChunk(chunk);
                }
            });
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof World)) {
            return false;
        }
        World other = (World)obj;
        return StringMan.isEqual(other.getName(), this.getName());
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.parent.isChunkLoaded(x, z);
    }

    public boolean isChunkInUse(int x, int z) {
        return this.parent.isChunkInUse(x, z);
    }

    public void loadChunk(final int x, final int z) {
        if (!this.isChunkLoaded(x, z)) {
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    AsyncWorld.this.parent.loadChunk(x, z);
                }
            });
        }
    }

    public boolean loadChunk(final int x, final int z, final boolean generate) {
        if (!this.isChunkLoaded(x, z)) {
            return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

                @Override
                public void run(Boolean value) {
                    this.value = AsyncWorld.this.parent.loadChunk(x, z, generate);
                }
            });
        }
        return true;
    }

    public boolean unloadChunk(final Chunk chunk) {
        if (chunk.isLoaded()) {
            return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

                @Override
                public void run(Boolean value) {
                    this.value = AsyncWorld.this.parent.unloadChunk(chunk);
                }
            });
        }
        return true;
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk(x, z, save, false);
    }

    @Deprecated
    public boolean unloadChunk(final int x, final int z, final boolean save, final boolean safe) {
        if (this.isChunkLoaded(x, z)) {
            return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

                @Override
                public void run(Boolean value) {
                    this.value = AsyncWorld.this.parent.unloadChunk(x, z, save, safe);
                }
            });
        }
        return true;
    }

    public boolean unloadChunkRequest(int x, int z) {
        return this.unloadChunk(x, z);
    }

    public boolean unloadChunkRequest(int x, int z, boolean safe) {
        return this.unloadChunk(x, z, safe);
    }

    @Override
    public boolean regenerateChunk(final int x, final int z) {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = AsyncWorld.this.parent.regenerateChunk(x, z);
            }
        });
    }

    @Deprecated
    public boolean refreshChunk(int x, int z) {
        this.queue.sendChunk(this.queue.getFaweChunk(x, z));
        return true;
    }

    public Item dropItem(final Location location, final ItemStack item) {
        return TaskManager.IMP.sync(new RunnableVal<Item>(){

            @Override
            public void run(Item value) {
                this.value = AsyncWorld.this.parent.dropItem(location, item);
            }
        });
    }

    public Item dropItemNaturally(final Location location, final ItemStack item) {
        return TaskManager.IMP.sync(new RunnableVal<Item>(){

            @Override
            public void run(Item value) {
                this.value = AsyncWorld.this.parent.dropItemNaturally(location, item);
            }
        });
    }

    public Arrow spawnArrow(final Location location, final Vector direction, final float speed, final float spread) {
        return TaskManager.IMP.sync(new RunnableVal<Arrow>(){

            @Override
            public void run(Arrow value) {
                this.value = AsyncWorld.this.parent.spawnArrow(location, direction, speed, spread);
            }
        });
    }

    public <T extends Arrow> T spawnArrow(Location location, Vector vector, float v, float v1, Class<T> aClass) {
        return (T)this.parent.spawnArrow(location, vector, v, v1, aClass);
    }

    public boolean generateTree(final Location location, final TreeType type) {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = AsyncWorld.this.parent.generateTree(location, type);
            }
        });
    }

    public boolean generateTree(final Location loc, final TreeType type, final BlockChangeDelegate delegate) {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = AsyncWorld.this.parent.generateTree(loc, type, delegate);
            }
        });
    }

    public Entity spawnEntity(Location loc, EntityType type) {
        return this.spawn(loc, type.getEntityClass());
    }

    public LightningStrike strikeLightning(final Location loc) {
        return TaskManager.IMP.sync(new RunnableVal<LightningStrike>(){

            @Override
            public void run(LightningStrike value) {
                this.value = AsyncWorld.this.parent.strikeLightning(loc);
            }
        });
    }

    public LightningStrike strikeLightningEffect(final Location loc) {
        return TaskManager.IMP.sync(new RunnableVal<LightningStrike>(){

            @Override
            public void run(LightningStrike value) {
                this.value = AsyncWorld.this.parent.strikeLightningEffect(loc);
            }
        });
    }

    public List getEntities() {
        return TaskManager.IMP.sync(new RunnableVal<List<Entity>>(){

            @Override
            public void run(List<Entity> value) {
                this.value = AsyncWorld.this.parent.getEntities();
            }
        });
    }

    public List<LivingEntity> getLivingEntities() {
        return TaskManager.IMP.sync(new RunnableVal<List<LivingEntity>>(){

            @Override
            public void run(List<LivingEntity> value) {
                this.value = AsyncWorld.this.parent.getLivingEntities();
            }
        });
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(final Class<T> ... classes) {
        return (Collection)TaskManager.IMP.sync(new RunnableVal<Collection<T>>(){

            @Override
            public void run(Collection<T> value) {
                this.value = AsyncWorld.this.parent.getEntitiesByClass(classes);
            }
        });
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(final Class<T> cls) {
        return (Collection)TaskManager.IMP.sync(new RunnableVal<Collection<T>>(){

            @Override
            public void run(Collection<T> value) {
                this.value = AsyncWorld.this.parent.getEntitiesByClass(cls);
            }
        });
    }

    public Collection<Entity> getEntitiesByClasses(final Class<?> ... classes) {
        return TaskManager.IMP.sync(new RunnableVal<Collection<Entity>>(){

            @Override
            public void run(Collection<Entity> value) {
                this.value = AsyncWorld.this.parent.getEntitiesByClasses(classes);
            }
        });
    }

    public List<Player> getPlayers() {
        return TaskManager.IMP.sync(new RunnableVal<List<Player>>(){

            @Override
            public void run(List<Player> value) {
                this.value = AsyncWorld.this.parent.getPlayers();
            }
        });
    }

    public Collection<Entity> getNearbyEntities(final Location location, final double x, final double y, final double z) {
        return TaskManager.IMP.sync(new RunnableVal<Collection<Entity>>(){

            @Override
            public void run(Collection<Entity> value) {
                this.value = AsyncWorld.this.parent.getNearbyEntities(location, x, y, z);
            }
        });
    }

    public String getName() {
        return this.parent.getName();
    }

    public UUID getUID() {
        return this.parent.getUID();
    }

    public Location getSpawnLocation() {
        return this.parent.getSpawnLocation();
    }

    public boolean setSpawnLocation(final int x, final int y, final int z) {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = AsyncWorld.this.parent.setSpawnLocation(x, y, z);
            }
        });
    }

    public long getTime() {
        return this.parent.getTime();
    }

    public void setTime(long time) {
        this.parent.setTime(time);
    }

    public long getFullTime() {
        return this.parent.getFullTime();
    }

    public void setFullTime(long time) {
        this.parent.setFullTime(time);
    }

    public boolean hasStorm() {
        return this.parent.hasStorm();
    }

    public void setStorm(boolean hasStorm) {
        this.parent.setStorm(hasStorm);
    }

    public int getWeatherDuration() {
        return this.parent.getWeatherDuration();
    }

    public void setWeatherDuration(int duration) {
        this.parent.setWeatherDuration(duration);
    }

    public boolean isThundering() {
        return this.parent.isThundering();
    }

    public void setThundering(boolean thundering) {
        this.parent.setThundering(thundering);
    }

    public int getThunderDuration() {
        return this.parent.getThunderDuration();
    }

    public void setThunderDuration(int duration) {
        this.parent.setThunderDuration(duration);
    }

    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    public boolean createExplosion(final double x, final double y, final double z, final float power, final boolean setFire, final boolean breakBlocks) {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = AsyncWorld.this.parent.createExplosion(x, y, z, power, setFire, breakBlocks);
            }
        });
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire);
    }

    public World.Environment getEnvironment() {
        return this.parent.getEnvironment();
    }

    public long getSeed() {
        return this.parent.getSeed();
    }

    public boolean getPVP() {
        return this.parent.getPVP();
    }

    public void setPVP(boolean pvp) {
        this.parent.setPVP(pvp);
    }

    public ChunkGenerator getGenerator() {
        return this.parent.getGenerator();
    }

    public void save() {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.save();
            }
        });
    }

    public List<BlockPopulator> getPopulators() {
        return this.parent.getPopulators();
    }

    public <T extends Entity> T spawn(final Location location, final Class<T> clazz) throws IllegalArgumentException {
        return (T)((Entity)TaskManager.IMP.sync(new RunnableVal<T>(){

            @Override
            public void run(T value) {
                this.value = AsyncWorld.this.parent.spawn(location, clazz);
            }
        }));
    }

    public <T extends Entity> T spawn(final Location location, final Class<T> clazz, final Consumer<T> function) throws IllegalArgumentException {
        return (T)((Entity)TaskManager.IMP.sync(new RunnableVal<T>(){

            @Override
            public void run(T value) {
                this.value = AsyncWorld.this.parent.spawn(location, clazz, function);
            }
        }));
    }

    public FallingBlock spawnFallingBlock(final Location location, final MaterialData data) throws IllegalArgumentException {
        return TaskManager.IMP.sync(new RunnableVal<FallingBlock>(){

            @Override
            public void run(FallingBlock value) {
                this.value = AsyncWorld.this.parent.spawnFallingBlock(location, data);
            }
        });
    }

    @Deprecated
    public FallingBlock spawnFallingBlock(final Location location, final Material material, final byte data) throws IllegalArgumentException {
        return TaskManager.IMP.sync(new Supplier<FallingBlock>(){

            @Override
            public FallingBlock get() {
                return AsyncWorld.this.parent.spawnFallingBlock(location, material, data);
            }
        });
    }

    public FallingBlock spawnFallingBlock(final Location location, final BlockData blockData) throws IllegalArgumentException {
        return TaskManager.IMP.sync(new Supplier<FallingBlock>(){

            @Override
            public FallingBlock get() {
                return AsyncWorld.this.parent.spawnFallingBlock(location, blockData);
            }
        });
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public void playEffect(final Location location, final Effect effect, final int data, final int radius) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playEffect(location, effect, data, radius);
            }
        });
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(final Location location, final Effect effect, final T data, final int radius) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playEffect(location, effect, data, radius);
            }
        });
    }

    public ChunkSnapshot getEmptyChunkSnapshot(final int x, final int z, final boolean includeBiome, final boolean includeBiomeTempRain) {
        return TaskManager.IMP.sync(new RunnableVal<ChunkSnapshot>(){

            @Override
            public void run(ChunkSnapshot value) {
                this.value = AsyncWorld.this.parent.getEmptyChunkSnapshot(x, z, includeBiome, includeBiomeTempRain);
            }
        });
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.parent.setSpawnFlags(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.parent.getAllowAnimals();
    }

    public boolean getAllowMonsters() {
        return this.parent.getAllowMonsters();
    }

    public Biome getBiome(int x, int z) {
        return this.adapter.getBiome(this.queue.getBiomeId(x, z));
    }

    public void setBiome(int x, int z, Biome bio) {
        int id = this.adapter.getBiomeId(bio);
        this.queue.setBiome(x, z, new BaseBiome(id));
    }

    public double getTemperature(int x, int z) {
        return this.parent.getTemperature(x, z);
    }

    public double getHumidity(int x, int z) {
        return this.parent.getHumidity(x, z);
    }

    public int getMaxHeight() {
        return this.parent.getMaxHeight();
    }

    public int getSeaLevel() {
        return this.parent.getSeaLevel();
    }

    public boolean getKeepSpawnInMemory() {
        return this.parent.getKeepSpawnInMemory();
    }

    public void setKeepSpawnInMemory(final boolean keepLoaded) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.setKeepSpawnInMemory(keepLoaded);
            }
        });
    }

    public boolean isAutoSave() {
        return this.parent.isAutoSave();
    }

    public void setAutoSave(boolean value) {
        this.parent.setAutoSave(value);
    }

    public void setDifficulty(Difficulty difficulty) {
        this.parent.setDifficulty(difficulty);
    }

    public Difficulty getDifficulty() {
        return this.parent.getDifficulty();
    }

    public File getWorldFolder() {
        return this.parent.getWorldFolder();
    }

    public WorldType getWorldType() {
        return this.parent.getWorldType();
    }

    public boolean canGenerateStructures() {
        return this.parent.canGenerateStructures();
    }

    public long getTicksPerAnimalSpawns() {
        return this.parent.getTicksPerAnimalSpawns();
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.parent.setTicksPerAnimalSpawns(ticksPerAnimalSpawns);
    }

    public long getTicksPerMonsterSpawns() {
        return this.parent.getTicksPerMonsterSpawns();
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.parent.setTicksPerMonsterSpawns(ticksPerMonsterSpawns);
    }

    public int getMonsterSpawnLimit() {
        return this.parent.getMonsterSpawnLimit();
    }

    public void setMonsterSpawnLimit(int limit) {
        this.parent.setMonsterSpawnLimit(limit);
    }

    public int getAnimalSpawnLimit() {
        return this.parent.getAnimalSpawnLimit();
    }

    public void setAnimalSpawnLimit(int limit) {
        this.parent.setAnimalSpawnLimit(limit);
    }

    public int getWaterAnimalSpawnLimit() {
        return this.parent.getWaterAnimalSpawnLimit();
    }

    public void setWaterAnimalSpawnLimit(int limit) {
        this.parent.setWaterAnimalSpawnLimit(limit);
    }

    public int getAmbientSpawnLimit() {
        return this.parent.getAmbientSpawnLimit();
    }

    public void setAmbientSpawnLimit(int limit) {
        this.parent.setAmbientSpawnLimit(limit);
    }

    public void playSound(final Location location, final Sound sound, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, volume, pitch);
            }
        });
    }

    public void playSound(final Location location, final String sound, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, volume, pitch);
            }
        });
    }

    public void playSound(final Location location, final Sound sound, final SoundCategory category, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, category, volume, pitch);
            }
        });
    }

    public void playSound(final Location location, final String sound, final SoundCategory category, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, category, volume, pitch);
            }
        });
    }

    public String[] getGameRules() {
        return this.parent.getGameRules();
    }

    public String getGameRuleValue(String rule) {
        return this.parent.getGameRuleValue(rule);
    }

    public boolean setGameRuleValue(String rule, String value) {
        return this.parent.setGameRuleValue(rule, value);
    }

    public boolean isGameRule(String rule) {
        return this.parent.isGameRule(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> gameRule) {
        return (T)this.parent.getGameRuleValue(gameRule);
    }

    public <T> T getGameRuleDefault(GameRule<T> gameRule) {
        return (T)this.parent.getGameRuleDefault(gameRule);
    }

    public <T> boolean setGameRule(GameRule<T> gameRule, T t) {
        return this.parent.setGameRule(gameRule, t);
    }

    public World.Spigot spigot() {
        return this.parent.spigot();
    }

    public void setMetadata(final String key, final MetadataValue meta) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.setMetadata(key, meta);
            }
        });
    }

    public List<MetadataValue> getMetadata(String key) {
        return this.parent.getMetadata(key);
    }

    public boolean hasMetadata(String key) {
        return this.parent.hasMetadata(key);
    }

    public void removeMetadata(final String key, final Plugin plugin) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.removeMetadata(key, plugin);
            }
        });
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        this.parent.sendPluginMessage(source, channel, message);
    }

    public Set<String> getListeningPluginChannels() {
        return this.parent.getListeningPluginChannels();
    }

    public BukkitImplAdapter getAdapter() {
        return this.adapter;
    }

    public int getEntityCount() {
        return TaskManager.IMP.sync(new RunnableVal<Integer>(){

            @Override
            public void run(Integer value) {
                this.value = AsyncWorld.this.parent.getEntityCount();
            }
        });
    }

    public int getTileEntityCount() {
        return TaskManager.IMP.sync(new RunnableVal<Integer>(){

            @Override
            public void run(Integer value) {
                this.value = AsyncWorld.this.parent.getTileEntityCount();
            }
        });
    }

    public int getTickableTileEntityCount() {
        return TaskManager.IMP.sync(new RunnableVal<Integer>(){

            @Override
            public void run(Integer value) {
                this.value = AsyncWorld.this.parent.getTickableTileEntityCount();
            }
        });
    }

    public int getChunkCount() {
        return TaskManager.IMP.sync(new RunnableVal<Integer>(){

            @Override
            public void run(Integer value) {
                this.value = AsyncWorld.this.parent.getChunkCount();
            }
        });
    }

    public int getPlayerCount() {
        return TaskManager.IMP.sync(new RunnableVal<Integer>(){

            @Override
            public void run(Integer value) {
                this.value = AsyncWorld.this.parent.getPlayerCount();
            }
        });
    }
}

