/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.regions.FaweMaskManager;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ResidenceFeature
extends BukkitMaskManager
implements Listener {
    FaweBukkit plugin;
    Plugin residence;

    public ResidenceFeature(Plugin residencePlugin, FaweBukkit p3) {
        super(residencePlugin.getName());
        this.residence = residencePlugin;
        this.plugin = p3;
    }

    public boolean isAllowed(Player player, ClaimedResidence residence, FaweMaskManager.MaskType type) {
        return residence != null && (residence.getOwner().equals(player.getName()) || residence.getOwner().equals(player.getUniqueId().toString()) || type == FaweMaskManager.MaskType.MEMBER && residence.getPermissions().playerHas(player, "build", false));
    }

    public BukkitMask getMask(FawePlayer<Player> fp, FaweMaskManager.MaskType type) {
        Player player = (Player)fp.parent;
        Location location = player.getLocation();
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByLoc(location);
        if (residence != null) {
            boolean isAllowed;
            while (!(isAllowed = this.isAllowed(player, residence, type)) && residence != null) {
                residence = residence.getSubzoneByLoc(location);
            }
            if (isAllowed) {
                CuboidArea area = residence.getAreaArray()[0];
                Location pos1 = area.getLowLoc();
                Location pos2 = area.getHighLoc();
                final ClaimedResidence finalResidence = residence;
                return new BukkitMask(pos1, pos2){

                    @Override
                    public String getName() {
                        return "RESIDENCE: " + finalResidence.getName();
                    }

                    @Override
                    public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                        return ResidenceFeature.this.isAllowed((Player)player.parent, finalResidence, type);
                    }
                };
            }
        }
        return null;
    }
}

