/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import java.util.HashSet;
import java.util.Set;

public class EllipsoidRegion
extends AbstractRegion {
    private MutableBlockVector center;
    private MutableBlockVector radius;
    private MutableBlockVector radiusSqr;
    private int radiusLengthSqr;
    private boolean sphere;

    public EllipsoidRegion(Vector pos1, Vector pos2) {
        this(null, pos1, pos2);
    }

    public EllipsoidRegion(World world, Vector center, Vector radius) {
        super(world);
        this.center = new MutableBlockVector(center);
        this.setRadius(radius);
    }

    public EllipsoidRegion(EllipsoidRegion ellipsoidRegion) {
        this(ellipsoidRegion.world, ellipsoidRegion.center, ellipsoidRegion.getRadius());
    }

    @Override
    public Vector getMinimumPoint() {
        return this.center.subtract(this.getRadius()).clampY(0, 255);
    }

    @Override
    public Vector getMaximumPoint() {
        return this.center.add(this.getRadius()).clampY(0, 255);
    }

    @Override
    public int getArea() {
        if (this.radius == null) {
            return 0;
        }
        return (int)Math.floor(4.1887902047863905 * this.radius.getX() * this.radius.getY() * this.radius.getZ());
    }

    @Override
    public int getWidth() {
        return (int)(2.0 * this.radius.getX());
    }

    @Override
    public int getHeight() {
        return Math.max((int)(2.0 * this.radius.getY()), 256);
    }

    @Override
    public int getLength() {
        return (int)(2.0 * this.radius.getZ());
    }

    private Vector calculateDiff(Vector ... changes) throws RegionOperationException {
        Vector diff = new Vector().add(changes);
        if ((diff.getBlockX() & 1) + (diff.getBlockY() & 1) + (diff.getBlockZ() & 1) != 0) {
            throw new RegionOperationException("Ellipsoid changes must be even for each dimensions.");
        }
        return diff.divide(2).floor();
    }

    private Vector calculateChanges(Vector ... changes) {
        Vector total = new Vector();
        for (Vector change : changes) {
            total = total.add(change.positive());
        }
        return total.divide(2).floor();
    }

    @Override
    public void expand(Vector ... changes) throws RegionOperationException {
        this.center = new MutableBlockVector(this.center.add(this.calculateDiff(changes)));
        this.setRadius(this.radius.add(this.calculateChanges(changes)));
    }

    @Override
    public void contract(Vector ... changes) throws RegionOperationException {
        this.center = new MutableBlockVector(this.center.subtract(this.calculateDiff(changes)));
        Vector newRadius = this.radius.subtract(this.calculateChanges(changes));
        this.setRadius(Vector.getMaximum(new Vector(1.5, 1.5, 1.5), newRadius));
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.center = new MutableBlockVector(this.center.add(change));
    }

    @Override
    public Vector getCenter() {
        return this.center;
    }

    public void setCenter(Vector center) {
        this.center = new MutableBlockVector(center);
    }

    public Vector getRadius() {
        if (this.radius == null) {
            return null;
        }
        return this.radius.subtract(0.5, 0.5, 0.5);
    }

    public void setRadius(Vector radius) {
        this.radius = new MutableBlockVector(radius.add(0.5, 0.5, 0.5));
        this.radiusSqr = new MutableBlockVector(radius.multiply(radius));
        this.radiusLengthSqr = this.radiusSqr.getBlockX();
        this.sphere = radius.getBlockY() == radius.getBlockX() && radius.getBlockX() == radius.getBlockZ();
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        int centerY = this.getCenter().getBlockY();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                if (!this.contains(new BlockVector(x, centerY, z))) continue;
                chunks.add(new BlockVector2D(x >> 4, z >> 4));
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(Vector position) {
        double czd;
        double cyd;
        int cx = position.getBlockX() - this.center.getBlockX();
        int cx2 = cx * cx;
        if (cx2 > this.radiusSqr.getBlockX()) {
            return false;
        }
        int cz = position.getBlockZ() - this.center.getBlockZ();
        int cz2 = cz * cz;
        if (cz2 > this.radiusSqr.getBlockZ()) {
            return false;
        }
        int cy = position.getBlockY() - this.center.getBlockY();
        int cy2 = cy * cy;
        if (this.radiusSqr.getBlockY() < 255 && cy2 > this.radiusSqr.getBlockY()) {
            return false;
        }
        if (this.sphere) {
            return cx2 + cy2 + cz2 <= this.radiusLengthSqr;
        }
        double cxd = (double)cx / (double)this.radius.getBlockX();
        return cxd * cxd + (cyd = (double)cy / (double)this.radius.getBlockY()) * cyd + (czd = (double)cz / (double)this.radius.getBlockZ()) * czd <= 1.0;
    }

    public String toString() {
        return this.center + " - " + this.getRadius();
    }

    public void extendRadius(Vector minRadius) {
        this.setRadius(Vector.getMaximum(minRadius, this.getRadius()));
    }

    @Override
    public EllipsoidRegion clone() {
        return (EllipsoidRegion)super.clone();
    }
}

