/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.reorder;

import com.google.common.collect.Iterators;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.reorder.ReorderingExtent;
import com.sk89q.worldedit.function.operation.BlockMapEntryPlacer;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.OperationQueue;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.collection.TupleArrayList;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiStageReorder
extends AbstractDelegateExtent
implements ReorderingExtent {
    private TupleArrayList<BlockVector, BlockStateHolder> stage1 = new TupleArrayList();
    private TupleArrayList<BlockVector, BlockStateHolder> stage2 = new TupleArrayList();
    private TupleArrayList<BlockVector, BlockStateHolder> stage3 = new TupleArrayList();
    private boolean enabled;

    public MultiStageReorder(Extent extent, boolean enabled) {
        super(extent);
        this.enabled = enabled;
    }

    public MultiStageReorder(Extent extent) {
        this(extent, true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        BlockState existing = this.getBlock(location);
        if (!this.enabled) {
            return super.setBlock(location, block);
        }
        if (Blocks.shouldPlaceLast(block.getBlockType())) {
            this.stage2.put(location.toBlockVector(), block);
            return !existing.equalsFuzzy(block);
        }
        if (Blocks.shouldPlaceFinal(block.getBlockType())) {
            this.stage3.put(location.toBlockVector(), block);
            return !existing.equalsFuzzy(block);
        }
        if (Blocks.shouldPlaceLast(existing.getBlockType())) {
            super.setBlock(location, BlockTypes.AIR.getDefaultState());
            return super.setBlock(location, block);
        }
        this.stage1.put(location.toBlockVector(), block);
        return !existing.equalsFuzzy(block);
    }

    @Override
    public Operation commitBefore() {
        return new OperationQueue(new BlockMapEntryPlacer(this.getExtent(), Iterators.concat(this.stage1.iterator(), this.stage2.iterator())), new Stage3Committer());
    }

    private class Stage3Committer
    implements Operation {
        private Stage3Committer() {
        }

        @Override
        public Operation resume(RunContext run) throws WorldEditException {
            Extent extent = MultiStageReorder.this.getExtent();
            HashSet<BlockVector> blocks = new HashSet<BlockVector>();
            HashMap blockTypes = new HashMap();
            for (Map.Entry entry : MultiStageReorder.this.stage3) {
                BlockVector pt = (BlockVector)entry.getKey();
                blocks.add(pt);
                blockTypes.put(pt, entry.getValue());
            }
            while (!blocks.isEmpty()) {
                BlockStateHolder blockStateHolder;
                BlockVector current = (BlockVector)blocks.iterator().next();
                if (!blocks.contains(current)) continue;
                LinkedList<BlockVector> walked = new LinkedList<BlockVector>();
                do {
                    BlockVector lowerBlock;
                    walked.addFirst(current);
                    assert (blockTypes.containsKey(current));
                    blockStateHolder = (BlockStateHolder)blockTypes.get(current);
                    if (BlockCategories.DOORS.contains(blockStateHolder.getBlockType())) {
                        BlockVector upperBlock;
                        Property halfProperty = blockStateHolder.getBlockType().getProperty("half");
                        if (!blockStateHolder.getState(halfProperty).equals("lower") || !blocks.contains(upperBlock = current.add(0, 1, 0).toBlockVector()) || walked.contains(upperBlock)) continue;
                        walked.addFirst(upperBlock);
                        continue;
                    }
                    if (!BlockCategories.RAILS.contains(blockStateHolder.getBlockType()) || !blocks.contains(lowerBlock = current.add(0, -1, 0).toBlockVector()) || walked.contains(lowerBlock)) continue;
                    walked.addFirst(lowerBlock);
                } while (blockStateHolder.getBlockType().getMaterial().isFragileWhenPushed() && !walked.contains(current));
                for (BlockVector pt : walked) {
                    extent.setBlock(pt, (BlockStateHolder)blockTypes.get(pt));
                    blocks.remove(pt);
                }
            }
            MultiStageReorder.this.stage1.clear();
            MultiStageReorder.this.stage2.clear();
            MultiStageReorder.this.stage3.clear();
            return null;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void addStatusMessages(List<String> messages) {
        }
    }
}

