/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;

public class Vector
extends Vector2D
implements Comparable<Vector>,
Serializable {
    public static final Vector ZERO = new Vector(0, 0, 0);
    public static final Vector UNIT_X = new Vector(1, 0, 0);
    public static final Vector UNIT_Y = new Vector(0, 1, 0);
    public static final Vector UNIT_Z = new Vector(0, 0, 1);
    public static final Vector ONE = new Vector(1, 1, 1);
    private transient double y;

    public Vector(double x, double y, double z) {
        this.mutX(x);
        this.mutY(y);
        this.mutZ(z);
    }

    public Vector(int x, int y, int z) {
        this.mutX(x);
        this.mutY(y);
        this.mutZ(z);
    }

    public Vector(float x, float y, float z) {
        this.mutX(x);
        this.mutY(y);
        this.mutZ(z);
    }

    public Vector(Vector other) {
        this.mutX(other.getX());
        this.mutY(other.getY());
        this.mutZ(other.getZ());
    }

    public Vector(double[] arr) {
        this.mutX(arr[0]);
        this.mutY(arr[1]);
        this.mutZ(arr[2]);
    }

    public Vector() {
        this.mutX(0);
        this.mutY(0);
        this.mutZ(0);
    }

    public Vector setComponents(int x, int y, int z) {
        this.mutX(x);
        this.mutY(y);
        this.mutZ(z);
        return this;
    }

    public Vector setComponents(double x, double y, double z) {
        this.mutX(x);
        this.mutY(y);
        this.mutZ(z);
        return this;
    }

    public void mutX(int x) {
        this.x = x;
    }

    public void mutY(int y) {
        this.y = y;
    }

    public void mutZ(int z) {
        this.z = z;
    }

    public void mutX(double x) {
        this.x = x;
    }

    public void mutY(double y) {
        this.y = y;
    }

    public void mutZ(double z) {
        this.z = z;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public int getBlockX() {
        return MathMan.roundInt(this.getX());
    }

    @Override
    public Vector setX(double x) {
        return new Vector(x, this.getY(), this.getZ());
    }

    @Override
    public Vector setX(int x) {
        return new Vector((double)x, this.getY(), this.getZ());
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return MathMan.roundInt(this.getY());
    }

    public Vector setY(double y) {
        return new Vector(this.getX(), y, this.getZ());
    }

    public Vector setY(int y) {
        return new Vector(this.getX(), (double)y, this.getZ());
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public int getBlockZ() {
        return MathMan.roundInt(this.getZ());
    }

    @Override
    public Vector setZ(double z) {
        return new Vector(this.getX(), this.getY(), z);
    }

    @Override
    public Vector setZ(int z) {
        return new Vector(this.getX(), this.getY(), (double)z);
    }

    public Vector add(Vector other) {
        return new Vector(this.getX() + other.getX(), this.getY() + other.getY(), this.getZ() + other.getZ());
    }

    public Vector add(double x, double y, double z) {
        return new Vector(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public Vector add(int x, int y, int z) {
        return new Vector(this.getX() + (double)x, this.getY() + (double)y, this.getZ() + (double)z);
    }

    public Vector add(Vector ... others) {
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        for (Vector other : others) {
            newX += other.getX();
            newY += other.getY();
            newZ += other.getZ();
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector subtract(Vector other) {
        return new Vector(this.getX() - other.getX(), this.getY() - other.getY(), this.getZ() - other.getZ());
    }

    public Vector subtract(double x, double y, double z) {
        return new Vector(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    public Vector subtract(int x, int y, int z) {
        return new Vector(this.getX() - (double)x, this.getY() - (double)y, this.getZ() - (double)z);
    }

    public Vector subtract(Vector ... others) {
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        for (Vector other : others) {
            newX -= other.getX();
            newY -= other.getY();
            newZ -= other.getZ();
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector multiply(Vector other) {
        return new Vector(this.getX() * other.getX(), this.getY() * other.getY(), this.getZ() * other.getZ());
    }

    public Vector multiply(double x, double y, double z) {
        return new Vector(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    public Vector multiply(int x, int y, int z) {
        return new Vector(this.getX() * (double)x, this.getY() * (double)y, this.getZ() * (double)z);
    }

    public Vector multiply(Vector ... others) {
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        for (Vector other : others) {
            newX *= other.getX();
            newY *= other.getY();
            newZ *= other.getZ();
        }
        return new Vector(newX, newY, newZ);
    }

    @Override
    public Vector multiply(double n) {
        return new Vector(this.getX() * n, this.getY() * n, this.getZ() * n);
    }

    @Override
    public Vector multiply(float n) {
        return new Vector(this.getX() * (double)n, this.getY() * (double)n, this.getZ() * (double)n);
    }

    @Override
    public Vector multiply(int n) {
        return new Vector(this.getX() * (double)n, this.getY() * (double)n, this.getZ() * (double)n);
    }

    public Vector divide(Vector other) {
        return new Vector(this.getX() / other.getX(), this.getY() / other.getY(), this.getZ() / other.getZ());
    }

    public Vector divide(double x, double y, double z) {
        return new Vector(this.getX() / x, this.getY() / y, this.getZ() / z);
    }

    public Vector divide(int x, int y, int z) {
        return new Vector(this.getX() / (double)x, this.getY() / (double)y, this.getZ() / (double)z);
    }

    @Override
    public Vector divide(int n) {
        return new Vector(this.getX() / (double)n, this.getY() / (double)n, this.getZ() / (double)n);
    }

    @Override
    public Vector divide(double n) {
        return new Vector(this.getX() / n, this.getY() / n, this.getZ() / n);
    }

    @Override
    public Vector divide(float n) {
        return new Vector(this.getX() / (double)n, this.getY() / (double)n, this.getZ() / (double)n);
    }

    @Override
    public double length() {
        return Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ());
    }

    @Override
    public double lengthSq() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public double volume() {
        return this.getX() * this.getY() * this.getZ();
    }

    public double distance(Vector other) {
        return Math.sqrt(Math.pow(other.getX() - this.getX(), 2.0) + Math.pow(other.getY() - this.getY(), 2.0) + Math.pow(other.getZ() - this.getZ(), 2.0));
    }

    public double distanceSq(Vector other) {
        return Math.pow(other.getX() - this.getX(), 2.0) + Math.pow(other.getY() - this.getY(), 2.0) + Math.pow(other.getZ() - this.getZ(), 2.0);
    }

    @Override
    public Vector normalize() {
        return this.divide(this.length());
    }

    public double dot(Vector other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    public Vector cross(Vector other) {
        return new Vector(this.getY() * other.getZ() - this.getZ() * other.getY(), this.getZ() * other.getX() - this.getX() * other.getZ(), this.getX() * other.getY() - this.getY() * other.getX());
    }

    public boolean containedWithin(Vector min, Vector max) {
        return this.getX() >= min.getX() && this.getX() <= max.getX() && this.getY() >= min.getY() && this.getY() <= max.getY() && this.getZ() >= min.getZ() && this.getZ() <= max.getZ();
    }

    public boolean containedWithinBlock(Vector min, Vector max) {
        return this.getBlockX() >= min.getBlockX() && this.getBlockX() <= max.getBlockX() && this.getBlockY() >= min.getBlockY() && this.getBlockY() <= max.getBlockY() && this.getBlockZ() >= min.getBlockZ() && this.getBlockZ() <= max.getBlockZ();
    }

    public Vector clampY(int min, int max) {
        return new Vector(this.getX(), Math.max((double)min, Math.min((double)max, this.getY())), this.getZ());
    }

    @Override
    public Vector floor() {
        return new Vector(Math.floor(this.getX()), Math.floor(this.getY()), Math.floor(this.getZ()));
    }

    @Override
    public Vector ceil() {
        return new Vector(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()));
    }

    @Override
    public Vector round() {
        return new Vector(Math.floor(this.getX() + 0.5), Math.floor(this.getY() + 0.5), Math.floor(this.getZ() + 0.5));
    }

    @Override
    public Vector positive() {
        return new Vector(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()));
    }

    @Override
    public Vector transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.getX() - aboutX;
        double z = this.getZ() - aboutZ;
        double x2 = x * Math.cos(angle) - z * Math.sin(angle);
        double z2 = x * Math.sin(angle) + z * Math.cos(angle);
        return new Vector(x2 + aboutX + translateX, this.getY(), z2 + aboutZ + translateZ);
    }

    public boolean isCollinearWith(Vector other) {
        if (this.getX() == 0.0 && this.getY() == 0.0 && this.getZ() == 0.0) {
            return true;
        }
        double otherX = other.getX();
        double otherY = other.getY();
        double otherZ = other.getZ();
        if (otherX == 0.0 && otherY == 0.0 && otherZ == 0.0) {
            return true;
        }
        if (this.getX() == 0.0 != (otherX == 0.0)) {
            return false;
        }
        if (this.getY() == 0.0 != (otherY == 0.0)) {
            return false;
        }
        if (this.getZ() == 0.0 != (otherZ == 0.0)) {
            return false;
        }
        double quotientX = otherX / this.getX();
        if (!Double.isNaN(quotientX)) {
            return other.equals(this.multiply(quotientX));
        }
        double quotientY = otherY / this.getY();
        if (!Double.isNaN(quotientY)) {
            return other.equals(this.multiply(quotientY));
        }
        double quotientZ = otherZ / this.getZ();
        if (!Double.isNaN(quotientZ)) {
            return other.equals(this.multiply(quotientZ));
        }
        throw new RuntimeException("This should not happen");
    }

    public float toPitch() {
        double x = this.getX();
        double z = this.getZ();
        if (x == 0.0 && z == 0.0) {
            return this.getY() > 0.0 ? -90.0f : 90.0f;
        }
        double x2 = x * x;
        double z2 = z * z;
        double xz = Math.sqrt(x2 + z2);
        return (float)Math.toDegrees(Math.atan(-this.getY() / xz));
    }

    public float toYaw() {
        double x = this.getX();
        double z = this.getZ();
        double t = Math.atan2(-x, z);
        double _2pi = Math.PI * 2;
        return (float)Math.toDegrees((t + _2pi) % _2pi);
    }

    public static BlockVector toBlockPoint(double x, double y, double z) {
        return new BlockVector(Math.floor(x), Math.floor(y), Math.floor(z));
    }

    public BlockVector toBlockPoint() {
        return new BlockVector(Math.floor(this.getX()), Math.floor(this.getY()), Math.floor(this.getZ()));
    }

    public BlockVector toBlockVector() {
        return new BlockVector(this);
    }

    public Vector2D toVector2D() {
        return new Vector2D(this.getX(), this.getZ());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        return other.getX() == this.getX() && other.getZ() == this.getZ() && other.getY() == this.getY();
    }

    @Override
    public int compareTo(@Nullable Vector other) {
        if (other == null) {
            throw new IllegalArgumentException("null not supported");
        }
        if (this.getY() != other.getY()) {
            return Double.compare(this.getY(), other.getY());
        }
        if (this.getZ() != other.getZ()) {
            return Double.compare(this.getZ(), other.getZ());
        }
        if (this.getX() != other.getX()) {
            return Double.compare(this.getX(), other.getX());
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return (int)this.getX() ^ (int)this.getZ() << 16 ^ (int)this.getY() << 30;
    }

    @Override
    public String toString() {
        String x = this.getX() == (double)this.getBlockX() ? "" + this.getBlockX() : "" + this.getX();
        String y = this.getY() == (double)this.getBlockY() ? "" + this.getBlockY() : "" + this.getY();
        String z = this.getZ() == (double)this.getBlockZ() ? "" + this.getBlockZ() : "" + this.getZ();
        return "(" + x + ", " + y + ", " + z + ")";
    }

    public static Vector getMinimum(Vector v1, Vector v2) {
        return new Vector(Math.min(v1.getX(), v2.getX()), Math.min(v1.getY(), v2.getY()), Math.min(v1.getZ(), v2.getZ()));
    }

    public static Vector getMaximum(Vector v1, Vector v2) {
        return new Vector(Math.max(v1.getX(), v2.getX()), Math.max(v1.getY(), v2.getY()), Math.max(v1.getZ(), v2.getZ()));
    }

    public static Vector getMidpoint(Vector v1, Vector v2) {
        return new Vector((v1.getX() + v2.getX()) / 2.0, (v1.getY() + v2.getY()) / 2.0, (v1.getZ() + v2.getZ()) / 2.0);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (!(this instanceof MutableBlockVector)) {
            stream.writeDouble(this.x);
            stream.writeDouble(this.y);
            stream.writeDouble(this.z);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (this instanceof MutableBlockVector) {
            return;
        }
        this.x = stream.readDouble();
        this.y = stream.readDouble();
        this.z = stream.readDouble();
    }
}

