/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal2;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.changeset.MemoryOptimizedHistory;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.history.change.BlockChange;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.history.change.EntityCreate;
import com.sk89q.worldedit.history.change.EntityRemove;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FaweChangeSet
implements ChangeSet {
    private World world;
    private final String worldName;
    private final boolean mainThread;
    private final int layers;
    protected AtomicInteger waitingCombined = new AtomicInteger(0);
    protected AtomicInteger waitingAsync = new AtomicInteger(0);

    public static FaweChangeSet getDefaultChangeSet(World world, UUID uuid) {
        if (Settings.IMP.HISTORY.USE_DISK) {
            if (Settings.IMP.HISTORY.USE_DATABASE) {
                return new RollbackOptimizedHistory(world, uuid);
            }
            return new DiskStorageHistory(world, uuid);
        }
        return new MemoryOptimizedHistory(world);
    }

    public FaweChangeSet(String world) {
        this.worldName = world;
        this.mainThread = Fawe.get() != null ? Fawe.isMainThread() : true;
        this.layers = FaweChunk.HEIGHT >> 4;
    }

    public FaweChangeSet(World world) {
        this.world = world;
        this.worldName = Fawe.imp().getWorldName(world);
        this.mainThread = Fawe.isMainThread();
        this.layers = this.world.getMaxY() + 1 >> 4;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public World getWorld() {
        if (this.world == null && this.worldName != null) {
            this.world = FaweAPI.getWorld(this.worldName);
        }
        return this.world;
    }

    @Deprecated
    public boolean flushAsync() {
        return this.closeAsync();
    }

    public boolean closeAsync() {
        this.waitingAsync.incrementAndGet();
        TaskManager.IMP.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FaweChangeSet.this.waitingAsync.decrementAndGet();
                AtomicInteger atomicInteger = FaweChangeSet.this.waitingAsync;
                synchronized (atomicInteger) {
                    FaweChangeSet.this.waitingAsync.notifyAll();
                }
                FaweChangeSet.this.close();
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean flush() {
        try {
            AtomicInteger atomicInteger;
            if (!Fawe.isMainThread()) {
                while (this.waitingAsync.get() > 0) {
                    atomicInteger = this.waitingAsync;
                    synchronized (atomicInteger) {
                        this.waitingAsync.wait(1000L);
                    }
                }
            }
            while (this.waitingCombined.get() > 0) {
                atomicInteger = this.waitingCombined;
                synchronized (atomicInteger) {
                    this.waitingCombined.wait(1000L);
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            MainUtil.handleError(e);
        }
        return true;
    }

    public boolean close() {
        return this.flush();
    }

    public abstract void add(int var1, int var2, int var3, int var4, int var5);

    @Override
    public Iterator<Change> backwardIterator() {
        return this.getIterator(false);
    }

    @Override
    public Iterator<Change> forwardIterator() {
        return this.getIterator(true);
    }

    public abstract void addTileCreate(CompoundTag var1);

    public abstract void addTileRemove(CompoundTag var1);

    public abstract void addEntityRemove(CompoundTag var1);

    public abstract void addEntityCreate(CompoundTag var1);

    public abstract void addBiomeChange(int var1, int var2, BaseBiome var3, BaseBiome var4);

    public Iterator<Change> getIterator(BlockBag blockBag, int mode, boolean redo) {
        return this.getIterator(redo);
    }

    public abstract Iterator<Change> getIterator(boolean var1);

    public void delete() {
    }

    public EditSession toEditSession(FawePlayer player) {
        return this.toEditSession(player, null);
    }

    public EditSession toEditSession(FawePlayer player, Region[] regions) {
        EditSessionBuilder builder = new EditSessionBuilder(this.getWorld()).player(player).autoQueue(false).fastmode(false).checkMemory(false).changeSet(this).limitUnlimited();
        if (regions != null) {
            builder.allowedRegions(regions);
        } else {
            builder.allowedRegionsEverywhere();
        }
        EditSession editSession = builder.build();
        editSession.setSize(1);
        return editSession;
    }

    public void add(EntityCreate change) {
        CompoundTag tag = change.state.getNbtData();
        MainUtil.setEntityInfo(tag, change.getEntity());
        this.addEntityCreate(tag);
    }

    public void add(EntityRemove change) {
        CompoundTag tag = change.state.getNbtData();
        MainUtil.setEntityInfo(tag, change.getEntity());
        this.addEntityRemove(tag);
    }

    @Override
    public void add(Change change) {
        if (change.getClass() == BlockChange.class) {
            this.add((BlockChange)change);
        } else if (change.getClass() == EntityCreate.class) {
            this.add((EntityCreate)change);
        } else if (change.getClass() == EntityRemove.class) {
            this.add((EntityRemove)change);
        } else {
            Fawe.debug("Unknown change: " + change.getClass());
        }
    }

    public void add(BlockChange change) {
        try {
            BlockVector loc = change.getPosition();
            BlockStateHolder from = change.getPrevious();
            BlockStateHolder to = change.getCurrent();
            this.add(loc, from, to);
        }
        catch (Exception e) {
            MainUtil.handleError(e);
        }
    }

    public void add(Vector loc, BlockStateHolder from, BlockStateHolder to) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        this.add(x, y, z, from, to);
    }

    public void add(int x, int y, int z, BlockStateHolder from, BlockStateHolder to) {
        try {
            CompoundTag nbt;
            if (from.hasNbtData()) {
                nbt = from.getNbtData();
                MainUtil.setPosition(nbt, x, y, z);
                this.addTileRemove(nbt);
            }
            if (to.hasNbtData()) {
                nbt = to.getNbtData();
                MainUtil.setPosition(nbt, x, y, z);
                this.addTileCreate(nbt);
            }
            int combinedFrom = from.getInternalId();
            int combinedTo = to.getInternalId();
            this.add(x, y, z, combinedFrom, combinedTo);
        }
        catch (Exception e) {
            MainUtil.handleError(e);
        }
    }

    public boolean isEmpty() {
        return this.waitingCombined.get() == 0 && this.waitingAsync.get() == 0 && this.size() == 0;
    }

    public void add(int x, int y, int z, int combinedFrom, BaseBlock to) {
        try {
            if (to.hasNbtData()) {
                CompoundTag nbt = to.getNbtData();
                MainUtil.setPosition(nbt, x, y, z);
                this.addTileCreate(nbt);
            }
            int combinedTo = to.getInternalId();
            this.add(x, y, z, combinedFrom, combinedTo);
        }
        catch (Exception e) {
            MainUtil.handleError(e);
        }
    }

    public void addChangeTask(FaweQueue queue) {
        queue.setChangeTask(new RunnableVal2<FaweChunk, FaweChunk>(){

            @Override
            public void run(final FaweChunk previous, final FaweChunk next) {
                FaweChangeSet.this.waitingCombined.incrementAndGet();
                Runnable run = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            int cx = previous.getX();
                            int cz = previous.getZ();
                            int bx = cx << 4;
                            int bz = cz << 4;
                            FaweChangeSet faweChangeSet = FaweChangeSet.this;
                            synchronized (faweChangeSet) {
                                Set<CompoundTag> entities;
                                if (previous.getBiomeArray() != null) {
                                    byte[] previousBiomes = previous.getBiomeArray();
                                    byte[] nextBiomes = next.getBiomeArray();
                                    int index = 0;
                                    for (int z = 0; z < 16; ++z) {
                                        int zz = bz + z;
                                        for (int x = 0; x < 16; ++x) {
                                            byte idFrom = previousBiomes[index];
                                            byte idTo = nextBiomes[index];
                                            if (idFrom != idTo && idTo != 0) {
                                                FaweChangeSet.this.addBiomeChange(bx + x, zz, FaweCache.getBiome(idFrom & 0xFF), FaweCache.getBiome(idTo & 0xFF));
                                            }
                                            ++index;
                                        }
                                    }
                                }
                                for (int layer = 0; layer < FaweChangeSet.this.layers; ++layer) {
                                    int[] currentLayer = next.getIdArray(layer);
                                    int[] previousLayer = previous.getIdArray(layer);
                                    if (currentLayer == null) continue;
                                    int startY = layer << 4;
                                    int index = 0;
                                    for (int y = 0; y < 16; ++y) {
                                        int yy = y + startY;
                                        for (int z = 0; z < 16; ++z) {
                                            int zz = z + bz;
                                            int x = 0;
                                            while (x < 16) {
                                                int xx = x + bx;
                                                int combinedIdCurrent = currentLayer[index];
                                                switch (combinedIdCurrent) {
                                                    case 0: {
                                                        break;
                                                    }
                                                    case 1: {
                                                        combinedIdCurrent = 0;
                                                    }
                                                    default: {
                                                        int combinedIdPrevious;
                                                        int n = combinedIdPrevious = previousLayer != null ? previousLayer[index] : 0;
                                                        if (combinedIdCurrent == combinedIdPrevious) break;
                                                        FaweChangeSet.this.add(xx, yy, zz, combinedIdPrevious, combinedIdCurrent);
                                                    }
                                                }
                                                ++x;
                                                ++index;
                                            }
                                        }
                                    }
                                }
                                Map<Short, CompoundTag> tiles = next.getTiles();
                                if (!tiles.isEmpty()) {
                                    for (Map.Entry<Short, CompoundTag> entry : tiles.entrySet()) {
                                        FaweChangeSet.this.addTileCreate(entry.getValue());
                                    }
                                }
                                if (!(tiles = previous.getTiles()).isEmpty()) {
                                    for (Map.Entry<Short, CompoundTag> entry : tiles.entrySet()) {
                                        FaweChangeSet.this.addTileRemove(entry.getValue());
                                    }
                                }
                                if (!(entities = next.getEntities()).isEmpty()) {
                                    for (CompoundTag entityTag : entities) {
                                        FaweChangeSet.this.addEntityCreate(entityTag);
                                    }
                                }
                                if (!(entities = previous.getEntities()).isEmpty()) {
                                    for (CompoundTag entityTag : entities) {
                                        FaweChangeSet.this.addEntityRemove(entityTag);
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            MainUtil.handleError(e);
                        }
                        finally {
                            if (FaweChangeSet.this.waitingCombined.decrementAndGet() <= 0) {
                                AtomicInteger cx = FaweChangeSet.this.waitingAsync;
                                synchronized (cx) {
                                    FaweChangeSet.this.waitingAsync.notifyAll();
                                }
                                cx = FaweChangeSet.this.waitingCombined;
                                synchronized (cx) {
                                    FaweChangeSet.this.waitingCombined.notifyAll();
                                }
                            }
                        }
                    }
                };
                if (FaweChangeSet.this.mainThread) {
                    run.run();
                } else {
                    TaskManager.IMP.getPublicForkJoinPool().submit(run);
                }
            }
        });
    }
}

