/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.jnbt.anvil.HeightMapMCAGenerator;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ExtentTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import java.io.File;
import java.io.IOException;

public class CFIChange
implements Change {
    private final File file;

    public CFIChange(File file) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
    }

    private HeightMapMCAGenerator getQueue(UndoContext context) {
        FaweQueue queue;
        ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(context.getExtent()).find(HasFaweQueue.class);
        if (found != null && (queue = found.get().getQueue()) instanceof HeightMapMCAGenerator) {
            return (HeightMapMCAGenerator)queue;
        }
        Fawe.debug("FAWE does not support: " + context.getExtent() + " for " + this.getClass() + " (bug Empire92)");
        return null;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        HeightMapMCAGenerator queue = this.getQueue(context);
        if (queue != null) {
            try {
                queue.undoChanges(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            queue.update();
        }
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        HeightMapMCAGenerator queue = this.getQueue(context);
        if (queue != null) {
            try {
                queue.redoChanges(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            queue.update();
        }
    }
}

