/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.example;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class IntFaweChunk<T, V extends FaweQueue>
extends FaweChunk<T> {
    public final int[][] ids;
    public final short[] count;
    public final short[] air;
    public final byte[] heightMap;
    public byte[] biomes;
    public HashMap<Short, CompoundTag> tiles;
    public HashSet<CompoundTag> entities;
    public HashSet<UUID> entityRemoves;
    public T chunk;

    public IntFaweChunk(FaweQueue parent, int x, int z, int[][] ids, short[] count, short[] air, byte[] heightMap) {
        super(parent, x, z);
        this.ids = ids;
        this.count = count;
        this.air = air;
        this.heightMap = heightMap;
    }

    public IntFaweChunk(FaweQueue parent, int x, int z) {
        super(parent, x, z);
        this.ids = new int[HEIGHT >> 4][];
        this.count = new short[HEIGHT >> 4];
        this.air = new short[HEIGHT >> 4];
        this.heightMap = new byte[256];
    }

    public V getParent() {
        return (V)super.getParent();
    }

    @Override
    public T getChunk() {
        if (this.chunk == null) {
            this.chunk = this.getNewChunk();
        }
        return this.chunk;
    }

    public abstract T getNewChunk();

    @Override
    public void setLoc(FaweQueue parent, int x, int z) {
        super.setLoc(parent, x, z);
        this.chunk = null;
    }

    public int getCount(int i) {
        return this.count[i];
    }

    public int getAir(int i) {
        return this.air[i];
    }

    public void setCount(int i, short value) {
        this.count[i] = value;
    }

    public int getTotalCount() {
        int total = 0;
        for (int i = 0; i < this.count.length; ++i) {
            total += Math.min(4096, this.count[i]);
        }
        return total;
    }

    public int getTotalAir() {
        int total = 0;
        for (int i = 0; i < this.air.length; ++i) {
            total += Math.min(4096, this.air[i]);
        }
        return total;
    }

    @Override
    public int getBitMask() {
        int bitMask = 0;
        for (int section = 0; section < this.ids.length; ++section) {
            if (this.ids[section] == null) continue;
            bitMask += 1 << section;
        }
        return bitMask;
    }

    @Override
    public int[] getIdArray(int i) {
        return this.ids[i];
    }

    @Override
    public int[][] getCombinedIdArrays() {
        return this.ids;
    }

    @Override
    public byte[] getBiomeArray() {
        return this.biomes;
    }

    @Override
    public int getBlockCombinedId(int x, int y, int z) {
        short i = FaweCache.CACHE_I[y][z][x];
        int[] array = this.getIdArray(i);
        if (array == null) {
            return 0;
        }
        return array[FaweCache.CACHE_J[y][z][x]];
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tile) {
        if (this.tiles == null) {
            this.tiles = new HashMap();
        }
        short pair = MathMan.tripleBlockCoord(x, y, z);
        this.tiles.put(pair, tile);
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        if (this.tiles == null) {
            return null;
        }
        short pair = MathMan.tripleBlockCoord(x, y, z);
        return this.tiles.get(pair);
    }

    @Override
    public Map<Short, CompoundTag> getTiles() {
        return this.tiles == null ? new HashMap<Short, CompoundTag>() : this.tiles;
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return this.entities == null ? Collections.emptySet() : this.entities;
    }

    @Override
    public void setEntity(CompoundTag tag) {
        if (this.entities == null) {
            this.entities = new HashSet();
        }
        this.entities.add(tag);
    }

    @Override
    public void removeEntity(UUID uuid) {
        if (this.entityRemoves == null) {
            this.entityRemoves = new HashSet();
        }
        this.entityRemoves.add(uuid);
    }

    public HashSet<UUID> getEntityRemoves() {
        return this.entityRemoves == null ? new HashSet<UUID>() : this.entityRemoves;
    }

    @Override
    public void setBlock(int x, int y, int z, int combinedId) {
        short i = FaweCache.CACHE_I[y][z][x];
        short j = FaweCache.CACHE_J[y][z][x];
        int[] vs = this.ids[i];
        if (vs == null) {
            this.ids[i] = new int[4096];
            vs = this.ids[i];
        }
        vs[j] = combinedId;
        short s = i;
        this.count[s] = (short)(this.count[s] + 1);
        switch (BlockTypes.getFromStateId(combinedId)) {
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                short s2 = i;
                this.air[s2] = (short)(this.air[s2] + 1);
                return;
            }
        }
        this.heightMap[z << 4 | x] = (byte)y;
    }

    @Deprecated
    public void setBitMask(int ignore) {
    }

    @Override
    public void setBiome(int x, int z, byte biome) {
        if (this.biomes == null) {
            this.biomes = new byte[256];
        }
        if (biome == 0) {
            biome = (byte)-1;
        }
        this.biomes[((z & 0xF) << 4) + (x & 0xF)] = biome;
    }

    public abstract IntFaweChunk<T, V> copy(boolean var1);
}

