/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.listener;

import com.boydti.fawe.command.CFICommands;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal3;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.util.SetQueue;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.BlockInteractEvent;
import com.sk89q.worldedit.event.platform.Interaction;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CFIPacketListener
implements Listener {
    private final Plugin plugin;
    private final ProtocolManager protocolmanager;

    public CFIPacketListener(Plugin plugin) {
        this.plugin = plugin;
        this.protocolmanager = ProtocolLibrary.getProtocolManager();
        this.registerBlockEvent(PacketType.Play.Client.BLOCK_DIG, false, new RunnableVal3<PacketEvent, VirtualWorld, Vector>(){

            @Override
            public void run(PacketEvent event, VirtualWorld gen, Vector pt) {
                try {
                    org.bukkit.entity.Player plr = event.getPlayer();
                    Vector realPos = pt.add(gen.getOrigin());
                    if (!CFIPacketListener.this.sendBlockChange(plr, gen, pt, Interaction.HIT)) {
                        gen.setBlock(pt, EditSession.nullBlock);
                    }
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        });
        RunnableVal3<PacketEvent, VirtualWorld, Vector> placeTask = new RunnableVal3<PacketEvent, VirtualWorld, Vector>(){

            @Override
            public void run(PacketEvent event, VirtualWorld gen, Vector pt) {
                try {
                    ItemStack hand;
                    org.bukkit.entity.Player plr = event.getPlayer();
                    List hands = event.getPacket().getHands().getValues();
                    EnumWrappers.Hand enumHand = hands.isEmpty() ? EnumWrappers.Hand.MAIN_HAND : (EnumWrappers.Hand)hands.get(0);
                    PlayerInventory inv = plr.getInventory();
                    ItemStack itemStack = hand = enumHand == EnumWrappers.Hand.MAIN_HAND ? inv.getItemInMainHand() : inv.getItemInOffHand();
                    if (hand != null && hand.getType().isBlock()) {
                        switch (hand.getType()) {
                            case AIR: 
                            case CAVE_AIR: 
                            case VOID_AIR: {
                                break;
                            }
                            default: {
                                BlockState block = BukkitAdapter.asBlockState(hand);
                                if (block == null) break;
                                gen.setBlock(pt, block);
                                return;
                            }
                        }
                    }
                    pt = CFIPacketListener.this.getRelPos(event, gen);
                    CFIPacketListener.this.sendBlockChange(plr, gen, pt, Interaction.OPEN);
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        };
        this.registerBlockEvent(PacketType.Play.Client.BLOCK_PLACE, true, placeTask);
        this.registerBlockEvent(PacketType.Play.Client.USE_ITEM, true, placeTask);
        this.registerBlockEvent(PacketType.Play.Server.BLOCK_CHANGE, false, new RunnableVal3<PacketEvent, VirtualWorld, Vector>(){

            @Override
            public void run(PacketEvent event, VirtualWorld gen, Vector pt) {
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    int ocz;
                    Vector origin = gen.getOrigin();
                    PacketContainer packet = event.getPacket();
                    StructureModifier ints = packet.getIntegers();
                    int cx = (Integer)ints.read(0);
                    int cz = (Integer)ints.read(1);
                    int ocx = origin.getBlockX() >> 4;
                    if (gen.contains(new Vector(cx - ocx << 4, 0, cz - (ocz = origin.getBlockZ() >> 4) << 4))) {
                        event.setCancelled(true);
                        org.bukkit.entity.Player plr = event.getPlayer();
                        FaweQueue queue = SetQueue.IMP.getNewQueue(plr.getWorld().getName(), true, false);
                        FaweChunk toSend = gen.getSnapshot(cx - ocx, cz - ocz);
                        toSend.setLoc(gen, cx, cz);
                        queue.sendChunkUpdate(toSend, FawePlayer.wrap(plr));
                    }
                }
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.ENTITY_VELOCITY}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                org.bukkit.entity.Player player = event.getPlayer();
                Location pos = player.getLocation();
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    Vector origin = gen.getOrigin();
                    Vector pt = new Vector(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                    StructureModifier ints = event.getPacket().getIntegers();
                    int id = (Integer)ints.read(0);
                    int mx = (Integer)ints.read(1);
                    int my = (Integer)ints.read(2);
                    int mz = (Integer)ints.read(3);
                    if (gen.contains(pt.subtract(origin)) && mx == 0 && my == 0 && mz == 0) {
                        event.setCancelled(true);
                    }
                }
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.POSITION}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                org.bukkit.entity.Player player = event.getPlayer();
                Location pos = player.getLocation();
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    Vector origin = gen.getOrigin();
                    Vector from = new Vector(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                    PacketContainer packet = event.getPacket();
                    StructureModifier doubles = packet.getDoubles();
                    Vector to = new Vector((Double)doubles.read(0), (Double)doubles.read(1), (Double)doubles.read(2));
                    if (gen.contains(to.subtract(origin)) && from.distanceSq(to) < 8.0) {
                        int id = (Integer)packet.getIntegers().read(0);
                        PacketContainer reply = new PacketContainer(PacketType.Play.Client.TELEPORT_ACCEPT);
                        reply.getIntegers().write(0, (Object)id);
                        try {
                            CFIPacketListener.this.protocolmanager.recieveClientPacket(player, reply);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        event.setCancelled(true);
                    }
                }
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.MULTI_BLOCK_CHANGE}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    int cz;
                    PacketContainer packet = event.getPacket();
                    ChunkCoordIntPair chunk = (ChunkCoordIntPair)packet.getChunkCoordIntPairs().read(0);
                    Vector origin = gen.getOrigin();
                    int cx = chunk.getChunkX() - (origin.getBlockX() >> 4);
                    if (gen.contains(new Vector(cx << 4, 0, (cz = chunk.getChunkZ() - (origin.getBlockX() >> 4)) << 4))) {
                        event.setCancelled(true);
                    }
                }
            }
        });
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        VirtualWorld gen = this.getGenerator(player);
        if (gen != null) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (to.getWorld().equals(from.getWorld()) && to.distanceSquared(from) < 8.0) {
                event.setTo(player.getLocation());
                event.setCancelled(true);
                player.setVelocity(player.getVelocity());
            }
        }
    }

    private boolean sendBlockChange(org.bukkit.entity.Player plr, VirtualWorld gen, Vector pt, Interaction action) {
        PlatformManager platform = WorldEdit.getInstance().getPlatformManager();
        Player actor = FawePlayer.wrap(plr).getPlayer();
        com.sk89q.worldedit.util.Location location = new com.sk89q.worldedit.util.Location(actor.getWorld(), pt);
        BlockInteractEvent toCall = new BlockInteractEvent(actor, location, action);
        platform.handleBlockInteract(toCall);
        if (toCall.isCancelled() || action == Interaction.OPEN) {
            Vector realPos = pt.add(gen.getOrigin());
            BlockState block = gen.getBlock(pt);
            this.sendBlockChange(plr, realPos, block);
            return true;
        }
        return false;
    }

    private void sendBlockChange(org.bukkit.entity.Player plr, Vector pt, BlockStateHolder block) {
        plr.sendBlockChange(new Location(plr.getWorld(), (double)pt.getBlockX(), (double)pt.getBlockY(), (double)pt.getBlockZ()), BukkitAdapter.adapt(block));
    }

    private VirtualWorld getGenerator(PacketEvent event) {
        return this.getGenerator(event.getPlayer());
    }

    private VirtualWorld getGenerator(org.bukkit.entity.Player player) {
        FawePlayer fp = FawePlayer.wrap(player);
        VirtualWorld vw = fp.getSession().getVirtualWorld();
        if (vw != null) {
            return vw;
        }
        CFICommands.CFISettings settings = (CFICommands.CFISettings)fp.getMeta("CFISettings");
        if (settings != null && settings.hasGenerator() && settings.getGenerator().hasPacketViewer()) {
            return settings.getGenerator();
        }
        return null;
    }

    private Vector getRelPos(PacketEvent event, VirtualWorld generator) {
        PacketContainer packet = event.getPacket();
        StructureModifier position = packet.getBlockPositionModifier();
        BlockPosition loc = (BlockPosition)position.readSafely(0);
        if (loc == null) {
            return null;
        }
        Vector origin = generator.getOrigin();
        Vector pt = new Vector(loc.getX() - origin.getBlockX(), loc.getY() - origin.getBlockY(), loc.getZ() - origin.getBlockZ());
        return pt;
    }

    private void handleBlockEvent(PacketEvent event, boolean relative, RunnableVal3<PacketEvent, VirtualWorld, Vector> task) {
        Vector pt;
        VirtualWorld gen = this.getGenerator(event);
        if (gen != null && (pt = this.getRelPos(event, gen)) != null) {
            if (relative) {
                pt = this.getRelative(event, pt);
            }
            if (gen.contains(pt)) {
                event.setCancelled(true);
                task.run(event, gen, pt);
            }
        }
    }

    private void registerBlockEvent(final PacketType type, final boolean relative, final RunnableVal3<PacketEvent, VirtualWorld, Vector> task) {
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{type}){

            public void onPacketReceiving(PacketEvent event) {
                if (type.isClient() || event.isServerPacket()) {
                    CFIPacketListener.this.handleBlockEvent(event, relative, task);
                }
            }

            public void onPacketSending(PacketEvent event) {
                this.onPacketReceiving(event);
            }
        });
    }

    private Vector getRelative(PacketEvent container, Vector pt) {
        PacketContainer packet = container.getPacket();
        StructureModifier dirs = packet.getDirections();
        EnumWrappers.Direction dir = (EnumWrappers.Direction)dirs.readSafely(0);
        if (dir == null) {
            return pt;
        }
        switch (dir.ordinal()) {
            case 0: {
                return pt.add(0, -1, 0);
            }
            case 1: {
                return pt.add(0, 1, 0);
            }
            case 2: {
                return pt.add(0, 0, -1);
            }
            case 3: {
                return pt.add(0, 0, 1);
            }
            case 4: {
                return pt.add(-1, 0, 0);
            }
            case 5: {
                return pt.add(1, 0, 0);
            }
        }
        return pt;
    }
}

