/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.NMSMappedFaweQueue;
import com.boydti.fawe.example.NMSRelighter;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.schematic.Schematic;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.WEManager;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.factory.DefaultMaskParser;
import com.sk89q.worldedit.extension.factory.DefaultTransformParser;
import com.sk89q.worldedit.extension.factory.HashTagPatternParser;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.internal.registry.AbstractFactory;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FaweAPI {
    public static EditSessionBuilder getEditSessionBuilder(World world) {
        return new EditSessionBuilder(world);
    }

    public static TaskManager getTaskManager() {
        return TaskManager.IMP;
    }

    public static boolean registerMasks(Object methods) {
        DefaultMaskParser parser = FaweAPI.getParser(DefaultMaskParser.class);
        if (parser != null) {
            parser.register(methods);
        }
        return parser != null;
    }

    public static boolean registerPatterns(Object methods) {
        HashTagPatternParser parser = FaweAPI.getParser(HashTagPatternParser.class);
        if (parser != null) {
            parser.register(methods);
        }
        return parser != null;
    }

    public static boolean registerTransforms(Object methods) {
        DefaultTransformParser parser = Fawe.get().getTransformParser();
        if (parser != null) {
            parser.register(methods);
        }
        return parser != null;
    }

    public static <T> T getParser(Class<T> parserClass) {
        try {
            Field field = AbstractFactory.class.getDeclaredField("parsers");
            field.setAccessible(true);
            ArrayList parsers = new ArrayList();
            parsers.addAll((List)field.get(WorldEdit.getInstance().getMaskFactory()));
            parsers.addAll((List)field.get(WorldEdit.getInstance().getBlockFactory()));
            parsers.addAll((List)field.get(WorldEdit.getInstance().getItemFactory()));
            parsers.addAll((List)field.get(WorldEdit.getInstance().getPatternFactory()));
            for (InputParser parser : parsers) {
                if (!parserClass.isAssignableFrom(parser.getClass())) continue;
                return (T)parser;
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void registerCommands(Object clazz, String ... aliases) {
        CommandManager.getInstance().registerCommands(clazz, aliases);
    }

    public static FawePlayer wrapPlayer(Object obj) {
        return FawePlayer.wrap(obj);
    }

    public static FaweQueue createQueue(String worldName, boolean autoqueue) {
        return SetQueue.IMP.getNewQueue(worldName, true, autoqueue);
    }

    public static FaweQueue createQueue(World world, boolean autoqueue) {
        return SetQueue.IMP.getNewQueue(world, true, autoqueue);
    }

    public static World getWorld(String worldName) {
        Platform platform = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING);
        List<? extends World> worlds = platform.getWorlds();
        for (World world : worlds) {
            if (!Fawe.imp().getWorldName(world).equals(worldName)) continue;
            return WorldWrapper.wrap((AbstractWorld)world);
        }
        for (World world : worlds) {
            if (!world.getName().equals(worldName)) continue;
            return WorldWrapper.wrap((AbstractWorld)world);
        }
        return null;
    }

    public static URL upload(Clipboard clipboard, ClipboardFormat format) {
        return format.uploadAnonymous(clipboard);
    }

    public static Schematic load(File file) throws IOException {
        return ClipboardFormat.SCHEMATIC.load(file);
    }

    public static Set<FaweMaskManager> getMaskManagers() {
        return new HashSet<FaweMaskManager>(WEManager.IMP.managers);
    }

    public static boolean isMemoryLimited() {
        return MemUtil.isMemoryLimited();
    }

    @Deprecated
    public static PseudoRandom getFastRandom() {
        return new PseudoRandom();
    }

    public static Region[] getRegions(FawePlayer player) {
        return WEManager.IMP.getMask(player);
    }

    public static void cancelEdit(Extent extent, BBC reason) {
        try {
            WEManager.IMP.cancelEdit(extent, reason);
        }
        catch (WorldEditException worldEditException) {
            // empty catch block
        }
    }

    public static void addMaskManager(FaweMaskManager maskMan) {
        WEManager.IMP.managers.add(maskMan);
    }

    public static DiskStorageHistory getChangeSetFromFile(File file) {
        UUID uuid;
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("Not a file!");
        }
        if (!file.getName().toLowerCase().endsWith(".bd")) {
            throw new IllegalArgumentException("Not a BD file!");
        }
        if (Settings.IMP.HISTORY.USE_DISK) {
            throw new IllegalArgumentException("History on disk not enabled!");
        }
        String[] path = file.getPath().split(File.separator);
        if (path.length < 3) {
            throw new IllegalArgumentException("Not in history directory!");
        }
        String worldName = path[path.length - 3];
        String uuidString = path[path.length - 2];
        World world = FaweAPI.getWorld(worldName);
        if (world == null) {
            throw new IllegalArgumentException("Corresponding world does not exist: " + worldName);
        }
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid UUID from file path: " + uuidString);
        }
        DiskStorageHistory history = new DiskStorageHistory(world, uuid, Integer.parseInt(file.getName().split("\\.")[0]));
        return history;
    }

    public static List<DiskStorageHistory> getBDFiles(FaweLocation origin, UUID user, int radius, long timediff, boolean shallow) {
        File history = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + origin.world);
        if (!history.exists()) {
            return new ArrayList<DiskStorageHistory>();
        }
        long now = System.currentTimeMillis();
        ArrayList<File> files = new ArrayList<File>();
        for (File userFile : history.listFiles()) {
            UUID userUUID;
            if (!userFile.isDirectory()) continue;
            try {
                userUUID = UUID.fromString(userFile.getName());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (user != null && !userUUID.equals(user)) continue;
            ArrayList ids = new ArrayList();
            for (File file : userFile.listFiles()) {
                if (!file.getName().endsWith(".bd") || timediff < Integer.MAX_VALUE && now - file.lastModified() > timediff) continue;
                files.add(file);
                if (files.size() <= 2048) continue;
                return null;
            }
        }
        World world = origin.getWorld();
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                int bI;
                String aName = a.getName();
                String bName = b.getName();
                int aI = Integer.parseInt(aName.substring(0, aName.length() - 3));
                long value = aI - (bI = Integer.parseInt(bName.substring(0, bName.length() - 3)));
                return value == 0L ? 0 : (value < 0L ? -1 : 1);
            }
        });
        RegionWrapper bounds = new RegionWrapper(origin.x - radius, origin.x + radius, origin.z - radius, origin.z + radius);
        RegionWrapper boundsPlus = new RegionWrapper(bounds.minX - 64, bounds.maxX + 512, bounds.minZ - 64, bounds.maxZ + 512);
        HashSet<RegionWrapper> regionSet = new HashSet<RegionWrapper>(Arrays.asList(bounds));
        ArrayList<DiskStorageHistory> result = new ArrayList<DiskStorageHistory>();
        for (File file : files) {
            UUID uuid = UUID.fromString(file.getParentFile().getName());
            DiskStorageHistory dsh = new DiskStorageHistory(world, uuid, Integer.parseInt(file.getName().split("\\.")[0]));
            DiskStorageHistory.DiskStorageSummary summary = dsh.summarize(boundsPlus, shallow);
            RegionWrapper region = new RegionWrapper(summary.minX, summary.maxX, summary.minZ, summary.maxZ);
            boolean encompassed = false;
            boolean isIn = false;
            for (RegionWrapper allowed : regionSet) {
                isIn = isIn || allowed.intersects(region);
                encompassed = allowed.isIn(region.minX, region.maxX) && allowed.isIn(region.minZ, region.maxZ);
                if (!encompassed) continue;
                break;
            }
            if (!isIn) continue;
            result.add(0, dsh);
            if (!encompassed) {
                regionSet.add(region);
            }
            if (!shallow || result.size() <= 64) continue;
            return result;
        }
        return result;
    }

    public static DiskStorageHistory getChangeSetFromDisk(World world, UUID uuid, int index) {
        return new DiskStorageHistory(world, uuid, index);
    }

    public static boolean checkVersion(int[] version, int major, int minor, int minor2) {
        return version[0] > major || version[0] == major && version[1] > minor || version[0] == major && version[1] == minor && version[2] >= minor2;
    }

    @Deprecated
    public static int fixLighting(String world, Region selection) {
        return FaweAPI.fixLighting(world, selection, FaweQueue.RelightMode.ALL);
    }

    @Deprecated
    public static int fixLighting(String world, Region selection, FaweQueue.RelightMode mode) {
        return FaweAPI.fixLighting(world, selection, null, mode);
    }

    @Deprecated
    public static int fixLighting(String world, Region selection, @Nullable FaweQueue queue, FaweQueue.RelightMode mode) {
        return FaweAPI.fixLighting(FaweAPI.getWorld(world), selection, queue, mode);
    }

    public static int fixLighting(World world, Region selection, @Nullable FaweQueue queue, FaweQueue.RelightMode mode) {
        Vector bot = selection.getMinimumPoint();
        Vector top = selection.getMaximumPoint();
        int minX = bot.getBlockX() >> 4;
        int minZ = bot.getBlockZ() >> 4;
        int maxX = top.getBlockX() >> 4;
        int maxZ = top.getBlockZ() >> 4;
        int count = 0;
        if (queue == null) {
            queue = SetQueue.IMP.getNewQueue(world, true, false);
        }
        if (queue instanceof NMSMappedFaweQueue) {
            NMSMappedFaweQueue nmsQueue = (NMSMappedFaweQueue)queue;
            NMSRelighter relighter = new NMSRelighter(nmsQueue);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    relighter.addChunk(x, z, null, 65535);
                    ++count;
                }
            }
            if (mode != FaweQueue.RelightMode.NONE) {
                boolean sky = nmsQueue.hasSky();
                if (sky) {
                    relighter.fixSkyLighting();
                }
                relighter.fixBlockLighting();
            } else {
                relighter.removeLighting();
            }
            relighter.sendChunks();
        }
        return count;
    }

    public static void addTask(Runnable whenDone) {
        SetQueue.IMP.addEmptyTask(whenDone);
    }

    public static void addMemoryLimitedTask(Runnable run) {
        MemUtil.addMemoryLimitedTask(run);
    }

    public static void addMemoryPlentifulTask(Runnable run) {
        MemUtil.addMemoryPlentifulTask(run);
    }

    public static BBC[] getTranslations() {
        return BBC.values();
    }

    @Deprecated
    public static EditSession getNewEditSession(@Nonnull FawePlayer player) {
        if (player == null) {
            throw new IllegalArgumentException("Player may not be null");
        }
        return player.getNewEditSession();
    }

    @Deprecated
    public static EditSession getNewEditSession(World world) {
        return WorldEdit.getInstance().getEditSessionFactory().getEditSession(world, -1);
    }
}

