/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.boydti.fawe.object.HasFaweQueue;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import java.util.Collection;

public class DirectionalVisitor
extends RecursiveVisitor {
    private final Vector origin;
    private final Vector dirVec;

    public DirectionalVisitor(Mask mask, RegionFunction function, Vector origin, Vector direction) {
        this(mask, function, origin, direction, Integer.MAX_VALUE, null);
    }

    public DirectionalVisitor(Mask mask, RegionFunction function, Vector origin, Vector direction, int distance, HasFaweQueue hasFaweQueue) {
        super(mask, function, distance, hasFaweQueue);
        Preconditions.checkNotNull((Object)mask);
        this.origin = origin;
        this.dirVec = new MutableBlockVector(direction);
        Collection<Vector> directions = this.getDirections();
        directions.clear();
        directions.add(new Vector(1, 0, 0));
        directions.add(new Vector(-1, 0, 0));
        directions.add(new Vector(0, 0, 1));
        directions.add(new Vector(0, 0, -1));
        directions.add(new Vector(0, -1, 0));
        directions.add(new Vector(0, 1, 0));
    }

    @Override
    public boolean isVisitable(Vector from, Vector to) {
        int dx = to.getBlockX() - from.getBlockX();
        int dz = to.getBlockZ() - from.getBlockZ();
        int dy = to.getBlockY() - from.getBlockY();
        if (dx != 0 && this.dirVec.getBlockX() != 0 && this.dirVec.getBlockX() != dx) {
            return false;
        }
        if (dy != 0 && this.dirVec.getBlockY() != 0 && this.dirVec.getBlockY() != dy) {
            return false;
        }
        if (dz != 0 && this.dirVec.getBlockZ() != 0 && this.dirVec.getBlockZ() != dz) {
            return false;
        }
        return super.isVisitable(from, to);
    }
}

