/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.transform;

import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class BlockTransformExtent
extends ResettableExtent {
    private Transform transform;
    private Transform transformInverse;
    private int[] BLOCK_ROTATION_BITMASK;
    private int[][] BLOCK_TRANSFORM;
    private int[][] BLOCK_TRANSFORM_INVERSE;
    private int[] ALL = new int[0];

    public BlockTransformExtent(Extent parent) {
        this(parent, new AffineTransform());
    }

    public BlockTransformExtent(Extent parent, Transform transform) {
        super(parent);
        this.transform = transform;
        this.transformInverse = this.transform.inverse();
        this.cache();
    }

    private List<Direction> getDirections(AbstractProperty property) {
        if (property instanceof DirectionalProperty) {
            DirectionalProperty directional = (DirectionalProperty)property;
            directional.getValues();
        } else {
            switch (property.getKey()) {
                default: 
            }
        }
        return null;
    }

    @Nullable
    private static Integer getNewStateIndex(Transform transform, List<Direction> directions, int oldIndex) {
        Direction oldDirection = directions.get(oldIndex);
        Vector oldVector = oldDirection.toVector();
        Vector newVector = transform.apply(oldVector).subtract(transform.apply(Vector.ZERO)).normalize();
        int newIndex = oldIndex;
        double closest = oldVector.toVector().normalize().dot(newVector);
        boolean found = false;
        for (int i = 0; i < directions.size(); ++i) {
            Direction v = directions.get(i);
            double dot = v.toVector().normalize().dot(newVector);
            if (!(dot > closest)) continue;
            closest = dot;
            newIndex = i;
            found = true;
        }
        if (found) {
            return newIndex;
        }
        return null;
    }

    private void cache() {
        this.BLOCK_ROTATION_BITMASK = new int[BlockTypes.size()];
        this.BLOCK_TRANSFORM = new int[BlockTypes.size()][];
        this.BLOCK_TRANSFORM_INVERSE = new int[BlockTypes.size()][];
        for (int i = 0; i < this.BLOCK_TRANSFORM.length; ++i) {
            this.BLOCK_TRANSFORM[i] = this.ALL;
            this.BLOCK_TRANSFORM_INVERSE[i] = this.ALL;
            BlockTypes type = BlockTypes.get(i);
            int bitMask = 0;
            for (AbstractProperty abstractProperty : type.getProperties()) {
                List<Direction> directions = this.getDirections(abstractProperty);
                if (directions == null) continue;
                this.BLOCK_TRANSFORM[i] = null;
                this.BLOCK_TRANSFORM_INVERSE[i] = null;
                bitMask |= abstractProperty.getBitMask();
            }
            if (bitMask == 0) continue;
            this.BLOCK_ROTATION_BITMASK[i] = bitMask;
        }
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        return super.setExtent(extent);
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform affine) {
        this.transform = affine;
        this.transformInverse = this.transform.inverse();
        this.cache();
    }

    private final BlockState transform(BlockState state, int[][] transformArray, Transform transform) {
        int typeId = state.getInternalBlockTypeId();
        int[] arr = transformArray[typeId];
        if (arr == this.ALL) {
            return state;
        }
        if (arr == null) {
            transformArray[typeId] = new int[state.getBlockType().getMaxStateId() + 1];
            arr = transformArray[typeId];
            Arrays.fill(arr, -1);
        }
        int mask = this.BLOCK_ROTATION_BITMASK[typeId];
        int internalId = state.getInternalId();
        int maskedId = internalId & mask;
        int newMaskedId = arr[maskedId];
        if (newMaskedId != -1) {
            return BlockState.getFromInternalId(newMaskedId | internalId & ~mask);
        }
        newMaskedId = state.getInternalId();
        BlockTypes type = state.getBlockType();
        for (AbstractProperty abstractProperty : type.getProperties()) {
            Integer newIndex;
            List<Direction> directions = this.getDirections(abstractProperty);
            if (directions == null || (newIndex = BlockTransformExtent.getNewStateIndex(transform, directions, abstractProperty.getIndex(state.getInternalId()))) == null) continue;
            newMaskedId = abstractProperty.modifyIndex(newMaskedId, newIndex);
        }
        arr[maskedId] = newMaskedId & mask;
        return BlockState.getFromInternalId(newMaskedId);
    }

    public final BlockState transformFast(BlockState block) {
        CompoundTag tag;
        BlockState transformed = this.transform(block, this.BLOCK_TRANSFORM, this.transform);
        if (block.hasNbtData() && (tag = block.getNbtData()).containsKey("Rot")) {
            int rot = tag.asInt("Rot");
            Direction direction = MCDirections.fromRotation(rot);
            if (direction != null) {
                Vector applyAbsolute = this.transform.apply(direction.toVector());
                Vector applyOrigin = this.transform.apply(Vector.ZERO);
                applyAbsolute.mutX(applyAbsolute.getX() - applyOrigin.getX());
                applyAbsolute.mutY(applyAbsolute.getY() - applyOrigin.getY());
                applyAbsolute.mutZ(applyAbsolute.getZ() - applyOrigin.getZ());
                Direction newDirection = Direction.findClosest(applyAbsolute, Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL);
                if (newDirection != null) {
                    Map values = ReflectionUtils.getMap(tag.getValue());
                    values.put("Rot", new ByteTag((byte)MCDirections.toRotation(newDirection)));
                }
            }
            transformed = new BaseBlock(transformed, tag);
        }
        return transformed;
    }

    public final BlockState transformFastInverse(BlockState block) {
        BlockState transformed = this.transform(block, this.BLOCK_TRANSFORM_INVERSE, this.transformInverse);
        if (block.hasNbtData()) {
            int rot;
            Direction direction;
            CompoundTag tag = block.getNbtData();
            if (tag.containsKey("Rot") && (direction = MCDirections.fromRotation(rot = tag.asInt("Rot"))) != null) {
                Vector applyAbsolute = this.transformInverse.apply(direction.toVector());
                Vector applyOrigin = this.transformInverse.apply(Vector.ZERO);
                applyAbsolute.mutX(applyAbsolute.getX() - applyOrigin.getX());
                applyAbsolute.mutY(applyAbsolute.getY() - applyOrigin.getY());
                applyAbsolute.mutZ(applyAbsolute.getZ() - applyOrigin.getZ());
                Direction newDirection = Direction.findClosest(applyAbsolute, Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL);
                if (newDirection != null) {
                    Map values = ReflectionUtils.getMap(tag.getValue());
                    values.put("Rot", new ByteTag((byte)MCDirections.toRotation(newDirection)));
                }
            }
            transformed = new BaseBlock(transformed, tag);
        }
        return transformed;
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        return this.transformFast(super.getLazyBlock(x, y, z));
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.transformFast(super.getLazyBlock(position));
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.transformFast(super.getBlock(position));
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return super.getBiome(position);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(x, y, z, this.transformFastInverse((BlockState)block));
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(location, this.transformFastInverse((BlockState)block));
    }
}

