/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent;

import com.boydti.fawe.jnbt.anvil.generator.CavesGen;
import com.boydti.fawe.jnbt.anvil.generator.GenBase;
import com.boydti.fawe.jnbt.anvil.generator.OreGen;
import com.boydti.fawe.jnbt.anvil.generator.Resource;
import com.boydti.fawe.jnbt.anvil.generator.SchemGen;
import com.boydti.fawe.object.clipboard.WorldCopyClipboard;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.InputExtent;
import com.sk89q.worldedit.extent.OutputExtent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.PropertyGroup;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public interface Extent
extends InputExtent,
OutputExtent {
    public Vector getMinimumPoint();

    public Vector getMaximumPoint();

    default public List<? extends Entity> getEntities(Region region) {
        return Collections.emptyList();
    }

    default public List<? extends Entity> getEntities() {
        return Collections.emptyList();
    }

    @Nullable
    default public Entity createEntity(Location location, BaseEntity entity) {
        return null;
    }

    @Override
    default public BlockState getBlock(Vector position) {
        return this.getFullBlock(position);
    }

    @Override
    default public BlockState getLazyBlock(Vector position) {
        return this.getFullBlock(position);
    }

    default public BlockState getLazyBlock(int x, int y, int z) {
        return this.getLazyBlock(MutableBlockVector.get(x, y, z));
    }

    default public boolean setBlock(int x, int y, int z, BlockStateHolder state) throws WorldEditException {
        return this.setBlock(MutableBlockVector.get(x, y, z), state);
    }

    default public boolean setBiome(int x, int y, int z, BaseBiome biome) {
        return this.setBiome(MutableBlockVector2D.get(x, z), biome);
    }

    default public int getHighestTerrainBlock(int x, int z, int minY, int maxY) {
        maxY = Math.min(maxY, Math.max(0, maxY));
        minY = Math.max(0, minY);
        for (int y = maxY; y >= minY; --y) {
            BlockState block = this.getLazyBlock(x, y, z);
            if (!block.getBlockType().getMaterial().isMovementBlocker()) continue;
            return y;
        }
        return minY;
    }

    default public int getNearestSurfaceLayer(int x, int z, int y, int minY, int maxY) {
        boolean state;
        block9: {
            int layer;
            int data1;
            int clearanceAbove = maxY - y;
            int clearanceBelow = y - minY;
            int clearance = Math.min(clearanceAbove, clearanceBelow);
            BlockState block = this.getLazyBlock(x, y, z);
            state = !block.getBlockType().getMaterial().isMovementBlocker();
            int data2 = data1 = PropertyGroup.LEVEL.get(block).intValue();
            int offset = state ? 0 : 1;
            for (int d = 0; d <= clearance; ++d) {
                int y1 = y + d;
                block = this.getLazyBlock(x, y1, z);
                if (!block.getBlockType().getMaterial().isMovementBlocker() != state) {
                    return (y1 - offset << 4) - (15 - (state ? PropertyGroup.LEVEL.get(block) : data1));
                }
                data1 = PropertyGroup.LEVEL.get(block);
                int y2 = y - d;
                block = this.getLazyBlock(x, y2, z);
                if (!block.getBlockType().getMaterial().isMovementBlocker() != state) {
                    return (y2 + offset << 4) - (15 - (state ? PropertyGroup.LEVEL.get(block) : data2));
                }
                data2 = PropertyGroup.LEVEL.get(block);
            }
            if (clearanceAbove == clearanceBelow) break block9;
            if (clearanceAbove < clearanceBelow) {
                for (layer = y - clearance - 1; layer >= minY; --layer) {
                    block = this.getLazyBlock(x, layer, z);
                    if (!block.getBlockType().getMaterial().isMovementBlocker() != state) {
                        int data = state ? PropertyGroup.LEVEL.get(block) : data1;
                        return (layer + offset << 4) + 0;
                    }
                    data1 = PropertyGroup.LEVEL.get(block);
                }
            } else {
                for (layer = y + clearance + 1; layer <= maxY; ++layer) {
                    block = this.getLazyBlock(x, layer, z);
                    if (!block.getBlockType().getMaterial().isMovementBlocker() != state) {
                        return (layer - offset << 4) - (15 - (state ? PropertyGroup.LEVEL.get(block) : data2));
                    }
                    data2 = PropertyGroup.LEVEL.get(block);
                }
            }
        }
        return (state ? minY : maxY) << 4;
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, boolean ignoreAir) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, minY, maxY, ignoreAir);
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, minY, maxY);
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, failedMin, failedMax, true);
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax, boolean ignoreAir) {
        int result;
        y = Math.max(minY, Math.min(maxY, y));
        int clearanceAbove = maxY - y;
        int clearanceBelow = y - minY;
        int clearance = Math.min(clearanceAbove, clearanceBelow);
        BlockState block = this.getLazyBlock(x, y, z);
        boolean state = !block.getBlockType().getMaterial().isMovementBlocker();
        int offset = state ? 0 : 1;
        for (int d = 0; d <= clearance; ++d) {
            int y1 = y + d;
            block = this.getLazyBlock(x, y1, z);
            if (!block.getMaterial().isMovementBlocker() != state && block.getBlockType() != BlockTypes.__RESERVED__) {
                return y1 - offset;
            }
            int y2 = y - d;
            block = this.getLazyBlock(x, y2, z);
            if (!block.getMaterial().isMovementBlocker() == state || block.getBlockType() == BlockTypes.__RESERVED__) continue;
            return y2 + offset;
        }
        if (clearanceAbove != clearanceBelow) {
            int layer;
            if (clearanceAbove < clearanceBelow) {
                for (layer = y - clearance - 1; layer >= minY; --layer) {
                    block = this.getLazyBlock(x, layer, z);
                    if (!block.getMaterial().isMovementBlocker() == state || block.getBlockType() == BlockTypes.__RESERVED__) continue;
                    return layer + offset;
                }
            } else {
                for (layer = y + clearance + 1; layer <= maxY; ++layer) {
                    block = this.getLazyBlock(x, layer, z);
                    if (!block.getMaterial().isMovementBlocker() == state || block.getBlockType() == BlockTypes.__RESERVED__) continue;
                    return layer - offset;
                }
            }
        }
        int n = result = state ? failedMin : failedMax;
        if (result > 0 && !ignoreAir) {
            block = this.getLazyBlock(x, result, z);
            return block.getBlockType().getMaterial().isAir() ? -1 : result;
        }
        return result;
    }

    default public void addCaves(Region region) throws WorldEditException {
        this.generate(region, new CavesGen(8));
    }

    default public void generate(Region region, GenBase gen) throws WorldEditException {
        for (Vector2D chunkPos : region.getChunks()) {
            gen.generate(chunkPos, this);
        }
    }

    default public void addSchems(Region region, Mask mask, List<ClipboardHolder> clipboards, int rarity, boolean rotate) throws WorldEditException {
        this.spawnResource(region, new SchemGen(mask, this, clipboards, rotate), rarity, 1);
    }

    default public void spawnResource(Region region, Resource gen, int rarity, int frequency) throws WorldEditException {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (Vector2D chunkPos : region.getChunks()) {
            for (int i = 0; i < frequency; ++i) {
                if (random.nextInt(100) > rarity) continue;
                int x = (chunkPos.getBlockX() << 4) + random.nextInt(16);
                int z = (chunkPos.getBlockZ() << 4) + random.nextInt(16);
                gen.spawn(random, x, z);
            }
        }
    }

    default public boolean contains(Vector pt) {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return pt.containedWithin(min, max);
    }

    default public void addOre(Region region, Mask mask, Pattern material, int size, int frequency, int rarity, int minY, int maxY) throws WorldEditException {
        this.spawnResource(region, new OreGen(this, mask, material, size, minY, maxY), rarity, frequency);
    }

    default public void addOres(Region region, Mask mask) throws WorldEditException {
        this.addOre(region, mask, BlockTypes.DIRT.getDefaultState(), 33, 10, 100, 0, 255);
        this.addOre(region, mask, BlockTypes.GRAVEL.getDefaultState(), 33, 8, 100, 0, 255);
        this.addOre(region, mask, BlockTypes.ANDESITE.getDefaultState(), 33, 10, 100, 0, 79);
        this.addOre(region, mask, BlockTypes.DIORITE.getDefaultState(), 33, 10, 100, 0, 79);
        this.addOre(region, mask, BlockTypes.GRANITE.getDefaultState(), 33, 10, 100, 0, 79);
        this.addOre(region, mask, BlockTypes.COAL_ORE.getDefaultState(), 17, 20, 100, 0, 127);
        this.addOre(region, mask, BlockTypes.IRON_ORE.getDefaultState(), 9, 20, 100, 0, 63);
        this.addOre(region, mask, BlockTypes.GOLD_ORE.getDefaultState(), 9, 2, 100, 0, 31);
        this.addOre(region, mask, BlockTypes.REDSTONE_ORE.getDefaultState(), 8, 8, 100, 0, 15);
        this.addOre(region, mask, BlockTypes.DIAMOND_ORE.getDefaultState(), 8, 1, 100, 0, 15);
        this.addOre(region, mask, BlockTypes.LAPIS_ORE.getDefaultState(), 7, 1, 100, 0, 15);
        this.addOre(region, mask, BlockTypes.EMERALD_ORE.getDefaultState(), 5, 1, 100, 4, 31);
    }

    default public List<Countable<BlockType>> getBlockDistribution(Region region) {
        int[] counter = new int[BlockTypes.size()];
        for (Vector pt : region) {
            BlockType type = this.getBlockType(pt);
            int n = type.getInternalId();
            counter[n] = counter[n] + 1;
        }
        ArrayList<Countable<BlockType>> distribution = new ArrayList<Countable<BlockType>>();
        for (int i = 0; i < counter.length; ++i) {
            int count = counter[i];
            if (count == 0) continue;
            distribution.add(new Countable<BlockTypes>(BlockTypes.get(i), count));
        }
        Collections.sort(distribution);
        return distribution;
    }

    default public List<Countable<BlockStateHolder>> getBlockDistributionWithData(Region region) {
        int[][] counter = new int[BlockTypes.size()][];
        for (Vector pt : region) {
            BlockState blk = this.getBlock(pt);
            BlockTypes type = blk.getBlockType();
            int[] stateCounter = counter[type.getInternalId()];
            if (stateCounter == null) {
                counter[type.getInternalId()] = stateCounter = new int[type.getMaxStateId() + 1];
            }
            int n = blk.getInternalPropertiesId();
            stateCounter[n] = stateCounter[n] + 1;
        }
        ArrayList<Countable<BlockStateHolder>> distribution = new ArrayList<Countable<BlockStateHolder>>();
        for (int typeId = 0; typeId < counter.length; ++typeId) {
            BlockTypes type = BlockTypes.get(typeId);
            int[] stateCount = counter[typeId];
            if (stateCount == null) continue;
            for (int propId = 0; propId < stateCount.length; ++propId) {
                int count = stateCount[propId];
                if (count == 0) continue;
                BlockState state = type.withPropertyId(propId);
                distribution.add(new Countable<BlockState>(state, count));
            }
        }
        return distribution;
    }

    default public BlockArrayClipboard lazyCopy(Region region) {
        WorldCopyClipboard faweClipboard = new WorldCopyClipboard(this, region);
        BlockArrayClipboard weClipboard = new BlockArrayClipboard(region, faweClipboard);
        weClipboard.setOrigin(region.getMinimumPoint());
        return weClipboard;
    }

    @Override
    @Nullable
    default public Operation commit() {
        return null;
    }

    default public int getMaxY() {
        return 255;
    }
}

