/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.database.DBHandler;
import com.boydti.fawe.database.RollbackDatabase;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.command.binding.Range;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

@Command(aliases={}, desc="Commands to undo, redo, and clear history: [More Info](http://wiki.sk89q.com/wiki/WorldEdit/Features#History)")
public class HistoryCommands
extends MethodCommands {
    public HistoryCommands(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Command(aliases={"/frb", "frb", "fawerollback", "/fawerollback", "/rollback"}, usage="<user=Empire92> <radius=5> <time=3d4h>", desc="Undo a specific edit.  - The time uses s, m, h, d, y.\n - Import from disk: /frb #import", min=1, max=3)
    @CommandPermissions(value={"worldedit.history.rollback"})
    public void faweRollback(final Player player, LocalSession session, final String user, @Optional(value={"0"}) @Range(min=0.0) int radius, @Optional(value={"0"}) String time, @Switch(value=114) boolean restore) throws WorldEditException {
        if (!Settings.IMP.HISTORY.USE_DATABASE) {
            BBC.SETTING_DISABLE.send(player, "history.use-database (Import with /frb #import )");
            return;
        }
        switch (user.charAt(0)) {
            case '#': {
                UUID uuid;
                if (user.equals("#import")) {
                    if (!player.hasPermission("fawe.rollback.import")) {
                        BBC.NO_PERM.send(player, "fawe.rollback.import");
                        return;
                    }
                    File folder = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY);
                    if (!folder.exists()) {
                        return;
                    }
                    for (File worldFolder : folder.listFiles()) {
                        String worldName;
                        World world;
                        if (!worldFolder.isDirectory() || (world = FaweAPI.getWorld(worldName = worldFolder.getName())) == null) continue;
                        for (File userFolder : worldFolder.listFiles()) {
                            if (!userFolder.isDirectory()) continue;
                            String userUUID = userFolder.getName();
                            try {
                                UUID uuid2 = UUID.fromString(userUUID);
                                for (File historyFile : userFolder.listFiles()) {
                                    RollbackOptimizedHistory rollback;
                                    DiskStorageHistory.DiskStorageSummary summary;
                                    String name = historyFile.getName();
                                    if (!name.endsWith(".bd") || (summary = (rollback = new RollbackOptimizedHistory(world, uuid2, Integer.parseInt(name.substring(0, name.length() - 3)))).summarize(RegionWrapper.GLOBAL(), false)) == null) continue;
                                    rollback.setDimensions(new Vector(summary.minX, 0, summary.minZ), new Vector(summary.maxX, 255, summary.maxZ));
                                    rollback.setTime(historyFile.lastModified());
                                    RollbackDatabase db = DBHandler.IMP.getDatabase(world);
                                    db.logEdit(rollback);
                                    player.print(BBC.getPrefix() + "Logging: " + historyFile);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    player.print(BBC.getPrefix() + "Done import!");
                    return;
                }
                String toParse = user.substring(1);
                if (!MathMan.isInteger(toParse)) {
                    BBC.COMMAND_SYNTAX.send(player, "/frb #<index>");
                    return;
                }
                int index = Integer.parseInt(toParse);
                World world = player.getWorld();
                DiskStorageHistory file = new DiskStorageHistory(world, uuid = player.getUniqueId(), index);
                if (file.getBDFile().exists()) {
                    if (restore) {
                        file.redo(FawePlayer.wrap(player));
                    } else {
                        file.undo(FawePlayer.wrap(player));
                    }
                    BBC.ROLLBACK_ELEMENT.send(player, Fawe.imp().getWorldName(world) + "/" + user + "-" + index);
                } else {
                    BBC.TOOL_INSPECT_INFO_FOOTER.send(player, 0);
                }
                return;
            }
        }
        UUID other = Fawe.imp().getUUID(user);
        if (other == null) {
            BBC.PLAYER_NOT_FOUND.send(player, user);
            return;
        }
        if (radius == 0) {
            BBC.COMMAND_SYNTAX.send(player, "/frb " + user + " <radius> <time>");
            return;
        }
        long timeDiff = MainUtil.timeToSec(time) * 1000L;
        if (timeDiff == 0L) {
            BBC.COMMAND_SYNTAX.send(player, "/frb " + user + " " + radius + " <time>");
            return;
        }
        radius = Math.max(Math.min(500, radius), 0);
        World world = player.getWorld();
        Location origin = player.getLocation();
        Vector bot = origin.toVector().subtract(radius, radius, radius);
        bot.mutY(Math.max(0.0, bot.getY()));
        Vector top = origin.toVector().add(radius, radius, radius);
        top.mutY(Math.min(255.0, top.getY()));
        RollbackDatabase database = DBHandler.IMP.getDatabase(world);
        final AtomicInteger count = new AtomicInteger();
        final FawePlayer fp = FawePlayer.wrap(player);
        final Region[] allowedRegions = fp.getCurrentRegions(FaweMaskManager.MaskType.OWNER);
        if (allowedRegions == null) {
            BBC.NO_REGION.send(fp, new Object[0]);
            return;
        }
        database.getPotentialEdits(other, System.currentTimeMillis() - timeDiff, bot, top, new RunnableVal<DiskStorageHistory>(){

            @Override
            public void run(DiskStorageHistory edit) {
                edit.undo(fp, allowedRegions);
                BBC.ROLLBACK_ELEMENT.send(player, Fawe.imp().getWorldName(edit.getWorld()) + "/" + user + "-" + edit.getIndex());
                count.incrementAndGet();
            }
        }, new Runnable(){

            @Override
            public void run() {
                BBC.TOOL_INSPECT_INFO_FOOTER.send(player, count);
            }
        }, true, restore);
    }

    @Command(aliases={"/fawerestore", "/frestore"}, usage="<user=Empire92|*> <radius=5> <time=3d4h>", desc="Redo a specific edit.  - The time uses s, m, h, d, y.\n - Import from disk: /frb #import", min=1, max=3)
    @CommandPermissions(value={"worldedit.history.rollback"})
    public void restore(Player player, LocalSession session, String user, @Optional(value={"0"}) @Range(min=0.0) int radius, @Optional(value={"0"}) String time) throws WorldEditException {
        this.faweRollback(player, session, user, radius, time, true);
    }

    @Command(aliases={"/undo", "undo"}, usage="[times] [player]", desc="Undoes the last action", min=0, max=2)
    @CommandPermissions(value={"worldedit.history.undo"})
    public void undo(Player player, LocalSession session, CommandContext context) throws WorldEditException {
        int times = Math.max(1, context.getInteger(0, 1));
        FawePlayer.wrap(player).checkConfirmation(() -> {
            int i;
            EditSession undone = null;
            for (i = 0; i < times; ++i) {
                if (context.argsLength() < 2) {
                    undone = session.undo(session.getBlockBag(player), player);
                    continue;
                }
                player.checkPermission("worldedit.history.undo.other");
                LocalSession sess = this.worldEdit.getSessionManager().findByName(context.getString(1));
                if (sess == null) {
                    BBC.COMMAND_HISTORY_OTHER_ERROR.send(player, context.getString(1));
                    break;
                }
                undone = sess.undo(session.getBlockBag(player), player);
                if (undone == null) break;
            }
            if (undone == null) {
                --i;
            }
            if (i > 0) {
                BBC.COMMAND_UNDO_SUCCESS.send(player, i == 1 ? "" : " x" + i);
                this.worldEdit.flushBlockBag(player, undone);
            }
            if (undone == null) {
                BBC.COMMAND_UNDO_ERROR.send(player, new Object[0]);
            }
        }, this.getArguments(context), times, 50, context);
    }

    @Command(aliases={"/redo", "redo"}, usage="[times] [player]", desc="Redoes the last action (from history)", min=0, max=2)
    @CommandPermissions(value={"worldedit.history.redo"})
    public void redo(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        int i;
        int times = Math.max(1, args.getInteger(0, 1));
        EditSession redone = null;
        for (i = 0; i < times; ++i) {
            if (args.argsLength() < 2) {
                redone = session.redo(session.getBlockBag(player), player);
                continue;
            }
            player.checkPermission("worldedit.history.redo.other");
            LocalSession sess = this.worldEdit.getSessionManager().findByName(args.getString(1));
            if (sess == null) {
                BBC.COMMAND_HISTORY_OTHER_ERROR.send(player, args.getString(1));
                break;
            }
            redone = sess.redo(session.getBlockBag(player), player);
            if (redone == null) break;
        }
        if (redone == null) {
            --i;
        }
        if (i > 0) {
            BBC.COMMAND_REDO_SUCCESS.send(player, i == 1 ? "" : " x" + i);
            this.worldEdit.flushBlockBag(player, redone);
        }
        if (redone == null) {
            BBC.COMMAND_REDO_ERROR.send(player, new Object[0]);
        }
    }

    @Command(aliases={"/clearhistory", "clearhistory"}, usage="", desc="Clear your history", min=0, max=0)
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(Player player, LocalSession session) throws WorldEditException {
        session.clearHistory();
        BBC.COMMAND_HISTORY_CLEAR.send(player, new Object[0]);
    }
}

