/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.adapter.v1_13_1.Spigot_v1_13_R2;
import com.boydti.fawe.util.MainUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitImplementationTester;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.NoCapablePlatformException;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class WorldEditPlugin
extends JavaPlugin {
    private static final Logger log = Logger.getLogger("FastAsyncWorldEdit");
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private BukkitImplAdapter bukkitAdapter;
    private BukkitServerInterface server;
    private BukkitConfiguration config;
    private static Map<String, Plugin> lookupNames;

    public WorldEditPlugin() {
        this.init();
    }

    public WorldEditPlugin(JavaPluginLoader loader, PluginDescriptionFile desc, File dataFolder, File jarFile) {
        super(loader, desc, dataFolder, jarFile);
        this.init();
    }

    private void init() {
        if (lookupNames != null) {
            lookupNames.putIfAbsent("FastAsyncWorldEdit".toLowerCase(Locale.ENGLISH), (Plugin)this);
            lookupNames.putIfAbsent("WorldEdit".toLowerCase(Locale.ENGLISH), (Plugin)this);
            lookupNames.putIfAbsent("FastAsyncWorldEdit", (Plugin)this);
            lookupNames.putIfAbsent("WorldEdit", (Plugin)this);
            this.rename();
        }
        this.setEnabled(true);
    }

    public static String getCuiPluginChannel() {
        return CUI_PLUGIN_CHANNEL;
    }

    public void onEnable() {
        INSTANCE = this;
        FaweBukkit imp = new FaweBukkit((Plugin)this);
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.server = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register(this.server);
        this.loadAdapter();
        worldEdit.loadMappings();
        this.loadConfig();
        this.fail(() -> PermissionsResolverManager.initialize((Plugin)INSTANCE), "Failed to initialize permissions resolver");
        this.fail(() -> {
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)INSTANCE, CUI_PLUGIN_CHANNEL, (PluginMessageListener)new CUIChannelListener(INSTANCE));
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)INSTANCE, CUI_PLUGIN_CHANNEL);
        }, "Failed to register CUI");
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditListener(this), (Plugin)this);
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent());
        BukkitImplementationTester.getImplementation();
        LegacyMapper legacyMapper = LegacyMapper.getInstance();
        for (Material m : Material.values()) {
            if (m.isLegacy() || !m.isBlock()) continue;
            legacyMapper.register(m.getId(), 0, BukkitAdapter.adapt(m).getDefaultState());
        }
    }

    private void rename() {
        Logger logger;
        File dir = this.getDataFolder();
        if (dir != null) {
            dir = new File(dir.getParentFile(), "FastAsyncWorldEdit");
            try {
                Field descriptionField = JavaPlugin.class.getDeclaredField("dataFolder");
                descriptionField.setAccessible(true);
                descriptionField.set((Object)this, dir);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        if ((logger = this.getLogger()) != null) {
            try {
                Field nameField = Logger.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(logger, "FastAsyncWorldEdit");
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        File pluginsFolder = MainUtil.getJarFile().getParentFile();
        for (File file : pluginsFolder.listFiles()) {
            if (file.length() != 1073L) continue;
            return;
        }
        File dummy = MainUtil.copyFile(MainUtil.getJarFile(), "DummyFawe.src", pluginsFolder, "DummyFawe.jar");
        if (dummy != null && dummy.exists()) {
            try {
                Bukkit.getPluginManager().loadPlugin(dummy);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        log.log(Level.INFO, "Please restart the server if you have any plugins which depend on FAWE.");
    }

    private void fail(Runnable run, String message) {
        try {
            run.run();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, message);
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        this.createDefaultConfiguration("config-legacy.yml");
        try {
            this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config-legacy.yml"), true), this);
            this.config.load();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Failed to load config.yml");
            e.printStackTrace();
        }
        WorldEdit worldEdit = WorldEdit.getInstance();
        File dir = worldEdit.getWorkingDirectoryFile(worldEdit.getConfiguration().saveDir);
        dir.mkdirs();
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addClass(Spigot_v1_13_R2.class);
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        try {
            adapterLoader.addFromPath(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to search " + this.getFile() + " for Bukkit adapters", e);
        }
        try {
            this.bukkitAdapter = adapterLoader.loadAdapter();
            log.log(Level.INFO, "Using " + this.bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
        }
        catch (AdapterLoadException e) {
            try {
                Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
                if (platform instanceof BukkitServerInterface) {
                    log.log(Level.WARNING, e.getMessage());
                    return;
                }
                log.log(Level.INFO, "WorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") " + "that handles the world editing.");
            }
            catch (NoCapablePlatformException noCapablePlatformException) {
                // empty catch block
            }
            log.log(Level.INFO, "WorldEdit could not find a Bukkit adapter for this MC version");
        }
    }

    public void onDisable() {
        Fawe.get().onDisable();
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().clear();
        worldEdit.getPlatformManager().unregister(this.server);
        if (this.config != null) {
            this.config.unload();
        }
        if (this.server != null) {
            this.server.unregisterCommands();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            InputStream input = null;
            try {
                JarFile file = new JarFile(this.getFile());
                ZipEntry copy = file.getEntry("defaults/" + name);
                if (copy == null) {
                    throw new FileNotFoundException();
                }
                input = file.getInputStream(copy);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
            if (input != null) {
                FileOutputStream output = null;
                try {
                    int length;
                    output = new FileOutputStream(actual);
                    byte[] buf = new byte[8192];
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                    this.getLogger().info("Default configuration file written: " + name);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, "Failed to write default config file", e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = cmd.getName();
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post(event);
        return true;
    }

    public LocalSession getSession(Player player) {
        return WorldEdit.getInstance().getSessionManager().get(this.wrapPlayer(player));
    }

    public EditSession createEditSession(Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(wePlayer);
        BlockBag blockBag = session.getBlockBag(wePlayer);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(wePlayer.getWorld(), session.getBlockChangeLimit(), blockBag, wePlayer);
        editSession.enableQueue();
        return editSession;
    }

    public void remember(Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(wePlayer);
        session.remember(editSession);
        editSession.flushQueue();
        WorldEdit.getInstance().flushBlockBag(wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPlayer wrapPlayer(Player player) {
        return new BukkitPlayer(this, player);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        return new BukkitCommandSender(this, sender);
    }

    public BukkitServerInterface getInternalPlatform() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static WorldEditPlugin getInstance() {
        return (WorldEditPlugin)((Object)Preconditions.checkNotNull((Object)((Object)INSTANCE)));
    }

    @Nullable
    public BukkitImplAdapter getBukkitImplAdapter() {
        return this.bukkitAdapter;
    }

    static {
        PluginManager manager = Bukkit.getPluginManager();
        try {
            Field pluginsField = manager.getClass().getDeclaredField("plugins");
            Field lookupNamesField = manager.getClass().getDeclaredField("lookupNames");
            pluginsField.setAccessible(true);
            lookupNamesField.setAccessible(true);
            List plugins = (List)pluginsField.get(manager);
            lookupNames = (Map)lookupNamesField.get(manager);
            plugins = new ArrayList<Plugin>((Collection)plugins){

                @Override
                public boolean add(Plugin plugin) {
                    if (plugin.getName().startsWith("AsyncWorldEdit")) {
                        Fawe.debug("Disabling `" + plugin.getName() + "` as it is incompatible");
                    } else if (plugin.getName().startsWith("BetterShutdown")) {
                        Fawe.debug("Disabling `" + plugin.getName() + "` as it is incompatible (Improperly shaded classes from com.sk89q.minecraft.util.commands)");
                    } else {
                        return super.add(plugin);
                    }
                    return false;
                }
            };
            pluginsField.set(manager, plugins);
            lookupNames = new ConcurrentHashMap<String, Plugin>(lookupNames){

                @Override
                public Plugin put(String key, Plugin plugin) {
                    if (plugin.getName().startsWith("AsyncWorldEdit") || plugin.getName().startsWith("BetterShutdown")) {
                        return null;
                    }
                    return super.put(key, plugin);
                }
            };
            lookupNamesField.set(manager, lookupNames);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

