/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.io.serialize;

import com.boydti.fawe.object.io.serialize.Serialize;
import com.boydti.fawe.util.ReflectionUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public interface Serializer
extends Serializable {
    default public void serialize(ObjectOutputStream stream) throws IOException {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.getDeclaredAnnotation(Serialize.class) == null) continue;
                Class<?> type = field.getType();
                boolean primitive = type.isPrimitive();
                Object value = field.get(this);
                if (primitive) {
                    stream.writeObject(value);
                    continue;
                }
                if (value == null) {
                    stream.writeByte(0);
                    continue;
                }
                stream.writeByte(1);
                stream.writeObject(value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    default public void deserialize(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getDeclaredAnnotation(Serialize.class) == null) continue;
            Class<?> type = field.getType();
            boolean primitive = type.isPrimitive();
            if (primitive) {
                ReflectionUtils.setField(field, (Object)this, stream.readObject());
                continue;
            }
            if (stream.readByte() != 1) continue;
            ReflectionUtils.setField(field, (Object)this, stream.readObject());
        }
    }
}

