/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.boydti.fawe.example.IFaweQueueMap;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.example.NullFaweChunk;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.jnbt.anvil.MCAFile;
import com.boydti.fawe.jnbt.anvil.MCAQueue;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.SetQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MCAQueueMap
implements IFaweQueueMap {
    private FaweQueue queue;
    private Map<Long, MCAFile> mcaFileMap = new ConcurrentHashMap<Long, MCAFile>(8, 0.9f, 1);
    private NullFaweChunk nullChunk;
    private boolean isHybridQueue;
    private MCAFile lastFile;
    private int lastFileX = Integer.MIN_VALUE;
    private int lastFileZ = Integer.MIN_VALUE;
    private FaweChunk lastChunk;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;

    public void setParentQueue(FaweQueue queue) {
        this.queue = queue;
        this.nullChunk = new NullFaweChunk(queue, 0, 0);
        this.isHybridQueue = queue != null && !(queue instanceof MCAQueue) && (!(queue instanceof MappedFaweQueue) || ((MappedFaweQueue)queue).getFaweQueueMap() != this);
    }

    public synchronized MCAFile getMCAFile(int cx, int cz, boolean create) {
        MCAFile tmp;
        int mcaX = cx >> 5;
        int mcaZ = cz >> 5;
        if (mcaX == this.lastFileX && mcaZ == this.lastFileZ) {
            return this.lastFile;
        }
        this.lastFileX = mcaX;
        this.lastFileZ = mcaZ;
        long pair = MathMan.pairInt(this.lastFileX, this.lastFileZ);
        this.lastFile = tmp = this.mcaFileMap.get(pair);
        if (this.lastFile == null) {
            try {
                File file;
                this.queue.setMCA(this.lastFileX, this.lastFileZ, RegionWrapper.GLOBAL(), null, true, false);
                File save = this.queue.getSaveFolder();
                if (save != null) {
                    file = new File(this.queue.getSaveFolder(), "r." + this.lastFileX + "." + this.lastFileZ + ".mca");
                    if (create) {
                        File parent = file.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                    }
                } else {
                    file = null;
                }
                this.lastFile = tmp = new MCAFile(this.queue, mcaX, mcaZ, file);
            }
            catch (FaweException.FaweChunkLoadException ignore) {
                this.lastFile = null;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lastFile = null;
                return null;
            }
            this.mcaFileMap.put(pair, tmp);
        }
        return tmp;
    }

    @Override
    public Collection<FaweChunk> getFaweCunks() {
        ArrayList<FaweChunk> chunks = new ArrayList<FaweChunk>();
        for (Map.Entry<Long, MCAFile> entry : this.mcaFileMap.entrySet()) {
            MCAFile file = entry.getValue();
            if (file == null) continue;
            chunks.addAll(file.getCachedChunks());
        }
        return chunks;
    }

    @Override
    public void forEachChunk(RunnableVal<FaweChunk> onEach) {
        for (FaweChunk chunk : this.getFaweCunks()) {
            onEach.run(chunk);
        }
    }

    public FaweChunk getFaweChunk(int cx, int cz, boolean create) {
        if (cx == this.lastX && cz == this.lastZ) {
            if (this.nullChunk == this.lastChunk) {
                this.nullChunk.setLoc(this.queue, this.lastX, this.lastZ);
            }
            return this.lastChunk;
        }
        this.lastX = cx;
        this.lastZ = cz;
        if (this.isHybridQueue) {
            MappedFaweQueue mfq = (MappedFaweQueue)this.queue;
            this.lastChunk = mfq.getFaweQueueMap().getCachedFaweChunk(cx, cz);
            if (this.lastChunk != null) {
                return this.lastChunk;
            }
        }
        try {
            MCAFile mcaFile = this.getMCAFile(cx, cz, create);
            if (mcaFile != null) {
                mcaFile.init();
                this.lastChunk = mcaFile.getChunk(cx, cz);
                if (this.lastChunk != null) {
                    return this.lastChunk;
                }
                if (create) {
                    MCAChunk chunk = new MCAChunk(this.queue, cx, cz);
                    mcaFile.setChunk(chunk);
                    this.lastChunk = chunk;
                    return chunk;
                }
            }
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        if (this.isHybridQueue) {
            this.lastChunk = ((MappedFaweQueue)this.queue).getFaweQueueMap().getFaweChunk(cx, cz);
            return this.lastChunk;
        }
        this.nullChunk.setLoc(this.queue, this.lastX, this.lastZ);
        this.lastChunk = this.nullChunk;
        return this.lastChunk;
    }

    @Override
    public FaweChunk getFaweChunk(int cx, int cz) {
        return this.getFaweChunk(cx, cz, !this.isHybridQueue);
    }

    @Override
    public FaweChunk getCachedFaweChunk(int cx, int cz) {
        int mcaX = cx >> 5;
        int mcaZ = cz >> 5;
        long pair = MathMan.pairInt(mcaX, mcaZ);
        MCAFile file = this.mcaFileMap.get(pair);
        if (file != null) {
            return file.getCachedChunk(cx, cz);
        }
        return null;
    }

    @Override
    public void add(FaweChunk chunk) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void clear() {
        for (Map.Entry<Long, MCAFile> entry : this.mcaFileMap.entrySet()) {
            entry.getValue().clear();
        }
        this.mcaFileMap.clear();
        this.lastChunk = null;
        this.lastFile = null;
        this.lastFileX = Integer.MIN_VALUE;
        this.lastFileZ = Integer.MIN_VALUE;
        this.lastX = Integer.MIN_VALUE;
        this.lastZ = Integer.MIN_VALUE;
        if (this.isHybridQueue) {
            this.queue.clear();
        }
    }

    @Override
    public int size() {
        int size = this.mcaFileMap.size();
        if (this.isHybridQueue) {
            size += this.queue.size();
        }
        return size;
    }

    @Override
    public boolean next(int size, long time) {
        this.lastX = Integer.MIN_VALUE;
        this.lastZ = Integer.MIN_VALUE;
        this.lastFileX = Integer.MIN_VALUE;
        this.lastFileZ = Integer.MIN_VALUE;
        if (!this.mcaFileMap.isEmpty()) {
            boolean result;
            Iterator<Map.Entry<Long, MCAFile>> iter = this.mcaFileMap.entrySet().iterator();
            long start = System.currentTimeMillis();
            while (result = iter.hasNext()) {
                final MCAFile file = iter.next().getValue();
                iter.remove();
                this.queue.setMCA(file.getX(), file.getZ(), RegionWrapper.GLOBAL(), new Runnable(){

                    @Override
                    public void run() {
                        file.close(SetQueue.IMP.getForkJoinPool());
                    }
                }, true, true);
                if (System.currentTimeMillis() - start < time) continue;
            }
            return result;
        }
        if (this.isHybridQueue) {
            boolean value = this.queue.next();
            return value;
        }
        return false;
    }
}

