/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper.state;

import com.boydti.fawe.bukkit.chat.FancyMessage;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncBlockState;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import java.util.Map;
import org.bukkit.block.Sign;

public class AsyncSign
extends AsyncBlockState
implements Sign {
    public AsyncSign(AsyncBlock block, int combined) {
        super(block, combined);
    }

    public String[] getLines() {
        CompoundTag nbt = this.getNbtData();
        String[] data = new String[4];
        if (nbt != null) {
            for (int i = 1; i <= 4; ++i) {
                data[i - 1] = this.fromJson(nbt.getString("Text" + i));
            }
        }
        return data;
    }

    private String fromJson(String jsonInput) {
        if (jsonInput == null || jsonInput.isEmpty()) {
            return "";
        }
        return FancyMessage.deserialize(jsonInput).toOldMessageFormat();
    }

    private String toJson(String oldInput) {
        if (oldInput == null || oldInput.isEmpty()) {
            return "";
        }
        return new FancyMessage("").color(oldInput).toJSONString();
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        CompoundTag nbt = this.getNbtData();
        return nbt == null ? null : this.fromJson(nbt.getString("Text" + (index + 1)));
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        CompoundTag nbt = this.getNbtData();
        if (nbt != null) {
            Map map = ReflectionUtils.getMap(nbt.getValue());
            map.put("Text" + (index + 1), new StringTag(this.toJson(line)));
        }
    }
}

