/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.bukkit.v0.BukkitQueue_0;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.TaskManager;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;

public class AsyncChunk
implements Chunk {
    private final AsyncWorld world;
    private final int z;
    private final int x;
    private final FaweQueue queue;

    public AsyncChunk(World world, FaweQueue queue, int x, int z) {
        this.world = world instanceof AsyncWorld ? (AsyncWorld)world : new AsyncWorld(world, true);
        this.queue = queue;
        this.x = x;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)obj;
        return other.getX() == this.x && other.getZ() == this.z && this.world.equals(other.getWorld());
    }

    public int hashCode() {
        return MathMan.pair((short)this.x, (short)this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public AsyncWorld getWorld() {
        return this.world;
    }

    public AsyncBlock getBlock(int x, int y, int z) {
        return new AsyncBlock(this.world, this.queue, (this.x << 4) + x, y, (this.z << 4) + z);
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(false, true, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxblocky, final boolean includeBiome, final boolean includeBiomeTempRain) {
        if (Fawe.isMainThread()) {
            return this.world.getChunkAt(this.x, this.z).getChunkSnapshot(includeMaxblocky, includeBiome, includeBiomeTempRain);
        }
        return this.whenLoaded(new RunnableVal<ChunkSnapshot>(){

            @Override
            public void run(ChunkSnapshot value) {
                this.value = AsyncChunk.this.world.getChunkAt(AsyncChunk.this.x, AsyncChunk.this.z).getChunkSnapshot(includeBiome, includeBiome, includeBiomeTempRain);
            }
        });
    }

    private <T> T whenLoaded(RunnableVal<T> task) {
        if (Fawe.isMainThread()) {
            task.run();
            return task.value;
        }
        if (this.queue instanceof BukkitQueue_0) {
            BukkitQueue_0 bq = (BukkitQueue_0)this.queue;
            if (this.world.isChunkLoaded(this.x, this.z)) {
                long pair = MathMan.pairInt(this.x, this.z);
                Long originalKeep = BukkitQueue_0.keepLoaded.get(pair);
                BukkitQueue_0.keepLoaded.put(pair, Long.MAX_VALUE);
                if (this.world.isChunkLoaded(this.x, this.z)) {
                    task.run();
                    if (originalKeep != null) {
                        BukkitQueue_0.keepLoaded.put(pair, originalKeep);
                    } else {
                        BukkitQueue_0.keepLoaded.remove(pair);
                    }
                    return task.value;
                }
            }
        }
        return TaskManager.IMP.sync(task);
    }

    public Entity[] getEntities() {
        if (!this.isLoaded()) {
            return new Entity[0];
        }
        return this.whenLoaded(new RunnableVal<Entity[]>(){

            @Override
            public void run(Entity[] value) {
                AsyncChunk.this.world.getChunkAt(AsyncChunk.this.x, AsyncChunk.this.z).getEntities();
            }
        });
    }

    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            return new BlockState[0];
        }
        return TaskManager.IMP.sync(new RunnableVal<BlockState[]>(){

            @Override
            public void run(BlockState[] value) {
                this.value = AsyncChunk.this.world.getChunkAt(AsyncChunk.this.x, AsyncChunk.this.z).getTileEntities();
            }
        });
    }

    public BlockState[] getTileEntities(final boolean b) {
        if (!this.isLoaded()) {
            return new BlockState[0];
        }
        return TaskManager.IMP.sync(new RunnableVal<BlockState[]>(){

            @Override
            public void run(BlockState[] value) {
                this.value = AsyncChunk.this.world.getChunkAt(AsyncChunk.this.x, AsyncChunk.this.z).getTileEntities(b);
            }
        });
    }

    public boolean isLoaded() {
        return this.world.isChunkLoaded(this.x, this.z);
    }

    public boolean load(final boolean generate) {
        return TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                this.value = AsyncChunk.this.world.loadChunk(AsyncChunk.this.x, AsyncChunk.this.z, generate);
            }
        });
    }

    public boolean load() {
        return this.load(false);
    }

    public boolean unload(boolean save, boolean safe) {
        return this.world.unloadChunk(this.x, this.z, save, safe);
    }

    public boolean unload(boolean save) {
        return this.unload(true, false);
    }

    public boolean unload() {
        return this.unload(true);
    }

    public boolean isSlimeChunk() {
        return false;
    }
}

