/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.wasteofplastic.askyblock.ASkyBlockAPI;
import com.wasteofplastic.askyblock.Island;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ASkyBlockHook
extends BukkitMaskManager
implements Listener {
    FaweBukkit plugin;
    Plugin aSkyBlock;

    public ASkyBlockHook(Plugin aSkyBlock, FaweBukkit p3) {
        super(aSkyBlock.getName());
        this.aSkyBlock = aSkyBlock;
        this.plugin = p3;
    }

    public boolean isAllowed(Player player, Island island, FaweMaskManager.MaskType type) {
        return island != null && (player.getUniqueId().equals(island.getOwner()) || type == FaweMaskManager.MaskType.MEMBER && island.getMembers().contains(player.getUniqueId()) && this.hasMemberPermission(player));
    }

    @Override
    public FaweMask getMask(FawePlayer<Player> fp, FaweMaskManager.MaskType type) {
        Player player = (Player)fp.parent;
        Location location = player.getLocation();
        final Island island = ASkyBlockAPI.getInstance().getIslandAt(location);
        if (island != null && this.isAllowed(player, island, type)) {
            int minX = island.getMinProtectedX();
            int minZ = island.getMinProtectedZ();
            World world = location.getWorld();
            Location center = island.getCenter();
            Location pos1 = new Location(world, (double)island.getMinProtectedX(), 0.0, (double)island.getMinProtectedZ());
            Location pos2 = center.add(center.subtract(pos1));
            pos2.setY(255.0);
            return new BukkitMask(pos1, pos2, "ISLAND: " + minX + "," + minZ){

                @Override
                public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                    return ASkyBlockHook.this.isAllowed((Player)player.parent, island, type);
                }
            };
        }
        return null;
    }
}

