/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.IFawe;
import com.boydti.fawe.bukkit.BukkitCommand;
import com.boydti.fawe.bukkit.BukkitPlayer;
import com.boydti.fawe.bukkit.Metrics;
import com.boydti.fawe.bukkit.chat.BukkitChatManager;
import com.boydti.fawe.bukkit.listener.AsyncTabCompleteListener;
import com.boydti.fawe.bukkit.listener.BrushListener;
import com.boydti.fawe.bukkit.listener.BukkitImageListener;
import com.boydti.fawe.bukkit.listener.CFIPacketListener;
import com.boydti.fawe.bukkit.listener.RenderListener;
import com.boydti.fawe.bukkit.listener.SyncTabCompleteListener;
import com.boydti.fawe.bukkit.regions.ASkyBlockHook;
import com.boydti.fawe.bukkit.regions.FactionsFeature;
import com.boydti.fawe.bukkit.regions.FactionsOneFeature;
import com.boydti.fawe.bukkit.regions.FactionsUUIDFeature;
import com.boydti.fawe.bukkit.regions.FreeBuildRegion;
import com.boydti.fawe.bukkit.regions.GriefPreventionFeature;
import com.boydti.fawe.bukkit.regions.PlotMeFeature;
import com.boydti.fawe.bukkit.regions.PreciousStonesFeature;
import com.boydti.fawe.bukkit.regions.ResidenceFeature;
import com.boydti.fawe.bukkit.regions.TownyFeature;
import com.boydti.fawe.bukkit.regions.Worldguard;
import com.boydti.fawe.bukkit.regions.WorldguardFlag;
import com.boydti.fawe.bukkit.util.BukkitReflectionUtils;
import com.boydti.fawe.bukkit.util.BukkitTaskMan;
import com.boydti.fawe.bukkit.util.ItemUtil;
import com.boydti.fawe.bukkit.util.VaultUtil;
import com.boydti.fawe.bukkit.util.cui.CUIListener;
import com.boydti.fawe.bukkit.util.cui.StructureCUI;
import com.boydti.fawe.bukkit.util.image.BukkitImageViewer;
import com.boydti.fawe.bukkit.v0.BukkitQueue_0;
import com.boydti.fawe.bukkit.v0.BukkitQueue_All;
import com.boydti.fawe.bukkit.v0.ChunkListener_8;
import com.boydti.fawe.bukkit.v0.ChunkListener_9;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweCommand;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.Jars;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.cui.CUI;
import com.boydti.fawe.util.image.ImageViewer;
import com.boydti.fawe.util.metrics.BStats;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class FaweBukkit
implements IFawe,
Listener {
    private final Plugin plugin;
    private VaultUtil vault;
    private ItemUtil itemUtil;
    private boolean listeningImages;
    private BukkitImageListener imageListener;
    private CFIPacketListener packetListener;
    private boolean listeningCui;
    private CUIListener cuiListener;
    private List<Vector> locations = Arrays.asList(new Vector(0, 5, 0));
    private boolean hasNMS = true;
    private boolean playerChunk = false;
    private boolean enabledBlocksHub = true;
    private Version version = null;

    public VaultUtil getVault() {
        return this.vault;
    }

    public FaweBukkit(final Plugin plugin) {
        this.plugin = plugin;
        try {
            Settings.IMP.TICK_LIMITER.ENABLED = !Bukkit.hasWhitelist();
            Fawe.set(this);
            Fawe.setupInjector();
            try {
                new BrushListener(plugin);
            }
            catch (Throwable e) {
                this.debug("====== BRUSH LISTENER FAILED ======");
                e.printStackTrace();
                this.debug("===================================");
            }
            if (Bukkit.getVersion().contains("git-Spigot")) {
                this.debug("====== USE PAPER ======");
                this.debug("DOWNLOAD: https://ci.destroystokyo.com/job/Paper-1.13/");
                this.debug("GUIDE: https://www.spigotmc.org/threads/21726/");
                this.debug(" - This is only a recommendation");
                this.debug("==============================");
            }
            if (Bukkit.getVersion().contains("git-Paper") && Settings.IMP.EXPERIMENTAL.DYNAMIC_CHUNK_RENDERING > 1) {
                new RenderListener(plugin);
            }
            try {
                Fawe.get().setChatManager(new BukkitChatManager());
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            Bukkit.getServer().shutdown();
        }
        TaskManager.IMP.task(new Runnable(){

            @Override
            public void run() {
                Bukkit.getPluginManager().registerEvents((Listener)FaweBukkit.this, FaweBukkit.this.plugin);
                try {
                    Class.forName("sun.misc.SharedSecrets");
                    new ChunkListener_8();
                }
                catch (ClassNotFoundException e) {
                    new ChunkListener_9();
                }
                try {
                    Class.forName("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent");
                    new AsyncTabCompleteListener(WorldEditPlugin.getInstance());
                }
                catch (Throwable ignore) {
                    Bukkit.getPluginManager().registerEvents((Listener)new SyncTabCompleteListener(WorldEditPlugin.getInstance()), plugin);
                }
            }
        });
    }

    @Override
    public CUI getCUI(FawePlayer player) {
        if (Settings.IMP.EXPERIMENTAL.VANILLA_CUI) {
            if (this.listeningCui && this.cuiListener == null) {
                return null;
            }
            this.listeningCui = true;
            if (this.cuiListener == null) {
                Plugin protocolLib = Bukkit.getPluginManager().getPlugin("ProtocolLib");
                if (protocolLib != null && protocolLib.isEnabled()) {
                    this.cuiListener = new CUIListener(this.plugin);
                } else {
                    return null;
                }
            }
            return new StructureCUI(player);
        }
        return null;
    }

    @Override
    public void registerPacketListener() {
        PluginManager manager = Bukkit.getPluginManager();
        if (this.packetListener == null && manager.getPlugin("ProtocolLib") != null) {
            this.packetListener = new CFIPacketListener(this.plugin);
        }
    }

    @Override
    public synchronized ImageViewer getImageViewer(FawePlayer fp) {
        if (this.listeningImages && this.imageListener == null) {
            return null;
        }
        try {
            Throwable throwable;
            FileOutputStream fos;
            byte[] jarData;
            File output;
            this.listeningImages = true;
            this.registerPacketListener();
            PluginManager manager = Bukkit.getPluginManager();
            if (manager.getPlugin("PacketListenerApi") == null) {
                output = new File(this.plugin.getDataFolder().getParentFile(), "PacketListenerAPI_v3.6.0-SNAPSHOT.jar");
                jarData = Jars.PL_v3_6_0.download();
                fos = new FileOutputStream(output);
                throwable = null;
                try {
                    fos.write(jarData);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            if (manager.getPlugin("MapManager") == null) {
                output = new File(this.plugin.getDataFolder().getParentFile(), "MapManager_v1.4.0-SNAPSHOT.jar");
                jarData = Jars.MM_v1_4_0.download();
                fos = new FileOutputStream(output);
                throwable = null;
                try {
                    fos.write(jarData);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            BukkitImageViewer viewer = new BukkitImageViewer((Player)fp.parent);
            if (this.imageListener == null) {
                this.imageListener = new BukkitImageListener(this.plugin);
            }
            return viewer;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public int getPlayerCount() {
        return this.plugin.getServer().getOnlinePlayers().size();
    }

    @Override
    public boolean isOnlineMode() {
        return Bukkit.getOnlineMode();
    }

    @Override
    public String getPlatformVersion() {
        String bukkitVersion = Bukkit.getVersion();
        int index = bukkitVersion.indexOf("MC: ");
        return index == -1 ? bukkitVersion : bukkitVersion.substring(index + 4, bukkitVersion.length() - 1);
    }

    @Override
    public void debug(String s) {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (console != null) {
            console.sendMessage(BBC.color(s));
        } else {
            Bukkit.getLogger().info(BBC.color(s));
        }
    }

    @Override
    public File getDirectory() {
        return this.plugin.getDataFolder();
    }

    @Override
    public void setupCommand(String label, FaweCommand cmd) {
        if (this.plugin instanceof JavaPlugin) {
            TaskManager.IMP.task(() -> {
                PluginCommand registered = ((JavaPlugin)this.plugin).getCommand(label);
                if (registered == null) {
                    this.debug("Command not registered in plugin.yml: " + label);
                    return;
                }
                registered.setExecutor((CommandExecutor)new BukkitCommand(cmd));
            });
        }
    }

    @Override
    public FawePlayer<Player> wrap(Object obj) {
        if (obj.getClass() == String.class) {
            String name = (String)obj;
            FawePlayer existing = Fawe.get().getCachedPlayer(name);
            if (existing != null) {
                return existing;
            }
            Player player = Bukkit.getPlayer((String)name);
            return player != null ? new BukkitPlayer(player) : null;
        }
        if (obj instanceof Player) {
            Player player = (Player)obj;
            FawePlayer existing = Fawe.get().getCachedPlayer(player.getName());
            return existing != null ? existing : new BukkitPlayer(player);
        }
        if (obj != null && obj.getClass().getName().contains("EntityPlayer")) {
            try {
                Method method = obj.getClass().getDeclaredMethod("getBukkitEntity", new Class[0]);
                return this.wrap(method.invoke(obj, new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public void startMetrics() {
        Metrics metrics = new Metrics(this.plugin);
        metrics.start();
        TaskManager.IMP.task(new Runnable(){

            @Override
            public void run() {
                ArrayList<Class> services = new ArrayList<Class>(Bukkit.getServicesManager().getKnownServices());
                services.forEach(service -> {
                    try {
                        service.getField("B_STATS_VERSION");
                        ArrayList providers = new ArrayList(Bukkit.getServicesManager().getRegistrations(service));
                        for (RegisteredServiceProvider provider : providers) {
                            Object instance = provider.getProvider();
                            BStats.linkMetrics(instance);
                            Bukkit.getServicesManager().unregister(service, instance);
                            try {
                                Class<?> clazz = instance.getClass();
                                Field logFailedRequests = ReflectionUtils.findField(clazz, Boolean.TYPE);
                                logFailedRequests.set(null, false);
                                Field url = null;
                                try {
                                    url = clazz.getDeclaredField("URL");
                                }
                                catch (NoSuchFieldException ignore) {
                                    for (Field field : clazz.getDeclaredFields()) {
                                        if (!ReflectionUtils.setAccessible(field).get(null).toString().startsWith("http")) continue;
                                        url = field;
                                        break;
                                    }
                                }
                                if (url == null) continue;
                                ReflectionUtils.setFailsafeFieldValue(url, null, null);
                            }
                            catch (IllegalAccessException | NoSuchFieldError throwable) {
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    public ItemUtil getItemUtil() {
        ItemUtil tmp = this.itemUtil;
        if (tmp == null) {
            try {
                this.itemUtil = tmp = new ItemUtil();
            }
            catch (Throwable e) {
                Settings.IMP.EXPERIMENTAL.PERSISTENT_BRUSHES = false;
                this.debug("===== PERSISTENT BRUSH FAILED =====");
                e.printStackTrace();
                this.debug("===================================");
            }
        }
        return tmp;
    }

    @Override
    public void setupVault() {
        try {
            this.vault = new VaultUtil();
        }
        catch (Throwable e) {
            this.debug("&dVault is used for persistent `/wea` toggles.");
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder msg = new StringBuilder();
        ArrayList pl = new ArrayList();
        msg.append("server.plugins: \n");
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            msg.append(" - " + p.getName() + ": " + p.getDescription().getVersion() + "\n");
        }
        msg.append("server.version: " + Bukkit.getVersion() + " / " + Bukkit.getBukkitVersion() + "\n");
        return msg.toString();
    }

    @Override
    public TaskManager getTaskManager() {
        return new BukkitTaskMan(this.plugin);
    }

    @Override
    public FaweQueue getNewQueue(String world, boolean fast) {
        this.playerChunk = true;
        if (!this.playerChunk) {
            try {
                Field fieldDirtyCount = BukkitReflectionUtils.getRefClass("{nms}.PlayerChunk").getField("dirtyCount").getRealField();
                fieldDirtyCount.setAccessible(true);
                int mod = fieldDirtyCount.getModifiers();
                if ((mod & 0x40) == 0) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(fieldDirtyCount, mod + 64);
                }
            }
            catch (Throwable fieldDirtyCount) {
                // empty catch block
            }
        }
        try {
            return this.getQueue(world);
        }
        catch (Throwable ignore) {
            Settings.IMP.QUEUE.PARALLEL_THREADS = 1;
            Settings.IMP.HISTORY.COMBINE_STAGES = false;
            if (this.hasNMS) {
                this.debug("====== NO NMS BLOCK PLACER FOUND ======");
                this.debug("FAWE couldn't find a fast block placer");
                this.debug("Bukkit version: " + Bukkit.getVersion());
                this.debug("NMS label: " + this.plugin.getClass().getSimpleName().split("_")[1]);
                this.debug("Fallback placer: " + BukkitQueue_All.class);
                this.debug("=======================================");
                this.debug("Download the version of FAWE for your platform");
                this.debug(" - http://ci.athion.net/job/FastAsyncWorldEdit/lastSuccessfulBuild/artifact/target");
                this.debug("=======================================");
                ignore.printStackTrace();
                this.debug("=======================================");
                TaskManager.IMP.laterAsync(new Runnable(){

                    @Override
                    public void run() {
                        MainUtil.sendAdmin("&cNo NMS placer found, see console!");
                    }
                }, 1);
                this.hasNMS = false;
            }
            return new BukkitQueue_All(world);
        }
    }

    @Override
    public FaweQueue getNewQueue(World world, boolean fast) {
        block7: {
            if (fast) {
                this.playerChunk = true;
                if (!this.playerChunk) {
                    try {
                        Field fieldDirtyCount = BukkitReflectionUtils.getRefClass("{nms}.PlayerChunk").getField("dirtyCount").getRealField();
                        fieldDirtyCount.setAccessible(true);
                        int mod = fieldDirtyCount.getModifiers();
                        if ((mod & 0x40) == 0) {
                            Field modifiersField = Field.class.getDeclaredField("modifiers");
                            modifiersField.setAccessible(true);
                            modifiersField.setInt(fieldDirtyCount, mod + 64);
                        }
                    }
                    catch (Throwable fieldDirtyCount) {
                        // empty catch block
                    }
                }
                Throwable error = null;
                try {
                    return this.getQueue(world);
                }
                catch (Throwable ignore) {
                    error = ignore;
                    Settings.IMP.QUEUE.PARALLEL_THREADS = 1;
                    Settings.IMP.HISTORY.COMBINE_STAGES = false;
                    if (!this.hasNMS) break block7;
                    this.debug("====== NO NMS BLOCK PLACER FOUND ======");
                    this.debug("FAWE couldn't find a fast block placer");
                    this.debug("Bukkit version: " + Bukkit.getVersion());
                    this.debug("NMS label: " + this.plugin.getClass().getSimpleName());
                    this.debug("Fallback placer: " + BukkitQueue_All.class);
                    this.debug("=======================================");
                    this.debug("Download the version of FAWE for your platform");
                    this.debug(" - http://ci.athion.net/job/FastAsyncWorldEdit/lastSuccessfulBuild/artifact/target");
                    this.debug("=======================================");
                    error.printStackTrace();
                    this.debug("=======================================");
                    TaskManager.IMP.laterAsync(new Runnable(){

                        @Override
                        public void run() {
                            MainUtil.sendAdmin("&cNo NMS placer found, see console!");
                        }
                    }, 1);
                    this.hasNMS = false;
                }
            }
        }
        return new BukkitQueue_All(world);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getWorldName(World world) {
        return world.getName();
    }

    @Override
    public Collection<FaweMaskManager> getMaskManagers() {
        Plugin aSkyBlock;
        Plugin preciousstonesPlugin;
        Plugin griefpreventionPlugin;
        Plugin residencePlugin;
        Plugin factionsPlugin;
        Plugin townyPlugin;
        Plugin plotmePlugin;
        Plugin worldguardPlugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
        ArrayList<FaweMaskManager> managers = new ArrayList<FaweMaskManager>();
        if (worldguardPlugin != null && worldguardPlugin.isEnabled()) {
            try {
                managers.add(new Worldguard(worldguardPlugin, this));
                managers.add(new WorldguardFlag(worldguardPlugin, this));
                Fawe.debug("Plugin 'WorldGuard' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if ((plotmePlugin = Bukkit.getServer().getPluginManager().getPlugin("PlotMe")) != null && plotmePlugin.isEnabled()) {
            try {
                managers.add(new PlotMeFeature(plotmePlugin, this));
                Fawe.debug("Plugin 'PlotMe' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if ((townyPlugin = Bukkit.getServer().getPluginManager().getPlugin("Towny")) != null && townyPlugin.isEnabled()) {
            try {
                managers.add(new TownyFeature(townyPlugin, this));
                Fawe.debug("Plugin 'Towny' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if ((factionsPlugin = Bukkit.getServer().getPluginManager().getPlugin("Factions")) != null && factionsPlugin.isEnabled()) {
            try {
                managers.add(new FactionsFeature(factionsPlugin, this));
                Fawe.debug("Plugin 'Factions' found. Using it now.");
            }
            catch (Throwable e) {
                try {
                    managers.add(new FactionsUUIDFeature(factionsPlugin, this));
                    Fawe.debug("Plugin 'FactionsUUID' found. Using it now.");
                }
                catch (Throwable e2) {
                    try {
                        managers.add(new FactionsOneFeature(factionsPlugin, this));
                        Fawe.debug("Plugin 'FactionsUUID' found. Using it now.");
                    }
                    catch (Throwable e3) {
                        MainUtil.handleError(e);
                    }
                }
            }
        }
        if ((residencePlugin = Bukkit.getServer().getPluginManager().getPlugin("Residence")) != null && residencePlugin.isEnabled()) {
            try {
                managers.add(new ResidenceFeature(residencePlugin, this));
                Fawe.debug("Plugin 'Residence' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if ((griefpreventionPlugin = Bukkit.getServer().getPluginManager().getPlugin("GriefPrevention")) != null && griefpreventionPlugin.isEnabled()) {
            try {
                managers.add(new GriefPreventionFeature(griefpreventionPlugin, this));
                Fawe.debug("Plugin 'GriefPrevention' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if ((preciousstonesPlugin = Bukkit.getServer().getPluginManager().getPlugin("PreciousStones")) != null && preciousstonesPlugin.isEnabled()) {
            try {
                managers.add(new PreciousStonesFeature(preciousstonesPlugin, this));
                Fawe.debug("Plugin 'PreciousStones' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if ((aSkyBlock = Bukkit.getServer().getPluginManager().getPlugin("ASkyBlock")) != null && aSkyBlock.isEnabled()) {
            try {
                managers.add(new ASkyBlockHook(aSkyBlock, this));
                Fawe.debug("Plugin 'ASkyBlock' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if (Settings.IMP.EXPERIMENTAL.FREEBUILD) {
            try {
                managers.add(new FreeBuildRegion());
                Fawe.debug("Plugin '<internal.freebuild>' found. Using it now.");
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        return managers;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        FawePlayer fp = Fawe.get().getCachedPlayer(name);
        if (fp != null) {
            fp.unregister();
            Fawe.get().unregister(name);
        }
    }

    @Override
    public String getPlatform() {
        return "bukkit";
    }

    @Override
    public UUID getUUID(String name) {
        return Bukkit.getOfflinePlayer((String)name).getUniqueId();
    }

    @Override
    public String getName(UUID uuid) {
        return Bukkit.getOfflinePlayer((UUID)uuid).getName();
    }

    @Override
    public Object getBlocksHubApi() {
        if (!this.enabledBlocksHub) {
            return null;
        }
        Plugin blocksHubPlugin = Bukkit.getPluginManager().getPlugin("BlocksHub");
        if (blocksHubPlugin == null) {
            this.enabledBlocksHub = false;
            return null;
        }
        return null;
    }

    public Version getVersion() {
        Version tmp = this.version;
        if (tmp == null) {
            tmp = Version.NONE;
            for (Version v : Version.values()) {
                try {
                    BukkitQueue_0.checkVersion(v.name());
                    this.version = tmp = v;
                    if (tmp != Version.v1_13_R1) break;
                    try {
                        Fawe.debug("Running 1.13 registry dumper!");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
        }
        return tmp;
    }

    private FaweQueue getQueue(World world) {
        switch (this.getVersion()) {
            default: 
        }
        return new BukkitQueue_All(world);
    }

    private FaweQueue getQueue(String world) {
        switch (this.getVersion()) {
            default: 
        }
        return new BukkitQueue_All(world);
    }

    public static enum Version {
        v1_13_R1,
        NONE;

    }
}

