/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.SingleBlockTypeMask;
import com.sk89q.worldedit.function.pattern.FawePattern;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.BundledBlockData;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public interface BlockType
extends FawePattern,
Comparable<BlockTypes> {
    default public BlockTypes getTypeEnum() {
        return (BlockTypes)this;
    }

    @Deprecated
    public int getMaxStateId();

    @Override
    default public boolean apply(Extent extent, Vector get, Vector set) throws WorldEditException {
        return extent.setBlock(set, this.getDefaultState());
    }

    @Override
    default public BlockStateHolder apply(Vector position) {
        return this.getDefaultState();
    }

    default public Mask toMask(Extent extent) {
        return new SingleBlockTypeMask(extent, this);
    }

    public String getId();

    default public String getNamespace() {
        String id = this.getId();
        int i = id.indexOf(58);
        return i == -1 ? "minecraft" : id.substring(0, i);
    }

    default public String getResource() {
        String id = this.getId();
        return id.substring(id.indexOf(58) + 1);
    }

    default public String getName() {
        BundledBlockData.BlockEntry entry = BundledBlockData.getInstance().findById(this.getId());
        if (entry == null) {
            return this.getId();
        }
        return entry.localizedName;
    }

    @Deprecated
    default public BlockState withPropertyId(int internalPropertiesId) {
        if (internalPropertiesId == 0) {
            return this.getDefaultState();
        }
        return BlockState.getFromInternalId(this.getInternalId() + (internalPropertiesId << BlockTypes.BIT_OFFSET));
    }

    @Deprecated
    default public Map<String, ? extends Property> getPropertyMap() {
        List<? extends Property> properties = this.getProperties();
        if (properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Property> map = new HashMap<String, Property>(properties.size());
        for (Property property : properties) {
            map.put(property.getName(), property);
        }
        return map;
    }

    @Deprecated
    public List<? extends Property> getProperties();

    @Deprecated
    default public Set<? extends Property> getPropertiesSet() {
        return new HashSet<Property>(this.getProperties());
    }

    @Deprecated
    default public <V> Property<V> getProperty(String name) {
        return this.getPropertyMap().get(name);
    }

    default public boolean hasProperty(PropertyKey key) {
        return this.getPropertyMap().containsKey(key.getId());
    }

    default public <V> Property<V> getProperty(PropertyKey key) {
        return this.getPropertyMap().get(key.getId());
    }

    public BlockState getDefaultState();

    public List<BlockState> getAllStates();

    default public boolean hasItemType() {
        return this.getItemType() != null;
    }

    @Nullable
    default public ItemType getItemType() {
        return ItemTypes.get(this.getTypeEnum());
    }

    public BlockMaterial getMaterial();

    default public int getLegacyCombinedId() {
        Integer combinedId = LegacyMapper.getInstance().getLegacyCombined(this);
        return combinedId == null ? 0 : combinedId;
    }

    public int getInternalId();

    public boolean equals(Object var1);

    public int hashCode();

    @Deprecated
    default public int getLegacyId() {
        Integer id = LegacyMapper.getInstance().getLegacyCombined(this.getDefaultState());
        if (id != null) {
            return id >> 4;
        }
        return 0;
    }
}

