/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class ClipboardFormats {
    @Nullable
    public static ClipboardFormat findByAlias(String alias) {
        return ClipboardFormat.findByAlias(alias);
    }

    @Nullable
    public static ClipboardFormat findByFile(File file) {
        Preconditions.checkNotNull((Object)file);
        for (ClipboardFormat format : ClipboardFormat.values) {
            if (!format.isFormat(file)) continue;
            return format;
        }
        return null;
    }

    public static Multimap<String, ClipboardFormat> getFileExtensionMap() {
        HashMultimap map = HashMultimap.create();
        for (ClipboardFormat format : ClipboardFormat.values) {
            for (String ext : format.getFileExtensions()) {
                map.put((Object)ext, (Object)format);
            }
        }
        return map;
    }

    public static Collection<ClipboardFormat> getAll() {
        return Arrays.asList(ClipboardFormat.values);
    }

    public static String[] getFileExtensionArray() {
        ArrayList<String> exts = new ArrayList<String>();
        HashMultimap map = HashMultimap.create();
        for (ClipboardFormat format : ClipboardFormat.values) {
            exts.addAll(format.getFileExtensions());
        }
        return exts.toArray(new String[exts.size()]);
    }

    private ClipboardFormats() {
    }
}

